/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.elimreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.BuildElimRptBookInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.SumHelper;
import com.kingdee.eas.fi.gr.dynamic.IMultiInterCheckageFacade;
import com.kingdee.eas.fi.gr.dynamic.MultiDynaSumTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.MultiInterCheckageFacadeFactory;
import com.kingdee.eas.fi.gr.dynamic.dynainnerexch.SortHelper;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.gr.dynamic.util.MultiDynaItem;
import com.kingdee.eas.fi.gr.dynamic.util.PointXComparator;
import com.kingdee.eas.fi.gr.dynamic.util.PointYComparator;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.excelformula.util.CellReference;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorFormula;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.util.ObjectValueComparator;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Point;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class MultiRptFillDataUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.elimreport.MultiRptFillDataUtils");
    public static final Pattern patternType = Pattern.compile(";");
    public static final Pattern patternItem = Pattern.compile("\\|");
    public static final Pattern pattern2Name = Pattern.compile("@!@");

    public static void fillDynaData(RptSrcTypeEnum rptSrcTypeEnum, Map tables, Map tableItem, Map sumResult, int precision, BuildElimRptBookInfo buildInfo) throws Exception {
        for (String sheetID : tables.keySet()) {
            if (!sumResult.containsKey(sheetID)) continue;
            Sheet table = (Sheet)tables.get(sheetID);
            Map sheetMap = (Map)sumResult.get(sheetID);
            HashMap templateFormulas = new HashMap();
            Object[] basePointArray = MultiRptFillDataUtils.sortByPosistion(table, sheetMap.keySet());
            for (int n = basePointArray.length - 1; n >= 0; --n) {
                Point basePoint = (Point)basePointArray[n];
                boolean baseLine = false;
                DynaParameters param = DynamicTemplateUtility.getDynaParameters((Sheet)table, (Point)basePoint);
                if (param == null || rptSrcTypeEnum != RptSrcTypeEnum.MULTIDYNAMICCSLREPORT) continue;
                MultiRptFillDataUtils.fillMultiSumData(param, basePoint, table, (Map)sheetMap.get(basePoint), buildInfo);
            }
        }
    }

    private static void fillMultiSumData(DynaParameters param, Point basePoint, Sheet sheet, Map valueMap, BuildElimRptBookInfo buildInfo) throws EASBizException, BOSException {
        List<AsstActTypeInfo> selectedAsstActTypeList = MultiRptFillDataUtils.getSelectedAsstActTypeList(sheet.getID(), basePoint, buildInfo);
        if (selectedAsstActTypeList == null || selectedAsstActTypeList.size() == 0) {
            return;
        }
        int maxCol = MultiRptFillDataUtils.getMaxColIndex(sheet, basePoint);
        List<Map<Object, Object>> mapedItemList = MultiRptFillDataUtils.getItemFormulaList(sheet, basePoint, maxCol);
        int asstColCount = 0;
        asstColCount = MultiRptFillDataUtils.fillHeadAsstItem(sheet, param, basePoint, selectedAsstActTypeList, maxCol, buildInfo);
        MultiRptFillDataUtils.fillHeadItemFormula(sheet, basePoint, mapedItemList, asstColCount, maxCol);
        List<Object> itemList = MultiRptFillDataUtils.getFormulaItemListFromMap(mapedItemList);
        int rowCount = 0;
        if (valueMap == null || valueMap.size() == 0) {
            MultiRptFillDataUtils.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), 0);
            MultiRptFillDataUtils.fillSumLine(param, sheet, basePoint, itemList, basePoint.y + 1, asstColCount, maxCol);
            param.setDefaultCounter(0);
            MultiRptFillDataUtils.saveBasePointCell(sheet, basePoint, param);
        } else {
            rowCount = MultiRptFillDataUtils.fillData(param, sheet, basePoint, itemList, valueMap, asstColCount, maxCol, buildInfo);
            MultiRptFillDataUtils.fillSumLine(param, sheet, basePoint, itemList, basePoint.y + 1 + rowCount, asstColCount, maxCol);
            param.setDefaultCounter(rowCount);
            MultiRptFillDataUtils.saveBasePointCell(sheet, basePoint, param);
            int startRow = param.getPosition() == 1 ? basePoint.y + 2 : basePoint.y + 1;
            int endRow = startRow + rowCount;
            MultiRptFillDataUtils.mergeCell(sheet, basePoint.x, basePoint.x + asstColCount - 1, startRow, endRow);
        }
        MultiRptFillDataUtils.setStyle(sheet, basePoint, param, rowCount);
    }

    private static void setStyle(Sheet sheet, Point basePoint, DynaParameters param, int rowCount) throws EASBizException, BOSException {
        if (rowCount > 0) {
            StyleDecoratorFormula sytleInherit = new StyleDecoratorFormula(null);
            RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
            if (param.isIncludeSum() && param.getPosition() == 1) {
                styleParam.setStartRow(basePoint.y + 2);
                styleParam.setStandardPoint(new Point(basePoint.x, basePoint.y + 1));
            } else {
                styleParam.setStartRow(basePoint.y + 1);
                styleParam.setStandardPoint(basePoint);
            }
            int endRow = styleParam.getStartRow() + rowCount - 1;
            styleParam.setEndRow(endRow);
            styleParam.setStartColumn(basePoint.x);
            styleParam.setEndColumn(MultiRptFillDataUtils.getMaxColIndex(sheet, basePoint));
            styleParam.setVerticalInherit(true);
            styleParam.setGradeFill(false);
            styleParam.setInsertInherit(false);
            sytleInherit.regionInheritStyleByDefaultPoint(sheet, styleParam);
            sytleInherit = new StyleDecoratorHeightOrWidth((IRptSheetSytleInherit)new RptSheetSytleInherit());
            sytleInherit = new StyleDecoratorValidation((IRptSheetSytleInherit)sytleInherit);
            sytleInherit.regionInheritStyleByDefaultPoint(sheet, styleParam);
        }
    }

    private static int getMaxColIndex(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !MultiRptFillDataUtils.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private static void mergeCell(Sheet sheet, int startCol, int endCol, int startRow, int endRow) {
    }

    private static int fillData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, Map valueMap, int asstColCount, int oldMaxCol, BuildElimRptBookInfo buildInfo) throws EASBizException, BOSException {
        List<AsstActTypeInfo> selectedAsstActType = MultiRptFillDataUtils.getSelectedAsstActTypeList(sheet.getID(), basePoint, buildInfo);
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int startRowIndex = basePoint.y + sumLine + 1;
        if (buildInfo.getMultDynaiSumTypeEnum() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            List companyList = MultiRptFillDataUtils.initCompanyList(buildInfo);
            OrgStructureInfo struct = MultiRptFillDataUtils.getCurrentStructure(buildInfo);
            Set dynaKeySet = (Set)valueMap.get("KEY_ALL_MULTIDYNAKEY");
            List dynaItemList = MultiRptFillDataUtils.analyzeDynaKey(sheet, basePoint, selectedAsstActType, dynaKeySet.iterator(), buildInfo);
            valueMap.remove("KEY_ALL_MULTIDYNAKEY");
            int realRowCount = 0;
            for (Map orgMap : valueMap.values()) {
                realRowCount += orgMap.size();
            }
            MultiRptFillDataUtils.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
            String longNumber = struct.getLongNumber();
            int longNumSize = longNumber.split("!").length;
            if (buildInfo.isOnlyListCompany()) {
                Collections.sort(companyList, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        if (o1 instanceof FullOrgUnitInfo && o2 instanceof FullOrgUnitInfo) {
                            String o1LongNum = ((FullOrgUnitInfo)o1).getLongNumber();
                            String o2LongNum = ((FullOrgUnitInfo)o2).getLongNumber();
                            int o1Len = o1LongNum.split("!").length;
                            int o2Len = o2LongNum.split("!").length;
                            return o1Len - o2Len;
                        }
                        return 0;
                    }
                });
            }
            for (OrgUnitInfo orgUnit : companyList) {
                Map orgValueMap = (Map)valueMap.get(orgUnit.getId().toString());
                if (orgValueMap == null) continue;
                int filledCount = MultiRptFillDataUtils.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActType, orgUnit, orgValueMap, startRowIndex, asstColCount, oldMaxCol, buildInfo);
                Range range = sheet.getRange(startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1);
                startRowIndex += filledCount;
            }
            MultiRptFillDataUtils.fillCompanyIDsToSheet(sheet, buildInfo);
            return realRowCount;
        }
        List dynaItemList = MultiRptFillDataUtils.analyzeDynaKey(sheet, basePoint, selectedAsstActType, valueMap.keySet().iterator(), buildInfo);
        int realRowCount = dynaItemList.size();
        MultiRptFillDataUtils.adjustRowCount(param, sheet, basePoint, asstColCount, param.getDefaultCounter(), realRowCount);
        int filledCount = MultiRptFillDataUtils.doFillItemAndData(param, sheet, basePoint, itemList, dynaItemList, selectedAsstActType, null, valueMap, startRowIndex, asstColCount, oldMaxCol, buildInfo);
        MultiRptFillDataUtils.fillBackColor(sheet, startRowIndex, basePoint.x, startRowIndex + filledCount - 1, basePoint.x + asstColCount + itemList.size() - 1, SortHelper.OUTBOUND_COMPANY_COLOR);
        MultiRptFillDataUtils.fillCompanyIDsToSheet(sheet, buildInfo);
        return realRowCount;
    }

    private static void fillBackColor(Sheet sheet, int startRowIndex, int startColIndex, int endRowIndex, int endColIndex, Color backColor) {
        Range range = sheet.getRange(startRowIndex, startColIndex, endRowIndex, endColIndex);
        StyleAttributes[] styles = MultiRptFillDataUtils.getRangeStyleAttributes(backColor);
        range.setStyle(styles[0], styles[1]);
    }

    private static OrgStructureInfo getCurrentStructure(BuildElimRptBookInfo buildInfo) throws EASBizException, BOSException {
        IOrgStructure istructure = buildInfo.getCtx() == null ? OrgStructureFactory.getRemoteInstance() : OrgStructureFactory.getLocalInstance((Context)buildInfo.getCtx());
        CslReportInfo report = buildInfo.getSrcCslRptInfo();
        return istructure.getValue(report.getOrgTree(), (OrgUnitInfo)report.getOrgUnit());
    }

    private static void fillCompanyIDsToSheet(Sheet sheet, BuildElimRptBookInfo buildInfo) {
        if (buildInfo.getMultDynaiSumTypeEnum() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            sheet.removeUserObject("COMPANY_NUMBER");
        } else {
            sheet.setUserObject("COMPANY_NUMBER", buildInfo.getCompanyList());
        }
    }

    private static int doFillItemAndData(DynaParameters param, Sheet sheet, Point basePoint, List itemList, List dynaItemList, List asstActTypeList, OrgUnitInfo curCompany, Map values, int startRowIndex, int asstColCount, int oldMaxCol, BuildElimRptBookInfo buildInfo) {
        int startItemColIndex = basePoint.x + asstColCount;
        int curRowIndex = startRowIndex;
        int newMaxCol = startItemColIndex + itemList.size() - 1;
        int count = 0;
        Map itemValMap = MultiRptFillDataUtils.getItemValMap(param, dynaItemList, asstActTypeList, buildInfo);
        for (int i = 0; i < dynaItemList.size(); ++i) {
            int asstIndex = 0;
            int itemIndex = 0;
            int startColIndex = basePoint.x;
            DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(i);
            String dItemKey = dynaKeyItem.toString();
            String dItem = dynaKeyItem.getDynaKey();
            if (buildInfo.getMultDynaiSumTypeEnum() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
                if (values.get(dItemKey) == null) continue;
                Range range = sheet.getRange(curRowIndex, startColIndex);
                range.setIgnoreProtected(true);
                range.setFormula(null);
                range.setUserObject("ITEM", null);
                range.setValue(new Variant((Object)curCompany.getName()));
                ++startColIndex;
                ++asstIndex;
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", (Object)curCompany.getId().toString());
                }
            } else {
                Row row = sheet.getRow(curRowIndex, false);
                if (row != null) {
                    row.setUserObject("COMPANY_NUMBER", null);
                }
            }
            ArrayList curAsstActTypelist = param.getAsstAccount().getAsstActTypeList();
            AsstActTypeInfo asstActTypeInfo = null;
            int x = startColIndex;
            while (x <= newMaxCol) {
                if (x < startItemColIndex) {
                    AsstActTypeUtils asstActType = (AsstActTypeUtils)curAsstActTypelist.get(buildInfo.getMultDynaiSumTypeEnum() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT ? asstIndex - 1 : asstIndex);
                    for (Object obj : asstActTypeList) {
                        if (!asstActType.asstHGAttribute.equals(((AsstActTypeInfo)obj).getAsstHGAttribute())) continue;
                        asstActTypeInfo = (AsstActTypeInfo)obj;
                        break;
                    }
                    String asstActTypeNumber = "";
                    String key = "";
                    if (asstActTypeInfo != null) {
                        asstActTypeNumber = asstActTypeInfo.getNumber();
                        key = asstActTypeInfo.getAsstHGAttribute() + "!" + dynaKeyItem.getItemNumber(asstActTypeNumber);
                    }
                    String itemNumber = dynaKeyItem.getItemNumber(asstActTypeNumber);
                    String itemName = "";
                    if (itemValMap.containsKey(key)) {
                        itemName = itemValMap.get(key).toString();
                    }
                    if (StringUtils.isEmpty((String)itemName)) {
                        itemName = dynaKeyItem.getItemName(asstActTypeNumber);
                    }
                    int colCount = MultiRptFillDataUtils.fillAsstItem(param, sheet, itemNumber, itemName, asstActTypeInfo, x, curRowIndex);
                    x += colCount;
                    ++asstIndex;
                    continue;
                }
                ItemFormula itemFormula = (ItemFormula)itemList.get(itemIndex);
                MultiRptFillDataUtils.fillItem(param, sheet, dItemKey, dItem, itemFormula, values, x, curRowIndex, itemIndex, buildInfo);
                ++x;
                ++itemIndex;
            }
            MultiRptFillDataUtils.clearExtraRange(sheet, curRowIndex, oldMaxCol, newMaxCol);
            ++count;
            ++curRowIndex;
        }
        return count;
    }

    private static void fillValue(Range range, Map valueMap, ItemFormula itemFormula, String dItemKey, BuildElimRptBookInfo buildInfo) {
        Map item2ValueMap;
        if (valueMap != null && (item2ValueMap = (Map)valueMap.get(dItemKey)) != null) {
            DataElementInfo dataElementInfo = buildInfo.getCtx() == null ? DataElementProvider.getDataElementInfo(itemFormula.getDataElementNumber()) : DataElementProvider.getDataElementInfo(buildInfo.getCtx(), itemFormula.getDataElementNumber());
            Object value = item2ValueMap.get(itemFormula.getItemNumber() + "@!@" + dataElementInfo.getInterSeq() + "@!@" + itemFormula.getValueType());
            if (value != null) {
                if (itemFormula.getValueType() != 3) {
                    try {
                        value = new BigDecimal(value.toString());
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                range.setValue(new Variant(value));
                return;
            }
        }
        if (itemFormula.getValueType() == 3) {
            range.setValue(Variant.nullVariant);
        } else {
            range.setValue(Variant.nullVariant);
        }
    }

    private static void fillItem(DynaParameters param, Sheet sheet, String dItemKey, String dItem, ItemFormula itemFormula, Map values, int x, int y, int colIndex, BuildElimRptBookInfo buildInfo) {
        Range range = sheet.getRange(y, x);
        range.setIgnoreProtected(true);
        if (itemFormula != null) {
            range.setFormula(null);
            MultiRptFillDataUtils.fillDItemFormula(range, itemFormula, dItem);
            MultiRptFillDataUtils.fillValue(range, values, itemFormula, dItemKey, buildInfo);
        } else {
            range.setUserObject("ITEM", null);
            range.setValue(Variant.nullVariant);
            range.setFormula(null);
        }
    }

    private static void fillDItemFormula(Range range, ItemFormula itemFormula, String dItemNumber) {
        String dItemFormula = MultiRptFillDataUtils.constructDItemFormula(itemFormula, dItemNumber);
        range.setUserObject("ITEM", (Object)new ItemFormula(dItemFormula));
    }

    private static String constructDItemFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum(itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum(itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private static int fillAsstItem(DynaParameters param, Sheet sheet, String itemNumber, String itemName, AsstActTypeInfo asstActTypeInfo, int x, int y) {
        Range range;
        int count = 0;
        AsstActTypeUtils asstActType = MultiRptFillDataUtils.getAsstActTypeUtils(param, asstActTypeInfo);
        if (!StringUtils.isEmpty((String)asstActType.properityName)) {
            range = sheet.getRange(y, x++);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemNumber));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.properityAlias)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.dynaProperty)) {
            sheet.getCell(y, x, true).setMerged(false);
            range = sheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setFormula(null);
            range.setUserObject("ITEM", null);
            range.setValue(new Variant((Object)itemName));
            ++count;
        }
        return count;
    }

    private static Map getItemValMap(DynaParameters param, List dynaItemList, List asstActTypeList, BuildElimRptBookInfo buildInfo) {
        HashMap<String, String> itemValMap = new HashMap<String, String>();
        for (int i = 0; i < asstActTypeList.size(); ++i) {
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)asstActTypeList.get(i);
            AsstActTypeUtils asstActType = MultiRptFillDataUtils.getAsstActTypeUtils(param, asstActTypeInfo);
            MetaDataPK pk = new MetaDataPK(asstActTypeInfo.getDefaultQueryName());
            IQueryExecutor exec = buildInfo.getCtx() == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk) : QueryExecutorFactory.getLocalInstance((Context)buildInfo.getCtx(), (IMetaDataPK)pk);
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            if ("numberandname".equalsIgnoreCase(asstActType.dynaProperty)) {
                sic.add("name");
            } else {
                sic.add(asstActType.dynaProperty);
            }
            sic.add("number");
            if (MultiRptFillDataUtils.isUsedLongNum(asstActTypeInfo)) {
                sic.add("longnumber");
            }
            ev.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            HashSet<String> numberSet = new HashSet<String>();
            for (int j = 0; j < dynaItemList.size(); ++j) {
                DynaKeyItem dynaKeyItem = (DynaKeyItem)dynaItemList.get(j);
                String dItemKey = dynaKeyItem.toString();
                String dItem = dynaKeyItem.getDynaKey();
                numberSet.add(dynaKeyItem.getItemNumber(asstActTypeInfo.getNumber()));
            }
            if (!MultiRptFillDataUtils.isUsedLongNum(asstActTypeInfo)) {
                filter.getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("longnumber", numberSet, CompareType.INCLUDE));
            }
            ev.setFilter(filter);
            exec.setObjectView(ev);
            try {
                IRowSet rs = exec.executeQuery();
                while (rs.next()) {
                    String key = !MultiRptFillDataUtils.isUsedLongNum(asstActTypeInfo) ? asstActTypeInfo.getAsstHGAttribute() + "!" + rs.getString("number") : asstActTypeInfo.getAsstHGAttribute() + "!" + rs.getString("longnumber");
                    String val = "";
                    val = "numberandname".equalsIgnoreCase(asstActType.dynaProperty) ? rs.getString("number") + "-" + rs.getString("name") : (rs.getString(asstActType.getDynaProperty()).equals("false") ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"87_DynaRangeUI") : (rs.getString(asstActType.getDynaProperty()).equals("true") ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"86_DynaRangeUI") : rs.getString(asstActType.getDynaProperty())));
                    itemValMap.put(key, val);
                }
                continue;
            }
            catch (BOSException e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e.getStackTrace(), (Throwable)e);
            }
        }
        return itemValMap;
    }

    private static boolean isUsedLongNum(AsstActTypeInfo asstActTypeInfo) {
        return RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo);
    }

    private static List analyzeDynaKey(Sheet sheet, Point basePoint, List asstActTypeList, Iterator iterator, BuildElimRptBookInfo buildInfo) {
        ArrayList<DynaKeyItem> result = new ArrayList<DynaKeyItem>();
        if (buildInfo.getMultDynaiSumTypeEnum() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            while (iterator.hasNext()) {
                String dynaKey = (String)iterator.next();
                DynaKeyItem item = new DynaKeyItem(dynaKey);
                result.add(item);
            }
            MultiKeyComparator multiKeyComparator = new MultiKeyComparator();
            multiKeyComparator.setAsstActTypeList(asstActTypeList);
            Collections.sort(result, multiKeyComparator);
        } else {
            HashMap<String, DynaKeyItem> dynaKeyMap = new HashMap<String, DynaKeyItem>();
            while (iterator.hasNext()) {
                String dynaKey = (String)iterator.next();
                DynaKeyItem item = new DynaKeyItem(dynaKey);
                dynaKeyMap.put(item.getDynaKey(), item);
            }
            List<Object> formerDynaKeyList = MultiRptFillDataUtils.getDynaKeyList(sheet.getSheetName(), basePoint, buildInfo);
            if (formerDynaKeyList == null || formerDynaKeyList.size() <= 0) {
                formerDynaKeyList = Arrays.asList(dynaKeyMap.keySet().toArray());
            }
            if (formerDynaKeyList != null) {
                MultiDynaItem multiDynaItem = MultiDynaItem.getInstance();
                for (String string : formerDynaKeyList) {
                    String string2 = multiDynaItem.sortDynaKey(string);
                    Object item = dynaKeyMap.get(string2);
                    if (item == null) continue;
                    result.add((DynaKeyItem)item);
                }
            }
        }
        return result;
    }

    private static List getDynaKeyList(String sheetName, Point basePoint, BuildElimRptBookInfo buildInfo) {
        Map sheetMap = (Map)buildInfo.getDynaKeyCache().get(sheetName);
        if (sheetMap != null) {
            return (List)sheetMap.get(basePoint);
        }
        return null;
    }

    private static List initCompanyList(BuildElimRptBookInfo buildInfo) throws EASBizException, BOSException {
        List companyList = buildInfo.getCompanyList();
        String orgTreeID = buildInfo.getSrcCslRptInfo().getOrgTree().getId().toString();
        if (buildInfo.isOnlyListCompany()) {
            IMultiInterCheckageFacade iFacade = buildInfo.getCtx() == null ? MultiInterCheckageFacadeFactory.getRemoteInstance() : MultiInterCheckageFacadeFactory.getLocalInstance((Context)buildInfo.getCtx());
            companyList = iFacade.getOrgBoundLeafCompanys(companyList, orgTreeID);
        }
        ObjectValueComparator comparator = new ObjectValueComparator();
        comparator.setFieldName("longnumber");
        Collections.sort(companyList, comparator);
        return companyList;
    }

    private static void saveBasePointCell(Sheet sheet, Point basePoint, DynaParameters param) {
        Range range = sheet.getRange(basePoint.y, basePoint.x);
        DynamicTemplateUtility.saveParametersToCell((Range)range, (DynaParameters)param);
    }

    private static void fillSumLine(DynaParameters param, Sheet sheet, Point basePoint, List itemList, int row, int asstColCount, int oldMaxCol) {
        if (!param.isIncludeSum()) {
            return;
        }
        int sumCellRow = param.getPosition() == 2 ? row : basePoint.y + 1;
        MultiRptFillDataUtils.fillSumTitle(param, sheet, basePoint, sumCellRow, asstColCount);
        int Count = itemList.size();
        int col = basePoint.x + asstColCount;
        if (row == basePoint.y + 1) {
            MultiRptFillDataUtils.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
            return;
        }
        int i = 0;
        while (i < Count) {
            ItemFormula itemFormula = (ItemFormula)itemList.get(i);
            if (itemFormula.getValueType() != 3) {
                String endCellName;
                String startCellName;
                Range sumCell;
                if (param.getPosition() == 1) {
                    sumCell = sheet.getRange(sumCellRow, col);
                    startCellName = Location.getCellName(basePoint.y + 1 + 1, col);
                    endCellName = Location.getCellName(row, col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                } else if (param.getPosition() == 2) {
                    sumCell = sheet.getRange(sumCellRow, col);
                    startCellName = Location.getCellName(basePoint.y + 1, col);
                    endCellName = Location.getCellName(row - 1, col);
                    sumCell.setUserObject("ITEM", null);
                    sumCell.setFormula("=sum(" + startCellName + ":" + endCellName + ")");
                }
            }
            ++i;
            ++col;
        }
        Row sumRow = sheet.getRow(sumCellRow, false);
        if (sumRow != null) {
            sumRow.setUserObject("COMPANY_NUMBER", null);
        }
        MultiRptFillDataUtils.clearExtraRange(sheet, sumCellRow, oldMaxCol, col - 1);
    }

    private static void fillSumTitle(DynaParameters param, Sheet table, Point basePoint, int row, int asstCount) {
        if (!param.isIncludeSum()) {
            return;
        }
        Point sumPoint = new Point();
        sumPoint.x = basePoint.x;
        sumPoint.y = row;
        Range range = table.getRange(sumPoint.y, sumPoint.x);
        range.setIgnoreProtected(true);
        range.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Msg_Total")));
        for (int i = 0; i < asstCount; ++i) {
            range = table.getRange(sumPoint.y, i + 1 + basePoint.x);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", null);
            range.setFormula(null);
            range.setValue(new Variant((Object)"--"));
        }
    }

    private static void adjustRowCount(DynaParameters param, Sheet sheet, Point basePoint, int asstColCount, int oldRowCount, int realRowCount) {
        if (realRowCount > oldRowCount) {
            MultiRptFillDataUtils.addSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        } else if (realRowCount < oldRowCount) {
            MultiRptFillDataUtils.removeSheetRows(param, sheet, basePoint, realRowCount, oldRowCount);
        }
        if (realRowCount == 0) {
            return;
        }
    }

    private static StyleAttributes[] getRangeStyleAttributes(Color backgroudColor) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.TOP, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.LEFT, Color.LIGHT_GRAY);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderColor(Styles.Position.RIGHT, Color.LIGHT_GRAY);
        sa.setBackground(backgroudColor);
        StyleAttributes saInner = Styles.getEmptySA();
        saInner.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        saInner.setBorderColor(Styles.Position.TOP, Color.LIGHT_GRAY);
        saInner.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        saInner.setBorderColor(Styles.Position.LEFT, Color.LIGHT_GRAY);
        saInner.setBackground(backgroudColor);
        return new StyleAttributes[]{sa, saInner};
    }

    private static int getFormulaColumns(DynaParameters param, Sheet sheet, Point basePoint) {
        int count = 0;
        if (param.getSpreadStyle() == 1) {
            int m = sheet.getRows().getMaxIntMark();
            for (int j = basePoint.y + 1; j <= m; ++j) {
                ItemFormula f = SumHelper.getFormula(sheet.getRange(j, basePoint.x));
                if (f == null) continue;
                ++count;
            }
        } else {
            int m = sheet.getCols().getMaxIntMark();
            for (int j = basePoint.x + 1; j <= m; ++j) {
                ItemFormula f = SumHelper.getFormula(sheet.getRange(basePoint.y, j));
                if (f == null) continue;
                ++count;
            }
        }
        return count;
    }

    private static void addSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int y1 = y + oldMaxRowCount + 1 + sumLine;
        int y2 = y + rowCount + sumLine;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.insert(true, InsertType.NOSTYLE);
    }

    private static void removeSheetRows(DynaParameters param, Sheet sheet, Point basePoint, int rowCount, int oldMaxRowCount) {
        int y = basePoint.y;
        int sumLine = param.isIncludeSum() && param.getPosition() == 1 ? 1 : 0;
        int y1 = y + rowCount + 1 + sumLine;
        int y2 = y + oldMaxRowCount + sumLine;
        Range range = sheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.delete();
    }

    private static List<Object> getFormulaItemListFromMap(List<Map<Object, Object>> mapedItemList) {
        ArrayList<Object> itemList = new ArrayList<Object>(mapedItemList.size());
        for (Map<Object, Object> map : mapedItemList) {
            itemList.add(map.get("formulas"));
        }
        return itemList;
    }

    private static void fillHeadItemFormula(Sheet sheet, Point basePoint, List<Map<Object, Object>> itemFormulaList, int asstColCount, int maxCol) {
        int col = basePoint.x + asstColCount;
        for (Map<Object, Object> map : itemFormulaList) {
            ItemFormula itemFormula = (ItemFormula)map.get("formulas");
            Variant value = (Variant)map.get("KEY_DITEM_NAME");
            String formula = (String)map.get("funtion_formula");
            Range range = sheet.getRange(basePoint.y, col++);
            range.setIgnoreProtected(true);
            range.setUserObject("ITEM", (Object)itemFormula);
            range.setValue(value);
            range.setFormula(formula);
        }
        MultiRptFillDataUtils.clearExtraRange(sheet, basePoint.y, maxCol, col - 1);
    }

    private static void clearExtraRange(Sheet sheet, int row, int oldMaxCol, int curMaxCol) {
        if (curMaxCol < oldMaxCol) {
            for (int i = curMaxCol + 1; i <= oldMaxCol; ++i) {
                Range range = sheet.getRange(row, i);
                MultiRptFillDataUtils.clearRange(range);
            }
        }
    }

    private static void clearRange(Range range) {
        range.setIgnoreProtected(true);
        range.setValue(Variant.nullVariant);
        range.setUserObject("ITEM", null);
        range.setFormula(null);
    }

    private static List<Map<Object, Object>> getItemFormulaList(Sheet sheet, Point basePoint, int maxCol) {
        ArrayList<Map<Object, Object>> list = new ArrayList<Map<Object, Object>>();
        for (int j = basePoint.x + 1; j <= maxCol; ++j) {
            Range range = sheet.getRange(basePoint.y, j);
            ItemFormula f = SumHelper.getFormula(range);
            if (f == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("formulas", f);
            map.put("KEY_DITEM_NAME", range.getValue());
            map.put("funtion_formula", range.getFormula());
            list.add(map);
        }
        return list;
    }

    private static int getMaxColIndex(Sheet curSheet, Point basePoint) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > basePoint.x; --i) {
            Cell cell = curSheet.getCell(basePoint.y, i, false);
            if (cell == null || !MultiRptFillDataUtils.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private static boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj != null;
    }

    private static List<AsstActTypeInfo> getSelectedAsstActTypeList(String sheetId, Point point, BuildElimRptBookInfo buildInfo) {
        CellReference cellReference = new CellReference(point.x, point.y);
        if (buildInfo.getSheetAsstActTypeMap() == null) {
            return null;
        }
        String key = sheetId + "|" + cellReference.getRow() + "|" + cellReference.getCol();
        AsstActTypeCollection asstActTypeColl = buildInfo.getSheetAsstActTypeMap().get(key);
        if (asstActTypeColl != null) {
            AsstActTypeInfo[] arrs = new AsstActTypeInfo[asstActTypeColl.size()];
            int size = asstActTypeColl.size();
            for (int i = 0; i < size; ++i) {
                arrs[i] = asstActTypeColl.get(i);
            }
            return Arrays.asList(arrs);
        }
        return null;
    }

    private static int fillHeadAsstItem(Sheet sheet, DynaParameters parameters, Point basePoint, List selectedAsstActTypeList, int maxCol, BuildElimRptBookInfo buildInfo) {
        Range cell;
        if (selectedAsstActTypeList == null || selectedAsstActTypeList.size() == 0) {
            return 0;
        }
        int dv = 0;
        if (buildInfo.getMultDynaiSumTypeEnum() == MultiDynaSumTypeEnum.BYCOMPANYANDASSTACCOUNT) {
            cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setValue(new Variant((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DynaMsgResource", (String)"Company")));
            if (sheet.getUserObject("needSetInsertStyle") == null) {
                Range range = sheet.getColRange(basePoint.x + 1, basePoint.x + 1);
                range.setIgnoreProtected(true);
                range.insert(false, InsertType.FLLOW_UP_STYLE);
                sheet.setUserObject("needSetInsertStyle", (Object)"");
            }
            ++dv;
        }
        for (Object obj : parameters.getAsstAccount().getAsstActTypeList()) {
            AsstActTypeUtils acctType = (AsstActTypeUtils)obj;
            if (acctType == null) continue;
            if (!StringUtils.isEmpty((String)acctType.properityName)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityName));
                ++dv;
            }
            if (!StringUtils.isEmpty((String)acctType.properityAlias)) {
                cell = sheet.getRange(basePoint.y, basePoint.x + dv);
                cell.setIgnoreProtected(true);
                cell.setFormula(null);
                if (dv != 0) {
                    cell.setUserObject("ITEM", null);
                }
                cell.setValue(new Variant((Object)acctType.properityAlias));
                ++dv;
            }
            if (StringUtils.isEmpty((String)acctType.dynaProperty)) continue;
            cell = sheet.getRange(basePoint.y, basePoint.x + dv);
            cell.setIgnoreProtected(true);
            cell.setFormula(null);
            if (dv != 0) {
                cell.setUserObject("ITEM", null);
            }
            cell.setValue(new Variant((Object)acctType.dynapropertyName));
            ++dv;
        }
        return dv;
    }

    private static AsstActTypeUtils getAsstActTypeUtils(DynaParameters param, AsstActTypeInfo asstActTypeInfo) {
        for (AsstActTypeUtils asstutil : param.getAsstAccount().getAsstActTypeList()) {
            if (!asstutil.asstHGAttribute.equals(asstActTypeInfo.getAsstHGAttribute())) continue;
            return asstutil;
        }
        return null;
    }

    private static Object[] sortByPosistion(Sheet table, Set set) {
        Object[] basePointArray = set.toArray();
        if (basePointArray.length > 0) {
            Point basePoint = (Point)basePointArray[0];
            DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)table, (int)basePoint.y, (int)basePoint.x);
            if (param != null) {
                if (param.getSpreadStyle() == 1) {
                    Arrays.sort(basePointArray, new PointXComparator());
                } else {
                    Arrays.sort(basePointArray, new PointYComparator());
                }
            }
        }
        return basePointArray;
    }

    private static class DynaKeyItem {
        private Map typeNumberMap;
        private String[] itemNumber;
        private String[] itemName;

        DynaKeyItem(String dynaKey) {
            String[] typeItem = patternType.split(dynaKey);
            this.typeNumberMap = new HashMap();
            this.itemNumber = new String[typeItem.length];
            this.itemName = new String[typeItem.length];
            for (int j = 0; j < typeItem.length; ++j) {
                String[] eachItem = patternItem.split(typeItem[j]);
                this.typeNumberMap.put(eachItem[0], new Integer(j));
                String[] split = pattern2Name.split(eachItem[1]);
                this.itemNumber[j] = split[0];
                this.itemName[j] = split[1];
            }
        }

        String getItemNumber(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemNumber[seq];
            }
            return null;
        }

        String getItemName(String typeNumber) {
            Integer seq = (Integer)this.typeNumberMap.get(typeNumber);
            if (seq != null) {
                return this.itemName[seq];
            }
            return null;
        }

        String getDynaKey() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }

        public String toString() {
            String[] item = new String[this.itemNumber.length];
            for (Map.Entry entry : this.typeNumberMap.entrySet()) {
                String typeNumber = (String)entry.getKey();
                Integer seq = (Integer)entry.getValue();
                item[seq.intValue()] = typeNumber + "|" + this.itemNumber[seq] + "@!@" + this.itemName[seq];
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < item.length; ++i) {
                if (i != 0) {
                    sb.append(";");
                }
                sb.append(item[i]);
            }
            return sb.toString();
        }
    }

    private static class MultiKeyComparator
    implements Comparator {
        private List asstActTypeNumberList = new ArrayList();

        private MultiKeyComparator() {
        }

        public int compare(Object o1, Object o2) {
            DynaKeyItem key1 = (DynaKeyItem)o1;
            DynaKeyItem key2 = (DynaKeyItem)o2;
            for (String typeNumber : this.asstActTypeNumberList) {
                String item2;
                String item1 = key1.getItemNumber(typeNumber);
                int compareTo = item1.compareTo(item2 = key2.getItemNumber(typeNumber));
                if (compareTo == 0) continue;
                return compareTo;
            }
            return 0;
        }

        public void setAsstActTypeList(List asstActTypeList) {
            this.asstActTypeNumberList.clear();
            for (AsstActTypeInfo asstActTypeInfo : asstActTypeList) {
                this.asstActTypeNumberList.add(asstActTypeInfo.getNumber());
            }
        }
    }
}

