/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.report.CslReportProvider;
import com.kingdee.eas.fi.gr.cslrpt.excel.ExcelClient;
import com.kingdee.eas.fi.gr.cslrpt.excel.ExcelConstants;
import com.kingdee.eas.fi.gr.cslrpt.excel.ExcelServerManager;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.ExcelJacobUtil;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.ExcelUtil;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ExcelClientHelper {
    private static final Logger logger = Logger.getLogger(ExcelClientHelper.class);
    private static ExcelClientHelper instance;
    private static boolean isStarted;

    public static ExcelClientHelper getInstance() {
        if (instance == null) {
            instance = new ExcelClientHelper();
        }
        return instance;
    }

    public static void setStarted(boolean isStarted) {
        ExcelClientHelper.isStarted = isStarted;
    }

    public void openExcel(String reportId, boolean isFromMergeReportCenter) throws Exception {
        if (StringUtils.isEmpty((String)reportId)) {
            return;
        }
        CslReportInfo reportInfo = CslReportFactory.getRemoteInstance().getCslReportInfo((IObjectPK)new ObjectStringPK(reportId), new CslReportProvider().getSelectors());
        if (isFromMergeReportCenter) {
            if (RptSrcTypeEnum.MANUSCRIPT.equals((Object)reportInfo.getSourceType()) || RptSrcTypeEnum.MANUSCRIPT_FASTMERGE.equals((Object)reportInfo.getSourceType()) || RptSrcTypeEnum.CONSOLIDATION.equals((Object)reportInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT.equals((Object)reportInfo.getSourceType()) || RptSrcTypeEnum.CONSOLIDATION_FASTMERGE.equals((Object)reportInfo.getSourceType()) || RptSrcTypeEnum.DYNAMICCSLREPORT_FASTMERGE.equals((Object)reportInfo.getSourceType())) {
                this.doOpenExcel(reportInfo, isFromMergeReportCenter);
            } else {
                MsgBox.showWarning((String)(reportInfo.getSourceType().getAlias() + EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingModificationResource", (String)"68_ExcelClientHelper")));
            }
        } else {
            this.doOpenExcel(reportInfo, isFromMergeReportCenter);
        }
    }

    private void doOpenExcel(ReportBaseInfo reportInfo, boolean isFromMergeReportCenter) throws Exception {
        String file;
        if (reportInfo == null) {
            return;
        }
        String basePath = ExcelConstants.EXCEL_EXPORT_PATH;
        File f = new File(FilenameUtils.normalize((String)basePath));
        if (!f.exists() && !f.isDirectory()) {
            f.mkdir();
        }
        if (new File(FilenameUtils.normalize((String)(file = ExcelUtil.getExportFile(reportInfo, isFromMergeReportCenter)))).exists()) {
            File temmf = new File(FilenameUtils.normalize((String)basePath));
            if (temmf.isDirectory()) {
                File[] fs = temmf.listFiles();
                String deleteExcel = null;
                for (File temp : fs) {
                    if (!temp.isFile()) continue;
                    try {
                        temp.delete();
                        if (deleteExcel == null) {
                            deleteExcel = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"957_ExcelClientHelper");
                        }
                        logger.info((Object)(deleteExcel + temp.getName()));
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                }
            }
            if (new File(FilenameUtils.normalize((String)file)).exists()) {
                MsgBox.showInfo((String)ExcelConstants.MSG_EXCEL_OPENED);
                return;
            }
        }
        Book book = reportInfo.getBook();
        int count = book.getSheetCount();
        String[] sns = new String[count];
        for (int i = 0; i < count; ++i) {
            sns[i] = book.getSheetName(i);
        }
        this.downloadBook(book, file);
        this.doAfterExport(file, reportInfo, isFromMergeReportCenter);
    }

    private void doAfterExport(String path, ReportBaseInfo reportInfo, boolean isFromMergeReportCenter) {
        try {
            this.refreshTemp();
            if (!isStarted) {
                Thread t = new Thread(new ExcelClient());
                t.start();
                isStarted = true;
            }
            HashMap<String, String> initProps = new HashMap<String, String>();
            initProps.put("reportId", reportInfo.getId().toString());
            initProps.put("url", "http://localhost:" + ExcelServerManager.port);
            initProps.put("sessionId", this.getSessionId());
            initProps.put("reportType", "groupRpt");
            initProps.put("isRpt", "1");
            initProps.put("rptSourceType", reportInfo.getSourceType().getValue() + "");
            initProps.put("isFromMergeReportCenter", String.valueOf(isFromMergeReportCenter));
            ExcelJacobUtil.openExcel(path, initProps);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            MsgBox.showError((String)"Fail to open Excel client, Please contact the administrator!");
        }
    }

    private String getSessionId() {
        return System.currentTimeMillis() + "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTemp() {
        InputStream is = null;
        BufferedInputStream bis = null;
        File file = null;
        FileOutputStream fos = null;
        try {
            is = this.getClass().getResourceAsStream("EAS_AddIn.xlam");
            bis = new BufferedInputStream(is);
            file = new File(FilenameUtils.normalize((String)ExcelUtil.getExcelDir()));
            if (!file.exists() && !file.isDirectory()) {
                file.mkdir();
            }
            if (!(file = new File(FilenameUtils.normalize((String)(ExcelUtil.getExcelDir() + File.separator + "EAS_AddIn.xlam")))).exists() || file.isDirectory()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = bis.read(buf)) != -1) {
                fos.write(buf, 0, len);
            }
            fos.flush();
        }
        catch (IOException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                CslRptUtil.closeOutputStream(fos);
                CslRptUtil.closeInputStream(bis);
                CslRptUtil.closeInputStream(is);
                throw throwable;
            }
            CslRptUtil.closeOutputStream(fos);
            CslRptUtil.closeInputStream(bis);
            CslRptUtil.closeInputStream(is);
        }
        CslRptUtil.closeOutputStream(fos);
        CslRptUtil.closeInputStream(bis);
        CslRptUtil.closeInputStream(is);
    }

    public static void main(String[] args) {
        String a = "";
        String sourcePath = ExcelClientHelper.class.getResource("EAS_AddIn.xlam").getFile();
        System.out.println(sourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void downloadBook(Book book, String bookPath) {
        File file = new File(FilenameUtils.normalize((String)bookPath));
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            Book tempBook = SpreadHelper.copyBook((Book)book);
            BookDataWrapper bookDataWrapper = new BookDataWrapper(tempBook);
            bookDataWrapper.setExportFormula(true);
            bookDataWrapper.setExportCustomerFomulas(false);
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            SXSSFExportWrapper bookWrpper = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
            bookWrpper.write((OutputStream)os);
            os.flush();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            CslRptUtil.closeOutputStream(os);
        }
        catch (Exception e2) {
            logger.error((Object)e2.getMessage(), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    CslRptUtil.closeOutputStream(os);
                    throw throwable;
                }
            }
            CslRptUtil.closeOutputStream(os);
        }
        CslRptUtil.closeOutputStream(os);
    }

    static {
        isStarted = false;
    }
}

