/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.export;

import com.kingdee.bos.ctrl.common.digitalstyle.Format;
import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.excel.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.ui.ExportEvent;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleUtil;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.DigitFormatPane;
import com.kingdee.eas.fi.gr.cslrpt.excel.export.MyXSSFWorkbookWrapper;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.values.XmlObjectBase;
import org.openxmlformats.schemas.officeDocument.x2006.relationships.STRelationshipId;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCol;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCols;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRow;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetData;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STCellType;

public class MyXSSFWorksheetWrapper
extends POIXMLDocumentPart {
    public static final Logger log = LogUtil.getPackageLogger(SXSSFExportWrapper.class);
    private XSSFSheet _host;
    private XSSFSheet _sheetBuffer;
    private AbstractDataWrapper _dataSource;
    private XSSFRow _rowBuffer;
    private StringBuffer sb = new StringBuffer(32);
    private static final QName SHEETDATA = new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "sheetData");
    private static final String SHEETDATA_START = "<worksheet xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\">";
    private static final String SHEETDATA_END = "</worksheet>";
    private static final String SHEETDATA_TAG = "<sheetData/>";
    private FileOutputStream _rowDataTmpStream;
    private FileOutputStream _mergeBlockTmpStream;
    private File _rowDataTmpFile;
    private File _mergeBlockTmpFile;
    private FileInputStream _mergeBlockTmpLoader;
    private String template_start;
    private String template_end;
    private MyXSSFWorkbookWrapper _workbook;
    private XSSFCellStyle emptyStyle;
    private XSSFCellStyle dateStyle;
    private XSSFCellStyle dateTimeStyle;
    private XSSFDataFormat format;
    private HashMap stylesMap;
    private HashMap fontsMap;
    private int _index;
    public static boolean DEBUG = true;
    public static boolean NOTIFY = true;
    long startTime_All;
    long startTime_SettingValue;
    long startTime_MovingCursor;
    long startTime_serialize;
    long startTime_While;
    long startTime_Finish;
    long startTime_GetText;
    long startTime_WriteToDisk;
    long sum_All = 0L;
    long sum_SettingValue = 0L;
    long sum_MovingCursor = 0L;
    long sum_Serialize = 0L;
    long sum_GetText = 0L;
    long sum_WriteToDisk = 0L;
    private ArrayList hyperList;

    MyXSSFWorksheetWrapper(MyXSSFWorkbookWrapper workbook, XSSFSheet sheet, AbstractDataWrapper datas, int index) {
        this._host = sheet;
        this._index = index;
        this._dataSource = datas;
        this._workbook = workbook;
        this.emptyStyle = this._workbook._host.createCellStyle();
        this.format = this._workbook._host.createDataFormat();
        this.createEmptyStyle();
    }

    protected void createEmptyStyle() {
        this.emptyStyle.setFillPattern(FillPatternType.NO_FILL);
        this.emptyStyle.setFillForegroundColor((short)0);
        this.emptyStyle.setFillBackgroundColor(new XSSFColor(Color.WHITE));
        this.emptyStyle.setAlignment(HorizontalAlignment.CENTER);
        this.emptyStyle.setHidden(false);
        this.emptyStyle.setLocked(false);
        this.emptyStyle.setBorderLeft(BorderStyle.NONE);
        this.emptyStyle.setBorderRight(BorderStyle.NONE);
        this.emptyStyle.setBorderTop(BorderStyle.NONE);
        this.emptyStyle.setBorderBottom(BorderStyle.NONE);
        short backColorIndex = HSSFColor.HSSFColorPredefined.BLACK.getIndex();
        this.emptyStyle.setBottomBorderColor(backColorIndex);
        this.emptyStyle.setTopBorderColor(backColorIndex);
        this.emptyStyle.setLeftBorderColor(backColorIndex);
        this.emptyStyle.setRightBorderColor(backColorIndex);
        this.emptyStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFFont defaultFont = this._workbook._host.createFont();
        defaultFont.setFontName(EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"958_MyXSSFWorksheetWrapper"));
        short size = 12;
        defaultFont.setFontHeightInPoints(size);
        this.emptyStyle.setFont((Font)defaultFont);
    }

    public String getSheetName() {
        return this._host.getSheetName();
    }

    public int getSheetIndex() {
        return this._index;
    }

    public void commit() throws IOException {
        this._dataSource.setCurrentSheetIndex(this._index);
        int i = 0;
        int j = 0;
        while (!this._dataSource.isColEnd(i)) {
            if (!this._dataSource.isHideCol(i)) {
                if (this._dataSource.colWidthAt(i) == 72) {
                    ++j;
                } else {
                    this._host.setColumnWidth(j++, (int)UnitConverter.px2mm((int)this._dataSource.colWidthAt(i)) * 140);
                }
            }
            ++i;
        }
        PackagePart part = this._host.getPackagePart();
        OutputStream out = part.getOutputStream();
        this._rowDataTmpFile = File.createTempFile("tmp" + this._host.getSheetName(), ".xml");
        this._rowDataTmpStream = new FileOutputStream(this._rowDataTmpFile);
        this._mergeBlockTmpFile = File.createTempFile("tmp" + this._host.getSheetName(), ".xml");
        this._mergeBlockTmpStream = new FileOutputStream(this._mergeBlockTmpFile);
        this.stylesMap = new HashMap(20);
        this.fontsMap = new HashMap(20);
        this._dataSource.setOutlineGroupDir(this._host);
        this.write(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(OutputStream out) throws IOException {
        CTCols col;
        CTCol[] cols;
        CTWorksheet worksheet;
        if (this._workbook._queue != null && NOTIFY) {
            this._workbook._queue.enQueue(new ExportEvent("export sheet(" + this.getSheetName() + ")", "preparing sheet"));
        }
        if (DEBUG) {
            this.startTime_All = System.currentTimeMillis();
        }
        if ((worksheet = this._host.getCTWorksheet()).getColsArray().length == 1 && (cols = (col = worksheet.getColsArray(0)).getColArray()).length == 0) {
            worksheet.setColsArray(null);
        }
        try {
            XmlCursor sheetCursor = ((XmlObjectBase)worksheet).newCursor();
            XmlOptions options = new XmlOptions();
            options.setSaveSyntheticDocumentElement(new QName(CTWorksheet.type.getName().getNamespaceURI(), "worksheet"));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(STRelationshipId.type.getName().getNamespaceURI(), "r");
            options.setSaveSuggestedPrefixes(map);
            int rowNum = 0;
            int excelRowNum = 0;
            this.prepare(options, sheetCursor);
            this.createBuffer();
            if (DEBUG) {
                log.info((Object)("-------------preparing buffer consuming " + (System.currentTimeMillis() - this.startTime_All) + " ms----------------"));
            }
            if (DEBUG) {
                this.startTime_While = System.currentTimeMillis();
            }
            if (this._workbook._queue != null && NOTIFY) {
                this._workbook._queue.enQueue(new ExportEvent("export sheet(" + this.getSheetName() + ")", "filling datas"));
            }
            this._sheetBuffer = this._host;
            while (!this._dataSource.isRowEnd(rowNum)) {
                if (this._dataSource.isHideRow(rowNum)) {
                    ++rowNum;
                    continue;
                }
                if (excelRowNum >= 0) {
                    if (DEBUG) {
                        this.startTime_serialize = System.currentTimeMillis();
                    }
                    if (this._workbook._queue != null && NOTIFY) {
                        this._workbook._queue.enQueue(new ExportEvent("export sheet(" + this.getSheetName() + ")", "serializing datas"));
                    }
                    this.serializeOnce(sheetCursor, options);
                    if (DEBUG) {
                        this.sum_Serialize += System.currentTimeMillis() - this.startTime_serialize;
                        log.info((Object)("-------------serialize one time consuming " + (System.currentTimeMillis() - this.startTime_serialize) + " ms----------------"));
                        this.startTime_MovingCursor = System.currentTimeMillis();
                    }
                    if (this._workbook._queue != null && NOTIFY) {
                        this._workbook._queue.enQueue(new ExportEvent("export sheet(" + this.getSheetName() + ")", "moving cursors"));
                    }
                    this._sheetBuffer = new XSSFWorkbook().createSheet(this.getSheetName());
                    sheetCursor = this._sheetBuffer.getCTWorksheet().newCursor();
                    this._rowBuffer = this._sheetBuffer.createRow(excelRowNum);
                    this._rowBuffer.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)this._dataSource.rowHeightAt(rowNum)) * 10.0f)) * 20.0));
                    this._dataSource.setGroupRow(this._host, this._rowBuffer);
                    if (DEBUG) {
                        this.sum_MovingCursor += System.currentTimeMillis() - this.startTime_MovingCursor;
                        log.info((Object)("-------------clearing and moving cursor consuming " + (System.currentTimeMillis() - this.startTime_MovingCursor) + " ms----------------"));
                    }
                }
                if (excelRowNum > 1048575) {
                    throw new IllegalArgumentException("too much rows!");
                }
                this.fillRow(rowNum, excelRowNum, options);
                ++excelRowNum;
                ++rowNum;
            }
            if (DEBUG) {
                log.info((Object)("------------while circle consuming " + (System.currentTimeMillis() - this.startTime_While) + " ms---------------"));
                this.startTime_Finish = System.currentTimeMillis();
            }
            int e = 1;
            CTSheetData sheetData = worksheet.getSheetData();
            if (excelRowNum != 0) {
                this._host.removeRow((Row)this._host.getRow(0));
                if (sheetData.sizeOfRowArray() != 0) {
                    sheetData.removeRow(0);
                }
                this._rowBuffer = this._host.createRow(excelRowNum - 1);
            }
            ArrayList<CTRow> list = new ArrayList<CTRow>(e);
            list.add(this._rowBuffer.getCTRow());
            CTRow[] rowArr = new CTRow[e];
            list.toArray(rowArr);
            sheetData.setRowArray(rowArr);
            this.serializeOnce(sheetCursor, options);
            rowArr = null;
            list = null;
            System.gc();
            this._rowBuffer = null;
            this.finish(options);
        }
        finally {
            this._rowDataTmpStream.close();
            if (this._mergeBlockTmpLoader != null) {
                this._mergeBlockTmpLoader.close();
                this._mergeBlockTmpLoader = null;
            }
            this._rowDataTmpStream = null;
            out.close();
        }
        if (DEBUG) {
            log.info((Object)("------------export one sheet consuming " + (System.currentTimeMillis() - this.startTime_All) + " ms---------------"));
            log.info((Object)("------------moving cursor consuming " + this.sum_MovingCursor + " ms---------------"));
            log.info((Object)("------------fill data consuming " + this.sum_SettingValue + " ms---------------"));
            log.info((Object)("------------finishing sheet consuming " + (System.currentTimeMillis() - this.startTime_Finish) + " ms---------------"));
            log.info((Object)("------------serialize data consuming " + this.sum_Serialize + " ms---------------"));
            log.info((Object)("   ------------get xml text consuming " + this.sum_GetText + " ms---------------"));
            log.info((Object)("   ------------write to disk consuming " + this.sum_WriteToDisk + " ms---------------"));
        }
    }

    private void createBuffer() {
        this._rowBuffer = this._host.createRow(0);
        this._rowBuffer.setHeight((short)(StyleUtil.lomToPt((double)((float)UnitConverter.px2mm((int)this._dataSource.rowHeightAt(0)) * 10.0f)) * 20.0));
    }

    private void serializeOnce(XmlCursor sheetCursor, XmlOptions options) throws IOException {
        if (DEBUG) {
            this.startTime_GetText = System.currentTimeMillis();
        }
        String sourceDatas = sheetCursor.xmlText(options);
        sheetCursor.toChild(SHEETDATA);
        String datas = sheetCursor.xmlText(options);
        datas = datas.substring(SHEETDATA_START.length(), datas.indexOf(SHEETDATA_END));
        if (DEBUG) {
            this.sum_GetText += System.currentTimeMillis() - this.startTime_GetText;
            this.startTime_WriteToDisk = System.currentTimeMillis();
        }
        this._rowDataTmpStream.write(datas.getBytes("utf-8"));
        this._rowDataTmpStream.flush();
        int mergeIndex = sourceDatas.indexOf("<mergeCells>");
        if (mergeIndex > 0) {
            datas = sourceDatas.substring(mergeIndex + "<mergeCells>".length(), sourceDatas.indexOf("</mergeCells>"));
            this._mergeBlockTmpStream.write(datas.getBytes("utf-8"));
            this._mergeBlockTmpStream.flush();
        }
        datas = null;
        if (DEBUG) {
            this.sum_WriteToDisk += System.currentTimeMillis() - this.startTime_WriteToDisk;
        }
    }

    protected File getTmpFile() {
        return this._rowDataTmpFile;
    }

    protected void prepare(XmlOptions options, XmlCursor cursor) throws IOException {
        this._host.getCTWorksheet().getSheetData().setRowArray(null);
        String template = cursor.xmlText(options);
        this.template_start = template.substring(0, template.indexOf(SHEETDATA_TAG));
        this._rowDataTmpStream.write((this.template_start + "<sheetData>").getBytes());
        this._rowDataTmpStream.flush();
    }

    protected void finish(XmlOptions options) throws IOException {
        boolean hasMergeBlocks;
        CTWorksheet sheet = this._host.getCTWorksheet();
        sheet.getSheetData().setRowArray(null);
        XmlCursor cursor = sheet.newCursor();
        String template = cursor.xmlText(options);
        this.template_end = template.substring(template.indexOf(SHEETDATA_TAG) + SHEETDATA_TAG.length(), template.indexOf("<pageMargins"));
        this._rowDataTmpStream.write("</sheetData>".getBytes());
        int mergeIndex = template.indexOf("<mergeCells>");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        String merges = null;
        this._mergeBlockTmpStream.close();
        this._mergeBlockTmpLoader = new FileInputStream(this._mergeBlockTmpFile);
        byte[] mergeBlocks = new byte[1024];
        int rl = -1;
        while ((rl = this._mergeBlockTmpLoader.read(mergeBlocks)) != -1) {
            buffer.write(mergeBlocks, 0, rl);
        }
        boolean bl = hasMergeBlocks = buffer.size() != 0;
        if (hasMergeBlocks) {
            merges = new String(buffer.toByteArray(), "utf-8");
        }
        if (mergeIndex != -1 && hasMergeBlocks) {
            template = template.substring(0, mergeIndex) + merges + template.substring(template.indexOf("</mergeCells>"));
        } else if (hasMergeBlocks) {
            this._rowDataTmpStream.write(("<mergeCells>" + merges + "</mergeCells>").getBytes());
        }
        this._rowDataTmpStream.write(this.template_end.getBytes());
        this.addDataValidation();
        this.addHyperlink();
        this._rowDataTmpStream.write(template.substring(template.indexOf("<pageMargins")).getBytes());
        this._rowDataTmpStream.flush();
        this.template_start = null;
        this.template_end = null;
    }

    protected void fillRow(int rowNum, int excelRowNum, XmlOptions options) throws IOException {
        if (this._workbook._queue != null && NOTIFY) {
            ExportEvent event = new ExportEvent("export sheet(" + this.getSheetName() + ")", "filling data(" + excelRowNum + ")");
            event.setRow(rowNum);
            this._workbook._queue.enQueue(event);
        }
        if (DEBUG) {
            this.startTime_SettingValue = System.currentTimeMillis();
        }
        int colNum = 0;
        int excelColNum = 0;
        int valueType = 1;
        while (!this._dataSource.isColEnd(colNum)) {
            if (this._dataSource.isHideCol(colNum)) {
                ++colNum;
                continue;
            }
            Object value = this._dataSource.valueAt(rowNum, colNum);
            String formula = this._dataSource.formulaAt(rowNum, colNum);
            if (excelColNum > 16383) {
                throw new IOException("too much columns!");
            }
            valueType = this._dataSource.valueTypeAt(rowNum, colNum);
            XSSFCell cell = this._rowBuffer.createCell(excelColNum, CellType.forInt((int)valueType));
            CTCell ct = cell.getCTCell();
            if ((!this._dataSource.isExportCustomerFormulas() || !this._dataSource.isExportFormula()) && StringUtil.isEmptyString((String)formula) && ct.isSetF()) {
                ct.unsetF();
            }
            switch (valueType) {
                case 3: {
                    break;
                }
                case 4: {
                    value = this._dataSource.booleanValue((Boolean)value);
                    ct.setV((String)value);
                    ct.setT(STCellType.STR);
                    break;
                }
                case 2: {
                    if (!StringUtil.isEmptyString((String)formula) && formula.charAt(0) == '=') {
                        formula = formula.substring(1, formula.length());
                    }
                    try {
                        boolean emptyFormula = StringUtil.isEmptyString((String)formula);
                        if (!emptyFormula) {
                            cell.setCellFormula(formula);
                        }
                        if (value == null) {
                            value = new BigDecimal(0.0);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            if (!emptyFormula) break;
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            try {
                                cell.setCellValue(Double.parseDouble((String)value));
                                if (!emptyFormula) break;
                                cell.setCellType(CellType.NUMERIC);
                            }
                            catch (NumberFormatException nfe) {
                                if (StringUtil.isEmptyString((String)((String)value))) {
                                    cell.setCellValue((String)null);
                                    if (!emptyFormula) break;
                                    cell.setCellType(CellType.BLANK);
                                    break;
                                }
                                if (emptyFormula) {
                                    ct.setV((String)value);
                                }
                                ct.setT(STCellType.STR);
                            }
                            break;
                        }
                        if (emptyFormula) {
                            ct.setV(value == null ? "" : value.toString());
                        }
                        ct.setT(STCellType.STR);
                    }
                    catch (RuntimeException ex) {
                        if (value == null) {
                            value = new BigDecimal(0.0);
                        }
                        if (value instanceof Number) {
                            cell.setCellValue(((Number)value).doubleValue());
                            cell.setCellType(CellType.NUMERIC);
                            break;
                        }
                        if (value instanceof String) {
                            ct.setV((String)value);
                        } else {
                            ct.setV(value.toString());
                        }
                        ct.setT(STCellType.STR);
                    }
                    break;
                }
                case 0: {
                    if (value == null) {
                        value = new Double(0.0);
                    }
                    if (value instanceof Number) {
                        cell.setCellValue(Double.valueOf(value.toString()).doubleValue());
                        break;
                    }
                    if (value instanceof Date) {
                        cell.setCellValue((Date)value);
                        valueType = 6;
                        break;
                    }
                    if (value instanceof Calendar) {
                        cell.setCellValue((Calendar)value);
                        valueType = 6;
                        break;
                    }
                    if (!(value instanceof String)) break;
                    try {
                        ct.setV(String.valueOf(value));
                        ct.setT(STCellType.STR);
                    }
                    catch (NumberFormatException nfe) {
                        ct.setV("0");
                    }
                    break;
                }
                case 1: {
                    String str;
                    if (value == null) {
                        value = "";
                    }
                    if (StringUtil.isEmptyString((String)(str = value.toString()))) {
                        ct.setV("");
                        ct.setT(STCellType.STR);
                        break;
                    }
                    ct.setV(str);
                    ct.setT(STCellType.STR);
                    break;
                }
                case 5: {
                    if (value == null) {
                        value = "error";
                    }
                    ct.setV(value.toString());
                    break;
                }
                default: {
                    ct.setV("");
                    ct.setT(STCellType.STR);
                }
            }
            this.cacheHyperLink(rowNum, colNum, cell.getReference());
            this.addStyle(rowNum, colNum, (short)valueType, cell, value);
            this.addMerge(rowNum, colNum, excelRowNum, excelColNum);
            value = null;
            ++excelColNum;
            ++colNum;
        }
        if (DEBUG) {
            this.sum_SettingValue += System.currentTimeMillis() - this.startTime_SettingValue;
            log.info((Object)("---------------- fill one row(" + rowNum + ") consuming " + (System.currentTimeMillis() - this.startTime_SettingValue) + " ms -------------------"));
        }
    }

    private void cacheHyperLink(int rowNum, int colNum, String cellRefference) {
        HyperLink hyper = this._dataSource.hyperLinkAt(rowNum, colNum);
        if (hyper != null) {
            if (this.hyperList == null) {
                this.hyperList = new ArrayList();
            }
            this.hyperList.add(cellRefference);
            this.hyperList.add(hyper);
        }
    }

    private void addHyperlink() throws IOException {
        if (this.hyperList != null) {
            this._rowDataTmpStream.write("<hyperlinks>".getBytes());
            Iterator iter = this.hyperList.iterator();
            while (iter.hasNext()) {
                String cellRefference = (String)iter.next();
                HyperLink hyper = (HyperLink)iter.next();
                this._rowDataTmpStream.write(("<hyperlink ref=\"" + cellRefference + "\" location=\"").getBytes());
                this._rowDataTmpStream.write(hyper.getLinkTo().getBytes("UTF-8"));
                this._rowDataTmpStream.write("\" display=\"".getBytes());
                this._rowDataTmpStream.write(hyper.getText().getBytes("UTF-8"));
                this._rowDataTmpStream.write("\"/>".getBytes());
            }
            this._rowDataTmpStream.write("</hyperlinks>".getBytes());
            this.hyperList = null;
        }
    }

    private void addDataValidation() throws IOException {
        ValidationList vList;
        int vSize;
        if (this._dataSource != null && this._dataSource.getSheet() != null && (vSize = (vList = this._dataSource.getSheet().getValidations()).size()) != 0) {
            this._rowDataTmpStream.write(StringUtil.getBytes((String)"<dataValidations count=\""));
            this._rowDataTmpStream.write(StringUtil.getBytes((String)String.valueOf(vSize)));
            this._rowDataTmpStream.write(StringUtil.getBytes((String)"\">"));
            for (int i = 0; i < vSize; ++i) {
                Validation v = vList.getValidation(i);
                MessagedValidate vMsg = v.getMessagedValidate();
                SortedCellBlockArray blocks = v.getBlocks();
                String sqref = SheetBaseMath.getBlocksA1Name((SortedCellBlockArray)blocks, (boolean)false);
                sqref = this.parseSqref(sqref);
                String qualifier = this.FirstChrLowerCase(vMsg.getQualifier());
                String type = this.FirstChrLowerCase(vMsg.getType());
                String min = vMsg.getMin();
                String max = vMsg.getMax();
                this._rowDataTmpStream.write(StringUtil.getBytes((String)("<dataValidation type=\"" + type)));
                if (Validate.Between.equals(vMsg.getQualifier())) {
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" operator=\"between"));
                } else {
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)("\" operator=\"" + qualifier)));
                }
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" allowBlank=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)String.valueOf(!vMsg.isUseBlank())));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" errorStyle=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)this.switchErrorStyle(vMsg.getErrorStyle())));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" showInputMessage=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)String.valueOf(!vMsg.isInputHide())));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" showErrorMessage=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)String.valueOf(!vMsg.isErrorHide())));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" errorTitle=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)vMsg.getErrorTitle()));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" error=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)vMsg.getErrorMessage()));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" promptTitle=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)vMsg.getInputTitle()));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" prompt=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)vMsg.getInputMessage()));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" sqref=\""));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)sqref));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"\" >"));
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"<formula1>"));
                if (MessagedValidate.Type_List.equals(vMsg.getType()) && min.indexOf("=") < 0) {
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)"\""));
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)min));
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)"\""));
                } else if (MessagedValidate.Type_Date.equals(vMsg.getType()) && min.indexOf("=") < 0) {
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)this.getExcelDate(min)));
                } else if (MessagedValidate.Type_Time.equals(vMsg.getType()) && min.indexOf("=") < 0) {
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)String.valueOf(HSSFDateUtil.convertTime((String)min))));
                } else {
                    if (min.startsWith("=") && min.indexOf("!") >= 0) {
                        min = min.replaceAll("=", "");
                    } else if (min.startsWith("=")) {
                        min = min.replaceAll("=", "");
                    }
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)min));
                }
                this._rowDataTmpStream.write(StringUtil.getBytes((String)"</formula1>"));
                if (!StringUtil.isEmptyString((String)max)) {
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)"<formula2>"));
                    if (MessagedValidate.Type_Date.equals(vMsg.getType()) && max.indexOf("=") < 0) {
                        this._rowDataTmpStream.write(StringUtil.getBytes((String)this.getExcelDate(max)));
                    } else if (MessagedValidate.Type_Time.equals(vMsg.getType()) && max.indexOf("=") < 0) {
                        this._rowDataTmpStream.write(StringUtil.getBytes((String)String.valueOf(HSSFDateUtil.convertTime((String)max))));
                    } else {
                        if (max.startsWith("=") && max.indexOf("!") >= 0) {
                            max = max.replaceAll("=" + this._dataSource.getSheet().getSheetName() + "!", "");
                        } else if (max.startsWith("=")) {
                            max = max.replaceAll("=", "");
                        }
                        this._rowDataTmpStream.write(StringUtil.getBytes((String)max));
                    }
                    this._rowDataTmpStream.write(StringUtil.getBytes((String)"</formula2>"));
                }
                this._rowDataTmpStream.write("</dataValidation>".getBytes());
            }
            this._rowDataTmpStream.write("</dataValidations>".getBytes());
        }
    }

    private String getExcelDate(String formula) {
        double excelDate = 0.0;
        try {
            excelDate = HSSFDateUtil.getExcelDate((Date)HSSFDateUtil.getJavaDate((double)(Format.parseData((String)formula, (boolean)true).doubleValue() + 1.0)));
        }
        catch (SyntaxErrorException e) {
            e.printStackTrace();
        }
        return String.valueOf(excelDate);
    }

    private String parseSqref(String sqref) {
        sqref = sqref.replaceAll(",", " ");
        String[] sqrefs = sqref.split(" ");
        for (int j = 0; j < sqrefs.length; ++j) {
            String[] _sqref;
            if (sqrefs[j].indexOf(":") < 0 || (_sqref = sqrefs[j].split(":"))[0] == null && _sqref[0] == "" || !_sqref[0].equals(_sqref[1])) continue;
            if (Character.isDigit(_sqref[0].charAt(0))) {
                _sqref[0] = "A" + _sqref[0];
                _sqref[1] = "XFD" + _sqref[1];
            } else if (Character.isLetter(_sqref[0].charAt(0))) {
                _sqref[0] = _sqref[0] + "1";
                _sqref[1] = _sqref[1] + "1048576";
            }
            sqref = sqref.replaceAll(sqrefs[j], _sqref[0] + ":" + _sqref[1]);
        }
        return sqref;
    }

    private String FirstChrLowerCase(String str) {
        if (str != null && str != "") {
            char firstCh = Character.toLowerCase(str.charAt(0));
            str = firstCh + str.substring(1, str.length());
        }
        return str;
    }

    private String switchErrorStyle(String errorStyle) {
        if (MessagedValidate.STOP_STYLE.equals(errorStyle)) {
            return "stop";
        }
        if (MessagedValidate.WARNING_STYLE.equals(errorStyle)) {
            return "warning";
        }
        if (MessagedValidate.INFORMATION_STYLE.equals(errorStyle)) {
            return "information";
        }
        return "stop";
    }

    private void addMerge(int rowNum, int colNum, int excelRowNum, int excelColNum) {
        AbstractDataWrapper.MergeBlock merge = this._dataSource.getMergeBlock(rowNum, colNum);
        if (merge == null) {
            return;
        }
        CellRangeAddress cra = new CellRangeAddress(excelRowNum, excelRowNum + (merge.getRow2() - merge.getRow()), excelColNum, excelColNum + (merge.getCol2() - merge.getCol()));
        this._sheetBuffer.addMergedRegion(cra);
    }

    private void addStyle(int rowNum, int colNum, short valueType, XSSFCell cell, Object value) {
        boolean isDateValue;
        ShareStyleAttributes ssa = this._dataSource.SSAAt(rowNum, colNum);
        boolean bl = isDateValue = valueType == 6;
        if (ssa.isEmpty() && !isDateValue) {
            StylesTable st = this._host.getWorkbook().getStylesSource();
            this.emptyStyle.verifyBelongsToStylesSource(st);
            long idx = st.putStyle(this.emptyStyle);
            cell.getCTCell().setS(idx);
            return;
        }
        if (isDateValue && StringUtil.isEmptyString((String)ssa.getNumberFormat())) {
            Calendar cal;
            if (this.dateTimeStyle == null) {
                this.dateTimeStyle = this._workbook._host.createCellStyle();
                this.dateStyle = this._workbook._host.createCellStyle();
                XSSFFont dateFont = this._workbook._host.createFont();
                dateFont.setFontName(ssa.getFontName());
                dateFont.setFontHeight((double)ssa.getFontSize());
                this.dateTimeStyle.setDataFormat(this.format.getFormat("yyyy-m-d hh:mm"));
                this.dateTimeStyle.setFont((Font)dateFont);
                this.dateStyle.setDataFormat(this.format.getFormat("yyyy-m-d"));
                this.dateStyle.setFont((Font)dateFont);
            }
            if (value instanceof Date) {
                cal = Calendar.getInstance();
                cal.setTime((Date)value);
            } else {
                cal = (Calendar)value;
            }
            if (ssa.isEmpty()) {
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    StylesTable st = this._host.getWorkbook().getStylesSource();
                    this.dateTimeStyle.verifyBelongsToStylesSource(st);
                    long idx = st.putStyle(this.dateTimeStyle);
                    cell.getCTCell().setS(idx);
                } else {
                    StylesTable st = this._host.getWorkbook().getStylesSource();
                    this.dateStyle.verifyBelongsToStylesSource(st);
                    long idx = st.putStyle(this.dateStyle);
                    cell.getCTCell().setS(idx);
                }
            } else {
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                if (cal.get(12) != 0 || cal.get(11) != 0) {
                    sa.setNumberFormat("yyyy-m-d hh:mm");
                } else {
                    sa.setNumberFormat("yyyy-m-d");
                }
                ssa = Styles.getSSA((StyleAttributes)sa);
                Integer hash = new Integer(ssa.hashCode());
                XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
                if (style == null) {
                    XSSFCellStyle fullStyle = this._workbook._host.createCellStyle();
                    this.parseStyle(ssa, fullStyle, hash, rowNum, colNum);
                    StylesTable st = this._host.getWorkbook().getStylesSource();
                    fullStyle.verifyBelongsToStylesSource(st);
                    long idx = st.putStyle(fullStyle);
                    cell.getCTCell().setS(idx);
                    fullStyle = null;
                } else {
                    StylesTable st = this._host.getWorkbook().getStylesSource();
                    style.verifyBelongsToStylesSource(st);
                    long idx = st.putStyle(style);
                    cell.getCTCell().setS(idx);
                }
            }
            return;
        }
        Integer hash = new Integer(ssa.hashCode());
        XSSFCellStyle style = (XSSFCellStyle)this.stylesMap.get(hash);
        if (style == null || DigitFormatPane.DataModel.isSpecialFormat((String)ssa.getNumberFormat())) {
            XSSFCellStyle fullStyle = this._workbook._host.createCellStyle();
            this.parseStyle(ssa, fullStyle, hash, rowNum, colNum);
            StylesTable st = this._host.getWorkbook().getStylesSource();
            fullStyle.verifyBelongsToStylesSource(st);
            long idx = st.putStyle(fullStyle);
            cell.getCTCell().setS(idx);
            fullStyle = null;
        } else {
            StylesTable st = this._host.getWorkbook().getStylesSource();
            style.verifyBelongsToStylesSource(st);
            long idx = st.putStyle(style);
            cell.getCTCell().setS(idx);
        }
    }

    private void parseStyle(ShareStyleAttributes ssa, XSSFCellStyle fullStyle, Integer id, int rowNum, int colNum) {
        Style stl = Styles.getStyle((ShareStyleAttributes)ssa);
        XSSFFont f = this.parseFont((ShareStyleAttributes)stl, id);
        fullStyle.setFont((Font)f);
        FillPatternType pattern = this.parsePattern((ShareStyleAttributes)stl);
        if (pattern.getCode() == 0) {
            fullStyle.setFillPattern(pattern);
        } else if (pattern.getCode() == 1) {
            Color clr = stl.getBackground();
            if (Color.WHITE.equals(clr)) {
                fullStyle.setFillPattern(FillPatternType.NO_FILL);
            } else {
                fullStyle.setFillForegroundColor(this.parseColor(stl.getBackground()));
                fullStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getFontColor()));
        } else {
            fullStyle.setFillBackgroundColor(this.parseColor(stl.getBackground()));
            fullStyle.setFillForegroundColor(this.parseColor(stl.getFontColor()));
            fullStyle.setFillPattern(pattern);
        }
        Styles.Position p = Styles.Position.LEFT;
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p))) {
            fullStyle.setBorderLeft(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setLeftBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.RIGHT))) {
            fullStyle.setBorderRight(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setRightBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.TOP))) {
            fullStyle.setBorderTop(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setTopBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        if (!LineStyle.isNull((LineStyle)stl.getBorderLineStyle(p = Styles.Position.BOTTOM))) {
            fullStyle.setBorderBottom(this.parseBorder((ShareStyleAttributes)stl, p));
            fullStyle.setBottomBorderColor(this.parseColor(stl.getBorderColor(p)));
        }
        fullStyle.setAlignment(this.parseHorizontalAlignment((ShareStyleAttributes)stl));
        fullStyle.setVerticalAlignment(this.parseVerticalAlignment((ShareStyleAttributes)stl));
        fullStyle.setWrapText(stl.isWrapText());
        fullStyle.setRotation((short)stl.getRotation());
        if (this._dataSource.isBookProtected()) {
            fullStyle.setLocked(true);
        } else {
            fullStyle.setLocked(stl.isLocked());
        }
        fullStyle.setHidden(stl.isHided());
        String numberFormat = stl.getNumberFormat();
        if (numberFormat.length() != 0) {
            if (!"000000".equals(numberFormat) && DigitFormatPane.DataModel.isSpecialFormat((String)numberFormat)) {
                String cellText = this._dataSource.textAt(rowNum, colNum);
                if (StringUtil.isEmptyString((String)cellText)) {
                    numberFormat = "";
                } else {
                    numberFormat = cellText.replaceAll("\\.", "\\\\.");
                    numberFormat = numberFormat + ";" + numberFormat;
                    numberFormat = numberFormat.replaceAll("^-", "");
                }
            }
            short builtInFormat = this.format.getFormat(numberFormat);
            fullStyle.setDataFormat(builtInFormat);
        }
        this.stylesMap.put(id, fullStyle);
    }

    private XSSFFont parseFont(ShareStyleAttributes ssa, Integer id) {
        XSSFFont cellFont = (XSSFFont)this.fontsMap.get(id);
        if (cellFont == null) {
            cellFont = this._workbook._host.createFont();
            cellFont.setFontName(ssa.getFontName());
            cellFont.setColor(this.parseColor(ssa.getFontColor()));
            cellFont.setFontHeightInPoints((short)ssa.getFontSize());
            if (ssa.isUnderline()) {
                cellFont.setUnderline((byte)1);
            }
            if (ssa.isStrikeThrough()) {
                cellFont.setStrikeout(true);
            }
            if (ssa.isBold()) {
                cellFont.setBold(true);
            }
            if (ssa.isItalic()) {
                cellFont.setItalic(true);
            }
            this.fontsMap.put(id, cellFont);
        }
        return cellFont;
    }

    private XSSFColor parseColor(Color awtColor) {
        return new XSSFColor(awtColor);
    }

    private BorderStyle parseBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        PenStyle ps = ssa.getBorderPenStyle(pos);
        int width = ssa.getBorderLineStyle(pos).getWidth();
        switch (width) {
            case 0: {
                return BorderStyle.NONE;
            }
            case 1: {
                if (ps == PenStyle.PS_SOLID) {
                    return BorderStyle.THIN;
                }
                if (ps == PenStyle.PS_CONTINUOUS) {
                    return BorderStyle.DOTTED;
                }
                if (ps == PenStyle.PS_DOT) {
                    return BorderStyle.DASHED;
                }
                if (ps == PenStyle.PS_DASHDOTDOT) {
                    return BorderStyle.DASH_DOT;
                }
                if (ps == PenStyle.PS_DASHDOT) {
                    return BorderStyle.DASH_DOT_DOT;
                }
                return BorderStyle.THIN;
            }
        }
        if (ps == PenStyle.PS_SOLID || ps == PenStyle.PS_CONTINUOUS) {
            if (width == 2) {
                return BorderStyle.MEDIUM;
            }
            return BorderStyle.THICK;
        }
        if (ps == PenStyle.PS_DOT) {
            return BorderStyle.MEDIUM_DASHED;
        }
        if (ps == PenStyle.PS_DASHDOTDOT) {
            return BorderStyle.MEDIUM_DASH_DOT;
        }
        if (ps == PenStyle.PS_DASHDOT) {
            return BorderStyle.MEDIUM_DASH_DOT_DOT;
        }
        if (width == 2) {
            return BorderStyle.MEDIUM;
        }
        return BorderStyle.THICK;
    }

    private HorizontalAlignment parseHorizontalAlignment(ShareStyleAttributes ssa) {
        Styles.HorizontalAlignment align = ssa.getHorizontalAlign();
        HorizontalAlignment horizontalAlignment = align == Styles.HorizontalAlignment.LEFT ? HorizontalAlignment.LEFT : (align == Styles.HorizontalAlignment.CENTER ? HorizontalAlignment.CENTER : (align == Styles.HorizontalAlignment.RIGHT ? HorizontalAlignment.RIGHT : HorizontalAlignment.JUSTIFY));
        return horizontalAlignment;
    }

    private VerticalAlignment parseVerticalAlignment(ShareStyleAttributes ssa) {
        Styles.VerticalAlignment align = ssa.getVerticalAlign();
        VerticalAlignment verticalAlignment = align == Styles.VerticalAlignment.TOP ? VerticalAlignment.TOP : (align == Styles.VerticalAlignment.MIDDLE ? VerticalAlignment.CENTER : (align == Styles.VerticalAlignment.BOTTOM ? VerticalAlignment.BOTTOM : VerticalAlignment.TOP));
        return verticalAlignment;
    }

    private FillPatternType parsePattern(ShareStyleAttributes ssa) {
        FillPatternType sret = FillPatternType.NO_FILL;
        switch (ssa.getPattern().getID()) {
            case 0: {
                sret = FillPatternType.NO_FILL;
                break;
            }
            case 1: {
                sret = FillPatternType.SOLID_FOREGROUND;
                break;
            }
            case 3: {
                sret = FillPatternType.FINE_DOTS;
                break;
            }
            case 26: {
                sret = FillPatternType.ALT_BARS;
                break;
            }
            case 19: {
                sret = FillPatternType.SPARSE_DOTS;
                break;
            }
            case 45: {
                sret = FillPatternType.THICK_HORZ_BANDS;
                break;
            }
            case 37: {
                sret = FillPatternType.THICK_VERT_BANDS;
                break;
            }
            case 20: {
                sret = FillPatternType.THICK_BACKWARD_DIAG;
                break;
            }
            case 28: {
                sret = FillPatternType.THICK_FORWARD_DIAG;
                break;
            }
            case 25: {
                sret = FillPatternType.BIG_SPOTS;
                break;
            }
            case 40: {
                sret = FillPatternType.BRICKS;
                break;
            }
            case 13: {
                sret = FillPatternType.THIN_HORZ_BANDS;
                break;
            }
            case 5: {
                sret = FillPatternType.THIN_VERT_BANDS;
                break;
            }
            case 4: {
                sret = FillPatternType.THIN_BACKWARD_DIAG;
                break;
            }
            case 12: {
                sret = FillPatternType.THIN_FORWARD_DIAG;
                break;
            }
            case 9: {
                sret = FillPatternType.SQUARES;
                break;
            }
            case 34: {
                sret = FillPatternType.DIAMONDS;
                break;
            }
            case 35: {
                sret = FillPatternType.LESS_DOTS;
                break;
            }
            case 43: {
                sret = FillPatternType.LEAST_DOTS;
                break;
            }
            default: {
                sret = FillPatternType.SOLID_FOREGROUND;
            }
        }
        return sret;
    }

    public String formatAsString(int rowIndex, int colIndex) {
        this.sb.delete(0, this.sb.length());
        this.appendCellReference(this.sb, rowIndex, colIndex);
        return this.sb.toString();
    }

    private void appendCellReference(StringBuffer sb, int rowIndex, int colIndex) {
        sb.append(MyXSSFWorksheetWrapper.convertNumToColString(colIndex));
        sb.append(rowIndex + 1);
    }

    private static String convertNumToColString(int col) {
        int excelColNum = col + 1;
        String colRef = "";
        int colRemain = excelColNum;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            char colChar = (char)(thisPart + 64);
            colRef = colChar + colRef;
        }
        return colRef;
    }

    public String toString() {
        return this._host.getPackagePart() == null ? null : this._host.getPackagePart().toString();
    }
}

