/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.excel.utils;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.CellInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.excel.SheetInfo;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.CslRptCalcUtil;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.CslRptCalculateContext;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.ExcelUtil;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.RptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.excel.utils.StyleUtils;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import java.util.ArrayList;
import java.util.Locale;

public class CalculatorUtils {
    public static SheetInfo calcClientSheet(Book book, String id, SheetInfo clientSheet, ReportBaseInfo rptInfo, boolean isFill) throws Exception {
        book.setAutoCalculate(false);
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        Sheet serverSheet = null;
        SheetInfo resultSheet = null;
        Book calcBook = Book.Manager.getNewBook(null, (int)1);
        calcBook.setCalculate(false);
        calcBook.setAutoCalculate(false);
        calcBook.getUndoManager().enable(false);
        Sheet sheet1 = calcBook.getSheet(0);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            if (id.equals(book.getSheet(i).getID())) {
                serverSheet = book.getSheet(i);
                serverSheet.setEnableCalculation(true);
                continue;
            }
            book.getSheet(i).setEnableCalculation(false);
        }
        CalculatorUtils.setClientSheetToServerSheet(serverSheet, clientSheet);
        if (sheet1 != null && serverSheet != null) {
            sheet1.copySheetFrom(serverSheet, false);
            sheet1.setName(serverSheet.getSheetName());
        }
        Book resultBook = null;
        if (rptInfo instanceof CslReportInfo) {
            FormulaDefinition.registerFormulaToBook((Book)calcBook, (ICalculateContextProvider)new CslRptCalculateContext(book, (CslReportInfo)rptInfo));
            new CslRptCalcUtil().calculateSheets(calcBook, (CslReportInfo)rptInfo);
            calcBook.calc();
            resultBook = calcBook;
        } else if (rptInfo instanceof ReportInfo) {
            BookProperties p = BookProperties.loadFromBook((Book)book);
            p.restoreToBook(calcBook);
            rptInfo.setBook(calcBook);
            RptCalculate rptCalc = new RptCalculate(rptInfo);
            if (RptWeaveCalcHelper.isDynamicRpt(rptInfo)) {
                resultBook = rptCalc.fillDynamicItemsandCalc(rptInfo, false, isFill);
            } else {
                resultBook = rptCalc.interOrExchFillCompanyAndCalc(rptInfo, false, isFill);
                for (int i = 0; i < resultBook.getSheetCount(); ++i) {
                    if (!id.equals(resultBook.getSheet(i).getID())) continue;
                    serverSheet = resultBook.getSheet(i);
                }
                CalculatorUtils.setServerSheetToClientSheet(serverSheet);
            }
        }
        if (resultBook != null && resultBook.getSheet(0) != null) {
            resultSheet = new SheetInfo();
            Sheet afterSheet = resultBook.getSheet(0);
            CellInfo[] cells = StyleUtils.getCellContent(afterSheet, false);
            resultSheet.setCells(cells);
            if (RptWeaveCalcHelper.isDynamicRpt(rptInfo)) {
                resultSheet.setDynaInfo(StyleUtils.buildDynaInfo(afterSheet));
            }
        }
        return resultSheet;
    }

    public static SheetInfo setServerSheetToClientSheet(Sheet sheet) {
        SheetInfo clientSheet = null;
        if (sheet != null) {
            clientSheet = new SheetInfo();
            ArrayList<CellInfo> cellList = new ArrayList<CellInfo>();
            CellInfo clientCell = null;
            String cellValue = null;
            String cellFormula = null;
            Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, true);
            while (iter.hasNext()) {
                Cell cell = iter.next();
                if (cell == null) continue;
                cellValue = cell.getValue() == null ? null : String.valueOf(cell.getValue());
                cellFormula = cell.getFormula() == null ? null : String.valueOf(cell.getFormula());
                clientCell = new CellInfo();
                clientCell.setRow(cell.getRow());
                clientCell.setCol(cell.getCol());
                clientCell.setCellValue(cellValue);
                if (cellValue != null && cellFormula != null && !cellValue.equals(cellFormula)) {
                    clientCell.setFormula(cellFormula);
                }
                if (cell.getUserObject("FormulaExp") != null) {
                    String formulaExp = cell.getUserObject("FormulaExp").getValue().toString();
                    clientCell.setFormulaExp(formulaExp);
                }
                cellList.add(clientCell);
            }
            if (cellList.size() > 0) {
                CellInfo[] cells = new CellInfo[cellList.size()];
                cellList.toArray(cells);
                clientSheet.setCells(cells);
            }
        }
        return clientSheet;
    }

    private static void setClientSheetToServerSheet(Sheet sheet, SheetInfo clientSheet) throws Exception {
        CalculatorUtils.clearSheetOldData(sheet);
        Cell serverCell = null;
        for (CellInfo cell : clientSheet.getCells()) {
            if (cell == null) continue;
            serverCell = sheet.getCell(cell.getRow() - 1, cell.getCol() - 1, true);
            if (!StringUtils.isEmpty((String)cell.getCellValue())) {
                serverCell.setValue(new Variant((Object)ExcelUtil.formatString(cell.getCellValue())));
            }
            if (!StringUtils.isEmpty((String)cell.getFormula())) {
                serverCell.setFormula(ExcelUtil.formatString(cell.getFormula()));
            }
            if (!StringUtils.isEmpty((String)cell.getItemformula())) {
                UserObjectHelper.setItemFormula((Cell)serverCell, (ItemFormula)new ItemFormula(ExcelUtil.formatString(cell.getItemformula())));
            }
            if (!StringUtils.isEmpty((String)cell.getExt()) && !cell.getExt().toUpperCase(Locale.ENGLISH).equals("NULL")) {
                ItemFormula vif = new ItemFormula();
                String[] exts = ExcelUtil.formatString(cell.getExt()).split("#:#");
                for (int e = 0; e < exts.length; ++e) {
                    String[] es = exts[e].split("#_#");
                    if (es.length == 2) {
                        vif.putExt(es[0], es[1]);
                        continue;
                    }
                    if (es.length != 1) continue;
                    vif.putExt(es[0], "");
                }
                UserObjectHelper.setItemFormula((Cell)serverCell, (ItemFormula)vif);
            }
            if (!StringUtils.isEmpty((String)cell.getGradeInfo())) {
                DItemGradeInfo digi = new DItemGradeInfo();
                digi.fromSerialString(ExcelUtil.formatString(cell.getGradeInfo()));
                serverCell.setUserObject("DItemGradeInfo", (Object)digi);
            }
            if (StringUtils.isEmpty((String)cell.getFormulaExp())) continue;
            String formulaExp = cell.getFormulaExp();
            serverCell.setUserObject("FormulaExp", (Object)formulaExp);
        }
    }

    public static void clearSheetOldData(Sheet sheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            if (cell == null) continue;
            cell.setValue(Variant.nullVariant);
            cell.setFormula(null);
            cell.removeUserObject("ITEM");
            cell.setComment(null);
        }
    }
}

