/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.inspect.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataCollection;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.app.AbstractInspectExe;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArchiveDynaItemData
extends AbstractInspectExe {
    private static final Logger logger = Logger.getLogger(ArchiveDynaItemData.class);

    @Override
    public Map<String, Object> executeFix(Map<String, Object> filters, Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int year = (Integer)filters.get("year");
        int period = (Integer)filters.get("month");
        try {
            StringBuffer uiResult = new StringBuffer();
            CslInspectFixDataCollection resultEntry = new CslInspectFixDataCollection();
            List<int[]> yearPeriodList = this.getYearPeriodListForArchive(ctx, year, period, this.isArchive());
            this.archiveOrUnArchiveItemData(ctx, yearPeriodList, uiResult, resultEntry, this.isArchive());
            this.addResult(uiResult.toString(), resultEntry, result);
        }
        catch (Exception ex) {
            logger.error((Object)"executeFix error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return result;
    }

    protected boolean isArchive() {
        return true;
    }

    @Override
    protected String getKey(Map<String, Object> filters) {
        return filters.get("year").toString() + filters.get("month") + filters.get("inspectId");
    }

    protected List<int[]> getYearPeriodListForArchive(Context ctx, int year, int period, boolean isArchive) throws Exception {
        String tableName = isArchive ? "t_csl_dynaitemdataentry" : "t_csl_hisdynaitemdataentry";
        ArrayList<int[]> yearPeriodList = new ArrayList<int[]>();
        ArrayList<Integer> params = new ArrayList<Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct fyear,fperiod from ").append(tableName);
        if (isArchive) {
            sql.append(" where (fyear= ? and fperiod <= ?) ");
            sql.append("or fyear < ? order by fyear asc,fperiod asc ");
        } else {
            sql.append(" where (fyear= ? and fperiod >= ?) ");
            sql.append("or fyear > ? order by fyear desc,fperiod desc ");
        }
        params.add(year);
        params.add(period);
        params.add(year);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        while (rs != null && rs.next()) {
            yearPeriodList.add(new int[]{rs.getInt("fyear"), rs.getInt("fperiod")});
        }
        return yearPeriodList;
    }

    protected void archiveOrUnArchiveItemData(Context ctx, List<int[]> yearPeriodList, StringBuffer uiResult, CslInspectFixDataCollection resultEntry, boolean isArchive) throws Exception {
        try {
            String targItemTable = isArchive ? "t_csl_hisdynaitemdata" : "t_csl_dynaitemdata";
            String targItemEntryTable = isArchive ? "t_csl_hisdynaitemdataentry" : "t_csl_dynaitemdataentry";
            String sourceItemTable = isArchive ? "t_csl_dynaitemdata" : "t_csl_hisdynaitemdata";
            String sourceItemEntryTable = isArchive ? "t_csl_dynaitemdataentry" : "t_csl_hisdynaitemdataentry";
            String itemDataFieldStr = "fid,forgunitid,fsourcecurrencyid,fcurrencyid,fperiodtype,fdatasource,freportid,fcommitstatus,fcontrolunitid,fdatatype,fdynatype,fdatacollectnumber,ffastmergesoluid,forgtype";
            String itemDataEntryFieldStr = "fid,fitemdataid,fitemid,fkeynumber,fkeyname,fdataelement,fvaluetype,fyear,fperiod,fvalue,ftextvalue,fdynaitemtype,fgradenumber,fgradeisleaf,frow,fcol,fsheetid,fissupportinnerexch";
            if (yearPeriodList != null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptCommonMsg", (String)"83_archiveResult");
                uiResult.append(msg).append("[");
                CslInspectFixDataInfo info = null;
                String curYearPeriodStr = null;
                for (int[] yearPeriod : yearPeriodList) {
                    CslRptUtil.invokeByManual(this, "archiveUnArchiveByPeriod", new Class[]{Context.class, int[].class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE}, new Object[]{ctx, yearPeriod, targItemTable, targItemEntryTable, sourceItemTable, sourceItemEntryTable, itemDataFieldStr, itemDataEntryFieldStr, isArchive}, 3);
                    curYearPeriodStr = CslRptUtil.getYearPeriod(yearPeriod[0], yearPeriod[1]);
                    uiResult.append(curYearPeriodStr).append(";");
                    info = new CslInspectFixDataInfo();
                    info.setFixDataDes(curYearPeriodStr);
                    resultEntry.add(info);
                }
                uiResult.append("]");
            }
        }
        catch (Exception exc) {
            logger.error((Object)"statement.execute(sql) error", (Throwable)exc);
            throw exc;
        }
    }

    protected void archiveUnArchiveByPeriod(Context ctx, int[] yearPeriod, String targItemTable, String targItemEntryTable, String sourceItemTable, String sourceItemEntryTable, String itemDataFieldStr, String itemDataEntryFieldStr, boolean isArchive) throws Exception {
        int batchSize;
        SQLBuilder sql = new SQLBuilder();
        sql.append("insert into ").append(targItemTable).append("(").append(itemDataFieldStr).append(") ");
        sql.append("select ").append(itemDataFieldStr).append(" from ").append(sourceItemTable);
        sql.append(" where fid in (select fitemdataid from ").append(sourceItemEntryTable).append(" where fyear=").append((Object)yearPeriod[0]);
        sql.append(" and fperiod=?", (Object)yearPeriod[1]).append(")");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        sql.reset();
        sql.append("insert into ").append(targItemEntryTable).append("(").append(itemDataEntryFieldStr).append(") ");
        sql.append("select ").append(itemDataEntryFieldStr).append(" from ").append(sourceItemEntryTable);
        sql.append(" where fyear=?", (Object)yearPeriod[0]);
        sql.append(" and fperiod=?", (Object)yearPeriod[1]);
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        sql.reset();
        sql.append("delete ").append(sourceItemTable).append(" where fid in(select fitemdataid from ");
        sql.append(sourceItemEntryTable).append(" where fyear=?", (Object)yearPeriod[0]);
        sql.append(" and fperiod=?", (Object)yearPeriod[1]).append(")");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        sql.reset();
        int updateCount = batchSize = 50000;
        sql.append("delete ").append(sourceItemEntryTable);
        sql.append(" where fid in(select top ").append((Object)batchSize).append(" fid from ").append(sourceItemEntryTable);
        sql.append(" where fyear=?", (Object)yearPeriod[0]);
        sql.append(" and fperiod=?", (Object)yearPeriod[1]).append(")");
        while (updateCount >= batchSize) {
            updateCount = DbUtil.executeUpdate((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        }
        sql.reset();
        String curYearPeriodStr = CslRptUtil.getYearPeriod(yearPeriod[0], yearPeriod[1]);
        sql.append("update t_csl_cslparam set FVALUE='").append(curYearPeriodStr + "," + isArchive);
        sql.append("' where fkey='").append("KEY_CSLPARAM_DYITEMARCHIVEPERIOD").append("'");
        DbUtil.execute((Context)ctx, (String)sql.getSQL(), (Object[])sql.getParams());
        logger.info((Object)("ArchiveDynaItemData :" + curYearPeriodStr + " end;"));
    }
}

