/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.inspect.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RptReceivedInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataCollection;
import com.kingdee.eas.fi.gr.cslrpt.inspect.CslInspectFixDataInfo;
import com.kingdee.eas.fi.gr.cslrpt.inspect.app.AbstractInspectExe;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RepairRecordLost
extends AbstractInspectExe {
    @Override
    public Map<String, Object> executeFix(Map<String, Object> filters, Context ctx) {
        Map<String, Object> result = null;
        try {
            result = this.fixReportLost(filters, ctx);
        }
        catch (Exception e) {
            result.put("UIResult", ResourceBase.getString((String)this.RES_PATH, (String)"reRecordExRpt", (Locale)ctx.getOriginLocale()) + RepairRecordLost.getExpMessage(e));
        }
        return result;
    }

    private Map<String, Object> fixReportLost(Map<String, Object> filters, Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap();
        OrgTreeInfo orgTreeInfo = (OrgTreeInfo)filters.get("orgBound");
        if (orgTreeInfo == null) {
            return null;
        }
        result = this.rptReceiveLostRepair(ctx, orgTreeInfo.getNumber());
        return result;
    }

    protected Map<String, Object> rptReceiveLostRepair(Context ctx, String orgTreeNum) throws BOSException, EASBizException {
        this.deleteReceiveWithErrorOrgTreeVersion(ctx, orgTreeNum);
        String selectSql = this.getLostRptReceived(orgTreeNum, ctx);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql);
        long n = 0L;
        Connection cn = null;
        PreparedStatement ps = null;
        BOSObjectType bosType = new RptReceivedInfo().getBOSType();
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(" INSERT INTO T_CSL_RptReceived                      \n");
        insertSql.append(" (FID, FReportID, FOrgTreeID, FCreatorID, FCreateTime)");
        insertSql.append(" VALUES                                             \n");
        insertSql.append(" (?, ?, ?, ?, getdate());");
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(insertSql.toString());
        }
        catch (SQLException e2) {
            throw new SQLDataException(e2);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        CslInspectFixDataCollection fixData = new CslInspectFixDataCollection();
        String UIResult = "";
        try {
            boolean isEmpty = true;
            while (rs.next()) {
                isEmpty = false;
                ps.setObject(1, BOSUuid.create((BOSObjectType)bosType).toString());
                ps.setObject(2, rs.getString(1));
                ps.setObject(3, rs.getString(3));
                ps.setObject(4, userID);
                ps.addBatch();
                CslInspectFixDataInfo fixDataInfo = new CslInspectFixDataInfo();
                fixDataInfo.setFixDataId(BOSUuid.read((String)rs.getString(1)));
                fixData.add(fixDataInfo);
                UIResult = UIResult + rs.getString(2) + ";";
                ++n;
            }
            if (!isEmpty) {
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        finally {
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        if (UIResult.length() > 0) {
            UIResult = UIResult.substring(UIResult.length() - 1);
        }
        if (n > 0L) {
            UIResult = UIResult + ResourceBase.getString((String)this.RES_PATH, (String)"dataEntryTip", (Locale)ctx.getOriginLocale());
        }
        UIResult = MessageFormat.format(ResourceBase.getString((String)this.RES_PATH, (String)"reRecordRpt", (Locale)ctx.getOriginLocale()), n) + UIResult;
        result.put("UIResult", UIResult);
        result.put("resultEntry", (Object)fixData);
        return result;
    }

    private void deleteReceiveWithErrorOrgTreeVersion(Context ctx, String orgTreeNum) throws BOSException {
        StringBuffer delsql = new StringBuffer();
        delsql.append("\tDELETE \tFROM\t\t\tT_CSL_RptReceived\t\t\t\t\t\t\t\n");
        delsql.append("\tWHERE\tEXISTS(\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        delsql.append("\t\tSELECT \t\t\t\t1\t\t\t\t\t\t\t\t\t\t\t\n");
        delsql.append("\t\tFROM \t\t\t\tT_CSL_RptReceived  RECEIVE  \t\t\t\t\n");
        delsql.append("\t\tINNER JOIN \t\t\tT_CSL_CslReport RPT \t\t\t\t\t\t\n");
        delsql.append("\t\t\tON\t\t\t\t\tRPT.FID = RECEIVE.FREPORTID    \t\t\t\n");
        delsql.append("\t\tINNER JOIN \t\t\tT_RPT_Template TPLV1\t\t\t\t\t\t\n");
        delsql.append("\t\t\tON \t\t\t\t\tRPT.FTemplateID \t= TPLV1.FID  \t\t\n");
        delsql.append("\t\tINNER JOIN \t\t\tT_RPT_Template TPLV2 \t\t    \t\t\t\n");
        delsql.append("\t\t\tON \t\t\t\t\tTPLV1.FGROUP \t\t= TPLV2.FGROUP \t\t\n");
        delsql.append("\t\tINNER JOIN \t\t\tT_CSL_TempletDispense TDISP     \t\t\t\n");
        delsql.append("\t\t\tON(\t\t\t\t\tTPLV2.FID \t\t\t= TDISP.FDispenseSrcID  \n");
        delsql.append("\t\t\tAND \t\t\t\tRPT.forgunitid \t\t= TDISP.fcompanyid\t)   \n");
        delsql.append("\t\tINNER JOIN \t\t\tT_ORG_Tree TREE    \t\t\t\t\t\t\t\n");
        delsql.append("\t\t\tON(\t\t\t\t\tTDISP.FOrgboundID \t= TREE.FID \t\t\t\n");
        delsql.append("\t\t\tAND\t\t\t\t\tTREE.FID \t\t\t= RECEIVE.FORGTREEID\n");
        delsql.append("\t\t\tAND\t\t\t\t\tTREE.FNUMBER\t\t= '").append(orgTreeNum).append('\'');
        delsql.append("\t\t\t)\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        delsql.append("\t\tWHERE(\t\t\t\tRPT.FENDDATE \t\t< TREE.FSTARTDATE\t\t\n");
        delsql.append("\t\tOR\t(\t\t\t\tTREE.FENDDATE \t\tIS NOT NULL \t\t\t\n");
        delsql.append("\t\t\tAND \t\t\tRPT.FENDDATE \t\t> TREE.FENDDATE\t) )\t\t\n");
        delsql.append("\t\tAND\tT_CSL_RptReceived.FID = RECEIVE.FID\t\t\t\t\t\t\t\t\n");
        delsql.append(")");
        DbUtil.execute((Context)ctx, (String)delsql.toString());
    }

    private String getLostRptReceived(String orgTreeNum, Context ctx) {
        StringBuffer sql = new StringBuffer();
        sql.append("    SELECT \t\tDISTINCT\tRPT.FID AS FFReportID, RPT.FName AS name, TREE.FID AS FFTreeID \t\n");
        sql.append("    FROM \t\tT_CSL_CslReport RPT                             \n");
        sql.append("    INNER JOIN \tT_RPT_Template TPLV1                            \n");
        sql.append("        ON \t\tRPT.FTemplateID \t= TPLV1.FID                 \n");
        sql.append("    INNER JOIN \tT_RPT_Template TPLV2                            \n");
        sql.append("        ON \t\tTPLV1.FGROUP \t\t= TPLV2.FGROUP              \n");
        sql.append("    INNER JOIN \tT_CSL_TempletDispense TDISP                     \n");
        sql.append("        ON \t\tTPLV2.FID \t\t\t= TDISP.FDispenseSrcID      \n");
        sql.append("    \tAND \tRPT.forgunitid \t\t= TDISP.fcompanyid          \n");
        sql.append("    INNER JOIN \tT_ORG_Tree TREE                                \t\n");
        sql.append("        ON \t\tTDISP.FOrgboundID \t= TREE.FID                  \n");
        sql.append("    WHERE   \tRPT.FENDDATE \t\t>= TREE.FSTARTDATE\t\t\t\n");
        sql.append("\tAND\t(\t\tTREE.FENDDATE \t\tIS NULL \t\t\t\t\t\n");
        sql.append("\t\tOR \t\tRPT.FENDDATE \t\t<= TREE.FENDDATE\t)\t\t\n");
        sql.append("\tAND \t\tTREE.FNUMBER\t\t=\t\t\t\t\t\t\t  ");
        sql.append('\'');
        sql.append(orgTreeNum);
        sql.append('\'');
        sql.append('\n');
        sql.append(" AND NOT EXISTS (                                         \t\n");
        sql.append("    SELECT \tFID                                              \t\n");
        sql.append("    FROM \tT_CSL_RptReceived                                  \t\n");
        sql.append("    WHERE \tFReportID \t= RPT.FID                  \t\t\t\t\n");
        sql.append("    AND \tFOrgTreeID \t= TREE.FID                 \t\t\t\t\n");
        sql.append(" )                                                          \t\n");
        return sql.toString();
    }
}

