/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.maintaintool.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.base.job.util.JobProcessUtil;
import com.kingdee.eas.base.job.util.ScheduleExpression;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.DispatchTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.IStatisticsAnalysisLog;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.ScheduleTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisCollection;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisFactory;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisInfo;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisLogFactory;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisLogInfo;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisLogStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.StatisticsAnalysisUtil;
import com.kingdee.eas.fi.gr.cslrpt.maintaintool.app.AbstractStatisticsAnalysisControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class StatisticsAnalysisControllerBean
extends AbstractStatisticsAnalysisControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.app.StatisticsAnalysisControllerBean");
    private static final String LOGINFO = "logInfo";
    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _statisticsAnalysisDisptach(Context ctx, String userId, int scheduleType) throws BOSException, EASBizException {
        IRowSet rs;
        HashSet<String> tableIdSet;
        String jobProcessDef;
        StringBuilder sqlsb;
        Statement statement;
        Connection conn;
        block10: {
            logger.error((Object)"_statisticsAnalysisDisptach_enter");
            conn = null;
            statement = null;
            sqlsb = new StringBuilder();
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            sqlsb.append("update T_CSL_StatisticsAnalysis set FExecuteStatus=1,FIsNeedExecute=1 where FID<>'5w47+ZhAG0jgUztAqMCga3hWiRE=' and FExecuteStatus<>2");
            statement.execute(sqlsb.toString());
            conn.commit();
            jobProcessDef = null;
            tableIdSet = new HashSet<String>();
            sqlsb.setLength(0);
            sqlsb.append("select Fid,FJobProcessDefId from T_CSL_StatisticsAnalysis");
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlsb.toString());
            try {
                while (rs.next()) {
                    tableIdSet.add(rs.getString("Fid"));
                    if (jobProcessDef != null) continue;
                    jobProcessDef = rs.getString("FJobProcessDefId");
                }
            }
            catch (Exception e) {
                logger.error((Object)"_statisticsAnalysisDisptach_findTableNameError:", (Throwable)e);
            }
            if (!tableIdSet.isEmpty()) break block10;
            SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
            return;
        }
        try {
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)userId));
            this.execute(ctx, conn, statement, rs, jobProcessDef, tableIdSet, sqlsb, ScheduleTypeEnum.getEnum(scheduleType), user);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"EJBFactory.getConnection(ctx) error", (Throwable)e);
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)"conn.rollback() error", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _retryStatisticsAnalysisDisptach(Context ctx, String userId, String jobProcessDefID, int scheduleType) throws BOSException, EASBizException {
        Map map = this._getProcessDef(ctx, jobProcessDefID);
        if (map == null) {
            return;
        }
        if (map != null && !map.isEmpty()) {
            int day;
            Calendar c = Calendar.getInstance();
            String define = (String)map.get("define");
            String[] defines = define.split(":");
            ScheduleType sType = ScheduleType.getEnum((String)defines[0]);
            ScheduleExpression se = JobProcessUtil.parseSchedule((String)defines[1]);
            if (ScheduleType.EVERYMONTH.equals((Object)sType)) {
                if (se != null) {
                    String dayofmonth = se.getDayofmonth();
                    day = c.get(5);
                    if (day == Integer.parseInt(dayofmonth)) {
                        return;
                    }
                }
            } else if (se != null) {
                String dayofweek = se.getDayofweek();
                day = c.get(7);
                if (day == Integer.parseInt(dayofweek)) {
                    return;
                }
            }
        }
        String jobProcessDef = null;
        StringBuilder sqlsb = new StringBuilder();
        HashSet<String> tableIdSet = new HashSet<String>();
        sqlsb.append("select Fid,FJobProcessDefId from T_CSL_StatisticsAnalysis where FExecuteStatus=1 and FIsNeedExecute=1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlsb.toString());
        try {
            while (rs.next()) {
                tableIdSet.add(rs.getString("Fid"));
                if (jobProcessDef != null) continue;
                jobProcessDef = rs.getString("FJobProcessDefId");
            }
        }
        catch (Exception e) {
            logger.error((Object)"_retryStatisticsAnalysisDisptach_findTableNameError:", (Throwable)e);
        }
        if (tableIdSet.isEmpty()) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)userId));
            this.execute(ctx, conn, statement, rs, jobProcessDef, tableIdSet, sqlsb, ScheduleTypeEnum.getEnum(scheduleType), user);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"_retryStatisticsAnalysisDisptach EJBFactory.getConnection(ctx) error", (Throwable)e);
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)"_retryStatisticsAnalysisDisptach conn.rollback() error", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
    }

    private java.util.Date getEndDate(java.util.Date endDate) {
        GregorianCalendar endTime = new GregorianCalendar();
        endTime.setTime(endDate);
        Calendar c = Calendar.getInstance();
        c.set(14, 0);
        c.set(11, endTime.get(11));
        c.set(12, endTime.get(12));
        c.set(13, endTime.get(13));
        return c.getTime();
    }

    private void afterExecute(Context ctx, Connection conn, Statement statement, java.util.Date nextExecuteTime, ScheduleTypeEnum scheduleType, boolean isSuccess, StringBuilder sqlsb, String id, ScheduleDef schedule) {
        logger.error((Object)"execute_afterExecute");
        sqlsb.setLength(0);
        if (nextExecuteTime != null) {
            boolean isFNextExecuteTimeNull = true;
            Long beforNextExecuteTimeLong = null;
            sqlsb.append("select FNextExecuteTime from T_CSL_StatisticsAnalysis where fid='" + id + "'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlsb.toString());
                if (rs.next() && rs.getTimestamp("FNextExecuteTime") != null) {
                    beforNextExecuteTimeLong = rs.getTimestamp("FNextExecuteTime").getTime();
                    isFNextExecuteTimeNull = false;
                }
            }
            catch (Exception e) {
                logger.error((Object)"beforeExecute_findFNextExecuteTime_error:", (Throwable)e);
            }
            nextExecuteTime = beforNextExecuteTimeLong == null || beforNextExecuteTimeLong != null && nextExecuteTime.getTime() == beforNextExecuteTimeLong.longValue() ? StatisticsAnalysisUtil.getNextExecuteTime(schedule) : new java.util.Date(beforNextExecuteTimeLong);
            sqlsb.setLength(0);
            sqlsb.append(" update T_CSL_StatisticsAnalysis set FExecuteFinishedTime=" + this.getSqlFormatterTime(new java.util.Date()) + ",FNextExecuteTime=" + (isFNextExecuteTimeNull ? null : this.getSqlFormatterTime(nextExecuteTime)) + ",FExecuteStatus=" + (isSuccess ? 3 : 4) + " where fid='" + id + "'");
        } else {
            sqlsb.append("update T_CSL_StatisticsAnalysis set FExecuteFinishedTime=" + this.getSqlFormatterTime(new java.util.Date()) + ",FExecuteStatus=" + (isSuccess ? 3 : 4) + " where fid='" + id + "'");
        }
        try {
            statement.execute(sqlsb.toString());
            conn.commit();
        }
        catch (SQLException e) {
            logger.error((Object)"beforeExecute_error:", (Throwable)e);
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                logger.error((Object)"afterExecute_conn.rollback()_erro:", (Throwable)e1);
            }
        }
    }

    private void beforeExecute(Context ctx, Connection conn, Statement statement, StringBuilder sqlsb, java.util.Date nowDate, String id, DispatchTypeEnum dispatchType, UserInfo user) throws BOSException {
        logger.error((Object)"execute_beforeExecute");
        sqlsb.setLength(0);
        sqlsb.append("update T_CSL_StatisticsAnalysis set FPreExecuteTime=" + this.getSqlFormatterTime(nowDate) + ",FExecuteStatus=2,FIsNeedExecute=0,FDispatchType=" + dispatchType.getValue() + " where fid='" + id + "'");
        StatisticsAnalysisLogInfo sLogInfo = new StatisticsAnalysisLogInfo();
        user.put(LOGINFO, (Object)sLogInfo);
        sLogInfo.setStatisticsAnalysisId(id);
        sLogInfo.setExecuteStartTime(new Timestamp(nowDate.getTime()));
        sLogInfo.setExecutor(user);
        try {
            statement.execute(sqlsb.toString());
            conn.commit();
            sLogInfo.setStatus(StatisticsAnalysisLogStatusEnum.EXECUTING);
            StatisticsAnalysisControllerBean.writeLog(ctx, sLogInfo);
        }
        catch (SQLException e) {
            sLogInfo.setStatus(StatisticsAnalysisLogStatusEnum.FAIL);
            sLogInfo.setDetails(e.getMessage());
            StatisticsAnalysisControllerBean.writeLog(ctx, sLogInfo);
            logger.error((Object)"beforeExecute_error:", (Throwable)e);
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                sLogInfo.setDetails(e1.getMessage());
                StatisticsAnalysisControllerBean.writeLog(ctx, sLogInfo);
                logger.error((Object)"beforeExecute_conn.rollback() error:", (Throwable)e1);
                throw new BOSException((Throwable)e1);
            }
            throw new BOSException((Throwable)e);
        }
    }

    private void execute(Context ctx, Connection conn, Statement statement, IRowSet rs, String jobProcessDef, Set<String> tableIdSet, StringBuilder sqlsb, ScheduleTypeEnum scheduleType, UserInfo user) throws EASBizException, BOSException {
        java.util.Date endDate = null;
        ScheduleDef schedule = null;
        Map map = this._getProcessDef(ctx, jobProcessDef);
        if (map != null && !map.isEmpty()) {
            endDate = (java.util.Date)map.get("endTime");
            endDate = this.getEndDate(endDate);
            String define = (String)map.get("define");
            String[] defines = define.split(":");
            ScheduleType sType = ScheduleType.getEnum((String)defines[0]);
            schedule = new ScheduleDef(null);
            schedule.setType(sType);
            schedule.setDefine(defines[1]);
        }
        if (endDate != null) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            logger.error((Object)("execute_preEndDate:" + format.format(endDate)));
            int endHour = endDate.getHours();
            boolean needExecute = true;
            java.util.Date newEndDate = null;
            Calendar c = Calendar.getInstance();
            for (String tableId : tableIdSet) {
                needExecute = true;
                java.util.Date nowDate = new java.util.Date();
                int nowHour = nowDate.getHours();
                if (nowHour >= 21 && nowHour < 23) {
                    if (endHour >= 0 && endHour <= 8) {
                        c.setTime(endDate);
                        c.add(6, 1);
                        newEndDate = c.getTime();
                    } else {
                        newEndDate = endDate;
                    }
                    if (nowDate.after(newEndDate)) {
                        needExecute = false;
                    }
                } else {
                    if (endHour >= 21 && endHour < 23) {
                        needExecute = false;
                    } else {
                        newEndDate = endDate;
                    }
                    if (nowDate.after(newEndDate)) {
                        needExecute = false;
                    }
                }
                logger.error((Object)("execute_EndDate:" + format.format(endDate)));
                logger.error((Object)("execute_needExecute:" + needExecute));
                if (!needExecute) {
                    return;
                }
                user.remove(LOGINFO);
                sqlsb.setLength(0);
                sqlsb.append("select Fid,FTableName,FNextExecuteTime from T_CSL_StatisticsAnalysis where Fid='" + tableId + "' and FIsFreezed=0 and FIsNeedExecute=1 and FExecuteStatus<>2");
                rs = DbUtil.executeQuery((Context)ctx, (String)sqlsb.toString());
                try {
                    if (!rs.next()) continue;
                    String id = rs.getString("Fid");
                    Date nextExecuteTime = rs.getDate("FNextExecuteTime");
                    this.beforeExecute(ctx, conn, statement, sqlsb, nowDate, id, DispatchTypeEnum.AUTOEXECUTE, user);
                    boolean isSuccess = this.executeStatisticsAnalysis(ctx, sqlsb, rs.getString("FTableName"), user);
                    this.afterExecute(ctx, conn, statement, nextExecuteTime, scheduleType, isSuccess, sqlsb, id, schedule);
                }
                catch (Exception e) {
                    logger.error((Object)"_statisticsAnalysisDisptach_findInfoError:", (Throwable)e);
                }
            }
        }
    }

    private boolean executeStatisticsAnalysis(Context ctx, StringBuilder sqlsb, String tableName, UserInfo user) {
        logger.error((Object)"execute_executeStatisticsAnalysis");
        String dbType = ContextUtil.getDbType((Context)ctx);
        sqlsb.setLength(0);
        if (DbType.getName((int)2).equals(dbType)) {
            sqlsb.append("/*dialect*/ analyze table /*+parallel(8)*/" + tableName + " compute statistics");
        } else if (DbType.getName((int)5).equals(dbType) || DbType.getName((int)12).equals(dbType)) {
            sqlsb.append("/*dialect*/ analyze " + tableName);
        } else {
            sqlsb.append("/*dialect*/ UPDATE STATISTICS " + tableName);
        }
        StatisticsAnalysisLogInfo sLogInfo = (StatisticsAnalysisLogInfo)user.get(LOGINFO);
        try {
            DbUtil.execute((Context)ctx, (String)sqlsb.toString());
            sLogInfo.setExecuteFinishTime(new Timestamp(new java.util.Date().getTime()));
            sLogInfo.setStatus(StatisticsAnalysisLogStatusEnum.SUCCESS);
            StatisticsAnalysisControllerBean.writeLog(ctx, sLogInfo);
        }
        catch (Exception e) {
            sLogInfo.setExecuteFinishTime(new Timestamp(new java.util.Date().getTime()));
            sLogInfo.setStatus(StatisticsAnalysisLogStatusEnum.FAIL);
            sLogInfo.setFailReason(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_analyzeSqlError", (Locale)ctx.getOriginLocale()));
            sLogInfo.setDetails(e.getMessage());
            StatisticsAnalysisControllerBean.writeLog(ctx, sLogInfo);
            logger.error((Object)"executeStatisticsAnalysis_error", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    protected Map _batchSave(Context ctx, Map condition) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> saveFailRowIndexList = new ArrayList<Object>();
        StringBuffer msg = new StringBuffer();
        List addNewList = (List)condition.get("addNewList");
        List modifyList = (List)condition.get("modifyList");
        List deleteIds = (List)condition.get("deleteIds");
        boolean saveSuccess = false;
        StringBuffer sql = new StringBuffer();
        try {
            StatisticsAnalysisInfo firstInfo = this.getFirstInfo(ctx);
            String jobProcessDef = firstInfo.getJobProcessDef();
            String retryJobProcessDef = firstInfo.getRetryJobProcessDef();
            Timestamp nextExecuteTime = firstInfo.getNextExecuteTime();
            if (!deleteIds.isEmpty()) {
                sql.append("delete from T_CSL_StatisticsAnalysis where fid=?");
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                for (Object obj : deleteIds) {
                    params.add(new Object[]{obj});
                }
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
                saveSuccess = true;
                sql.setLength(0);
                sql.append("delete from T_CSL_StatisticsAnalysisLog where FStatisticsAnalysisId=?");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
            }
            HashMap<String, String> tableName_IdMap = new HashMap<String, String>();
            StatisticsAnalysisCollection statisticsAnalysisCollection = StatisticsAnalysisFactory.getLocalInstance(ctx).getStatisticsAnalysisCollection("select id,tableName");
            for (int i = 0; i < statisticsAnalysisCollection.size(); ++i) {
                StatisticsAnalysisInfo info = statisticsAnalysisCollection.get(i);
                tableName_IdMap.put(info.getTableName(), info.getId().toString());
            }
            HashSet<String> errorTable = new HashSet<String>();
            HashSet<String> existsTable = new HashSet<String>();
            StringBuilder exsitInfoSb = new StringBuilder();
            Timestamp time = this.getTime();
            if (!modifyList.isEmpty()) {
                sql.setLength(0);
                sql.append(" update T_CSL_StatisticsAnalysis set FTableName=?,FRemark=?,FLastUpdateUserID=?,FLastUpdateTime=? where fid=? ");
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                HashSet<String> updateIdSet = new HashSet<String>();
                for (Object obj : modifyList) {
                    Object[] objs = (Object[])obj;
                    String tableName = ((String)objs[1]).trim();
                    if (!this.checkTable(ctx, tableName, exsitInfoSb, errorTable, existsTable)) {
                        saveFailRowIndexList.add(objs[3]);
                        continue;
                    }
                    String id = (String)objs[0];
                    String remark = (String)objs[2];
                    if (tableName_IdMap.containsKey(tableName)) {
                        if (!((String)tableName_IdMap.get(tableName)).equals(id)) {
                            saveFailRowIndexList.add(objs[3]);
                            exsitInfoSb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_tableIsRepeat", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tableName}));
                            exsitInfoSb.append("\n");
                            continue;
                        }
                        updateIdSet.add((String)objs[0]);
                        params.add(new Object[]{objs[1], objs[2], ctx.getCaller().toString(), time, objs[0]});
                        continue;
                    }
                    tableName_IdMap.put(tableName, id);
                    params.add(new Object[]{objs[1], objs[2], ctx.getCaller().toString(), time, objs[0]});
                    updateIdSet.add((String)objs[0]);
                }
                if (params.size() > 0) {
                    DbUtil.executeBatch((Context)ctx, (String)sql.toString(), params);
                    saveSuccess = true;
                }
                if (updateIdSet.size() > 0) {
                    SQLBuilder sqlSb = new SQLBuilder();
                    sqlSb.append("delete from T_CSL_StatisticsAnalysisLog where FStatisticsAnalysisId in", updateIdSet);
                    DbUtil.execute((Context)ctx, (String)sqlSb.toString(), (Object[])sqlSb.getParams());
                }
            }
            if (!addNewList.isEmpty()) {
                HashSet<String> tableNameSet = new HashSet<String>();
                tableNameSet.addAll(tableName_IdMap.keySet());
                this.verifyExsitInfoCol(ctx, addNewList, tableNameSet, exsitInfoSb, errorTable, existsTable, saveFailRowIndexList);
                if (!addNewList.isEmpty()) {
                    UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
                    CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                    CoreBaseCollection infoCol = new CoreBaseCollection();
                    for (Object obj : addNewList) {
                        StatisticsAnalysisInfo stInfo = new StatisticsAnalysisInfo();
                        Object[] objs = (Object[])obj;
                        stInfo.setTableName(((String)objs[0]).trim());
                        stInfo.setRemark((String)objs[1]);
                        stInfo.setCreator(user);
                        stInfo.setCreateTime(time);
                        stInfo.setLastUpdateUser(user);
                        stInfo.setLastUpdateTime(time);
                        stInfo.setCU(cu);
                        stInfo.setJobProcessDef(jobProcessDef);
                        stInfo.setRetryJobProcessDef(retryJobProcessDef);
                        stInfo.setNextExecuteTime(nextExecuteTime);
                        infoCol.add((CoreBaseInfo)stInfo);
                    }
                    StatisticsAnalysisFactory.getLocalInstance(ctx).saveBatchData(infoCol);
                    saveSuccess = true;
                }
            }
            if ((firstInfo = this.getFirstInfo(ctx)).getId() == null) {
                if (jobProcessDef != null) {
                    EnactmentServiceFactory.createEnactService((Context)ctx).removeJobProcessDef(jobProcessDef);
                }
                if (retryJobProcessDef != null) {
                    EnactmentServiceFactory.createEnactService((Context)ctx).removeJobProcessDef(retryJobProcessDef);
                }
            }
            if (!saveFailRowIndexList.isEmpty()) {
                result.put("saveFailRowIndexList", saveFailRowIndexList);
            }
            if (exsitInfoSb.length() > 0 && saveSuccess) {
                result.put("warning", exsitInfoSb.toString());
            } else if (!saveSuccess) {
                result.put("fail", exsitInfoSb.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)"_batchSave error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result.isEmpty() ? null : result;
    }

    private boolean checkTable(Context ctx, String tableName, StringBuilder exsitInfoSb, Set<String> errorTable, Set<String> existsTable) {
        if (existsTable.contains(tableName)) {
            return true;
        }
        if (errorTable.contains(tableName)) {
            exsitInfoSb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_tableNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tableName}));
            exsitInfoSb.append("\n");
            return false;
        }
        try {
            String sql = "select 1 from KSQL_USERTABLES where KSQL_TABNAME = '" + CslRptUtil.checkSqlParam(tableName) + "'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!rowSet.next()) {
                exsitInfoSb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_tableNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tableName}));
                exsitInfoSb.append("\n");
                errorTable.add(tableName);
                return false;
            }
            existsTable.add(tableName);
        }
        catch (Exception e) {
            errorTable.add(tableName);
            exsitInfoSb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_tableNotExist", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tableName}));
            exsitInfoSb.append("\n");
            logger.error((Object)"checkTable_error:", (Throwable)e);
            return false;
        }
        return true;
    }

    private void verifyExsitInfoCol(Context ctx, List<Object[]> addNewList, Set<String> tableNameSet, StringBuilder exsitInfoSb, Set errorTable, Set<String> existsTable, List saveFailRowIndexList) {
        Iterator<Object[]> iterator = addNewList.iterator();
        while (iterator.hasNext()) {
            Object[] obj = iterator.next();
            String tableName = ((String)obj[0]).trim();
            if (!this.checkTable(ctx, tableName, exsitInfoSb, errorTable, existsTable)) {
                saveFailRowIndexList.add(obj[2]);
                iterator.remove();
                continue;
            }
            if (tableNameSet.contains(tableName)) {
                saveFailRowIndexList.add(obj[2]);
                iterator.remove();
                exsitInfoSb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.maintaintool.MaintainToolResource", (String)"statisticsAnalysis_tableIsRepeat", (Locale)ctx.getOriginLocale(), (Object[])new Object[]{tableName}));
                exsitInfoSb.append("\n");
                continue;
            }
            tableNameSet.add(tableName);
        }
    }

    private Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected void _freeze(Context ctx, Set idSet, boolean isFreeze) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        for (String id : idSet) {
            ObjectUuidPK pk = new ObjectUuidPK(id);
            StatisticsAnalysisInfo stInfo = this.getStatisticsAnalysisInfo(ctx, (IObjectPK)pk);
            if (isFreeze) {
                stInfo.setIsFreezed(true);
            } else {
                stInfo.setIsFreezed(false);
            }
            this.update(ctx, (IObjectPK)pk, stInfo);
        }
    }

    @Override
    protected Map _getProcessDef(Context ctx, String jobProcessDefId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)jobProcessDefId)) {
            return null;
        }
        if (!jobProcessDefId.endsWith("BGJOBDEF")) {
            int endLength = jobProcessDefId.length() - "BGJOBDEF".length() + 1;
            String str = jobProcessDefId.substring(0, endLength);
            jobProcessDefId = jobProcessDefId + str + "BGJOBDEF";
        }
        String sql = "select fscheduleplan define, Fexpiredtime expiredtime from t_job_trigger where fjobdefid = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{jobProcessDefId});
        HashMap<String, Object> map = null;
        try {
            if (rs.next()) {
                map = new HashMap<String, Object>();
                map.put("define", rs.getString("define"));
                map.put("endTime", rs.getDate("expiredtime"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return map;
    }

    @Override
    protected void _batchUpdateJobProcessDef(Context ctx, String jobProcessDef, String retryJobProcessDef, java.util.Date endTime, java.util.Date nextExecuteTime) throws BOSException, EASBizException {
        if (jobProcessDef == null && retryJobProcessDef == null && endTime == null && nextExecuteTime == null) {
            DbUtil.execute((Context)ctx, (String)"update T_CSL_StatisticsAnalysis set FJobProcessDefId=null,FRetryJobProcessDefId=null,FNextExecuteTime=null");
        } else if (jobProcessDef != null && retryJobProcessDef == null && endTime != null && nextExecuteTime != null) {
            DbUtil.execute((Context)ctx, (String)"update T_CSL_StatisticsAnalysis set FNextExecuteTime=? where fid <> '5w47+ZhAG0jgUztAqMCga3hWiRE='", (Object[])new Object[]{new Timestamp(nextExecuteTime.getTime())});
            DbUtil.execute((Context)ctx, (String)"update t_job_trigger set Fexpiredtime=? where fjobdefid=?", (Object[])new Object[]{new Timestamp(endTime.getTime()), jobProcessDef});
        } else if (jobProcessDef != null && retryJobProcessDef != null && endTime != null && nextExecuteTime != null) {
            DbUtil.execute((Context)ctx, (String)"update T_CSL_StatisticsAnalysis set FJobProcessDefId=?,FRetryJobProcessDefId=?,FNextExecuteTime=? where fid <> '5w47+ZhAG0jgUztAqMCga3hWiRE='", (Object[])new Object[]{jobProcessDef, retryJobProcessDef, new Timestamp(nextExecuteTime.getTime())});
            DbUtil.execute((Context)ctx, (String)"update t_job_trigger set Fexpiredtime=? where fjobdefid=?", (Object[])new Object[]{new Timestamp(endTime.getTime()), jobProcessDef});
        }
    }

    @Override
    protected StatisticsAnalysisInfo _getFirstInfo(Context ctx) throws BOSException, EASBizException {
        StatisticsAnalysisInfo info = new StatisticsAnalysisInfo();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select top 1 Fid,FJobProcessDefId,FRetryJobProcessDefId,FNextExecuteTime from T_CSL_StatisticsAnalysis where fid <> '5w47+ZhAG0jgUztAqMCga3hWiRE='");
        try {
            if (rs.next()) {
                info.setId(BOSUuid.read((String)rs.getString("Fid")));
                info.setJobProcessDef(rs.getString("FJobProcessDefId"));
                info.setRetryJobProcessDef(rs.getString("FRetryJobProcessDefId"));
                info.setNextExecuteTime(rs.getTimestamp("FNextExecuteTime"));
                return info;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getFirstInfoJobProcessDef_error:", (Throwable)e);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _startExecute(Context ctx, List idList) throws BOSException, EASBizException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            conn.setAutoCommit(false);
            statement = conn.createStatement();
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            StringBuilder sqlsb = new StringBuilder();
            for (int i = 0; i < idList.size(); ++i) {
                user.remove(LOGINFO);
                java.util.Date nowDate = new java.util.Date();
                String id = (String)idList.get(i);
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)("select Fid,FTableName,FExecuteStatus,FIsFreezed from T_CSL_StatisticsAnalysis where fid='" + id + "'"));
                if (!rowSet.next()) continue;
                String tableName = rowSet.getString("FTableName");
                int executeStatus = rowSet.getInt("FExecuteStatus");
                boolean isFreezed = rowSet.getBoolean("FIsFreezed");
                if (isFreezed || 2 == executeStatus) continue;
                this.beforeExecute(ctx, conn, statement, sqlsb, nowDate, id, DispatchTypeEnum.NOWSTART, user);
                boolean isSuccess = this.executeStatisticsAnalysis(ctx, sqlsb, tableName, user);
                this.afterExecute(ctx, conn, statement, null, null, isSuccess, sqlsb, id, null);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"EJBFactory.getConnection(ctx) error", (Throwable)e);
                try {
                    conn.rollback();
                }
                catch (SQLException e1) {
                    logger.error((Object)"conn.rollback() error", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, statement, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)statement, (Connection)conn);
    }

    @Override
    protected void _stopExecute(Context ctx) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"update T_CSL_StatisticsAnalysis set FIsNeedExecute=0");
    }

    private static void writeLog(Context ctx, StatisticsAnalysisLogInfo info) {
        try {
            IStatisticsAnalysisLog localInstance = StatisticsAnalysisLogFactory.getLocalInstance(ctx);
            BOSUuid id = info.getId();
            if (id == null) {
                IObjectPK pk = localInstance.addnew(info);
                info.setId(BOSUuid.read((String)pk.toString()));
                return;
            }
            localInstance.update((IObjectPK)new ObjectUuidPK(id), info);
        }
        catch (Exception e) {
            logger.error((Object)"writeLog_error", (Throwable)e);
        }
    }

    private String getSqlFormatterTime(java.util.Date date) {
        return "{ts '" + this.formatter.format(date) + "'}";
    }
}

