/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.reportcalc;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportCalculatorFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ICSLReportCalculator;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.AbstractRptCalculate;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.ClearMnsFormulaHandler;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptParamInfo;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.RptCalcHelper;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnCollection;
import com.kingdee.eas.fi.gr.cslrpt.reportcalc.mns.MnsColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptFillCondition;
import com.kingdee.eas.fi.gr.cslrpt.util.MnsRptGuideHelper;
import com.kingdee.eas.fi.newrpt.samecontrol.SameControlUtil;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.IBreakableExpressionHandler;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MnsRptCalculate
extends AbstractRptCalculate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.reportcalc.MnsRptCalculate");
    public static final int CalculateBookAdjust = 3;
    public static final int CalculateSheetAdjust = 4;
    private boolean isSupportCrossMerger = false;
    private boolean isSupportHandElim = false;
    private boolean isIncludeUnAuditElim = false;
    private int dataElementRelating = -1;
    private Map tables;
    private Map tableFormulas;
    private Map elimValueMap = null;
    private boolean includeSendback = false;
    private MnsRptParamInfo mnsRptParamInfo;
    private List fillCompanyList;
    private List fillExcludeCompanyList;
    private boolean isBeforeAdjust;
    private String clientSource;
    private boolean isSupportGroupReport = true;
    private List adjustTypeFilter = null;
    private String fastMergeSoluId = null;
    private List elimTypeFilter = null;
    private boolean isCheckRptReceived = true;
    private boolean isCalcCslBeginByCurPeriodBegin = false;

    public MnsRptCalculate(Context ctx) {
        super(ctx);
    }

    public MnsRptCalculate(Context ctx, Map context) {
        super(ctx, context);
    }

    public String getFastMergeSoluId() {
        return this.fastMergeSoluId;
    }

    public void setFastMergeSoluId(String fastMergeSoluId) {
        this.fastMergeSoluId = fastMergeSoluId;
    }

    public List getElimTypeFilter() {
        return this.elimTypeFilter;
    }

    public void setElimTypeFilter(List elimTypeFilter) {
        this.elimTypeFilter = elimTypeFilter;
    }

    @Override
    public void prepareCalculate() throws EASBizException, BOSException {
        super.prepareCalculate();
        if (this.calcType == 4) {
            for (int i = 0; i < this.book.getSheetCount(); ++i) {
                this.book.getSheet(i).setEnableCalculation(false);
            }
            this.book.getActiveSheet().setEnableCalculation(true);
        }
        if (this.isSupportCrossMerger && this.mnsRptParamInfo != null && this.mnsRptParamInfo.isSupportHandSingleData()) {
            this.mnsRptParamInfo.setSingleDataMap(this.getSingleDataMap(this.book, false));
        }
        if (this.isSupportCrossMerger) {
            MnsRptFillCondition condition = new MnsRptFillCondition(this._ctx, this.cslRptInfo.getOrgTree(), (OrgUnitInfo)this.cslRptInfo.getOrgUnit(), this.cslRptInfo.getYear(), this.cslRptInfo.getPeriod(), this.cslRptInfo.getPeriodType().getValue(), this.isSupportCrossMerger);
            condition.book = this.book;
            condition.companys = this.fillCompanyList;
            condition.excludeCompanys = this.fillExcludeCompanyList;
            MnsRptGuideHelper.fillMnsRptSheet(condition);
        } else if ("EXCEL".equals(this.getClientSouce())) {
            this.elimValueMap = this.isSupportHandElim ? this.getElimValueMap(this.book, false) : null;
            this.init();
        } else {
            List sendBackedCompany;
            if (this._ctx == null) {
                if (this.isCheckRptReceived) {
                    RptCalcHelper.checkRptRule(this._context, this.cslRptInfo);
                }
                this.elimValueMap = this.isSupportHandElim ? this.getElimValueMap(this.book, false) : null;
            }
            this.init();
            if (this._ctx == null && this.tableFormulas.size() > 0 && (sendBackedCompany = CSLReportCalculatorFactory.getRemoteInstance().sendBackedCompany((IObjectPK)new ObjectUuidPK(this.cslRptInfo.getId()), this.tableFormulas)) != null && sendBackedCompany.size() > 0) {
                String res = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"57_MnsRptCalculate");
                int confirm = MsgBox.showConfirm3a((Component)this.reportProcessUI, (String)(MessageFormat.format(msg, sendBackedCompany.size()) + "\n" + EASResource.getString((String)res, (String)"381_CslRptUIUtil_1") + "\n" + EASResource.getString((String)res, (String)"381_CslRptUIUtil_2")), (String)CslRptUtil.list2String(sendBackedCompany, "\n"));
                if (confirm == 0) {
                    this.includeSendback = true;
                }
            }
        }
    }

    private void init() {
        this.clearMANCellData(this.book, false);
        this.tables = new HashMap();
        this.tableFormulas = new HashMap();
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            Sheet sheet = this.book.getSheet(i);
            if (!sheet.isEnableCalculation()) continue;
            this.tables.put(sheet.getID(), sheet);
            HashMap cellFormula = this.constructMnsTableMap(sheet);
            this.tableFormulas.put(sheet.getID(), cellFormula);
        }
    }

    @Override
    public void calculate() throws EASBizException, BOSException {
        if (this.isSupportCrossMerger) {
            this.init();
        }
        ICSLReportCalculator calculator = null;
        calculator = this._ctx == null ? CSLReportCalculatorFactory.getRemoteInstance() : CSLReportCalculatorFactory.getLocalInstance(this._ctx);
        if (this.mnsRptParamInfo == null) {
            this.mnsRptParamInfo = new MnsRptParamInfo();
        }
        if (this.book != null) {
            this.mnsRptParamInfo.setSheetName(this.book.getActiveSheet().getSheetName());
        }
        this.mnsRptParamInfo.setReportID(this.cslRptInfo.getId().toString());
        this.mnsRptParamInfo.setTableFormulas(this.tableFormulas);
        this.mnsRptParamInfo.setIncludeSendBacked(this.includeSendback);
        this.mnsRptParamInfo.setBeforeAdjust(this.isBeforeAdjust);
        if (StringUtils.isEmpty((String)this.fastMergeSoluId) && !this.mnsRptParamInfo.isSupportGroupReport() && this.isSupportCrossMerger) {
            this.dataElementRelating = -1;
        }
        this.mnsRptParamInfo.setDataElementRelating(this.dataElementRelating);
        this.mnsRptParamInfo.setIncludeUnAuditElim(this.isIncludeUnAuditElim);
        this.mnsRptParamInfo.setSupportHandElim(this.isSupportHandElim);
        this.mnsRptParamInfo.setElimValueMap(this.elimValueMap);
        this.mnsRptParamInfo.setElimTypeFilter(this.elimTypeFilter);
        this.mnsRptParamInfo.setSupportCrossMerger(this.isSupportCrossMerger);
        this.mnsRptParamInfo.setAdjustTypeFilter(this.adjustTypeFilter);
        this.mnsRptParamInfo.setSupportGroupReport(this.isSupportGroupReport);
        this.mnsRptParamInfo.setFastMergeSoluId(this.fastMergeSoluId);
        boolean isRoundingByPrecision = CSLParamUtil.getSysParamBoolValFromContext(this._ctx, "GR_CSL_RoundingByPrecision", true);
        this.mnsRptParamInfo.setRoundingByPrecision(isRoundingByPrecision);
        this.mnsRptParamInfo.setCalcCslBeginByCurPeriodBegin(SameControlUtil.getBookVariable((Book)this.book, (String)"isCalcCslBeginByCurPeriod"));
        Map sumResult = calculator.calculateMnsReport(this.mnsRptParamInfo);
        int precision = RptCalcHelper.getPrecisionByCry(this._ctx, this.cslRptInfo.getCurrency());
        RptCalcHelper.refreshTableData(this.tables, sumResult, precision, isRoundingByPrecision);
        if (this.calcType == 0 || this.calcType == 1) {
            RptCalcHelper.setDataElementRelatingColor(this.dataElementRelating, this.book, false);
        }
    }

    private BigDecimal getCellVaule(Sheet sheet, int row, int col, int iTop, boolean keepLocked) {
        if (row == iTop) {
            return null;
        }
        Cell cell = sheet.getCell(row, col, false);
        if (cell == null || cell.getValue() == null || cell.isLocked() && keepLocked) {
            return null;
        }
        Variant value = cell.getValue();
        BigDecimal decimal = null;
        if (value.getValue() != null) {
            if (value.getValue() instanceof BigDecimal) {
                decimal = (BigDecimal)value.getValue();
            } else if (value.getValue() instanceof String) {
                try {
                    if (!((String)value.getValue()).trim().equals("")) {
                        decimal = new BigDecimal(((String)value.getValue()).trim());
                    }
                }
                catch (Exception e) {
                    decimal = null;
                }
            }
        }
        return decimal;
    }

    @Override
    public void afterCalculate() {
        super.afterCalculate();
        this.isSupportHandElim = false;
        this.isIncludeUnAuditElim = false;
        this.dataElementRelating = -1;
        this.multiCalculateQueue = null;
        this.calcType = 0;
        this.isBeforeAdjust = false;
        this.isCalcCslBeginByCurPeriodBegin = false;
    }

    private Map getElimValueMap(Book book, boolean keepLocked) {
        HashMap<String, Cloneable> elimValueMap = new HashMap<String, Cloneable>();
        Sheet sheet = null;
        Variant value = null;
        int iLeft = 0;
        int iTop = 0;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            HashMap base;
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation() || (base = CslRptUtil.getBasePosition(sheet)) == null) continue;
            HashSet<Integer> colSet = new HashSet<Integer>();
            HashMap<String, BigDecimal> elimValueMap1 = new HashMap<String, BigDecimal>();
            iTop = (Integer)base.get("top");
            iLeft = (Integer)base.get("left");
            ItemFormula colitem = null;
            int columnDataType = -1;
            Cell cell = null;
            int colCount = sheet.getCols().getMaxIntMark() + 1;
            for (int col = 0; col < colCount; ++col) {
                if (col == iLeft || (colitem = UserObjectHelper.getItemFormula((Cell)sheet.getCell(iTop, col, false))) == null || colitem.getExt("DataSrc") == null || (columnDataType = Integer.valueOf(colitem.getExt("DataSrc")).intValue()) != 5 && columnDataType != 4 && columnDataType != 6) continue;
                int rowCount = sheet.getRows().getMaxIntMark() + 1;
                for (int row = 0; row < rowCount; ++row) {
                    if (row == iTop || (cell = sheet.getCell(row, col, false)) == null || cell.getValue() == null || cell.isLocked() && keepLocked) continue;
                    value = cell.getValue();
                    BigDecimal decimal = null;
                    if (value.getValue() != null) {
                        if (value.getValue() instanceof BigDecimal) {
                            decimal = (BigDecimal)value.getValue();
                        } else if (value.getValue() instanceof String) {
                            try {
                                if (!((String)value.getValue()).trim().equals("")) {
                                    decimal = new BigDecimal(((String)value.getValue()).trim());
                                }
                            }
                            catch (Exception e) {
                                decimal = null;
                            }
                        }
                    }
                    if (decimal == null) continue;
                    colSet.add(new Integer(col));
                    elimValueMap1.put(row + "-" + col + "-" + columnDataType + "-" + colitem.getDataElementNumber(), decimal);
                    elimValueMap1.put(row + "-" + col + "-" + columnDataType, decimal);
                }
            }
            elimValueMap.put(sheet.getID() + "-colSet", colSet);
            elimValueMap.put(sheet.getID() + "-elimValueMap", elimValueMap1);
        }
        return elimValueMap;
    }

    private void clearMANCellData(Book book, boolean keepLocked) {
        Sheet sheet = null;
        Variant value = null;
        int iLeft = 0;
        int iTop = 0;
        Set noClearSet = this.getNoClearSet();
        boolean isIncludeAdjust = false;
        Cell curCell = null;
        boolean isColItemNull = true;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            HashMap base;
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation() || (base = CslRptUtil.getBasePosition(sheet)) == null) continue;
            iTop = (Integer)base.get("top");
            iLeft = (Integer)base.get("left");
            isIncludeAdjust = MnsRptGuideHelper.isIncludeAdjust(sheet, sheet.getCell(iTop, iLeft, false));
            int rowCount = sheet.getRows().getMaxIntMark() + 1;
            for (int row = 0; row < rowCount; ++row) {
                if (row == iTop) continue;
                int colCount = sheet.getCols().getMaxIntMark() + 1;
                for (int col = 0; col < colCount; ++col) {
                    Cell cell;
                    if (col == iLeft || (cell = sheet.getCell(row, col, false)) == null || cell.isLocked() && keepLocked || cell.hasFormula() && !MnsRptCalculate.isClearMnsFormula(cell.getFormula(), new ClearMnsFormulaHandler(noClearSet)) || (value = cell.getValue()) == null) continue;
                    Cell colCell = sheet.getCell(iTop, col, false);
                    ItemFormula rowitem = UserObjectHelper.getItemFormula((Cell)sheet.getCell(row, iLeft, false));
                    ItemFormula colitem = UserObjectHelper.getItemFormula((Cell)colCell);
                    boolean bl = isColItemNull = colitem == null;
                    if (colitem != null) {
                        if ("1".equals(colitem.getExt("DataSrc")) && StringUtils.isEmpty((String)colitem.getExt("Company"))) {
                            isColItemNull = true;
                        }
                    } else if (isIncludeAdjust) {
                        Integer[] adjustDataSrc;
                        ItemFormula firstCellItem;
                        CellBlock block;
                        curCell = sheet.getCell(iTop + 1, col, false);
                        if (curCell != null && curCell.getUserObject("DATASRCFORADJUST") != null) {
                            isColItemNull = false;
                        } else if (colCell != null && (block = colCell.getMerge(true)) != null && (firstCellItem = UserObjectHelper.getItemFormula((Cell)sheet.getCell(block.getRow(), block.getCol(), false))) != null && (adjustDataSrc = MnsRptGuideHelper.getAdjustDataSrc(firstCellItem)) != null && block.getCol() < col && col <= block.getCol() + adjustDataSrc.length) {
                            isColItemNull = false;
                        }
                    }
                    if (rowitem == null || isColItemNull) continue;
                    cell.setValue(Variant.nullVariant);
                    cell.setFormula(null);
                }
            }
        }
    }

    private HashMap constructMnsTableMap(Sheet sheet) {
        if (sheet == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap items = null;
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        int left = 0;
        int top = 0;
        left = CslRptUtil.getBasePosition_Left(sheet);
        top = CslRptUtil.getBasePosition_Top(sheet);
        left = left >= 0 ? left : 0;
        top = top >= 0 ? top : 0;
        items = this.getItemsMap(sheet, rowCount, top + 1, left);
        boolean isIncludeAdjust = MnsRptGuideHelper.isIncludeAdjust(sheet, sheet.getCell(top, left, false));
        Integer[] adjustDataSrc = null;
        if (items.size() > 0) {
            HashMap<Integer, ItemFormula> formulas = new HashMap<Integer, ItemFormula>();
            for (int columnIndex = left + 1; columnIndex < colCount; ++columnIndex) {
                ItemFormula curFormula = (ItemFormula)sheet.getRange(top, columnIndex).getUserObject("ITEM");
                if (curFormula == null) continue;
                curFormula.setCell(null);
                if (isIncludeAdjust && curFormula.getExt("DataSrc") != null && (1 == Integer.valueOf(curFormula.getExt("DataSrc")) || 2 == Integer.valueOf(curFormula.getExt("DataSrc")) || 3 == Integer.valueOf(curFormula.getExt("DataSrc")))) {
                    adjustDataSrc = MnsRptGuideHelper.getAdjustDataSrc(curFormula);
                    if (adjustDataSrc != null) {
                        for (int i = 0; i < adjustDataSrc.length; ++i) {
                            curFormula = (ItemFormula)curFormula.clone();
                            curFormula.putExt("DATASRCFORADJUST", String.valueOf(adjustDataSrc[i]));
                            formulas.put(new Integer(columnIndex + i), curFormula);
                        }
                        continue;
                    }
                    formulas.put(new Integer(columnIndex), curFormula);
                    continue;
                }
                formulas.put(new Integer(columnIndex), curFormula);
            }
            if (formulas.size() > 0) {
                result.put("KEY_ITEMS", items);
                result.put("KEY_PARAMS", formulas);
                result.put("KEY_CUR_ORGBOUND_ID", this.cslRptInfo.getOrgTree().getId().toString());
                result.put("KEY_CUR_ORGBOUNDGROUP_NUMBER", this.cslRptInfo.getNumber());
            }
        }
        return result;
    }

    private Set getNoClearSet() {
        HashSet<String> noClearSet = new HashSet<String>();
        noClearSet.add("sum");
        noClearSet.add("if");
        noClearSet.add("and");
        noClearSet.add("abs");
        noClearSet.add("max");
        noClearSet.add("min");
        noClearSet.add("not");
        noClearSet.add("or");
        noClearSet.add("subtotal");
        noClearSet.add("sumif");
        noClearSet.add("acctitem");
        noClearSet.add("csref");
        noClearSet.add("iferror");
        String mnsNoClearFormulas = CSLParamUtil.getStringCslParamValue(this._ctx, "KEY_CSLPARAM_MNSRPTNOCLEARFORMULAS");
        if (!StringUtils.isEmpty((String)mnsNoClearFormulas)) {
            String[] formulas;
            for (String formula : formulas = mnsNoClearFormulas.split(";")) {
                if (StringUtils.isEmpty((String)formula)) continue;
                noClearSet.add(formula.trim().toLowerCase());
            }
        }
        return noClearSet;
    }

    private static boolean isClearMnsFormula(String formula, ClearMnsFormulaHandler handler) {
        if (!StringUtils.isEmpty((String)formula) && !StringUtils.isEmpty((String)formula.trim()) && formula.trim().charAt(0) == '=') {
            if (formula.trim().indexOf("(") > 0) {
                try {
                    Expression exp = ExcelFormulaPaserHelper.parse((String)formula);
                    ExcelFormulaPaserHelper.walk((Expression)exp, (IBreakableExpressionHandler)handler);
                    return handler.isClearMnsFormula();
                }
                catch (Exception e) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public void setSupportCrossMerger(boolean isSupportCrossMerger) {
        this.isSupportCrossMerger = isSupportCrossMerger;
    }

    public void setIncludeUnAuditElim(boolean isIncludeUnAuditElim) {
        this.isIncludeUnAuditElim = isIncludeUnAuditElim;
    }

    public void setSupportHandElim(boolean isSupportHandElim) {
        this.isSupportHandElim = isSupportHandElim;
    }

    @Override
    public void setCalcType(int calcType) {
        if (calcType == 3) {
            this.calcType = 0;
            this.isBeforeAdjust = true;
        } else if (calcType == 4) {
            this.calcType = 1;
            this.isBeforeAdjust = true;
        } else {
            this.calcType = calcType;
            this.isBeforeAdjust = false;
        }
    }

    public void setDataElementRelating(int dataElementRelating) {
        this.dataElementRelating = dataElementRelating;
    }

    public void setMnsRptParamInfo(MnsRptParamInfo mnsRptParamInfo) {
        this.mnsRptParamInfo = mnsRptParamInfo;
    }

    public MnsRptParamInfo getMnsRptParamInfo() {
        return this.mnsRptParamInfo;
    }

    public void setFillCompanyList(List fillCompanyList) {
        this.fillCompanyList = fillCompanyList;
    }

    public void setFillExcludeCompanyList(List fillExcludeCompanyList) {
        this.fillExcludeCompanyList = fillExcludeCompanyList;
    }

    public boolean isSupportGroupReport() {
        return this.isSupportGroupReport;
    }

    public void setSupportGroupReport(boolean isSupportGroupReport) {
        this.isSupportGroupReport = isSupportGroupReport;
    }

    public List getAdjustTypeFilter() {
        return this.adjustTypeFilter;
    }

    public void setAdjustTypeFilter(List adjustIdsFilter) {
        this.adjustTypeFilter = adjustIdsFilter;
    }

    private Map getSingleDataMap(Book book, boolean keepLocked) {
        HashMap<String, MnsColumnCollection> singleDataMap = new HashMap<String, MnsColumnCollection>(4);
        Sheet sheet = null;
        int iLeft = 0;
        int iTop = 0;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            HashMap base;
            sheet = book.getSheet(i);
            if (sheet == null || !sheet.isEnableCalculation() || (base = CslRptUtil.getBasePosition(sheet)) == null) continue;
            iTop = (Integer)base.get("top");
            iLeft = (Integer)base.get("left");
            int rowCount = sheet.getMaxRowIndex() + 1;
            int colCount = sheet.getMaxColIndex() + 1;
            HashMap items = this.getItemsMap(sheet, rowCount, iTop + 1, iLeft);
            if (items.isEmpty()) {
                return singleDataMap;
            }
            ItemFormula colitem = null;
            int columnDataType = -1;
            String dataElementNumber = null;
            int valueType = -100;
            String companyID = null;
            MnsColumnCollection sinColColl = new MnsColumnCollection(10);
            MnsColumnInfo columnInfo = null;
            HashMap valueMap = null;
            for (int col = 0; col < colCount; ++col) {
                if (col == iLeft || (colitem = UserObjectHelper.getItemFormula((Cell)sheet.getCell(iTop, col, false))) == null || colitem.getExt("DataSrc") == null || (columnDataType = Integer.valueOf(colitem.getExt("DataSrc")).intValue()) != 1) continue;
                dataElementNumber = colitem.getDataElementNumber();
                valueType = colitem.getValueType();
                companyID = colitem.getExt("Company");
                boolean includeCompany = false;
                for (OrgUnitInfo curCom : this.fillCompanyList) {
                    if (!curCom.getId().toString().equals(companyID)) continue;
                    includeCompany = true;
                    break;
                }
                if (!includeCompany) continue;
                columnInfo = new MnsColumnInfo(col, companyID, dataElementNumber, valueType);
                sinColColl.add(columnInfo);
                valueMap = new HashMap(rowCount);
                for (int row = 0; row < rowCount; ++row) {
                    BigDecimal decimal = this.getCellVaule(sheet, row, col, iTop, keepLocked);
                    if (decimal == null) continue;
                    valueMap.put(items.get(new Integer(row)), decimal);
                }
                columnInfo.setValueMap(valueMap);
            }
            singleDataMap.put(sheet.getID(), sinColColl);
        }
        return singleDataMap;
    }

    private HashMap getItemsMap(Sheet sheet, int rowCount, int top, int left) {
        HashMap<Integer, String> items = new HashMap<Integer, String>(8);
        for (int rowIndex = top; rowIndex < rowCount; ++rowIndex) {
            ItemFormula curFormula = (ItemFormula)sheet.getRange(rowIndex, left).getUserObject("ITEM");
            if (curFormula == null) continue;
            curFormula.setCell(null);
            if (curFormula.getItemNumber() == null) continue;
            items.put(new Integer(rowIndex), curFormula.getItemNumber());
        }
        return items;
    }

    public List getFillCompanyList() {
        return this.fillCompanyList;
    }

    public void setClientSource(String clientSource) {
        this.clientSource = clientSource;
    }

    public String getClientSouce() {
        return this.clientSource;
    }

    public boolean isCheckRptReceived() {
        return this.isCheckRptReceived;
    }

    public void setCheckRptReceived(boolean isCheckRptReceived) {
        this.isCheckRptReceived = isCheckRptReceived;
    }

    public boolean isCalcCslBeginByCurPeriodBegin() {
        return this.isCalcCslBeginByCurPeriodBegin;
    }

    public void setCalcCslBeginByCurPeriodBegin(boolean isCalcCslBeginByCurPeriodBegin) {
        this.isCalcCslBeginByCurPeriodBegin = isCalcCslBeginByCurPeriodBegin;
    }
}

