/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.util.ResourceBase;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public final class CSLPermissionUtil {
    public static final String PMS_DATACOLLECT_AC = "csl_datacollect_ac";
    public static final String PMS_DATACOLLECT_BG = "csl_datacollect_bg";
    public static final String PMS_TEMPLATEDISPSTATEVIEM = "csl_rpt_templatedispstateview";
    public static final String PMS_RECEIVE_PRINT = "csl_rpt_receive_print";
    public static final String RESNAME_NOACTUALPERM = "No_AMDC_Permission";
    public static final String RESNAME_NOBUDGETPERM = "No_BGDC_Permission";
    public static final int PERM_ONLY_ACTUAL = 1;
    public static final int PERM_ONLY_BUDGET = 2;
    public static final int PERM_BOTH = 10;
    public static final int PERM_NO = 0;

    private static boolean hasAMPermission(Context ctx, String userId) throws BOSException, EASBizException {
        if (userId == null || !BOSUuid.isValid((String)userId, (boolean)true)) {
            return false;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        IPermission iPermission = null;
        iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission.hasFunctionPermission((IObjectPK)userPK, null, PMS_DATACOLLECT_AC);
    }

    private static boolean hasBGPermission(Context ctx, String userId) throws BOSException, EASBizException {
        if (userId == null || !BOSUuid.isValid((String)userId, (boolean)true)) {
            return false;
        }
        ObjectUuidPK userPK = new ObjectUuidPK(userId);
        IPermission iPermission = null;
        iPermission = ctx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        return iPermission.hasFunctionPermission((IObjectPK)userPK, null, PMS_DATACOLLECT_BG);
    }

    public static boolean hasDataCollectPermission(Context ctx, String userId, DataCollectInfo dataCollect) throws BOSException, EASBizException {
        return CSLPermissionUtil.hasDataCollectPermissionAndParam(ctx, userId, dataCollect);
    }

    public static boolean hasDataCollectPermission(Context ctx, String userId, DataCollectInfo dataCollect, boolean isSupportOtherDS) throws BOSException, EASBizException {
        if (userId == null || !BOSUuid.isValid((String)userId, (boolean)true) || dataCollect == null || dataCollect.getNumber() == null) {
            return false;
        }
        if (!isSupportOtherDS) {
            return true;
        }
        if (dataCollect.getNumber().equals("ACTUALDATA")) {
            return CSLPermissionUtil.hasAMPermission(ctx, userId);
        }
        if (dataCollect.getNumber().equals("BUDGETDATA")) {
            return CSLPermissionUtil.hasBGPermission(ctx, userId);
        }
        return false;
    }

    public static boolean hasDataCollectPermissionAndParam(Context ctx, String userId, DataCollectInfo dataCollect) throws BOSException, EASBizException {
        if (userId == null || !BOSUuid.isValid((String)userId, (boolean)true) || dataCollect == null || dataCollect.getNumber() == null) {
            return false;
        }
        boolean isSupportOtherDS = CslRptUtil.isSupportOtherDSServer(ctx);
        return CSLPermissionUtil.hasDataCollectPermission(ctx, userId, dataCollect, isSupportOtherDS);
    }

    public static void checkDataCollectPermissionForFormula(Context ctx, String userId, String dataCollectNumber, Map storage) throws BOSException, EASBizException {
        if (userId == null || !BOSUuid.isValid((String)userId, (boolean)true) || dataCollectNumber == null) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NODataCollectPermission", (Locale)ctx.getOriginLocale());
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(str, dataCollectNumber)});
        }
        boolean permission = true;
        if (!storage.containsKey(userId + "!" + dataCollectNumber)) {
            if (dataCollectNumber.equals("ACTUALDATA")) {
                permission = CSLPermissionUtil.hasAMPermission(ctx, userId);
            } else if (dataCollectNumber.equals("BUDGETDATA")) {
                permission = CSLPermissionUtil.hasBGPermission(ctx, userId);
            }
            storage.put(userId + "!" + dataCollectNumber, new Boolean(permission));
        } else {
            permission = (Boolean)storage.get(userId + "!" + dataCollectNumber);
        }
        if (!permission) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NODataCollectPermission", (Locale)ctx.getOriginLocale());
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(str, dataCollectNumber)});
        }
    }

    public static void checkDataCollectPermissionForFormula(Context ctx, String userId, String dataCollectNumber) throws BOSException, EASBizException {
        if (userId == null || !BOSUuid.isValid((String)userId, (boolean)true) || dataCollectNumber == null) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NODataCollectPermission", (Locale)ctx.getOriginLocale());
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(str, dataCollectNumber)});
        }
        boolean permission = false;
        if (dataCollectNumber.equals("ACTUALDATA")) {
            permission = CSLPermissionUtil.hasAMPermission(ctx, userId);
        } else if (dataCollectNumber.equals("BUDGETDATA")) {
            permission = CSLPermissionUtil.hasBGPermission(ctx, userId);
        }
        if (!permission) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"NODataCollectPermission", (Locale)ctx.getOriginLocale());
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{MessageFormat.format(str, dataCollectNumber)});
        }
    }

    public static String checkDataCollectPermissionForRptReceive(Context ctx, String tableAlias, String userId) {
        int perm = CSLPermissionUtil.checkDataCollectPermission(ctx, userId);
        if (perm == 10) {
            return "";
        }
        if (perm == 1) {
            return " and " + tableAlias + ".FDataCollectNumber = 'ACTUALDATA' ";
        }
        if (perm == 2) {
            return " and " + tableAlias + ".FDataCollectNumber = 'BUDGETDATA' ";
        }
        return "";
    }

    public static int checkDataCollectPermission(Context ctx, String userId) {
        int ret = 0;
        boolean actual = true;
        boolean budget = true;
        try {
            actual = CSLPermissionUtil.hasAMPermission(ctx, userId);
            budget = CSLPermissionUtil.hasBGPermission(ctx, userId);
        }
        catch (EASBizException e) {
            return 0;
        }
        catch (BOSException e) {
            return 0;
        }
        if (actual && budget) {
            return 10;
        }
        if (actual) {
            return 1;
        }
        if (budget) {
            return 2;
        }
        return ret;
    }
}

