/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.gzh.util.AESUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherInputStream;
import com.kingdee.eas.fi.gr.cslrpt.util.CipherOutputStream;
import com.kingdee.eas.fi.gr.cslrpt.util.PropertiesFileUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;

public class DNFFile {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.cslrpt.util.DNFFile");
    public static final String FileExtensionName = "dnf";
    public static final String INFO_PROPERTY_ISALLOWCHANGE = "CSL_PROPERTY_ISALLOWCHANGE";
    public static final String DNF_ENTRY_PUBLIC = "public.dat";
    private String DNF_ENTRY_TEMPLATE = "template.dat";
    private String DNF_ENTRY_CURRENCY = "currency.dat";
    private String DNF_ENTRY_COMPANY = "company.dat";
    private String DNF_ENTRY_UPDATETIME = "updatetime.dat";
    private String DNF_ENTRY_EASVERSION = "easversion.dat";
    private ArrayList templateCollection = null;
    private ArrayList currencyCollection = null;
    private ArrayList orgUnitCollection = null;
    private OrgUnitInfo orgUnit = null;
    private String updateTime = null;
    private String easVersion = null;
    private HashMap extEntry = null;
    private ZipFile curFile = null;
    public static String DNF_PASSWORD = null;

    public static String getDNF_PASSWORD() {
        if (DNF_PASSWORD == null) {
            try {
                String tmp = PropertiesFileUtil.readValue(DNFFile.class.getResource("").getPath() + File.separator + "config.properties", "DNF_PASSWORD");
                DNF_PASSWORD = AESUtil.decrypt((String)tmp, (String)DNFFile.getAESKey());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return DNF_PASSWORD;
    }

    public ArrayList getCurrencyCollection() {
        return this.currencyCollection;
    }

    public void setCurrencyCollection(ArrayList currencyCollection) {
        this.currencyCollection = currencyCollection;
    }

    public ArrayList getOrgUnitCollection() {
        return this.orgUnitCollection;
    }

    public void setOrgUnitCollection(ArrayList orgUnitCollection) {
        this.orgUnitCollection = orgUnitCollection;
    }

    public OrgUnitInfo getOrgUnit() {
        return this.orgUnit;
    }

    public void setOrgUnit(OrgUnitInfo orgUnit) {
        this.orgUnit = orgUnit;
    }

    public ArrayList getTemplateCollection() {
        return this.templateCollection;
    }

    public void setTemplateCollection(ArrayList templateCollection) {
        this.templateCollection = templateCollection;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    private void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public DNFFile(String kdtPath, String password) {
        try {
            this.init(kdtPath, password);
        }
        catch (IOException e) {
            logger.debug((Object)EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"763_DNFFile"));
        }
    }

    private ArrayList parseTemplateData(InputStream templateDat) {
        ArrayList<TemplateInfo> result = new ArrayList<TemplateInfo>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        Element root = doc.getRootElement();
        Element foo = null;
        Iterator i = root.elementIterator("row");
        while (i.hasNext()) {
            foo = (Element)i.next();
            TemplateInfo info = new TemplateInfo();
            info.setId(BOSUuid.read((String)foo.elementTextTrim("fid")));
            info.setNumber(foo.elementTextTrim("fnumber"));
            info.setVersionNumber(foo.elementTextTrim("fversionnumber"));
            info.setName(foo.elementTextTrim("fname"));
            info.setDescription(foo.elementTextTrim("fdescription"));
            info.setPeriodType(RptPeriodTypeEnum.getEnum((int)Integer.parseInt(foo.elementTextTrim("fperiodtype"))));
            info.setTemplateType(RptTmpTypeEnum.getEnum((int)Integer.parseInt(foo.elementTextTrim("ftemplatetype"))));
            info.put(INFO_PROPERTY_ISALLOWCHANGE, (Object)Boolean.valueOf(foo.elementTextTrim("fisAllowChgTemplet")));
            try {
                if (foo.element("isIncludeOtherDC") != null) {
                    info.setIncludeOtherDC(foo.element("isIncludeOtherDC").getTextTrim().equalsIgnoreCase("true"));
                } else {
                    info.setIncludeOtherDC(true);
                }
            }
            catch (Exception e) {
                logger.error((Object)"parseTemplateData_Exception", (Throwable)e);
            }
            try {
                info.setZipData(this.getBookData(foo.elementTextTrim("fdata")));
            }
            catch (Exception e1) {
                logger.error((Object)"setZipData_Exception", (Throwable)e1);
            }
            info.setDynaRptType(DynaEnumRptTypeEnum.getEnum(Integer.parseInt(foo.elementTextTrim("fdynarpttype"))));
            result.add(info);
        }
        return result;
    }

    private ArrayList parseCurrencyData(InputStream templateDat) {
        ArrayList<CurrencyInfo> result = new ArrayList<CurrencyInfo>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator("row");
            while (i.hasNext()) {
                Element foo = (Element)i.next();
                CurrencyInfo info = new CurrencyInfo();
                info.setId(BOSUuid.read((String)foo.elementTextTrim("fid")));
                info.setNumber(foo.elementTextTrim("fnumber"));
                info.setName(foo.elementTextTrim("fname"));
                result.add(info);
            }
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        return result;
    }

    private ArrayList parseCompanyData(InputStream companyDat) {
        ArrayList<OrgUnitInfo> result = new ArrayList<OrgUnitInfo>();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(companyDat);
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator("row");
            while (i.hasNext()) {
                Element foo = (Element)i.next();
                OrgUnitInfo info = new OrgUnitInfo();
                info.setId(BOSUuid.read((String)foo.elementTextTrim("fid").trim()));
                info.setNumber(foo.elementTextTrim("fnumber").trim());
                info.setName(foo.elementTextTrim("fname_l1"), LocaleUtils.getLocale((String)"L1"));
                info.setName(foo.elementTextTrim("fname_l2"), LocaleUtils.getLocale((String)"L2"));
                info.setName(foo.elementTextTrim("fname_l3"), LocaleUtils.getLocale((String)"L3"));
                result.add(info);
            }
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        return result;
    }

    private OrgUnitInfo parsePublicData(InputStream templateDat) {
        OrgUnitInfo info = new OrgUnitInfo();
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(templateDat);
            Element foo = doc.getRootElement();
            info.setId(BOSUuid.read((String)foo.elementTextTrim("companyid")));
            info.setNumber(foo.elementTextTrim("companynumber"));
            info.setName(foo.elementTextTrim("companyname"));
            this.loadEntry(foo);
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        return info;
    }

    private String parseUpdateTime(InputStream insTime) {
        Document doc;
        block2: {
            SAXReader reader = new SAXReader();
            doc = null;
            try {
                doc = reader.read(insTime);
            }
            catch (DocumentException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug((Object)e);
            }
        }
        Element foo = doc.getRootElement();
        String timeValue = foo.getTextTrim();
        return timeValue;
    }

    private String parseEASVersion(InputStream insVersion) {
        SAXReader reader = new SAXReader();
        Document doc = null;
        try {
            doc = reader.read(insVersion);
        }
        catch (DocumentException e) {
            logger.error((Object)"reader.read_DocumentException", (Throwable)e);
        }
        Element foo = doc.getRootElement();
        String version = foo.getTextTrim();
        return version;
    }

    private void loadEntry(Element foo) {
        this.DNF_ENTRY_TEMPLATE = foo.elementTextTrim("templatefile");
        this.DNF_ENTRY_CURRENCY = foo.elementTextTrim("currencyfile");
        this.DNF_ENTRY_COMPANY = foo.elementTextTrim("companyfile");
    }

    private void saveEntry(Element foo) {
        foo.addElement("templatefile").setText(this.DNF_ENTRY_TEMPLATE);
        foo.addElement("currencyfile").setText(this.DNF_ENTRY_CURRENCY);
        foo.addElement("companyfile").setText(this.DNF_ENTRY_COMPANY);
        foo.addElement("updatetimefile").setText(this.DNF_ENTRY_UPDATETIME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String kdtPath, String password) throws IOException {
        File tempFile;
        boolean isEncrypt;
        block11: {
            isEncrypt = false;
            tempFile = new File(kdtPath);
            if (StringUtils.isEmpty((String)password)) break block11;
            CipherInputStream in = null;
            FileOutputStream out = null;
            FileInputStream fileInputStream = null;
            try {
                int c;
                fileInputStream = new FileInputStream(tempFile);
                in = new CipherInputStream(fileInputStream, password);
                kdtPath = kdtPath + System.currentTimeMillis();
                tempFile = new File(kdtPath);
                out = new FileOutputStream(tempFile);
                while ((c = ((InputStream)in).read()) != -1) {
                    ((OutputStream)out).write(c);
                }
            }
            catch (Throwable throwable) {
                CslRptUtil.close(fileInputStream);
                CslRptUtil.close(in);
                CslRptUtil.close(out);
                throw throwable;
            }
            CslRptUtil.close(fileInputStream);
            CslRptUtil.close(in);
            CslRptUtil.close(out);
            isEncrypt = true;
        }
        try {
            this.curFile = new ZipFile(tempFile);
        }
        catch (IOException e) {
            if (isEncrypt) {
                tempFile.delete();
            }
            throw e;
        }
        ZipEntry ze = null;
        ze = this.curFile.getEntry(DNF_ENTRY_PUBLIC);
        this.setOrgUnit(this.parsePublicData(this.curFile.getInputStream(ze)));
        ze = this.curFile.getEntry(this.DNF_ENTRY_TEMPLATE);
        this.setTemplateCollection(this.parseTemplateData(this.curFile.getInputStream(ze)));
        ze = this.curFile.getEntry(this.DNF_ENTRY_CURRENCY);
        if (ze != null) {
            this.setCurrencyCollection(this.parseCurrencyData(this.curFile.getInputStream(ze)));
        }
        if ((ze = this.curFile.getEntry(this.DNF_ENTRY_COMPANY)) != null) {
            this.setOrgUnitCollection(this.parseCompanyData(this.curFile.getInputStream(ze)));
        }
        if ((ze = this.curFile.getEntry(this.DNF_ENTRY_UPDATETIME)) != null) {
            this.setUpdateTime(this.parseUpdateTime(this.curFile.getInputStream(ze)));
        }
        if ((ze = this.curFile.getEntry(this.DNF_ENTRY_EASVERSION)) != null) {
            this.setEASVersion(this.parseEASVersion(this.curFile.getInputStream(ze)));
        }
        this.curFile.close();
        if (isEncrypt) {
            tempFile.delete();
        }
    }

    private byte[] getBookData(String kdfEntry) throws Exception {
        int i;
        InputStream inputStream = this.curFile.getInputStream(this.curFile.getEntry(kdfEntry));
        ByteArrayOutputStream in = new ByteArrayOutputStream();
        while ((i = inputStream.read()) >= 0) {
            in.write(i);
        }
        return in.toByteArray();
    }

    public DNFFile(OrgUnitInfo targetCompany, ArrayList templates, ArrayList currencys, ArrayList companys) {
        this.setTemplateCollection(templates);
        this.setCurrencyCollection(currencys);
        this.setOrgUnitCollection(companys);
        this.setOrgUnit(targetCompany);
        this.extEntry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean export(String path, String password) {
        boolean result;
        block13: {
            result = true;
            HashMap map = this.extEntry;
            if (this.templateCollection != null && this.templateCollection.size() != 0) {
                map.put(this.DNF_ENTRY_TEMPLATE, this.parseTemplateCollection(this.templateCollection));
            }
            if (this.currencyCollection != null && this.currencyCollection.size() != 0) {
                map.put(this.DNF_ENTRY_CURRENCY, this.parseCurrencyCollection(this.currencyCollection));
            }
            if (this.orgUnitCollection != null && this.orgUnitCollection.size() != 0) {
                map.put(this.DNF_ENTRY_COMPANY, this.parseOrgUnitCollection(this.orgUnitCollection));
            }
            if (this.orgUnit != null) {
                map.put(DNF_ENTRY_PUBLIC, this.parseOrgUnitInfo(this.orgUnit));
            }
            map.put(this.DNF_ENTRY_UPDATETIME, this.parseUpdateTime());
            map.put(this.DNF_ENTRY_EASVERSION, this.parseEASVersion());
            ZipOutputStream out = null;
            CipherOutputStream f = null;
            FileOutputStream f1 = null;
            try {
                f1 = new FileOutputStream(path);
                if (!StringUtils.isEmpty((String)password)) {
                    f = new CipherOutputStream(f1, password);
                }
                out = new ZipOutputStream(new DataOutputStream(f));
                Set keySet = map.keySet();
                for (String key : keySet) {
                    out.putNextEntry(new ZipEntry(key));
                    Object entry = map.get(key);
                    byte[] data = null;
                    data = entry instanceof byte[] ? (byte[])entry : ((String)entry).getBytes("UTF-8");
                    for (int i = 0; i < data.length; ++i) {
                        byte b = data[i];
                        out.write(b);
                    }
                }
                CslRptUtil.close(out);
            }
            catch (Exception e) {
                result = false;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)e);
                }
                break block13;
            }
            finally {
                CslRptUtil.close(out);
                CslRptUtil.close(f);
                CslRptUtil.close(f1);
            }
            CslRptUtil.close(f);
            CslRptUtil.close(f1);
        }
        return result;
    }

    private String parseTemplateCollection(ArrayList templates) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("template");
        String kdfEntryName = null;
        for (int i = 0; i < templates.size(); ++i) {
            Element rowElement;
            TemplateInfo info;
            block3: {
                info = (TemplateInfo)templates.get(i);
                rowElement = rootElement.addElement("row");
                rowElement.addElement("fid").setText(info.getId().toString());
                rowElement.addElement("fnumber").setText(info.getNumber());
                rowElement.addElement("fversionnumber").setText(info.getVersionNumber());
                rowElement.addElement("fname").setText(info.getName());
                String des = info.getDescription() == null ? "" : info.getDescription();
                rowElement.addElement("isIncludeOtherDC").setText(info.isIncludeOtherDC() ? "true" : "false");
                rowElement.addElement("fdescription").setText(des);
                rowElement.addElement("fperiodtype").setText(Integer.toString(info.getPeriodType().getValue()));
                rowElement.addElement("ftemplatetype").setText(Integer.toString(info.getTemplateType().getValue()));
                rowElement.addElement("fisAllowChgTemplet").setText(info.get(INFO_PROPERTY_ISALLOWCHANGE).toString());
                kdfEntryName = info.getNumber() + ".kdf";
                rowElement.addElement("fdata").setText(kdfEntryName);
                try {
                    this.extEntry.put(kdfEntryName, info.getData());
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug((Object)e);
                }
            }
            rowElement.addElement("fdata").setData((Object)kdfEntryName);
            rowElement.addElement("fdynarpttype").setText(Integer.toString(info.getDynaRptType().getValue()));
        }
        return document.asXML();
    }

    private String parseCurrencyCollection(ArrayList currencys) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("currency");
        for (int i = 0; i < currencys.size(); ++i) {
            CurrencyInfo info = (CurrencyInfo)currencys.get(i);
            Element rowElement = rootElement.addElement("row");
            rowElement.addElement("fid").setText(info.getId().toString());
            rowElement.addElement("fnumber").setText(info.getNumber());
            rowElement.addElement("fname").setText(info.getName());
        }
        return document.asXML();
    }

    private String parseOrgUnitCollection(ArrayList companys) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("company");
        for (int i = 0; i < companys.size(); ++i) {
            OrgUnitInfo info = (OrgUnitInfo)companys.get(i);
            Element rowElement = rootElement.addElement("row");
            rowElement.addElement("fid").setText(info.getId().toString());
            rowElement.addElement("fnumber").setText(info.getNumber());
            rowElement.addElement("fname_l1").setText(info.getName(LocaleUtils.getLocale((String)"L1")) != null ? info.getName(LocaleUtils.getLocale((String)"L1")) : "");
            rowElement.addElement("fname_l2").setText(info.getName(LocaleUtils.getLocale((String)"L2")) != null ? info.getName(LocaleUtils.getLocale((String)"L2")) : "");
            rowElement.addElement("fname_l3").setText(info.getName(LocaleUtils.getLocale((String)"L3")) != null ? info.getName(LocaleUtils.getLocale((String)"L3")) : "");
        }
        return document.asXML();
    }

    private String parseOrgUnitInfo(OrgUnitInfo info) {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("public");
        rootElement.addElement("companyid").setText(info.getId().toString());
        rootElement.addElement("companynumber").setText(info.getNumber());
        rootElement.addElement("companyname").setText(info.getName());
        this.saveEntry(rootElement);
        return document.asXML();
    }

    private String parseUpdateTime() {
        String dateTime = RPTDateUtil.formateDate(new Date(), "yyyy-MM-dd HH:mm:ss");
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("updatetime");
        rootElement.setText(dateTime);
        return document.asXML();
    }

    public void setEASVersion(String version) {
        this.easVersion = version;
    }

    public String getEASVersion() {
        return this.easVersion;
    }

    private String parseEASVersion() {
        Document document = DocumentHelper.createDocument();
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        Element rootElement = document.addElement("easversion");
        if (this.easVersion == null || this.easVersion.trim().length() == 0) {
            rootElement.setText("unknowVersion");
        } else {
            rootElement.setText(this.easVersion);
        }
        return document.asXML();
    }

    private static String getAESKey() {
        StringBuffer aesKey = new StringBuffer();
        aesKey.append("DNF_PASSWORD");
        aesKey.append("_EAS");
        return aesKey.toString();
    }
}

