/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.OnlyItemDefineInfoStrategy;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryItemDefineFromTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.cslrpt.util.Location;
import com.kingdee.eas.fi.gr.cslrpt.util.PropertyItemForXML;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class DispensePropertyHelperForItemProp {
    public static final String DISPENSE_RESOURCE = "com.kingdee.eas.fi.gr.cslrpt.RptSpecialResource";
    public static final String CSLRPTAutoGenerate_Resource = "com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource";
    public static final int NO_DATA = 0;
    public static final int NUMBER = 1;
    public static final int STRING = 2;
    HashMap<String, PropertyItemForXML> map = new HashMap();

    public DispensePropertyHelperForItemProp() {
        Color bc = Color.WHITE;
        int w = 150;
        int h = 12;
        Font f = new Font(DispensePropertyHelperForItemProp.getString("Dispense_DefaultFont"), 0, 12);
        this.map.put("Parent", new PropertyItemForXML("Parent", DispensePropertyHelperForItemProp.getString("Dispense_Parent_ItemProp"), new Location(0, 0, 0), f, w, h, bc, null, null, 2, false, false));
        this.map.put("SimpleCode", new PropertyItemForXML("SimpleCode", DispensePropertyHelperForItemProp.getString("Dispense_SimpleCode_ItemProp"), new Location(0, 0, 1), f, w, h, bc, null, null, 2, false, false));
        this.map.put("EffectItem", new PropertyItemForXML("EffectItem", DispensePropertyHelperForItemProp.getString("Dispense_EffectItem_ItemProp"), new Location(0, 0, 2), f, w, h, bc, null, null, 2, false, false));
        this.map.put("SumItemFormula", new PropertyItemForXML("SumItemFormula", DispensePropertyHelperForItemProp.getString("Dispense_SumItemFormula_ItemProp"), new Location(0, 0, 3), f, w, h, bc, null, null, 2, false, false));
        this.map.put("Dc", new PropertyItemForXML("Dc", DispensePropertyHelperForItemProp.getString("Dispense_Dc_ItemProp"), new Location(0, 0, 4), f, w, h, bc, null, null, 2, false, false));
        this.map.put("ItemGroup", new PropertyItemForXML("ItemGroup", DispensePropertyHelperForItemProp.getString("Dispense_ItemGroup_ItemProp"), new Location(0, 0, 5), f, w, h, bc, null, null, 2, false, false));
        this.map.put("IsFreezed", new PropertyItemForXML("IsFreezed", DispensePropertyHelperForItemProp.getString("Dispense_IsFreezed_ItemProp"), new Location(0, 0, 6), f, w, h, bc, null, null, 2, false, false));
        this.map.put("IsProfitAndLosses", new PropertyItemForXML("IsProfitAndLosses", DispensePropertyHelperForItemProp.getString("Dispense_IsProfitAndLosses_ItemProp"), new Location(0, 0, 7), f, w, h, bc, null, null, 2, false, false));
        this.map.put("Description", new PropertyItemForXML("Description", DispensePropertyHelperForItemProp.getString("Dispense_Description_ItemProp"), new Location(0, 0, 8), f, w, h, bc, null, null, 2, false, false));
        this.map.put("IsSumItem", new PropertyItemForXML("IsSumItem", DispensePropertyHelperForItemProp.getString("Dispense_IsSumItem_ItemProp"), new Location(0, 0, 9), f, w, h, bc, null, null, 2, false, false));
        this.map.put("ReportClassID", new PropertyItemForXML("ReportClassID", DispensePropertyHelperForItemProp.getString("Dispense_ReportClassID_ItemProp"), new Location(0, 0, 10), f, w, h, bc, null, null, 2, false, false));
        this.map.put("Number", new PropertyItemForXML("Number", DispensePropertyHelperForItemProp.getString("Dispense_Number_ItemProp"), new Location(0, 0, 11), f, w, h, bc, null, null, 2, false, false));
        this.map.put("Control", new PropertyItemForXML("Control", DispensePropertyHelperForItemProp.getString("Dispense_Control_ItemProp"), new Location(0, 0, 12), f, w, h, bc, null, null, 2, false, false));
        this.map.put("Name", new PropertyItemForXML("Name", DispensePropertyHelperForItemProp.getString("Dispense_Name_ItemProp"), new Location(0, 0, 13), f, w, h, bc, null, null, 2, false, false));
        this.map.put("CreatorId", new PropertyItemForXML("CreatorId", DispensePropertyHelperForItemProp.getString("Dispense_CreatorId_ItemProp"), new Location(0, 0, 14), f, w, h, bc, null, null, 2, false, false));
        this.map.put("CreateTime", new PropertyItemForXML("CreateTime", DispensePropertyHelperForItemProp.getString("Dispense_CreateTime_ItemProp"), new Location(0, 0, 15), f, w, h, bc, null, null, 2, false, false));
    }

    public Sheet outputToItemProp(TemplateInfo template, Sheet table) throws Exception {
        Iterator<String> iterator = this.map.keySet().iterator();
        PropertyItemForXML item = null;
        String alias = null;
        String number = null;
        Range cellValueName = null;
        Range cellValueNumber = null;
        while (iterator.hasNext()) {
            item = this.map.get(iterator.next());
            number = item.getName();
            alias = item.getAlias();
            cellValueNumber = table.getRange(item.getLocation().getRowIndex(), item.getLocation().getColIndex());
            cellValueNumber.setValue(new Variant((Object)number));
            cellValueName = table.getRange(item.getLocation().getRowIndex() + 1, item.getLocation().getColIndex());
            cellValueName.setValue(new Variant((Object)alias));
        }
        DBHandler dao = new DBHandler(null);
        QueryItemDefineFromTemplate<ItemFormula> query = new QueryItemDefineFromTemplate<ItemFormula>(dao, new OnlyItemDefineInfoStrategy());
        List<ItemFormula> schemes = query.action(template);
        ArrayList<String> itemList = new ArrayList<String>();
        for (int i = 0; i < schemes.size(); ++i) {
            ItemFormula itemFormula = schemes.get(i);
            if (itemFormula == null || StringUtil.isEmpty((String)itemFormula.getItemNumber()) || itemList.contains(itemFormula.getItemNumber())) continue;
            itemList.add(itemFormula.getItemNumber());
        }
        if (itemList.size() == 0) {
            return null;
        }
        EntityViewInfo rptItemView = new EntityViewInfo();
        FilterInfo rptItem_filter = new FilterInfo();
        rptItem_filter.getFilterItems().add(new FilterItemInfo("number", new HashSet(itemList), CompareType.INCLUDE));
        rptItemView.setFilter(rptItem_filter);
        rptItemView.setSelector(this.getSelectors());
        rptItemView.getSorter().add(new SorterItemInfo("number"));
        CoreBaseCollection rptItemCollection = RPTItemFactory.getRemoteInstance().getCollection(rptItemView);
        for (int j = 0; j < rptItemCollection.size(); ++j) {
            RPTItemInfo rptItemInfo = (RPTItemInfo)rptItemCollection.getObject(j);
            if (rptItemInfo.getParent() != null) {
                table.getRange(j + 2, 0).setValue(new Variant((Object)rptItemInfo.getParent().getId().toString()));
            } else {
                table.getRange(j + 2, 0).setValue(new Variant());
            }
            table.getRange(j + 2, 1).setValue(new Variant((Object)rptItemInfo.getSimpleCode()));
            table.getRange(j + 2, 2).setValue(new Variant(rptItemInfo.getEffectItem().getValue()));
            table.getRange(j + 2, 3).setValue(new Variant((Object)rptItemInfo.getSumItemFormula()));
            table.getRange(j + 2, 4).setValue(new Variant(rptItemInfo.getDc().getValue()));
            table.getRange(j + 2, 5).setValue(new Variant(rptItemInfo.getItemGroup().getValue()));
            table.getRange(j + 2, 6).setValue(new Variant(rptItemInfo.isIsFreezed()));
            table.getRange(j + 2, 7).setValue(new Variant(rptItemInfo.isIsProfitAndLosses()));
            table.getRange(j + 2, 8).setValue(new Variant((Object)rptItemInfo.getDescription()));
            table.getRange(j + 2, 9).setValue(new Variant(rptItemInfo.isIsSumItem()));
            if (rptItemInfo.getReportClass() != null) {
                table.getRange(j + 2, 10).setValue(new Variant((Object)rptItemInfo.getReportClass().getNumber()));
            } else {
                table.getRange(j + 2, 10).setValue(new Variant());
            }
            table.getRange(j + 2, 11).setValue(new Variant((Object)rptItemInfo.getNumber()));
            table.getRange(j + 2, 12).setValue(new Variant(rptItemInfo.getControl().getValue()));
            table.getRange(j + 2, 13).setValue(new Variant((Object)rptItemInfo.getName()));
            table.getRange(j + 2, 14).setValue(new Variant());
            table.getRange(j + 2, 15).setValue(new Variant());
        }
        return table;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection rptItem_selectorColl = new SelectorItemCollection();
        rptItem_selectorColl.add("parent.id");
        rptItem_selectorColl.add("simpleCode");
        rptItem_selectorColl.add("effectItem");
        rptItem_selectorColl.add("sumItemFormula");
        rptItem_selectorColl.add("dc");
        rptItem_selectorColl.add("itemGroup");
        rptItem_selectorColl.add("isFreezed");
        rptItem_selectorColl.add("isProfitAndLosses");
        rptItem_selectorColl.add("description");
        rptItem_selectorColl.add("isSumItem");
        rptItem_selectorColl.add("reportClass.id");
        rptItem_selectorColl.add("number");
        rptItem_selectorColl.add("control");
        rptItem_selectorColl.add("name");
        rptItem_selectorColl.add("creator.id");
        rptItem_selectorColl.add("createTime");
        return rptItem_selectorColl;
    }

    public static boolean hasItemFormula(Sheet sheet, int r, int c) {
        Cell cell = sheet.getCell(r, c, false);
        if (cell != null) {
            ItemFormula itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
            return itemFormula != null && !StringUtils.isEmpty((String)itemFormula.getFormula());
        }
        return false;
    }

    public static String getString(String resName) {
        return EASResource.getString((String)DISPENSE_RESOURCE, (String)resName);
    }

    public static String getString(String resName, Context ctx) {
        if (ctx == null) {
            return EASResource.getString((String)DISPENSE_RESOURCE, (String)resName);
        }
        return ResourceBase.getString((String)DISPENSE_RESOURCE, (String)resName, (Locale)ctx.getOriginLocale());
    }

    public static String getCSLRPTAutoGenerateResource(String resName, Context ctx) {
        if (ctx == null) {
            return EASResource.getString((String)CSLRPTAutoGenerate_Resource, (String)resName);
        }
        return ResourceBase.getString((String)CSLRPTAutoGenerate_Resource, (String)resName, (Locale)ctx.getOriginLocale());
    }
}

