/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.cslrpt.util;

import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorFormula;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.util.SumcalcRange;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import java.awt.Point;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class StyleInheritDynamicRpt {
    private static final Logger logger = Logger.getLogger(StyleInheritDynamicRpt.class);
    protected Sheet curSheet = null;

    public StyleInheritDynamicRpt(Sheet curSheet) {
        this.curSheet = curSheet;
    }

    public void sytleInherit(Range range) {
        try {
            if (range == null) {
                return;
            }
            ArrayList basePointList = DynamicTemplateUtility.getBasePointList((Sheet)this.curSheet);
            if (basePointList.isEmpty()) {
                return;
            }
            Point basePoint = null;
            RptSheetSytleInheritParam styleParam = null;
            Object[] obj = range.getArray();
            DynaParameters param = null;
            int endRow = 0;
            for (int i = 0; i < obj.length && obj[i] != null; ++i) {
                CellBlock cblock = (CellBlock)obj[i];
                int startRow = cblock.getRow();
                Point activePoint = new Point(((Point)basePointList.get((int)0)).x, startRow);
                basePoint = this.initBasePoint(basePointList, activePoint);
                if (basePoint == null) continue;
                param = DynamicTemplateUtility.getDynaParametersFromCell((Sheet)this.curSheet, (int)basePoint.y, (int)basePoint.x);
                if (param.getDynaItemSource() == 0 && param.isGrade()) {
                    DItemGradeInfo gradeInfo = DynamicTemplateUtility.getGradeInfo((Range)this.curSheet.getRange(basePoint.y, basePoint.x));
                    boolean isVertical = param.getSpreadStyle() == 0;
                    FillRange currDynRange = this.investigate(activePoint, basePoint, isVertical, gradeInfo, param);
                    if (currDynRange.startPos + 1 >= startRow) {
                        return;
                    }
                    endRow = currDynRange.lastDetail == currDynRange.startPos ? currDynRange.endPos - 1 : currDynRange.lastDetail;
                } else {
                    boolean isHorizon = param.getSpreadStyle() == 1;
                    boolean isLeftUp = param.getPosition() == 1;
                    int baseLine = isLeftUp ? basePoint.y + 1 : basePoint.y;
                    endRow = param.getDefaultCounter() + baseLine;
                }
                styleParam = new RptSheetSytleInheritParam();
                styleParam.setInsertInherit(true);
                styleParam.setStandardPoint(new Point(activePoint.x, activePoint.y - 2));
                styleParam.setStartRow(startRow);
                styleParam.setEndRow(endRow);
                styleParam.setStartColumn(basePoint.x);
                styleParam.setEndColumn(this.curSheet.getCols().getMaxIntMark());
                StyleDecoratorHeightOrWidth sytleInherit = new StyleDecoratorHeightOrWidth((IRptSheetSytleInherit)new RptSheetSytleInherit());
                sytleInherit = new StyleDecoratorValidation((IRptSheetSytleInherit)sytleInherit);
                sytleInherit = new StyleDecoratorFormula((IRptSheetSytleInherit)sytleInherit);
                sytleInherit.regionInheritStyleByDefaultPoint(this.curSheet, styleParam);
            }
            Object dynaRange = this.curSheet.getUserObjectValue("DYNAMICSUMVALUEZONE");
            Object dynaRangeKey = this.curSheet.getUserObjectValue("DYNAMICSUMKEYZONE");
            if (dynaRangeKey != null && dynaRange != null) {
                SumcalcRange dynaSumRange = (SumcalcRange)dynaRangeKey;
                SortedCellBlockArray sorted = dynaSumRange.getRanges();
                CslRptUIUtil.InsertDynaRange((Sheet)this.curSheet, (SumcalcRange)((SumcalcRange)dynaRangeKey), (SumcalcRange)((SumcalcRange)dynaRange));
            }
        }
        catch (Exception e) {
            logger.error((Object)"sytleInherit", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point initBasePoint(ArrayList list, Point activePoint) {
        Point point = new Point(2, 2);
        int col = activePoint.x;
        int row = activePoint.y;
        if (col >= 0 && row >= 0) {
            point.x = col < 0 ? 0 : col;
            point.y = row < 0 ? 0 : row;
            if (list.size() <= 0) return point;
            if ((point = DynamicTemplateUtility.getBasePoint((Sheet)this.curSheet, (Point)point, (ArrayList)list)) != null) return point;
            if (list.size() != 1) return null;
            return (Point)list.get(0);
        }
        if (list.size() <= 0) return point;
        return (Point)list.get(0);
    }

    private int findStartPos(Point activePoint, Point point, boolean isVertical, DItemGradeInfo gradeInfo) {
        int row;
        int pos;
        ItemFormula item;
        int i;
        int col = activePoint.x;
        for (i = pos = (row = activePoint.y); i > 0 && !this.isSumLineOrEnd(item = UserObjectHelper.getItemFormula((Range)this.curSheet.getRange(isVertical ? i : point.y, isVertical ? point.x : i)), gradeInfo); --i) {
        }
        return i;
    }

    private int findLastDetail(int start, int end, boolean isVertical, DItemGradeInfo gradeInfo, Point point) {
        int pos = start;
        for (int i = start; i < end; ++i) {
            DItemGradeEntryInfo info;
            String grade;
            ItemFormula item = UserObjectHelper.getItemFormula((Range)this.curSheet.getRange(isVertical ? i : point.y, isVertical ? point.x : i));
            if (item == null || (grade = item.getExt("GRADE_NUMBER")) == null || (info = gradeInfo.findParent(grade)) == null) continue;
            pos = i;
        }
        return pos;
    }

    private int findEndPos(Point activePoint, Point point, boolean isVertical, DItemGradeInfo gradeInfo, DynaParameters param) {
        int row;
        int pos;
        ItemFormula item;
        int i;
        int col = activePoint.x;
        for (i = pos = (row = activePoint.y); i < param.getDefaultCounter() + (isVertical ? point.y : point.x) && !this.isSumLineOrEnd(item = UserObjectHelper.getItemFormula((Range)this.curSheet.getRange(isVertical ? i : point.y, isVertical ? point.x : i)), gradeInfo); ++i) {
        }
        return i;
    }

    private boolean isSumLineOrEnd(ItemFormula item, DItemGradeInfo gradeInfo) {
        if (item == null) {
            return false;
        }
        if (item.isBasePoint()) {
            return true;
        }
        String grade = item.getExt("GRADE_NUMBER");
        if (grade == null) {
            return false;
        }
        DItemGradeEntryInfo info = gradeInfo.find(grade);
        return info != null;
    }

    private FillRange investigate(Point activePoint, Point point, boolean isVertical, DItemGradeInfo gradeInfo, DynaParameters param) {
        FillRange r = new FillRange();
        r.startPos = this.findStartPos(activePoint, point, isVertical, gradeInfo);
        r.endPos = this.findEndPos(activePoint, point, isVertical, gradeInfo, param);
        r.lastDetail = this.findLastDetail(r.startPos, r.endPos, isVertical, gradeInfo, point);
        if (r.startPos == r.endPos && r.endPos == r.lastDetail) {
            Point active = new Point(activePoint);
            if (isVertical) {
                active.y = param.getPosition() == 2 ? --active.y : ++active.y;
            } else {
                active.x = param.getPosition() == 2 ? --active.x : ++active.x;
            }
            r.endPos = this.findEndPos(active, point, isVertical, gradeInfo, param);
            r.startPos = this.findStartPos(active, point, isVertical, gradeInfo);
            r.lastDetail = this.findLastDetail(r.startPos, r.endPos, isVertical, gradeInfo, point);
            if (r.endPos == r.startPos) {
                if (param.getPosition() != 1) {
                    --r.startPos;
                } else {
                    ++r.endPos;
                }
            }
        } else if (r.startPos == r.endPos) {
            if (param.getPosition() != 1) {
                --r.startPos;
            } else {
                ++r.endPos;
            }
        }
        return r;
    }

    class FillRange {
        int startPos;
        int endPos;
        int lastDetail;

        FillRange() {
        }
    }
}

