/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.AutoItemException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.biz.parser.refact.OnlyItemDefineInfoStrategy;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.ItemContext;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.ItemMap;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.facade.item.csl.QueryItemDefineFromTemplate;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.gr.fast.FastMergeTemplateCollection;
import com.kingdee.eas.fi.gr.fast.IFastMergeSolu;
import com.kingdee.eas.fi.gr.fast.biz.query.ConvertSolutionUnitType;
import com.kingdee.eas.fi.gr.fast.biz.query.CreateCSLItemMap;
import com.kingdee.eas.fi.gr.fast.biz.query.ExecuteParam;
import com.kingdee.eas.fi.gr.fast.biz.query.FastMergeItemQueryUnit;
import com.kingdee.eas.fi.gr.fast.biz.query.MergeStatus;
import com.kingdee.eas.fi.gr.fast.biz.query.UpdateOrgUnitByNewVersionOrgTree;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CreateFastMergeItemQueryUnit {
    private DBHandler dao;

    public CreateFastMergeItemQueryUnit(DBHandler dao) {
        this.dao = dao;
    }

    public FastMergeItemQueryUnit by(String fastMerge, ExecuteParam param) throws EASBizException, BOSException {
        RptPeriodTypeEnum periodType;
        FastMergeSoluInfo solution = this.querySolution(fastMerge);
        try {
            periodType = solution.getTemplates().get(0).getTemplate().getPeriodType();
        }
        catch (Exception e1) {
            periodType = RptPeriodTypeEnum.MONTHLY;
        }
        new UpdateOrgUnitByNewVersionOrgTree(this.dao).exec(solution.getOrgUnits(), solution.getOrgBound(), param.getYear(), param.getPeriod(), periodType);
        OrgTreeInfo orgTree = solution.getOrgBound();
        FastMergeOrgUnitCollection solutionOrgUnits = solution.getOrgUnits();
        ConvertSolutionUnitType convertType = new ConvertSolutionUnitType();
        Collection<OrgUnitInfo> orgUnits = convertType.orgUnits(solutionOrgUnits);
        CurrencyInfo currency = solution.getCurrency();
        FastMergeTemplateCollection solutionTemplates = solution.getTemplates();
        Collection<TemplateInfo> templates = convertType.templates(solutionTemplates);
        QueryItemDefineFromTemplate<ItemFormula> query = new QueryItemDefineFromTemplate<ItemFormula>(this.dao, new OnlyItemDefineInfoStrategy());
        HashSet<ItemMap> itemMaps = new HashSet<ItemMap>(10);
        ItemContext baseItemContext = null;
        for (TemplateInfo template : templates) {
            List<ItemFormula> formulas;
            if (baseItemContext == null) {
                baseItemContext = new ItemContext(null, currency, template.getPeriodType(), param.getYear(), param.getPeriod());
            }
            try {
                formulas = query.action(template);
            }
            catch (AutoItemException e) {
                e.printStackTrace();
                continue;
            }
            for (ItemFormula formula : formulas) {
                Collection<ItemMap> subItemMaps = new CreateCSLItemMap(this.dao).exec(formula, template.getTemplateType(), baseItemContext);
                itemMaps.addAll(subItemMaps);
            }
        }
        return new FastMergeItemQueryUnit(orgTree, orgUnits, itemMaps, new MergeStatus(solution.isIsSupportGroupReport(), fastMerge));
    }

    protected FastMergeSoluInfo querySolution(String fastMerge) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("name");
        selectors.add("isAutoSum");
        selectors.add("isSupportGroupReport");
        selectors.add("autoItemFormual.id");
        selectors.add("adjustEntrySolu.id");
        selectors.add("elimEntrySolu.id");
        selectors.add("templates.template.*");
        selectors.add("orgUnits.orgUnit.*");
        selectors.add("orgBound.*");
        selectors.add("currency.id");
        selectors.add("currency.name");
        return this.dao.get(IFastMergeSolu.class).getFastMergeSoluInfo((IObjectPK)new ObjectUuidPK(fastMerge), selectors);
    }
}

