/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.biz.query;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.sys.DBHandler;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitCollection;
import com.kingdee.eas.fi.gr.fast.FastMergeOrgUnitInfo;
import com.kingdee.eas.fi.gr.fast.biz.query.QueryOrgUnitByOrgTree;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class UpdateOrgUnitByNewVersionOrgTree {
    private DBHandler dao;

    public UpdateOrgUnitByNewVersionOrgTree(DBHandler dao) {
        this.dao = dao;
    }

    public void exec(FastMergeOrgUnitCollection soluOrgUnits, OrgTreeInfo orgTree, int year, int period, RptPeriodTypeEnum periodType) throws BOSException {
        try {
            Date date = RPTDateUtil.getPeriodLastDate(year, period, periodType);
            this.exec(soluOrgUnits, orgTree, date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void exec(FastMergeOrgUnitCollection soluOrgUnits, OrgTreeInfo orgTree, Date date) throws BOSException {
        Map<String, FullOrgUnitInfo> newOrgUnits = this.queryNewVersionOrgUnits(orgTree, date);
        FullOrgUnitInfo newOrgUnit = null;
        FullOrgUnitInfo oldOrgUnit = null;
        Iterator it = soluOrgUnits.iterator();
        while (it.hasNext()) {
            FastMergeOrgUnitInfo orgUnit = (FastMergeOrgUnitInfo)it.next();
            oldOrgUnit = orgUnit.getOrgUnit();
            if (oldOrgUnit == null || oldOrgUnit.getNumber() == null || !newOrgUnits.containsKey(oldOrgUnit.getNumber())) continue;
            newOrgUnit = newOrgUnits.get(oldOrgUnit.getNumber());
            this.updateFrom(newOrgUnit, oldOrgUnit);
        }
    }

    protected void updateFrom(FullOrgUnitInfo newOrgUnit, FullOrgUnitInfo oldOrgUnit) {
        oldOrgUnit.setId(newOrgUnit.getId());
    }

    protected Map<String, FullOrgUnitInfo> queryNewVersionOrgUnits(OrgTreeInfo orgTree, Date date) throws BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("fid", "id");
        selector.add("fnumber", "number");
        Collection<FullOrgUnitInfo> newOrgUnits = new QueryOrgUnitByOrgTree(this.dao).exec(date, orgTree.getNumber(), selector);
        HashMap<String, FullOrgUnitInfo> cache = new HashMap<String, FullOrgUnitInfo>(newOrgUnits.size());
        for (FullOrgUnitInfo orgUnit : newOrgUnits) {
            cache.put(orgUnit.getNumber(), orgUnit);
        }
        return cache;
    }
}

