/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.fast.util;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.ILog;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.log.LogFactory;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.ITreeTableNodeEntity;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.ITreeTableNodeEntityConvert;
import com.kingdee.eas.fi.gr.cslrpt.client.autoitem.util.treetable.TreeTableNodeFoldAction;
import java.util.ArrayList;
import java.util.List;

public class TreeTableOrgUnitFoldAction {
    private static final ILog LOG = LogFactory.getLog("TREETABLE", TreeTableNodeFoldAction.class);
    protected KDTable table;
    protected ITreeTableNodeEntityConvert entityConvert;
    private String treeCellColumnName;

    public TreeTableOrgUnitFoldAction(KDTable table, ITreeTableNodeEntityConvert entityConvert, String treeCellColumnName) {
        this.table = table;
        this.entityConvert = entityConvert;
        this.treeCellColumnName = treeCellColumnName;
    }

    public void action(int rowIndex) {
        IRow currRow = this.table.getRow(rowIndex);
        LOG.debug("start expand row ,Current RowIndex is " + rowIndex);
        if (currRow == null || currRow.getCell(this.treeCellColumnName) == null || !(currRow.getCell(this.treeCellColumnName).getUserObject() instanceof ITreeTableNodeEntity)) {
            LOG.debug("omit all expand row,current company's longnumber is null or empty");
            return;
        }
        ITreeTableNodeEntity currOrg = (ITreeTableNodeEntity)currRow.getCell(this.treeCellColumnName).getUserObject();
        if (currOrg == null) {
            LOG.debug("omit all expand row,current company's longnumber is null or empty");
            return;
        }
        String currLongNumber = currOrg.getLongNumber();
        LOG.debug("current company,company number is " + currLongNumber);
        if (currOrg.isLeaf()) {
            LOG.debug("omit expand row,current company is leaf or have not 'isExpand' attribute");
            return;
        }
        boolean expandStatusWhenCurrIsRoot = !currOrg.isExpand();
        currOrg.setExpand(expandStatusWhenCurrIsRoot);
        LOG.debug("current company's expand status," + expandStatusWhenCurrIsRoot);
        List<ITreeTableNodeEntity> entrys = this.buildTreeCellUserObjects(currRow);
        if (entrys == null || entrys.isEmpty()) {
            LOG.debug("omit all expand row,tblCompany.getUserObject() is null or empty,isNull = " + (entrys == null));
            return;
        }
        ITreeTableNodeEntity entity = null;
        int subRowIndex = 0;
        int size = entrys.size();
        for (int i = 0; i < size; ++i) {
            entity = entrys.get(i);
            subRowIndex = currRow.getRowIndex() + i;
            if (entity.getLongNumber() == null) {
                LOG.debug("omit expand row,rowIndex=" + subRowIndex + ", company longNumber is null");
                continue;
            }
            if (!entity.getLongNumber().startsWith(currLongNumber + "!")) {
                LOG.debug("omit expand row,circle company 's longnumber is not match,rowIndex=" + subRowIndex + ",longNumber=" + entity.getLongNumber());
                continue;
            }
            if (expandStatusWhenCurrIsRoot && entity.getLongNumber().substring((currLongNumber + "!").length()).indexOf("!") == -1) {
                entity.cleanStatusBeforeCollapse();
            } else if (expandStatusWhenCurrIsRoot && entity.getLongNumber().substring((currLongNumber + "!").length()).indexOf("!") != -1) {
                if (entity.hideStatusBeforeCollapse() != null && currLongNumber.startsWith(entity.parentNodeLongNumberForCollapse())) {
                    LOG.debug("omit expand row,circle company must be current company's direct sub company,rowIndex=" + subRowIndex + ",longNumber=" + entity.getLongNumber() + ",expandStatusBeforeNoExpand = " + entity.hideStatusBeforeCollapse());
                    this.table.getRow(subRowIndex).getStyleAttributes().setHided(entity.hideStatusBeforeCollapse().booleanValue());
                    entity.cleanStatusBeforeCollapse();
                    continue;
                }
                LOG.debug("omit expand row,circle company must be current company's direct sub company,rowIndex=" + subRowIndex + ",longNumber=" + entity.getLongNumber());
                continue;
            }
            if (!expandStatusWhenCurrIsRoot && entity.getLongNumber().substring(currLongNumber.length()).indexOf("!") != -1 && (entity.parentNodeLongNumberForCollapse() == null || currLongNumber.startsWith(entity.parentNodeLongNumberForCollapse()))) {
                entity.setHideStatusBeforeCollapse(Boolean.valueOf(this.table.getRow(subRowIndex).getStyleAttributes().isHided()));
                entity.setParentNodeLongNumberForCollapse(currLongNumber);
            }
            LOG.debug("execute expand row , rowIndex=" + subRowIndex + ",longNumber=" + entity.getLongNumber() + ",isHidden=" + !expandStatusWhenCurrIsRoot);
            this.table.getRow(subRowIndex).getStyleAttributes().setHided(!expandStatusWhenCurrIsRoot);
        }
    }

    private List<ITreeTableNodeEntity> buildTreeCellUserObjects(IRow currRow) {
        ArrayList<ITreeTableNodeEntity> treeNodeEntitys = new ArrayList<ITreeTableNodeEntity>(this.table.getRowCount());
        int size = this.table.getRowCount();
        for (int i = currRow.getRowIndex(); i < size; ++i) {
            block4: {
                try {
                    if (!(this.table.getRow(i).getCell(this.treeCellColumnName).getUserObject() instanceof ITreeTableNodeEntity)) {
                    }
                    break block4;
                }
                catch (NullPointerException e) {
                    LOG.debug("", e);
                }
                continue;
            }
            treeNodeEntitys.add((ITreeTableNodeEntity)this.table.getRow(i).getCell(this.treeCellColumnName).getUserObject());
        }
        return treeNodeEntitys;
    }
}

