/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.mobile.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.MultiLangHelper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.mobile.DCAmountEnum;
import com.kingdee.eas.fi.gr.mobile.DCCurYearCumulative;
import com.kingdee.eas.fi.gr.mobile.DCEndingBalance;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisInfo;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexAnalysisSchemeInfo;
import com.kingdee.eas.fi.gr.mobile.IndexDataElementEnum;
import com.kingdee.eas.fi.gr.mobile.IndexDispensedCollection;
import com.kingdee.eas.fi.gr.mobile.IndexDispensedFactory;
import com.kingdee.eas.fi.gr.mobile.IndexDispensedInfo;
import com.kingdee.eas.fi.gr.mobile.IndexQueryCondition;
import com.kingdee.eas.fi.gr.mobile.IndexTypeCollection;
import com.kingdee.eas.fi.gr.mobile.IndexTypeDimension;
import com.kingdee.eas.fi.gr.mobile.IndexTypeFactory;
import com.kingdee.eas.fi.gr.mobile.IndexTypeInfo;
import com.kingdee.eas.fi.gr.mobile.MobileUtil;
import com.kingdee.eas.fi.gr.mobile.app.AbstractIndexAnalysisFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class IndexAnalysisFacadeControllerBean
extends AbstractIndexAnalysisFacadeControllerBean {
    private static final long serialVersionUID = 4268541570430400858L;
    private static Logger logger = Logger.getLogger((String)IndexAnalysisFacadeControllerBean.class.getName());
    private IMutexServiceControl mutexService = null;
    private boolean isExistRun = false;
    private static final String MAX_NUMBER = "-9999999999999999.9999999";
    private MobileUtil mobileUtil = new MobileUtil();
    private static final String KEYS_ERRORMESSAGE = "errorMessage";
    private static final String KEYS_INFOMESSAGE = "infoMessage";
    private static final String KEYS_SCHEME = "scheme";
    private static final String KEYS_ORGUNIT = "orgUnit";
    private static final String KEYS_TITLE = "title";
    private static final String KEYS_PERIODSTR = "periodStr";
    private static final String KEYS_TYPE = "type";
    private static final String KEYS_TABLE = "table";
    private static final String KEYS_INDEXTYPE = "indexType";
    private String na = "N/A";
    private static final String KEYS_CHART_BAR = "bar";
    private static final String KEYS_CHART_LINE = "line";
    private static final String KEYS_CHART_PIE = "pie";

    @Override
    protected void _runImmediate(Context ctx, String userId, String bizId, int year, int period, int periodType, boolean is13Period) throws BOSException, EASBizException {
        IndexTypeInfo itInfo = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeInfo((IObjectPK)new ObjectUuidPK(bizId));
        if (IndexTypeDimension.year.equals((Object)itInfo.getDimension())) {
            period = 12;
        } else if (IndexTypeDimension.quater.equals((Object)itInfo.getDimension())) {
            period *= 3;
        }
        try {
            this.mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean bl = this.isExistRun = !this.mutexService.requestBizObjIDForUpdate(bizId);
            if (this.isExistRun) {
                return;
            }
            IndexTypeFactory.getLocalInstance(ctx).calculate(bizId, year, period, periodType, is13Period);
        }
        catch (Exception e) {
            logger.error((Object)"immediateRunSolu", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (!this.isExistRun) {
                this.mutexService.releaseObjIDForUpdate(bizId);
            }
        }
    }

    @Override
    protected void _runPeriod(Context ctx, String userId, String bizId) throws BOSException, EASBizException {
        IndexTypeInfo itInfo = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeInfo((IObjectPK)new ObjectUuidPK(bizId));
        int[] ym = this.getPreYearAndMonth(itInfo.getDimension().getValue());
        this._runImmediate(ctx, userId, bizId, ym[0], ym[1], 3, false);
    }

    @Override
    protected Map<String, Object> _getIdxTypeCollection(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        StringBuffer buffer = new StringBuffer();
        String tableName = this.insertIndexData(ctx, userId);
        buffer.append(" SELECT idxInfo.FIndexTypeID FIndexTypeID,idxInfo.Factor Factor,idxInfo.FPrecision FPrecision,idxInfo.FYear fYear,idxInfo.FPeriod fPeriod,\n").append(" idxInfo.FDimension FDimension,idxInfo.FIndexTypeName FIndexTypeName,idxInfo.FUnit FUnit,idxInfo.FRemark, idxInfo.FIndexID FIndexID,idxInfo.FIndexName FIndexName, \n").append(" idxData.FAmount FAmount,idxInfo.FIsAdded FIsAdded \n").append(" FROM ").append(tableName).append(" idxInfo \n").append(" LEFT JOIN T_CSL_IndexAnalysisData idxData \n").append(" ON  idxInfo.FIndexTypeID = idxData.FIndexTypeId \n").append(" AND idxInfo.FDefaultDE = idxData.FDataElement \n").append(" AND idxInfo.FIndexID = idxData.FIndexAnalysisId \n").append(" AND idxInfo.FYear = idxData.FYear AND idxInfo.FPeriod = idxData.FPeriod \n").append(" AND idxInfo.FOrgLongNumber = idxData.FOrgLongNumber \n").append(" AND idxData.FPeriodType=? AND idxData.FDataType=? \n").append(" ORDER BY idxInfo.FSeq \n");
        Object[] params = new Object[]{RptPeriodTypeEnum.MONTHLY.getValue(), DCAmountEnum.currentAmount.getName()};
        try {
            String kql = PsSql.getSqlWithParams((Object)buffer.toString(), (Object[])params, (int)7, (boolean)false);
            MobileUtil.debugLog(logger, "[Query IndexType Collection SQL]******************************************:\n" + kql);
        }
        catch (SQLException kql) {
            // empty catch block
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])params);
        ArrayList resultList = new ArrayList();
        HashMap<String, String> rec = null;
        String line2 = "";
        try {
            while (rs.next()) {
                rec = new HashMap<String, String>();
                rec.put("id", rs.getString("FIndexTypeID"));
                rec.put("name", rs.getString("FIndexTypeName"));
                line2 = this.getLine2(rs.getInt("FYear"), rs.getInt("FPeriod"), rs.getString("FUnit"), rs.getInt("FDimension"));
                rec.put("unit", line2);
                rec.put("isAdded", rs.getString("FIsAdded"));
                rec.put("indexId", rs.getString("FIndexID"));
                rec.put("indexName", rs.getString("FIndexName"));
                rec.put("description", rs.getString("FRemark"));
                rec.put("amount", this.formatAmount(ctx, rs.getString("FAmount"), null, rs.getDouble("Factor"), rs.getInt("FPrecision")));
                resultList.add(rec);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getIndexTypeCollection", (Throwable)e);
            throw new SQLDataException(e);
        }
        finally {
            TempTablePool.getInstance((Context)ctx).releaseTable(tableName);
        }
        resultMap.put("key_list", resultList);
        return resultMap;
    }

    private String insertIndexData(Context ctx, String userId) throws BOSException {
        String tableName = this.createTmplTable(ctx);
        String sql = this.getInsertIndexDataSql(ctx, tableName);
        Object[] params = new Object[]{userId, userId, 1, userId, 10};
        try {
            String kql = PsSql.getSqlWithParams((Object)sql, (Object[])params, (int)7, (boolean)false);
            MobileUtil.debugLog(logger, "[Query IndexType Collection SQL]******************************************:\n" + kql);
        }
        catch (SQLException e) {
            logger.error((Object)"Print Log Error In The Method Of insertIndexData", (Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])params);
        return tableName;
    }

    private String getInsertIndexDataSql(Context ctx, String tableName) {
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        String unitField = MultiLangHelper.getFieldName((String)"FUnit", (Locale)ctx.getLocale());
        String remarkField = MultiLangHelper.getFieldName((String)"FRemark", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        sql.append(" INSERT INTO ").append(tableName).append(" \n").append(" SELECT idxType.FId FIndexTypeID,idxType." + nameField + " FIndexTypeName, idxType." + unitField + " FUnit, idxType." + remarkField + " FRemark, \n").append(" idxType.FPrecision FPrecision,idxType.Factor Factor,idxType.FDimension FDimension,MIN(structure.FLongNumber) FOrgLongNumber,YEAR(idxType.FLastCalcTime) FYear, \n").append(" MONTH(idxType.FLastCalcTime) FPeriod,idxA.FId FIndexID,idxA." + nameField + " FIndexName,idxA.FDefaultDE FDefaultDE, \n").append(" CASE WHEN idxTypeUD.findextypeid IS NULL THEN 0 ELSE 1 END FIsAdded,idxTypeUD.FSeq FSeq \n").append(" FROM T_CSL_IndexType idxType \n").append(" LEFT JOIN T_CSL_IndexType_UserDefine idxTypeUD ON idxType.fid = idxTypeUD.findextypeid AND idxTypeUD.fuserid = ? \n").append(" INNER JOIN T_CSL_IndexDispensed idxD ON idxType.fid = idxD.findextype AND idxD.FUser=? \n").append(" INNER JOIN T_CSL_IndexAnalysis idxA ON idxA.findextypeid = idxD.findextype AND idxA.FId=idxD.FIndex \n").append(" INNER JOIN T_ORG_Structure structure ON idxType.FOrgboundId = structure.FTreeId \n").append(" INNER JOIN T_PM_Orgrange range ON range.FOrgId = structure.FUnitId \n").append(" WHERE idxA.FisDefaultIndex=? AND range.FUserId=? AND range.FType=? \n").append(" GROUP BY idxType.FId,idxType.Factor,idxType.FPrecision,idxType." + nameField + ",idxType." + unitField + ",idxType." + remarkField + ",idxA.FId,idxA." + nameField + ",idxTypeUD.FSeq,idxType.FLastCalcTime,idxA.FDefaultDE,idxType.FDimension,idxTypeUD.findextypeid \n");
        return sql.toString();
    }

    private String createTmplTable(Context ctx) throws BOSException {
        String tableName;
        StringBuffer createSql = new StringBuffer(300);
        createSql.append(" CREATE TABLE Tmp_Index_Table( \n").append(" FIndexTypeID VARCHAR(44),FIndexTypeName NVARCHAR(255),FUnit NVARCHAR(255), FRemark NVARCHAR(255),\n").append(" FPrecision INT,Factor NUMERIC(28,10),FDimension VARCHAR(100),FOrgLongNumber VARCHAR(255),FYear INT, \n").append(" FPeriod INT,FIndexID VARCHAR(44),FIndexName NVARCHAR(255),FDefaultDE INT, \n").append(" FIsAdded INT,FSeq VARCHAR(4))");
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            tableName = pool.createTempTable(createSql.toString());
            pool.createIndex(tableName, "FIndexTypeID,FOrgLongNumber,FYear,FPeriod,FDefaultDE", false, false);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tableName;
    }

    private String getLine2(int year, int period, String unit, int dim) {
        String line2 = "";
        String yearName = IndexTypeDimension.year.getAlias();
        if (dim == 2) {
            line2 = year == 0 ? "--" + yearName + "(" + unit + ")" : year + yearName + "(" + unit + ")";
        } else if (year == 0) {
            line2 = "--" + yearName + "--" + IndexTypeDimension.getEnum(dim).getAlias() + "(" + unit + ")";
        } else {
            period = dim == 3 ? period / 3 : period;
            line2 = year + yearName + period + IndexTypeDimension.getEnum(dim).getAlias() + "(" + unit + ")";
        }
        return line2;
    }

    private String formatAmount(Context ctx, String amount, String dataTypeNumber, double factor, int precision) {
        String result = "0";
        boolean isRate = false;
        if (amount == null || "N/A".equalsIgnoreCase(amount) || MAX_NUMBER.equals(amount)) {
            return "N/A";
        }
        if ("0".equals(amount.toString())) {
            return "0";
        }
        try {
            Double.parseDouble(amount);
        }
        catch (Exception e) {
            return result;
        }
        BigDecimal temp = new BigDecimal(amount);
        if (dataTypeNumber != null && dataTypeNumber.length() > 4 && dataTypeNumber.substring(dataTypeNumber.length() - 4, dataTypeNumber.length()).equals("Rate")) {
            isRate = true;
        }
        if (this.mobileUtil.isDemo(ctx) && temp.compareTo(BigDecimal.ONE) < 0 && temp.compareTo(new BigDecimal("-1")) > 0) {
            isRate = true;
        }
        if (isRate) {
            temp = temp.multiply(new BigDecimal(100));
            temp = temp.setScale(precision, RoundingMode.HALF_UP);
        } else {
            BigDecimal fct = new BigDecimal(factor);
            temp = temp.divide(fct, precision, 4);
        }
        result = temp.toString();
        return result.concat(isRate ? "%" : "");
    }

    private String formatAmount(Context ctx, Object amount, String dataTypeNumber, double factor, int precision) {
        if (amount == null) {
            return "N/A";
        }
        return this.formatAmount(ctx, amount.toString(), dataTypeNumber, factor, precision);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> _updateIdxTypeCollection(Context ctx, String selectedIds) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)selectedIds)) {
            resultMap.put("key_state", "FAIL");
            return resultMap;
        }
        String[] ids = selectedIds.split(",");
        if (ids.length == 0) {
            resultMap.put("key_state", "FAIL");
            return resultMap;
        }
        Connection cn = null;
        PreparedStatement ps = null;
        String userID = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("DELETE FROM T_CSL_IndexType_UserDefine WHERE FUserId = ?");
        try {
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new String[]{userID});
        }
        catch (BOSException e) {
            resultMap.put("key_state", "FAIL");
            logger.error((Object)"_updateIndexTypeCollection", (Throwable)e);
            return resultMap;
        }
        sql = new StringBuffer();
        sql.append(" INSERT INTO T_CSL_IndexType_UserDefine \n");
        sql.append(" (FID, FUserId, FIndexTypeID,FSeq) \n");
        sql.append(" VALUES (?, ?, ?, ?);");
        try {
            cn = super.getConnection(ctx);
            ps = cn.prepareStatement(sql.toString());
            for (int i = 0; i < ids.length; ++i) {
                ps.setObject(1, Uuid.create().toString());
                ps.setObject(2, userID);
                ps.setObject(3, ids[i]);
                ps.setObject(4, i + 1);
                ps.addBatch();
            }
            if (ids != null && ids.length > 0) {
                ps.executeBatch();
            }
            resultMap.put("key_state", "SUCCESS");
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"_updateIndexTypeCollection", (Throwable)e);
                resultMap.put("key_state", "FAIL");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        return resultMap;
    }

    @Override
    protected Map _getIdxAnaMainData(Context ctx, IndexQueryCondition cond) throws BOSException, EASBizException {
        int i;
        int year = cond.getYear();
        int period = cond.getPeriod();
        int periodType = cond.getPeriodType();
        String treeId = cond.getOrgTreeID();
        String longNumber = cond.getLongNumber();
        String idxTypeID = cond.getIdxTypeID();
        String idxAnaID = cond.getIdxID();
        String searchTxt = cond.getSearchTxt();
        int dataElement = cond.getDataElement();
        String sortColumnNo = cond.getSortColumnNo();
        int sortType = cond.getSortType();
        int mainQueryType = cond.getMainQueryType();
        int dimension = cond.getDimension();
        boolean isFirst = cond.isFirstMainQuery();
        int precision = 0;
        double factor = 0.0;
        IndexTypeInfo itInfo = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeInfo((IObjectPK)new ObjectUuidPK(idxTypeID));
        precision = itInfo.getPrecision();
        factor = itInfo.getFactor();
        dimension = itInfo.getDimension().getValue();
        periodType = 3;
        treeId = itInfo.getOrgBound().getId().toString();
        if (!isFirst) {
            treeId = this.getTreeIdBy(ctx, year, period, periodType, treeId);
        }
        HashMap<String, String> defaultCond = new HashMap<String, String>();
        int topLevel = 0;
        if (isFirst) {
            defaultCond.put("periodType", String.valueOf(periodType));
            IndexAnalysisInfo iaInfo = this.getDefaultIdxAnaInfo(ctx, idxTypeID);
            idxAnaID = iaInfo.getId().toString();
            defaultCond.put("idxAnaID", idxAnaID);
            defaultCond.put("idxAnaName", iaInfo.getName());
            defaultCond.put("dimension", String.valueOf(dimension));
            int[] yAndM = this.getYearAndMonth(itInfo.getLastCalcTime());
            year = yAndM[0];
            period = yAndM[1];
            treeId = this.getTreeIdBy(ctx, year, period, periodType, treeId);
            if (dimension == 3) {
                period /= 3;
            }
            defaultCond.put("year", String.valueOf(year));
            defaultCond.put("period", String.valueOf(period));
            OrgStructureInfo osInfo = this.getTopOrgUnit(ctx, treeId);
            topLevel = this.getTopLevelByUser(ctx, treeId);
            if (osInfo != null) {
                longNumber = osInfo.getLongNumber();
                defaultCond.put("orgUnitLongNumber", longNumber);
                String unitFullName = osInfo.getUnit().getName();
                String unitSimpName = osInfo.getUnit().getSimpleName();
                if (!StringUtils.isEmpty((String)unitSimpName)) {
                    unitFullName = unitSimpName;
                }
                defaultCond.put("orgUnitName", unitFullName);
            }
            if (iaInfo.getDefaultDE() != null) {
                dataElement = iaInfo.getDefaultDE().getValue();
            }
            if (dataElement == 0) {
                dataElement = 1;
            }
            defaultCond.put("dataElement", String.valueOf(dataElement));
            defaultCond.put("dataElementName", IndexDataElementEnum.getEnum(dataElement).getAlias());
        }
        if (dimension == 3) {
            period *= 3;
        } else if (dimension == 2) {
            period = 12;
        }
        if (mainQueryType == 2 && !StringUtils.isEmpty((String)longNumber) && (i = longNumber.lastIndexOf("!")) > 0) {
            longNumber = longNumber.substring(0, i);
            defaultCond.put("orgUnitLongNumber", longNumber);
        }
        SQLBuilder buffer = new SQLBuilder();
        buffer.append(" SELECT FDataTypeNumber, FDataTypeName");
        buffer.append("   FROM T_CSL_IndexAnalysisEntry");
        buffer.append("  WHERE FIndexAnalysisId=?", (Object)idxAnaID);
        buffer.append("    AND FDataElementType =? AND FIsDefault = 1 ORDER BY FSeq ", (Object)dataElement);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        if (rs == null || rs.size() == 0) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"967_IndexAnalysisFacadeControllerBean", (Locale)ctx.getLocale()));
            return null;
        }
        String[] dtNos = new String[rs.size()];
        try {
            int i2 = 0;
            while (rs.next()) {
                dtNos[i2] = rs.getString("FDataTypeNumber");
                ++i2;
            }
        }
        catch (SQLException e) {
            logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"968_IndexAnalysisFacadeControllerBean", (Locale)ctx.getLocale()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        buffer.reset();
        buffer.append(" SELECT FOrgId, FOrgIsLeaf, FOrgLongNumber, FOrgName, ");
        for (int i3 = 0; i3 < dtNos.length; ++i3) {
            if (i3 > 0) {
                buffer.append(", \n");
            }
            buffer.append("(SELECT CASE WHEN (TRIM(FSpecialValue) IS NULL OR LEN(FSpecialValue)=0) THEN TOCHAR(FAmount) ELSE '-9999999999999999.9999999' END");
            buffer.append("   FROM T_CSL_IndexAnalysisData t ");
            buffer.append("  WHERE t.FOrgId = dt.FOrgId AND t.FIndexAnalysisId=?", (Object)idxAnaID);
            buffer.append("    AND t.FPeriodType=?", (Object)periodType);
            buffer.append("    AND t.FDataElement =?", (Object)dataElement);
            buffer.append("    AND t.FDataType=?", (Object)dtNos[i3]);
            buffer.append("    AND t.FYear=?", (Object)year);
            buffer.append("    AND t.FPeriod=?", (Object)period);
            buffer.append(") " + dtNos[i3]);
        }
        buffer.append(" FROM (\n");
        buffer.append(" SELECT struc.FId FOrgId, unit.FNumber FOrgNumber, struc.FIsLeaf FOrgIsLeaf,");
        buffer.append("   CASE WHEN (TRIM(unit.FSimpleName) IS NULL OR LEN(TRIM(unit.FSimpleName))=0) THEN unit.");
        buffer.append(nameField).append(" ELSE unit.FSimpleName END FOrgName, struc.FLongNumber FOrgLongNumber");
        buffer.append("  FROM T_ORG_Structure struc ");
        buffer.append(" INNER JOIN T_ORG_BaseUnit unit ON unit.FId = struc.FUnitId");
        buffer.append(" INNER JOIN T_PM_OrgRange Range ON Range.FOrgId = unit.FId");
        buffer.append(" WHERE struc.FTreeId = ?", (Object)treeId);
        buffer.append("   AND Range.FUserId = ?", (Object)userId);
        buffer.append("   AND Range.FType = ?", (Object)10);
        if (!isFirst) {
            buffer.append("   AND struc.FLongNumber LIKE ?", (Object)(longNumber + "%"));
            int level = this.getLevelByLongNumber(longNumber);
            buffer.append("   AND struc.FLevel >=?", (Object)level);
            buffer.append("   AND struc.FLevel <=?", (Object)(level + 1));
        } else {
            buffer.append("   AND struc.FLevel >=?", (Object)topLevel);
            buffer.append("   AND struc.FLevel <=?", (Object)(topLevel + 1));
        }
        buffer.append(" ) dt \n");
        if (!StringUtils.isEmpty((String)searchTxt)) {
            buffer.append(" WHERE (FOrgName LIKE ?", (Object)("%" + searchTxt.trim() + "%"));
            buffer.append("  OR FOrgNumber LIKE ?) \n", (Object)("%" + searchTxt.trim() + "%"));
        }
        String sortStr = "";
        if (!StringUtils.isEmpty((String)sortColumnNo) && sortType > 0) {
            sortStr = "TO_NUMBER(" + sortColumnNo + ") " + (sortType == 1 ? "ASC" : "DESC") + ",";
        }
        buffer.append(" ORDER BY " + sortStr + "dt.FOrgLongNumber \n");
        ArrayList result = new ArrayList();
        try {
            this.debug(buffer, "_getIdxAnaMainData: Main Page Sql");
            rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])buffer.getParams());
            Map icgInfo = this.getIndexCalcGuideInfo(ctx, year, period, itInfo.getId().toString());
            boolean is13Period = false;
            String suffix = "";
            if (icgInfo != null) {
                is13Period = (Boolean)icgInfo.get("is13Period");
                String string = suffix = icgInfo.get("suffix") != null ? icgInfo.get("suffix").toString() : "";
            }
            while (rs.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                rec.put("orgID", rs.getString("forgId"));
                rec.put("isUnion", rs.getString("forgisleaf"));
                rec.put("longNumber", rs.getString("forglongnumber"));
                if (is13Period) {
                    rec.put("orgName", rs.getString("forgName") + suffix);
                } else {
                    rec.put("orgName", rs.getString("forgName"));
                }
                for (int i4 = 0; i4 < dtNos.length; ++i4) {
                    String dtNumber = dtNos[i4];
                    String amount = rs.getString(dtNumber);
                    amount = this.formatAmount(ctx, amount, dtNumber, factor, precision);
                    rec.put(dtNumber, amount);
                }
                result.add(rec);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getIdxAnaMainData", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key_list", result);
        map.put("key_columnnos", Arrays.asList(dtNos));
        List<String> columns = MobileUtil.getSimpleColumnNameList(ctx, dtNos);
        map.put("key_columnnames", columns);
        if (isFirst) {
            map.put("key_condition", defaultCond);
        }
        return map;
    }

    private int getLevelByLongNumber(String longNumber) {
        if (StringUtils.isEmpty((String)longNumber)) {
            return 0;
        }
        return longNumber.split("!").length;
    }

    private int[] getPreYearAndMonth(int dimension) {
        int y = 0;
        int m = 0;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        switch (dimension) {
            case 1: {
                c.add(2, -1);
                y = c.get(1);
                m = c.get(2) + 1;
                break;
            }
            case 2: {
                c.add(1, -1);
                y = c.get(1);
                m = 12;
                break;
            }
            case 3: {
                c.add(2, -3);
                y = c.get(1);
                m = c.get(2) + 1;
                if (m == 1 || m == 2 || m == 3) {
                    m = 3;
                    break;
                }
                if (m == 4 || m == 5 || m == 6) {
                    m = 6;
                    break;
                }
                if (m == 7 || m == 8 || m == 9) {
                    m = 9;
                    break;
                }
                m = 12;
                break;
            }
        }
        int[] result = new int[]{y, m};
        return result;
    }

    @Override
    protected Map<String, List<String>> _getSearchTip(Context ctx, IndexQueryCondition cond) throws BOSException, EASBizException {
        String idxTypeId = cond.getIdxTypeID();
        String longNumber = cond.getLongNumber();
        String searchTxt = cond.getSearchTxt();
        IndexTypeInfo itInfo = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeInfo((IObjectPK)new ObjectUuidPK(idxTypeId));
        String treeId = itInfo.getOrgBound().getId().toString();
        int year = cond.getYear();
        int period = cond.getPeriod();
        int periodType = cond.getPeriodType();
        if (periodType == 0) {
            periodType = 3;
        }
        if (year <= 0 || period <= 0) {
            int[] yearAndPeriod = this.getPeriod(itInfo.getDimension().getValue(), -1);
            year = yearAndPeriod[0];
            period = yearAndPeriod[1];
        }
        treeId = this.getTreeIdBy(ctx, year, period, periodType, treeId);
        List<String> list = this.filterOrgUnit(ctx, treeId, longNumber, searchTxt);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("key_list", list);
        return map;
    }

    private List<String> filterOrgUnit(Context ctx, String treeId, String longNumber, String searchTxt) throws BOSException, EASBizException {
        SQLBuilder buffer = new SQLBuilder();
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        buffer.append("SELECT orgName FROM ( \n");
        buffer.append(" SELECT CASE WHEN (TRIM(unit.FSimpleName) IS NULL OR LEN(TRIM(unit.FSimpleName))=0) THEN unit.");
        buffer.append(nameField).append(" ELSE unit.FSimpleName END orgName, ");
        buffer.append("   unit.FNumber, struc.FLongnumber");
        buffer.append("  FROM T_ORG_Structure struc ");
        buffer.append(" INNER JOIN T_ORG_BaseUnit unit ON unit.FId = struc.FUnitId");
        buffer.append(" INNER JOIN T_PM_OrgRange Range ON Range.FOrgId = unit.FId");
        buffer.append(" WHERE struc.FTreeId=?", (Object)treeId);
        buffer.append("   AND Range.FUserId=?", (Object)userId);
        buffer.append("   AND Range.FType=?", (Object)10);
        if (!StringUtils.isEmpty((String)longNumber)) {
            int level = this.getLevelByLongNumber(longNumber);
            buffer.append("   AND struc.FLevel>=?", (Object)level);
            buffer.append("   AND struc.FLevel<=?", (Object)(level + 1));
        }
        buffer.append(") t \n");
        buffer.append(" WHERE (FNumber LIKE ?", (Object)("%" + searchTxt + "%"));
        buffer.append("    OR orgName LIKE ?)", (Object)("%" + searchTxt + "%"));
        buffer.append(" ORDER BY FLongNumber");
        this.debug(buffer, "[Tip Sql]******************************************:\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        ArrayList<String> result = new ArrayList<String>();
        try {
            while (rs.next()) {
                result.add(rs.getString("orgName"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private IndexAnalysisInfo getDefaultIdxAnaInfo(Context ctx, String idxTypeID) throws EASBizException, BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT index.id, index.name, index.hasProduce, index.hasCumulation, index.hasBalance,").append(" index.indexType.id, index.indexType.dimension, index.indexType.orgBound.id, index.indexType.precision,").append(" index.defaultDE ").append("WHERE indexType='" + idxTypeID + "' AND user='" + ctx.getCaller().toString()).append("' ORDER BY index.isDefaultIndex DESC, index.number ASC");
        IndexDispensedCollection coll = IndexDispensedFactory.getLocalInstance(ctx).getIndexDispensedCollection(buffer.toString());
        if (coll != null && coll.size() > 0 && coll.get(0) != null && coll.get(0).getIndex() != null) {
            return coll.get(0).getIndex();
        }
        return new IndexAnalysisInfo();
    }

    @Override
    protected Map<String, Object> _getIdxAnaDetailData(Context ctx, IndexQueryCondition cond) throws BOSException, EASBizException {
        String dataType;
        int year = cond.getYear();
        int period = cond.getPeriod();
        int periodType = cond.getPeriodType();
        int dataElement = cond.getDataElement();
        String idxTypeID = cond.getIdxTypeID();
        String idxAnaID = cond.getIdxID();
        String orgID = cond.getOrgID();
        IndexTypeInfo itInfo = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeInfo((IObjectPK)new ObjectUuidPK(idxTypeID));
        int precision = itInfo.getPrecision();
        double factor = itInfo.getFactor();
        String unit = itInfo.getUnit();
        int anaPeriod = itInfo.getAnaPeriod();
        int dimension = itInfo.getDimension().getValue();
        String description = itInfo.getDescription();
        String indexName = IndexAnalysisFactory.getLocalInstance(ctx).getIndexAnalysisInfo((IObjectPK)new ObjectUuidPK(idxAnaID)).getName();
        if (dimension == 3) {
            period *= 3;
        } else if (dimension == 2) {
            period = 12;
        }
        if (periodType == 0) {
            periodType = 3;
        }
        String curAmount = DCAmountEnum.currentAmount.getName();
        String orgUnitNumber = "";
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("SELECT unit.FNumber number FROM T_ORG_Structure stuc");
        buffer.append("  JOIN T_ORG_BaseUnit unit ON stuc.FUnitId = unit.FId ");
        buffer.append(" WHERE stuc.FId =?", (Object)orgID);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        try {
            while (rowSet.next()) {
                orgUnitNumber = rowSet.getString("number");
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        StringBuffer selectors = new StringBuffer("");
        selectors.append("t.FDatatype dataType").append(", t.FOrgName orgName").append(", t.FDataTypeName dataTypeName").append(", t.FYear year").append(", t.FPeriod period").append(", t.FDay updateTime").append(", idxEntry.FIsShow isshow").append(", CASE WHEN (TRIM(t.FSpecialValue) IS NULL OR LEN(t.FSpecialValue)=0) THEN tochar(t.FAmount) ELSE t.FSpecialValue END amount").append(", idxEntry.FSeq seq \n");
        buffer.reset();
        buffer.append("SELECT ").append(selectors.toString());
        buffer.append("  FROM T_CSL_IndexAnalysisData t \n");
        buffer.append(" INNER JOIN T_CSL_IndexAnalysisEntry idxEntry ON t.FIndexAnalysisEntryID = idxEntry.FId \n");
        buffer.append(" WHERE 1=1 ");
        buffer.append("   AND t.FPeriodType=?", (Object)periodType);
        buffer.append("   AND t.FDataElement=?", (Object)dataElement);
        buffer.append("   AND t.FYear=?", (Object)year);
        buffer.append("   AND t.FPeriod=?", (Object)period);
        buffer.append("   AND t.FDataType<>?", (Object)curAmount);
        buffer.append("   AND t.FOrgNumber=?", (Object)orgUnitNumber);
        buffer.append("   AND t.FIndexAnalysisId=? \n", (Object)idxAnaID);
        buffer.append(" UNION ALL \n");
        buffer.append("SELECT ").append(selectors.toString());
        buffer.append("  FROM T_CSL_IndexAnalysisData t \n");
        buffer.append(" INNER JOIN T_CSL_IndexAnalysisEntry idxEntry ON t.FIndexAnalysisEntryID = idxEntry.fid \n");
        buffer.append(" WHERE 1=1 ");
        buffer.append("   AND t.FPeriodType=?", (Object)periodType);
        buffer.append("   AND t.FDataElement=?", (Object)dataElement);
        buffer.append("   AND t.FDataType=?", (Object)curAmount);
        buffer.append("   AND t.FOrgNumber=?", (Object)orgUnitNumber);
        buffer.append("   AND t.FindexanalysisId=?", (Object)idxAnaID);
        String whereStr = this.getWhereSql(year, period, anaPeriod, dimension, "t");
        if (!StringUtils.isEmpty((String)whereStr)) {
            buffer.append(" AND (" + whereStr + ")");
        }
        buffer.append(" ORDER BY seq \n");
        this.debug(buffer, "[Detail Page Sql]******************************************:\n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])buffer.getParams());
        ArrayList result = new ArrayList();
        ArrayList detailList = new ArrayList();
        ArrayList chartList = new ArrayList();
        Timestamp ts = null;
        String orgName = "";
        try {
            while (rs.next()) {
                HashMap<String, String> rec = new HashMap<String, String>();
                rec.put("dataElement", String.valueOf(dataElement));
                dataType = rs.getString("dataType");
                rec.put("dataType", dataType);
                rec.put("dataTypeName", rs.getString("dataTypeName"));
                rec.put("amount", this.formatAmount(ctx, rs.getString("amount"), dataType, factor, precision));
                ts = rs.getTimestamp("updateTime");
                orgName = rs.getString("orgName");
                int y = rs.getInt("year");
                int p = rs.getInt("period");
                rec.put("year", String.valueOf(y));
                rec.put("period", String.valueOf(p));
                rec.put("relPeriod", String.valueOf((y - year) * 12 + (p - period)));
                rec.put("isshow", String.valueOf(rs.getInt("isshow")));
                result.add(rec);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        for (int i = 0; i < result.size(); ++i) {
            Map rec = (Map)result.get(i);
            int isshow = Integer.parseInt((String)rec.get("isshow"));
            int y = Integer.parseInt((String)rec.get("year"));
            int p = Integer.parseInt((String)rec.get("period"));
            if (isshow != 1 || y != year || p != period) continue;
            HashMap dtRec = new HashMap();
            dtRec.put("dataType", rec.get("dataType"));
            dtRec.put("dataTypeName", rec.get("dataTypeName"));
            String amount = (String)rec.get("amount");
            dtRec.put("amount", amount);
            detailList.add(dtRec);
        }
        if (detailList.size() == 0) {
            buffer.reset();
            buffer.append("SELECT fdatatypenumber dataType, 0 amount  FROM T_CSL_Indexanalysisentry ");
            buffer.append("WHERE FIsShow=1 AND FDataElementType=" + dataElement + " AND FIndexAnalysisId='" + idxAnaID + "' ");
            buffer.append("ORDER BY FSeq");
            rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString());
            try {
                while (rs.next()) {
                    HashMap<String, String> dtRec = new HashMap<String, String>();
                    dataType = rs.getString("dataType");
                    dtRec.put("dataType", dataType);
                    dtRec.put("dataTypeName", this.mobileUtil.getFormatDataTypeName(ctx, dataElement, dataType));
                    String amount = rs.getString("amount");
                    dtRec.put("amount", amount);
                    detailList.add(dtRec);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        for (int i = 0; i > -anaPeriod; --i) {
            int relPer = i;
            if (3 == dimension) {
                relPer = i * 3;
            } else if (2 == dimension) {
                relPer = i * 12;
            }
            HashMap<String, String> clRec = new HashMap<String, String>();
            clRec.put("relPeriod", String.valueOf(relPer));
            String amount = "0";
            for (int j = 0; j < result.size(); ++j) {
                Map rec = (Map)result.get(j);
                String dataType2 = (String)rec.get("dataType");
                int relPeriod = Integer.valueOf((String)rec.get("relPeriod"));
                if (!dataType2.equals(curAmount) || relPeriod != relPer) continue;
                amount = (String)rec.get("amount");
                break;
            }
            String x = "";
            if (1 == dimension) {
                relPer = (relPer = (relPer + 120 + period) % 12) == 0 ? 12 : relPer;
                x = String.valueOf(relPer);
            } else if (2 == dimension) {
                x = String.valueOf(relPer / 12 + year).substring(2);
            } else {
                int n = relPer = (relPer = (relPer + 120 + period) % 12) == 0 ? 12 : relPer;
                relPer = relPer == 1 || relPer == 2 || relPer == 3 ? 3 : (relPer == 4 || relPer == 5 || relPer == 6 ? 6 : (relPer == 7 || relPer == 8 || relPer == 9 ? 9 : 12));
                x = String.valueOf(relPer / 3);
            }
            clRec.put("period", x);
            clRec.put("amount", amount);
            chartList.add(clRec);
        }
        Collections.sort(chartList, new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                int i2;
                int i1 = Integer.valueOf(o1.get("relPeriod").toString());
                return i1 > (i2 = Integer.valueOf(o2.get("relPeriod").toString()).intValue()) ? 1 : -1;
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key_detailList", detailList);
        map.put("key_chartList", chartList);
        HashMap<String, String> tab3 = new HashMap<String, String>();
        tab3.put(KEYS_TITLE, this.getResourceByName(ctx, "96_theme_description"));
        tab3.put("description", description);
        map.put("key_tab3", tab3);
        HashMap<String, String> condMap = new HashMap<String, String>();
        StringBuffer chartTitle = new StringBuffer();
        if (StringUtils.isEmpty((String)orgName)) {
            OrgStructureInfo ouInfo = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo("select unit.simplename, unit.name where id='" + orgID + "'");
            String name = ouInfo.getUnit().getSimpleName();
            orgName = StringUtils.isEmpty((String)name) ? ouInfo.getUnit().getName() : name;
        }
        chartTitle.append(orgName).append("-").append(indexName).append("(").append(unit).append(")");
        condMap.put("chartTitle", chartTitle.toString());
        String updateTime = "";
        if (ts != null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            updateTime = df.format(ts);
        }
        condMap.put("updateTime", updateTime);
        condMap.put("unit", unit);
        map.put("key_other", condMap);
        return map;
    }

    private String getWhereSql(int year, int period, int anaPeriod, int dimension, String tableAlias) {
        StringBuffer result = new StringBuffer();
        Calendar c = Calendar.getInstance();
        c.set(year, period - 1, 1);
        if (1 == dimension) {
            c.add(2, 1);
        } else if (2 == dimension) {
            c.add(1, 1);
        } else if (3 == dimension) {
            c.add(2, 3);
        }
        for (int i = 0; i < anaPeriod; ++i) {
            if (1 == dimension) {
                c.add(2, -1);
            } else if (2 == dimension) {
                c.add(1, -1);
            } else if (3 == dimension) {
                c.add(2, -3);
            }
            if (i > 0) {
                result.append(" OR");
            }
            result.append(" (").append(tableAlias).append(".FYear=").append(c.get(1)).append(" And ").append(tableAlias).append(".FPeriod=").append(c.get(2) + 1).append(") ");
        }
        return result.toString();
    }

    @Override
    @Deprecated
    protected Map<String, List<Map<String, String>>> _getOrgUnitList(Context ctx, String idxTypeID) throws BOSException, EASBizException {
        String treeId = IndexTypeFactory.getLocalInstance(ctx).getIndexTypeInfo((IObjectPK)new ObjectUuidPK(idxTypeID)).getOrgBound().getId().toString();
        List<Map<String, String>> list = this.getOrgUnitListByTreeId(ctx, treeId, null, true, null);
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        map.put("key_list", list);
        return map;
    }

    private List<Map<String, String>> getOrgUnitListByTreeId(Context ctx, String treeId, String longNumber, boolean isGrouping, String searchTxt) throws BOSException, EASBizException {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        OrgStructureCollection col = this.getOrgUnitFromSql(ctx, treeId, longNumber, false, isGrouping, searchTxt, -1);
        if (col != null) {
            Locale locale = ctx.getLocale();
            for (int i = 0; i < col.size(); ++i) {
                FullOrgUnitInfo info = col.get(i).getUnit();
                HashMap<String, String> rec = new HashMap<String, String>();
                String longLumber = col.get(i).getLongNumber();
                String fullName = info.getName(locale);
                String simpName = info.getSimpleName();
                if (!StringUtils.isEmpty((String)simpName)) {
                    fullName = simpName;
                }
                rec.put("name", fullName);
                rec.put("value", longLumber);
                rec.put("orgId", col.get(i).getId().toString());
                rec.put("isUnion", col.get(i).isIsLeaf() ? "0" : "1");
                list.add(rec);
            }
        }
        return list;
    }

    @Override
    protected Map _getDataElementList(Context ctx, String indexId) throws BOSException, EASBizException {
        HashMap<String, String> rec;
        ArrayList list = new ArrayList();
        IndexAnalysisInfo info = IndexAnalysisFactory.getLocalInstance(ctx).getIndexAnalysisInfo((IObjectPK)new ObjectUuidPK(indexId));
        if (info.isHasProduce()) {
            rec = new HashMap<String, String>();
            rec.put("name", IndexDataElementEnum.Produce.getAlias());
            rec.put("value", IndexDataElementEnum.Produce.getValue() + "");
            list.add(rec);
        }
        if (info.isHasCumulation()) {
            rec = new HashMap();
            rec.put("name", IndexDataElementEnum.Cumulation.getAlias());
            rec.put("value", IndexDataElementEnum.Cumulation.getValue() + "");
            list.add(rec);
        }
        if (info.isHasBalance()) {
            rec = new HashMap();
            rec.put("name", IndexDataElementEnum.Balance.getAlias());
            rec.put("value", IndexDataElementEnum.Balance.getValue() + "");
            list.add(rec);
        }
        HashMap map = new HashMap();
        map.put("key_list", list);
        return map;
    }

    @Override
    protected Map _getIdxAnaCollection(Context ctx, String idxTypeID) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        StringBuffer osql = new StringBuffer("SELECT index.id, index.name,").append(" index.hasProduce, index.hasCumulation, index.hasBalance").append(" WHERE indexType = '" + idxTypeID + "' AND user = '" + ctx.getCaller().toString() + "'").append(" ORDER BY index.number");
        IndexDispensedCollection dispIdxColl = IndexDispensedFactory.getLocalInstance(ctx).getIndexDispensedCollection(osql.toString());
        IndexDataElementEnum de = null;
        for (int i = 0; i < dispIdxColl.size(); ++i) {
            IndexDispensedInfo info = dispIdxColl.get(i);
            HashMap<String, String> rec = new HashMap<String, String>();
            rec.put("name", info.getIndex().getName());
            rec.put("value", info.getIndex().getId().toString());
            de = info.getIndex().isHasBalance() ? IndexDataElementEnum.Balance : (info.getIndex().isHasCumulation() ? IndexDataElementEnum.Cumulation : IndexDataElementEnum.Produce);
            rec.put("deName", de.getAlias());
            rec.put("deValue", String.valueOf(de.getValue()));
            list.add(rec);
        }
        HashMap map = new HashMap();
        map.put("key_list", list);
        return map;
    }

    private OrgStructureInfo getTopOrgUnit(Context ctx, String teeId) throws BOSException {
        OrgStructureInfo info;
        OrgStructureCollection col = this.getOrgUnitFromSql(ctx, teeId, null, true, false, null, -1);
        if (col != null && col.size() > 0 && (info = col.get(0)).isIsLeaf() && info.getParent() != null) {
            String parentId = info.getParent().getId().toString();
            col = this.getOrgUnitByParentId(ctx, parentId);
            return col == null ? new OrgStructureInfo() : col.get(0);
        }
        return col == null ? new OrgStructureInfo() : col.get(0);
    }

    private int getTopLevelByUser(Context ctx, String treeId) throws BOSException {
        OrgStructureCollection col = this.getOrgUnitFromSql(ctx, treeId, null, true, false, null, -1);
        if (col != null && col.size() > 0) {
            OrgStructureInfo info = col.get(0);
            return info.getLevel();
        }
        return 0;
    }

    private OrgStructureCollection getOrgUnitByParentId(Context ctx, String orgId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgId));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("unit.id"));
        view.getSelector().add(new SelectorItemInfo("unit.name"));
        view.getSelector().add(new SelectorItemInfo("unit.simpleName"));
        view.getSelector().add(new SelectorItemInfo("level"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        return OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
    }

    private OrgStructureCollection getOrgUnitFromSql(Context ctx, String orgTreeID, String longNumber, boolean isTop, boolean isGrouping, String searchTxt, int topLevel) throws BOSException {
        OrgStructureCollection result = new OrgStructureCollection();
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        SQLBuilder buffer = new SQLBuilder();
        String nameField = MultiLangHelper.getFieldName((String)"FName", (Locale)ctx.getLocale());
        buffer.append("SELECT stru.FId, unit.FId, unit.FSimpleName, stru.FLevel, stru.FIsLeaf, stru.FParentId, stru.FLongNumber, unit.").append(nameField + "\n");
        buffer.append("  FROM T_Org_Structure stru \n");
        buffer.append(" INNER JOIN T_Org_BaseUnit unit ON unit.FId = stru.FUnitId \n");
        buffer.append(" INNER JOIN T_Org_Tree tree ON tree.FId = stru.FTreeId \n");
        buffer.append(" INNER JOIN T_PM_OrgRange range ON range.FOrgId = unit.FId \n");
        buffer.append(" WHERE tree.FId = ?", (Object)orgTreeID);
        buffer.append("   AND range.FUserId = ?", (Object)userId);
        buffer.append("   AND range.FType = ?", (Object)10);
        if (isGrouping) {
            buffer.append(" AND unit.FIsGrouping = 1");
        }
        if (!StringUtils.isEmpty((String)searchTxt)) {
            searchTxt = "%" + searchTxt + "%";
            buffer.append(" AND (unit.FNumber LIKE ?", (Object)searchTxt);
            buffer.append("  OR unit.FSimpleName LIKE ?", (Object)searchTxt);
            buffer.append("  OR unit.").append(nameField).append(" LIKE ?)", (Object)searchTxt);
        }
        if (topLevel > 0) {
            buffer.append(" AND stru.FLevel <=?", (Object)(topLevel + 1));
        }
        if (isTop) {
            buffer.append(" ORDER BY unit.FIsGrouping DESC, stru.FLevel");
        } else if (!StringUtils.isEmpty((String)longNumber)) {
            buffer.append("   AND stru.FLongNumber LIKE ?", (Object)(longNumber + "%"));
            int level = this.getLevelByLongNumber(longNumber);
            buffer.append("   AND stru.FLevel >=?", (Object)level);
            buffer.append("   AND stru.FLevel <=?", (Object)(level + 1));
            buffer.append(" ORDER BY stru.FLongNumber ");
        } else {
            buffer.append(" ORDER BY stru.FLongNumber ");
        }
        try {
            this.debug(buffer, "getOrgUnitFromSql");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
            OrgStructureInfo info = null;
            OrgStructureInfo parent = null;
            FullOrgUnitInfo unit = null;
            while (rs.next()) {
                info = new OrgStructureInfo();
                info.setId(BOSUuid.read((String)rs.getString("FId")));
                info.setLongNumber(rs.getString("FLongNumber"));
                info.setLevel(rs.getInt("FLevel"));
                info.setIsLeaf(rs.getBoolean("FIsLeaf"));
                parent = null;
                if (rs.getString("FParentId") != null) {
                    parent = new OrgStructureInfo();
                    parent.setId(BOSUuid.read((String)rs.getString("FParentId")));
                }
                info.setParent(parent);
                unit = new FullOrgUnitInfo();
                unit.setId(BOSUuid.read((String)rs.getString("FId")));
                unit.setSimpleName(rs.getString("FSimpleName"));
                unit.setName(rs.getString(nameField));
                info.setUnit(unit);
                result.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getOrgUnitFromSql", (Throwable)e);
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        int[] a;
        for (int i : a = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}) {
            long t = i / 3;
            System.out.println(t);
        }
    }

    private int[] getYearAndMonth(Timestamp ts) throws EASBizException, BOSException {
        Calendar c = Calendar.getInstance();
        if (ts != null) {
            c.setTimeInMillis(ts.getTime());
        } else {
            c.setTimeInMillis(System.currentTimeMillis());
        }
        int year = c.get(1);
        int period = c.get(2) + 1;
        return new int[]{year, period};
    }

    @Override
    protected Map _getBossQuery(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String schemeId = "";
        String searchTxt = "";
        String longNumber = "";
        int year = 0;
        int period = 0;
        int periodType = 0;
        if (param != null && param.get("schemeId") != null) {
            schemeId = param.get("schemeId").toString();
        }
        if (param != null && param.get("searchTxt") != null) {
            searchTxt = param.get("searchTxt").toString();
        }
        if (param != null && param.get("longNumber") != null) {
            longNumber = param.get("longNumber").toString();
        }
        if (param != null && param.get("year") != null) {
            year = Integer.parseInt(param.get("year").toString());
        }
        if (param != null && param.get("period") != null) {
            period = Integer.parseInt(param.get("period").toString());
        }
        periodType = param != null && param.get("periodType") != null ? Integer.parseInt(param.get("periodType").toString()) : 3;
        if (StringUtils.isEmpty((String)schemeId)) {
            List<Map<String, String>> schemeList = this.getSchemeByUser(ctx);
            resultMap.put("schemeList", schemeList);
            if (schemeList.size() == 0) {
                resultMap.put(KEYS_ERRORMESSAGE, this.getResourceByName(ctx, "90_no_dispensed_shcemes"));
                return resultMap;
            }
            schemeId = schemeList.get(0).get("schemeId").toString();
        }
        IndexTypeCollection indexTypeCol = this.getIndexTypeInfoBySchemId(ctx, schemeId);
        IndexTypeInfo itInfo = indexTypeCol.get(0);
        String treeId = itInfo.getOrgBound().getId().toString();
        if (year <= 0 || period <= 0) {
            int[] yAndP = this.getPeriod(itInfo.getLastCalcTime(), itInfo.getDimension().getValue(), 0);
            year = yAndP[0];
            period = yAndP[1];
        }
        treeId = this.getTreeIdBy(ctx, year, period, periodType, treeId);
        int dimension = itInfo.getDimension().getValue();
        resultMap.put("dimension", dimension);
        if (StringUtils.isEmpty((String)searchTxt) && StringUtils.isEmpty((String)longNumber)) {
            int[] yAndP = this.getPeriod(itInfo.getLastCalcTime(), itInfo.getDimension().getValue(), 0);
            int y = yAndP[0];
            int p = yAndP[1];
            String periodStr = "";
            String yearStr = IndexTypeDimension.year.getAlias();
            periodStr = dimension == 2 ? y + yearStr : y + yearStr + p + IndexTypeDimension.getEnum(dimension).getAlias();
            resultMap.put(KEYS_PERIODSTR, periodStr);
        }
        int topLevel = -1;
        if (StringUtils.isEmpty((String)longNumber)) {
            topLevel = this.getTopLevelByUser(ctx, treeId);
        }
        ArrayList list = new ArrayList();
        OrgStructureCollection col = this.getOrgUnitFromSql(ctx, treeId, longNumber, false, false, searchTxt, topLevel);
        if (col != null) {
            Locale locale = ctx.getLocale();
            for (int i = 0; i < col.size(); ++i) {
                FullOrgUnitInfo info = col.get(i).getUnit();
                HashMap<String, String> rec = new HashMap<String, String>();
                String longLumber = col.get(i).getLongNumber();
                String fullName = info.getName(locale);
                String simpName = info.getSimpleName();
                if (!StringUtils.isEmpty((String)simpName)) {
                    fullName = simpName;
                }
                rec.put("name", fullName);
                rec.put("value", longLumber);
                rec.put("orgId", col.get(i).getId().toString());
                rec.put("isUnion", col.get(i).isIsLeaf() ? "0" : "1");
                list.add(rec);
            }
        }
        resultMap.put(KEYS_ORGUNIT, list);
        return resultMap;
    }

    private List<Map<String, String>> getSchemeByUser(Context ctx) throws BOSException {
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        SQLBuilder buffer = new SQLBuilder();
        String local = ctx.getLocale().toString();
        buffer.append("SELECT DISTINCT schm.FId, schm.FName_" + local + " fname, de.FIsDefaultScheme, schm.FNumber");
        buffer.append("  FROM T_CSL_IndexAnalysisScheme schm");
        buffer.append("  JOIN T_CSL_ReportUsergroupDispEntry de ON de.FSchemeId = schm.FId");
        buffer.append("  JOIN T_CSL_ReportUsergroupDispense d ON d.FId= de.FDispenseId");
        buffer.append("  JOIN T_CSL_ReportUsergroup g ON d.FUserGroupid = g.FId");
        buffer.append(" WHERE EXISTS (SELECT 1");
        buffer.append("          FROM T_CSL_Reportusergroupentry e");
        buffer.append("         WHERE FUserId = ?", (Object)userId);
        buffer.append("           AND e.FGroupId = g.FId)");
        buffer.append(" ORDER BY de.FIsdefaultScheme DESC, schm.FNumber");
        ArrayList<Map<String, String>> schemeList = new ArrayList<Map<String, String>>();
        try {
            this.debug(buffer, "getSchemeByUser:");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
            while (rs.next()) {
                HashMap<String, String> scheme = new HashMap<String, String>();
                scheme.put("schemeName", rs.getString("FName"));
                scheme.put("schemeId", rs.getString("FId"));
                schemeList.add(scheme);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return schemeList;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Map _getBossMain(Context ctx, Map param) throws BOSException, EASBizException {
        block35: {
            block34: {
                resultMap = new HashMap<String, Object>();
                schemeId = "";
                orgId = "";
                longNumber = "";
                orgUnitName = "";
                year = 0;
                period = 0;
                periodType = 3;
                treeId = "";
                if (param == null) break block34;
                obj = null;
                obj = param.get("schemeId");
                schemeId = obj != null ? obj.toString() : "";
                obj = param.get("orgId");
                orgId = obj != null ? obj.toString() : "";
                obj = param.get("longNumber");
                longNumber = obj != null ? obj.toString() : "";
                obj = param.get("treeId");
                treeId = obj != null ? obj.toString() : "";
                obj = param.get("year");
                year = obj != null && "null".equalsIgnoreCase(obj.toString()) == false ? Integer.valueOf(obj.toString()) : 0;
                obj = param.get("period");
                period = obj != null && "null".equalsIgnoreCase(obj.toString()) == false ? Integer.valueOf(obj.toString()) : 0;
                buffer = null;
                isFirst = false;
                if (!StringUtils.isEmpty((String)schemeId)) ** GOTO lbl35
                isFirst = true;
                schemeList = this.getSchemeByUser(ctx);
                if (schemeList.size() > 0) {
                    schemeId = schemeList.get(0).get("schemeId");
                } else {
                    resultMap.put("errorMessage", this.getResourceByName(ctx, "91_no_indexscheme_foruser"));
                    return resultMap;
lbl35:
                    // 1 sources

                    if (StringUtils.isEmpty((String)schemeId) || !StringUtils.isEmpty((String)treeId)) {
                        // empty if block
                    }
                }
                resultMap.put("schemeId", schemeId);
                indexTypeCol = this.getIndexTypeInfoBySchemId(ctx, schemeId);
                itInfo = indexTypeCol.get(0);
                if (itInfo == null) {
                    resultMap.put("errorMessage", this.getResourceByName(ctx, "92_no_theme_forscheme"));
                    return resultMap;
                }
                treeId = itInfo.getOrgBound().getId().toString();
                dimension = itInfo.getDimension().getValue();
                if (year == 0 || period == 0) {
                    yAndM = this.getPeriod(itInfo.getLastCalcTime(), itInfo.getDimension().getValue(), 0);
                    year = yAndM[0];
                    period = yAndM[1];
                } else if (dimension == 3) {
                    period *= 3;
                } else if (dimension == 2) {
                    period = 12;
                }
                resultMap.put("year", year);
                if (dimension == 3) {
                    resultMap.put("period", period / 3);
                } else if (dimension == 2) {
                    resultMap.put("period", 12);
                } else {
                    resultMap.put("period", period);
                }
                treeId = this.getTreeIdBy(ctx, year, period, periodType, treeId);
                resultMap.put("treeId", treeId);
                topLevel = -1;
                if (isFirst) {
                    topLevel = this.getTopLevelByUser(ctx, treeId);
                }
                if ((col = this.getOrgUnitFromSql(ctx, treeId, longNumber, false, false, null, topLevel)) != null && col.size() > 0) {
                    info = col.get(0).getUnit();
                    fullName = info.getName(ctx.getLocale());
                    simpName = info.getSimpleName();
                    if (!StringUtils.isEmpty((String)simpName)) {
                        fullName = simpName;
                    }
                    orgUnitName = fullName;
                    longNumber = col.get(0).getLongNumber();
                    orgId = col.get(0).getId().toString();
                }
                resultMap.put("longNumber", longNumber);
                resultMap.put("orgId", orgId);
                title = "";
                title = dimension == 3 ? orgUnitName + "(" + period / 3 + indexTypeCol.get(0).getDimension().getAlias() + ")" : (dimension == 2 ? orgUnitName + "(" + year + indexTypeCol.get(0).getDimension().getAlias() + ")" : orgUnitName + "(" + period + indexTypeCol.get(0).getDimension().getAlias() + ")");
                resultMap.put("title", title);
                buffer = new SQLBuilder();
                buffer.append("SELECT d.FIndexTypeId, d.FIndexAnalysisId, d.FDataElement, d.FDataType,");
                buffer.append("       CASE WHEN FSpecialValue IS NULL THEN TOCHAR(FAmount) ELSE FSpecialValue END FAmount");
                buffer.append("  FROM T_CSL_Indexanalysisdata d");
                buffer.append("  JOIN T_CSL_Indexanalysisschemeentry e ON e.findextypeid = d.findextypeid");
                buffer.append("                                       AND e.findexid = d.findexanalysisid");
                buffer.append(" WHERE d.FOrgId = ?", (Object)orgId);
                buffer.append("   AND d.FOrgLongNumber = ?", (Object)longNumber);
                buffer.append("   AND d.FYear = ?", (Object)year);
                buffer.append("   AND d.FPeriod = ?", (Object)period);
                buffer.append("   AND d.FPeriodType = ?", (Object)periodType);
                buffer.append("   AND e.FSchemeId = ?", (Object)schemeId);
                data = new HashMap<String, String>();
                try {
                    this.debug(buffer, "_getBossMain:" + this.getHardCodingSettingResourceByName(ctx, "5_getTableData"));
                    rs3 = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
                    key = "";
                    while (rs3.next()) {
                        key = rs3.getString("FIndexTypeId") + "_" + rs3.getString("FIndexAnalysisId") + "_" + rs3.getInt("FDataElement") + "_" + rs3.getString("FDataType") + "";
                        data.put(key, rs3.getString("FAmount"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                buffer = new SQLBuilder();
                userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
                local = ctx.getLocale().toString();
                buffer.append("SELECT it.fid itId, it.FNumber itNumber, it.fname_" + local + " itName, idx.fid idxId, idx.FNumber idxNumber, s.FSeq, idx.fname_" + local + " indexName,");
                buffer.append("       it.fisproduce, it.fiscumulative, it.fisbalance,");
                buffer.append("       it.fproducedatatype, it.fcumulativedatatype, it.fbalancedatatype,");
                buffer.append("       it.factor, it.funit_" + local + " funit, it.fprecision, it.fcurrencyid, idx.fhasproduce");
                buffer.append("  FROM T_CSL_IndexAnalysis idx");
                buffer.append("  JOIN T_CSL_IndexType it ON idx.findextypeid = it.fid");
                buffer.append("  JOIN T_CSL_IndexAnalysisSchemeEntry schmEntry ON schmEntry.FIndexId = idx.FId ");
                buffer.append("       AND schmEntry.FIndexTypeId = it.FId");
                buffer.append("  LEFT JOIN T_CSL_IndexCalcGuide g ON g.FIndexTypeId = it.FId AND g.FIs13Period=1 AND g.FYear = ?", (Object)year);
                buffer.append("  LEFT JOIN T_CSL_IndexType_Sort s ON s.FSchemeId = schmEntry.FSchemeId AND s.FIndexTypeId = schmEntry.FIndexTypeId ");
                buffer.append("       AND s.FUserId=?", (Object)userId);
                buffer.append(" WHERE schmEntry.FSchemeId = ?", (Object)schemeId);
                buffer.append(" ORDER BY s.FSeq, itNumber, idxNumber");
                produceAlias = IndexDataElementEnum.Produce.getAlias();
                cumulationAlias = IndexDataElementEnum.Cumulation.getAlias();
                balanceAlias = IndexDataElementEnum.Balance.getAlias();
                produceValue = IndexDataElementEnum.Produce.getValue();
                cumulationValue = IndexDataElementEnum.Cumulation.getValue();
                balanceValue = IndexDataElementEnum.Balance.getValue();
                try {
                    this.debug(buffer, "_getBossMain:" + this.getHardCodingSettingResourceByName(ctx, "6_buildTableData"));
                    rs4 = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
                    itList = new ArrayList<Map<String, ArrayList<E>>>();
                    allItMap = new HashMap<String, Map<String, ArrayList<E>>>();
                    itId = "";
                    idxId = "";
                    dataType = "";
                    dataElement = "";
                    key = "";
                    factor = 0.0;
                    precision = 0;
                    while (rs4.next()) {
                        itId = rs4.getString("itId");
                        idxId = rs4.getString("idxId");
                        factor = rs4.getDouble("factor");
                        precision = rs4.getInt("fprecision");
                        if (!allItMap.keySet().contains(itId)) {
                            itMap = new HashMap<K, V>();
                            itList.add(itMap);
                            bodyList = new ArrayList<ArrayList<E>>();
                            headList1 = new ArrayList<String>();
                            headList2 = new ArrayList<String>();
                            columns = new ArrayList<E>();
                            indexIds = new ArrayList<E>();
                            itMap.put("head1", headList1);
                            itMap.put("head2", headList2);
                            itMap.put("body", bodyList);
                            itMap.put("columns", columns);
                            itMap.put("indexIds", indexIds);
                            corner = new HashMap<String, String>();
                            itMap.put("corner", corner);
                            corner.put("corner1", rs4.getString("itName"));
                            corner.put("corner2", "(" + rs4.getString("funit") + ")");
                            if (rs4.getBoolean("fisbalance")) {
                                dataType = rs4.getString("fbalancedatatype");
                                arr = dataType.split(",");
                                for (j = 0; j < arr.length; ++j) {
                                    headList1.add(DCEndingBalance.getEnum(arr[j]).getAlias());
                                    headList2.add("(" + balanceAlias + ")");
                                }
                            }
                            if (rs4.getBoolean("fiscumulative")) {
                                dataType = rs4.getString("fcumulativedatatype");
                                arr = dataType.split(",");
                                for (j = 0; j < arr.length; ++j) {
                                    headList1.add(this.mobileUtil.getDataTypeNameByValue(ctx, 2, arr[j]));
                                    headList2.add("(" + cumulationAlias + ")");
                                }
                            }
                            if (rs4.getBoolean("fisproduce")) {
                                dataType = rs4.getString("fproducedatatype");
                                arr = dataType.split(",");
                                for (j = 0; j < arr.length; ++j) {
                                    headList1.add(DCAmountEnum.getEnum(arr[j]).getAlias());
                                    headList2.add("(" + produceAlias + ")");
                                }
                            }
                            allItMap.put(itId, itMap);
                        }
                        itMap = (Map)allItMap.get(itId);
                        bodyList = (ArrayList<ArrayList<E>>)itMap.get("body");
                        columns = (List)itMap.get("columns");
                        indexIds = (List)itMap.get("indexIds");
                        row = new ArrayList<String>();
                        bodyList.add(row);
                        columns.add(rs4.getString("indexName"));
                        indexIds.add(idxId);
                        dataTypeName = "";
                        if (rs4.getBoolean("fisbalance")) {
                            dataType = rs4.getString("fbalancedatatype");
                            arr = dataType.split(",");
                            for (j = 0; j < arr.length; ++j) {
                                dataTypeName = DCEndingBalance.getEnum(arr[j]).getName();
                                key = itId + "_" + idxId + "_" + balanceValue + "_" + dataTypeName;
                                row.add(this.formatAmount(ctx, data.get(key), dataTypeName, factor, precision));
                            }
                        }
                        if (rs4.getBoolean("fiscumulative")) {
                            dataType = rs4.getString("fcumulativedatatype");
                            arr = dataType.split(",");
                            for (j = 0; j < arr.length; ++j) {
                                dataTypeName = DCCurYearCumulative.getEnum(arr[j]).getName();
                                key = itId + "_" + idxId + "_" + cumulationValue + "_" + dataTypeName;
                                row.add(this.formatAmount(ctx, data.get(key), dataTypeName, factor, precision));
                            }
                        }
                        if (!rs4.getBoolean("fisproduce")) continue;
                        dataType = rs4.getString("fproducedatatype");
                        arr = dataType.split(",");
                        for (j = 0; j < arr.length; ++j) {
                            dataTypeName = DCAmountEnum.getEnum(arr[j]).getName();
                            key = itId + "_" + idxId + "_" + produceValue + "_" + dataTypeName;
                            row.add(this.formatAmount(ctx, data.get(key), dataTypeName, factor, precision));
                        }
                    }
                    resultMap.put("table", itList);
                }
                catch (SQLException e) {
                    IndexAnalysisFacadeControllerBean.logger.error((Object)"", (Throwable)e);
                }
                break block35;
            }
            resultMap.put("errorMessage", "param is null");
        }
        return resultMap;
    }

    @Override
    protected Map _getBossChart(Context ctx, Map param) throws BOSException, EASBizException {
        Map<String, Object> resultMap = new HashMap<String, Object>();
        HashMap barMap = new HashMap();
        HashMap lineMap = new HashMap();
        HashMap pieMap = new HashMap();
        String schemeId = "";
        String longNumber = "";
        String periodStr = "";
        String treeId = "";
        String orgId = "";
        String idxId = "";
        int year = 0;
        int period = 0;
        int chartType = 0;
        if (param != null) {
            Object obj = null;
            obj = param.get("schemeId");
            schemeId = obj != null ? obj.toString() : "";
            obj = param.get("idxId");
            idxId = obj != null ? obj.toString() : "";
            obj = param.get("longNumber");
            longNumber = obj != null ? obj.toString() : "";
            obj = param.get("treeId");
            treeId = obj != null ? obj.toString() : "";
            obj = param.get("orgId");
            orgId = obj != null ? obj.toString() : "";
            obj = param.get("year");
            year = obj != null && !"null".equalsIgnoreCase(obj.toString()) ? Integer.valueOf(obj.toString()) : 0;
            obj = param.get("period");
            period = obj != null && !"null".equalsIgnoreCase(obj.toString()) ? Integer.valueOf(obj.toString()) : 0;
            obj = param.get("chartType");
            chartType = obj != null && !"null".equalsIgnoreCase(obj.toString()) ? Integer.valueOf(obj.toString()) : 0;
        }
        boolean isUnion = false;
        boolean isFirst = chartType == 0;
        OrgStructureInfo info = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureInfo((IObjectPK)new ObjectUuidPK(orgId));
        treeId = info.getTree().getId().toString();
        isUnion = !info.isIsLeaf();
        IndexAnalysisSchemeInfo schemeInfo = IndexAnalysisSchemeFactory.getLocalInstance(ctx).getIndexAnalysisSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        IndexAnalysisInfo idxInfo = IndexAnalysisFactory.getLocalInstance(ctx).getIndexAnalysisInfo("select indexType.*, name where id='" + idxId + "'");
        IndexTypeInfo indexTypeInfo = idxInfo.getIndexType();
        String indexName = idxInfo.getName();
        String itId = indexTypeInfo.getId().toString();
        String unit = indexTypeInfo.getUnit();
        double factor = indexTypeInfo.getFactor();
        int precision = indexTypeInfo.getPrecision();
        int periodType = 3;
        int dimension = indexTypeInfo.getDimension().getValue();
        if (dimension == 3) {
            period *= 3;
        } else if (dimension == 2) {
            period = 12;
        }
        boolean isDisplayBarChart = schemeInfo.isIsDisplayColumnChart();
        boolean isDisplayLinChart = schemeInfo.isIsDisplayLineChart();
        boolean isDisplayPieChart = schemeInfo.isIsDisplayPieChart();
        if (isFirst) {
            if (isDisplayBarChart) {
                chartType = 1;
            } else if (isDisplayLinChart) {
                chartType = 2;
            } else if (isDisplayPieChart) {
                chartType = 3;
            }
            ArrayList<Integer> chartTypes = new ArrayList<Integer>();
            ArrayList<String> chartNames = new ArrayList<String>();
            if (isDisplayBarChart) {
                chartTypes.add(1);
                chartNames.add(this.getResourceByName(ctx, "68_BarCharName"));
            }
            boolean linHided = false;
            if (isDisplayLinChart) {
                if (indexTypeInfo.isIsCumulative() && !indexTypeInfo.isIsBalance() && !indexTypeInfo.isIsProduce()) {
                    linHided = true;
                } else {
                    chartTypes.add(2);
                    chartNames.add(this.getResourceByName(ctx, "69_LinChartName"));
                }
            }
            if (isDisplayPieChart && isUnion) {
                chartTypes.add(3);
                chartNames.add(this.getResourceByName(ctx, "70_PieChartName"));
            }
            if (chartTypes.size() > 0) {
                resultMap.put("chartTypes", chartTypes);
                resultMap.put("chartNames", chartNames);
                if (chartType == 2 && linHided) {
                    chartType = 3;
                }
            } else {
                resultMap.put(KEYS_INFOMESSAGE, this.getResourceByName(ctx, "96_no_cumu_for_linchart"));
                return resultMap;
            }
        }
        ArrayList<Integer> dataElementList = new ArrayList<Integer>();
        if (indexTypeInfo.isIsProduce()) {
            dataElementList.add(1);
        }
        if (indexTypeInfo.isIsCumulative() && chartType != 2) {
            dataElementList.add(2);
        }
        if (indexTypeInfo.isIsBalance()) {
            dataElementList.add(3);
        }
        if (!(indexTypeInfo.isIsBalance() || indexTypeInfo.isIsCumulative() || indexTypeInfo.isIsProduce())) {
            resultMap.put(KEYS_INFOMESSAGE, this.getResourceByName(ctx, "94_no_de_forindextype"));
            return resultMap;
        }
        int[] dataElement = new int[dataElementList.size()];
        for (int i = 0; i < dataElement.length; ++i) {
            dataElement[i] = (Integer)dataElementList.get(i);
        }
        String[] dataType = new String[2];
        dataType[0] = "currentAmount";
        int anaPeriod = 0;
        if (chartType == 1) {
            anaPeriod = schemeInfo.getColumnChartDispPeriods();
            dataType[1] = schemeInfo.getColumnCharDataType() == 0 ? "theSamePeriodLastYear" : "budgetAmount";
            resultMap = this.getBarChart(ctx, resultMap, schemeId, indexName, unit, factor, precision, itId, idxId, year, period, periodType, anaPeriod, dimension, longNumber, dataElement, dataType);
        } else if (chartType == 2) {
            anaPeriod = schemeInfo.getLineChartDispPeriods();
            dataType[1] = schemeInfo.getLineCharDataType() == 0 ? "theSamePeriodLastYear" : "budgetAmount";
            resultMap = this.getBarChart(ctx, resultMap, schemeId, indexName, unit, factor, precision, itId, idxId, year, period, periodType, anaPeriod, dimension, longNumber, dataElement, dataType);
        } else if (chartType == 3) {
            anaPeriod = schemeInfo.getPieCharCompTops();
            return this.getPieChart(ctx, resultMap, schemeId, indexName, unit, factor, precision, itId, idxId, year, period, periodType, anaPeriod, dimension, treeId, dataElement, longNumber);
        }
        return resultMap;
    }

    private Map getBarChart(Context ctx, Map resultMap, String schemeId, String indexName, String unit, double factor, int precision, String itId, String idxId, int year, int period, int periodType, int anaPeriod, int dimension, String orgLongNumber, int[] dataElement, String[] dataType) throws BOSException, EASBizException {
        String[] dtParam = new String[dataType.length + 1];
        for (int i = 0; i < dataType.length; ++i) {
            dtParam[i] = dataType[i];
        }
        dtParam[dataType.length] = DCAmountEnum.theSamePeriodLastYear.getName().equals(dataType[1]) ? "yoyGrowthRate" : "bgCompletionRate";
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("SELECT DISTINCT d.FDataType, d.FDataElement, d.FIndexAnalysisId, d.FYear,d.FPeriod,");
        buffer.append("   CASE WHEN FSpecialValue IS NULL THEN TOCHAR(FAmount) ELSE FSpecialValue END FAmount");
        buffer.append("  FROM T_CSL_IndexAnalysisData d");
        buffer.append(" WHERE d.FIndexTypeid = ?", (Object)itId);
        buffer.append("   AND d.FIndexAnalysisId = ?", (Object)idxId);
        buffer.append("   AND (").append(this.getWhereSql(year, period, anaPeriod, dimension, "d") + ")");
        buffer.append("   AND d.FPeriodType = ?", (Object)periodType);
        buffer.append("   AND d.FOrgLongNumber = ?", (Object)orgLongNumber);
        buffer.append("   AND d.FDataElement IN ", dataElement);
        buffer.append("   AND d.FDataType IN ", dtParam);
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            this.debug(buffer, "getBarChart:" + this.getHardCodingSettingResourceByName(ctx, "7_graphData"));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
            String key = "";
            while (rs.next()) {
                key = rs.getInt("FYear") + "_" + rs.getInt("FPeriod") + "_" + rs.getInt("FDataelement") + "_" + rs.getString("FDatatype") + "";
                dataMap.put(key, rs.getString("FAmount"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList deList = new ArrayList();
        resultMap.put("deList", deList);
        for (int i = 0; i < dataElement.length; ++i) {
            int de = dataElement[i];
            HashMap<String, Object> map = new HashMap<String, Object>();
            deList.add(map);
            map.put("caption", indexName + "(" + IndexDataElementEnum.getEnum(de).getAlias() + ")");
            map.put("subCaption", this.getResourceByName(ctx, "71_UnitName") + "\uff1a" + unit);
            String[][] category = this.getCategory(ctx, year, period, anaPeriod, dimension);
            map.put("category", category[0]);
            String[] seriesname = new String[dataType.length];
            for (int j = 0; j < dataType.length; ++j) {
                seriesname[j] = this.mobileUtil.getFormatDataTypeName(ctx, de, dataType[j]);
            }
            map.put("seriesname", seriesname);
            ArrayList data = new ArrayList();
            map.put("data", data);
            Object temp = null;
            for (int j = 0; j < dataType.length; ++j) {
                String dt = dataType[j];
                ArrayList<String> categoryList = new ArrayList<String>();
                String amount = "";
                for (int k = 0; k < anaPeriod; ++k) {
                    String key = category[1][k] + "_" + category[2][k] + "_" + de + "_" + dt;
                    temp = dataMap.get(key);
                    amount = temp != null && !this.na.equalsIgnoreCase(temp.toString()) ? this.formatAmount(ctx, temp.toString(), dt, factor, precision) : "0";
                    categoryList.add(amount);
                }
                data.add(categoryList);
            }
            ArrayList table = new ArrayList();
            map.put(KEYS_TABLE, table);
            ArrayList<String> headList = new ArrayList<String>();
            table.add(headList);
            String[][] columns = this.getColumns(ctx, de, dataType, seriesname, dimension);
            for (int j = 0; j < columns[0].length; ++j) {
                headList.add(columns[1][j]);
            }
            ArrayList bodyList = new ArrayList();
            table.add(bodyList);
            for (int j = 0; j < anaPeriod; ++j) {
                ArrayList<String> row = new ArrayList<String>();
                bodyList.add(row);
                for (int k = 0; k < columns[0].length; ++k) {
                    String value = "";
                    if (k == 0) {
                        value = category[0][j];
                    } else if (k == 1 || k == 2) {
                        String key = category[1][j] + "_" + category[2][j] + "_" + de + "_" + dataType[k - 1];
                        value = this.formatAmount(ctx, dataMap.get(key), dataType[k - 1], factor, precision);
                    } else {
                        String dt = "";
                        dt = DCAmountEnum.theSamePeriodLastYear.getName().equals(dataType[1]) ? "yoyGrowthRate" : "bgCompletionRate";
                        String key = category[1][j] + "_" + category[2][j] + "_" + de + "_" + dt;
                        value = this.formatAmount(ctx, dataMap.get(key), dt, factor, precision);
                    }
                    row.add(value);
                }
            }
        }
        return resultMap;
    }

    private Map getPieChart(Context ctx, Map resultMap, String schemeId, String indexName, String unit, double factor, int precision, String itId, String idxId, int year, int period, int periodType, int anaPeriod, int dimension, String treeId, int[] dataElement, String longNumber) throws BOSException, EASBizException {
        String dt;
        int de;
        int level = this.getLevelByLongNumber(longNumber);
        StringBuffer osql = new StringBuffer("SELECT id, longnumber, unit.simpleName, unit.name");
        osql.append(" WHERE level=" + (level + 1));
        osql.append("   AND tree.Id='" + treeId + "'");
        osql.append(" ORDER BY longnumber ");
        OrgStructureCollection orgStructureCollection = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(osql.toString());
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("SELECT DISTINCT d.FOrgName, d.FOrgLongNumber, d.FDataElement, d.FDataType, d.FIndexAnalysisId, d.FAmount");
        buffer.append("  FROM T_CSL_IndexAnalysisData d");
        buffer.append(" WHERE d.FIndexTypeId = ?", (Object)itId);
        buffer.append("   AND d.FIndexAnalysisId = ?", (Object)idxId);
        buffer.append("   AND d.FYear =?", (Object)year);
        buffer.append("   AND d.FPeriod =?", (Object)period);
        buffer.append("   AND d.FPeriodType =?", (Object)periodType);
        buffer.append("   AND d.FDataElement in ", dataElement);
        buffer.append("\t  AND d.FDataType in", new String[]{"currentAmount", "yearBeginAmount"});
        buffer.append("   AND d.FOrgLevel=?", (Object)(level + 1));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            this.debug(buffer, "getPieChart:" + this.getHardCodingSettingResourceByName(ctx, "8_baseData"));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
            String key = "";
            String amount = "";
            while (rs.next()) {
                de = rs.getInt("FDataElement");
                dt = rs.getString("FDataType");
                String number = rs.getString("FOrgLongNumber");
                key = de + "_" + dt + "_" + number;
                dataMap.put(key, rs.getString("FAmount"));
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPieChart", (Throwable)e);
        }
        ArrayList deList = new ArrayList();
        resultMap.put("deList", deList);
        boolean isMore = false;
        for (int d = 0; d < dataElement.length; ++d) {
            Map<String, String> map;
            de = dataElement[d];
            dt = "currentAmount";
            if (!isMore && de == 3) {
                isMore = true;
                --d;
            } else if (isMore) {
                dt = "yearBeginAmount";
                isMore = false;
            }
            HashMap<String, Object> deMap = new HashMap<String, Object>();
            ArrayList<Map<String, String>> orgList = new ArrayList<Map<String, String>>();
            for (int i = 0; i < orgStructureCollection.size(); ++i) {
                OrgStructureInfo info = orgStructureCollection.get(i);
                String unitName = info.getUnit().getName();
                String simpName = info.getUnit().getSimpleName();
                if (!StringUtils.isEmpty((String)simpName)) {
                    unitName = simpName;
                }
                map = new HashMap<String, String>();
                map.put("longNumber", info.getLongNumber());
                map.put("orgName", unitName);
                String key = de + "_" + dt + "_" + info.getLongNumber();
                Object amount = dataMap.get(key);
                if (amount == null) {
                    map.put("amount", this.na);
                } else {
                    map.put("amount", amount.toString());
                }
                orgList.add(map);
            }
            Collections.sort(orgList, new Comparator<Map>(){

                @Override
                public int compare(Map o1, Map o2) {
                    double d2;
                    double d1;
                    String amount1 = o1.get("amount").toString();
                    String amount2 = o2.get("amount").toString();
                    if (IndexAnalysisFacadeControllerBean.this.na.equals(amount1)) {
                        amount1 = "0";
                    }
                    if (IndexAnalysisFacadeControllerBean.this.na.equals(amount2)) {
                        amount2 = "0";
                    }
                    if ((d1 = Double.valueOf(amount1).doubleValue()) == (d2 = Double.valueOf(amount2).doubleValue())) {
                        String l1 = o1.get("longNumber").toString();
                        String l2 = o2.get("longNumber").toString();
                        return l1.compareTo(l2);
                    }
                    return d2 > d1 ? 1 : -1;
                }
            });
            double sum = 0.0;
            boolean existAmount = false;
            for (int i = 0; i < orgList.size(); ++i) {
                map = (Map)orgList.get(i);
                String amount = map.get("amount").toString();
                if (this.na.equals(amount)) continue;
                double v = Double.valueOf(amount);
                if (v != 0.0) {
                    existAmount = true;
                }
                sum += v;
            }
            if (!existAmount) continue;
            ArrayList<Object> lables = new ArrayList<Object>();
            ArrayList<String> values = new ArrayList<String>();
            deMap.put("lables", lables);
            deMap.put("values", values);
            int size = orgList.size();
            if (anaPeriod > size) {
                anaPeriod = size;
            }
            double anaSum = 0.0;
            for (int i = 0; i < anaPeriod; ++i) {
                Map orgMap = (Map)orgList.get(i);
                lables.add(orgMap.get("orgName"));
                String amount = (String)orgMap.get("amount");
                if (this.na.equals(amount)) {
                    values.add(this.na);
                    continue;
                }
                anaSum += Double.valueOf(amount).doubleValue();
                values.add(amount);
            }
            if (size > anaPeriod && sum - anaSum > 0.0) {
                lables.add(this.getResourceByName(ctx, "75_OtherName"));
                double otherSum = sum - anaSum;
                values.add(otherSum + "");
            }
            deMap.put("caption", indexName + "(" + IndexDataElementEnum.getEnum(de).getAlias() + ")");
            deMap.put("subCaption", this.getResourceByName(ctx, "71_UnitName") + "\uff1a" + unit);
            ArrayList table = new ArrayList();
            deMap.put(KEYS_TABLE, table);
            ArrayList<String> headList = new ArrayList<String>();
            table.add(headList);
            headList.add(this.getResourceByName(ctx, "72_OrgName"));
            headList.add(this.mobileUtil.getFormatDataTypeName(ctx, de, dt));
            headList.add(this.getResourceByName(ctx, "73_RateName"));
            ArrayList bodyList = new ArrayList();
            table.add(bodyList);
            for (int j = 0; j < anaPeriod; ++j) {
                ArrayList<Object> row = new ArrayList<Object>();
                bodyList.add(row);
                Map orgMap = (Map)orgList.get(j);
                row.add(orgMap.get("orgName"));
                String key = de + "_" + dt + "_" + (String)orgMap.get("longNumber");
                row.add(this.formatAmount(ctx, (String)dataMap.get(key), "currentAmount", factor, precision));
                row.add(this.divide(dataMap.get(key), sum + "", factor, precision));
            }
            if (size > anaPeriod && sum - anaSum > 0.0) {
                ArrayList<String> row = new ArrayList<String>();
                bodyList.add(row);
                row.add(this.getResourceByName(ctx, "75_OtherName"));
                row.add(this.formatAmount(ctx, sum - anaSum, "currentAmount", factor, precision));
                row.add(this.divide(sum - anaSum, sum + "", factor, precision));
            }
            deList.add(deMap);
        }
        if (deList.size() == 0) {
            resultMap.put(KEYS_ERRORMESSAGE, this.getResourceByName(ctx, "93_no_data_forpie"));
        }
        return resultMap;
    }

    private String divide(Object amount, Object amount2, double factor, int precision) {
        String result = "0";
        if (amount == null || amount2 == null) {
            return "N/A";
        }
        if ("0".equals(amount2.toString())) {
            return "N/A";
        }
        try {
            Double.parseDouble(amount.toString());
            Double.parseDouble(amount2.toString());
        }
        catch (Exception e) {
            return result;
        }
        double d1 = Double.parseDouble(amount.toString());
        double d2 = Double.parseDouble(amount2.toString());
        double d = d1 / d2;
        BigDecimal temp = new BigDecimal(d);
        temp = temp.multiply(new BigDecimal(100));
        temp = temp.setScale(precision, RoundingMode.HALF_UP);
        result = temp.toString() + "%";
        return result;
    }

    private String[][] getColumns(Context ctx, int dataElement, String[] dataType, String[] seriesname, int dimension) {
        String[][] columns = new String[2][4];
        String col0 = "";
        col0 = 3 == dimension ? IndexTypeDimension.quater.getAlias() : (2 == dimension ? IndexTypeDimension.year.getAlias() : IndexTypeDimension.month.getAlias());
        String col1 = seriesname[0];
        String col2 = seriesname[1];
        String col3 = "";
        col3 = DCAmountEnum.theSamePeriodLastYear.getName().equals(dataType[1]) ? this.mobileUtil.getFormatDataTypeName(ctx, dataElement, "yoyGrowthRate") : this.mobileUtil.getFormatDataTypeName(ctx, dataElement, "bgCompletionRate");
        columns[0][0] = "col0";
        columns[0][1] = "col1";
        columns[0][2] = "col2";
        columns[0][3] = "col3";
        columns[1][0] = col0;
        columns[1][1] = col1;
        columns[1][2] = col2;
        columns[1][3] = col3;
        return columns;
    }

    private String[][] getCategory(Context ctx, int year, int period, int anaPeriod, int dimension) {
        String[][] arr = new String[3][anaPeriod];
        String label = "";
        int y = 0;
        int m = 0;
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, period - 1);
        if (3 == dimension) {
            c.add(2, -anaPeriod * 3);
        } else if (2 == dimension) {
            c.add(1, -anaPeriod);
        } else {
            c.add(2, -anaPeriod);
        }
        for (int i = 0; i < anaPeriod; ++i) {
            if (1 == dimension) {
                c.add(2, 1);
                m = c.get(2) + 1;
                label = String.valueOf(m) + IndexTypeDimension.month.getAlias();
            } else if (2 == dimension) {
                c.add(1, 1);
                y = c.get(1);
                m = c.get(2) + 1;
                label = String.valueOf(y).substring(2) + IndexTypeDimension.year.getAlias();
            } else {
                c.add(2, 3);
                m = c.get(2) + 1;
                label = String.valueOf((int)Math.ceil((double)m / 3.0)) + IndexTypeDimension.quater.getAlias();
            }
            y = c.get(1);
            arr[0][i] = label;
            arr[1][i] = y + "";
            arr[2][i] = m + "";
        }
        return arr;
    }

    private IndexTypeCollection getIndexTypeInfoBySchemId(Context ctx, String schemeId) throws BOSException, EASBizException {
        IndexTypeCollection col = new IndexTypeCollection();
        String local = ctx.getLocale().toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append("SELECT DISTINCT it.FId, it.FNumber, it.FName_").append(local).append(" FName, it.FActor, it.FPrecision, it.FOrgboundid, it.FDimension, it.FUnit_").append(local).append(" FUnit, it.FLastCalcTime \n");
        buffer.append("  FROM T_CSL_IndexAnalysisScheme schm \n");
        buffer.append("  JOIN T_CSL_IndexAnalysisSchemeEntry e ON schm.fid=e.fschemeid \n");
        buffer.append("  JOIN T_CSL_IndexType it ON it.FId=e.FIndexTypeId \n");
        buffer.append(" WHERE schm.FId=?");
        buffer.append(" ORDER BY it.FNumber");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])new String[]{schemeId});
            while (rs.next()) {
                IndexTypeInfo info = new IndexTypeInfo();
                info.setId(BOSUuid.read((String)rs.getString("FId")));
                info.setName(rs.getString("FName"));
                info.setFactor(rs.getDouble("Factor"));
                info.setPrecision(rs.getInt("FPrecision"));
                info.setUnit(rs.getString("FUnit"));
                info.setDimension(IndexTypeDimension.getEnum(rs.getInt("FDimension")));
                info.setLastCalcTime(rs.getTimestamp("FLastCalcTime"));
                OrgTreeInfo treeInfo = new OrgTreeInfo();
                treeInfo.setId(BOSUuid.read((String)rs.getString("FOrgboundId")));
                info.setOrgBound(treeInfo);
                col.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map saveSort(Context ctx, String userId, String schemeId, List indexTypeIds) throws SQLDataException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (indexTypeIds == null || indexTypeIds.size() == 0) {
            resultMap.put("key_state", "FAIL");
            return resultMap;
        }
        Connection cn = null;
        PreparedStatement ps = null;
        SQLBuilder builder = new SQLBuilder();
        builder.append("DELETE FROM T_CSL_IndexType_Sort ");
        builder.append(" WHERE FUserId = ?", (Object)userId);
        builder.append("   AND FSchemeId=?", (Object)schemeId);
        try {
            DbUtil.execute((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
        }
        catch (BOSException e) {
            resultMap.put("key_state", "FAIL");
            logger.error((Object)e.getMessage(), (Throwable)e);
            return resultMap;
        }
        builder.reset();
        builder.append(" INSERT INTO T_CSL_IndexType_Sort \n");
        builder.append(" (FID, FUserId, FSchemeId, FIndexTypeId, FSeq) \n");
        builder.append(" VALUES (?, ?, ?, ?, ?);");
        try {
            cn = super.getConnection(ctx);
            ps = cn.prepareStatement(builder.toString());
            int index = 0;
            for (int i = 0; i < indexTypeIds.size(); ++i) {
                index = 1;
                ps.setObject(index++, Uuid.create().toString());
                ps.setObject(index++, userId);
                ps.setObject(index++, schemeId);
                ps.setObject(index++, indexTypeIds.get(i));
                ps.setObject(index++, i + 1);
                ps.addBatch();
            }
            ps.executeBatch();
            resultMap.put("key_state", "SUCCESS");
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                resultMap.put("key_state", "FAIL");
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)cn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)ps, (Connection)cn);
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
        return resultMap;
    }

    @Override
    protected Map _sortIndexType(Context ctx, Map param) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String schemeId = "";
        if (param.get("schemeId") != null) {
            schemeId = param.get("schemeId").toString();
        }
        List list = null;
        if (param != null && param.get(KEYS_INDEXTYPE) != null) {
            list = (List)param.get(KEYS_INDEXTYPE);
        }
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        if (list != null) {
            this.saveSort(ctx, userId, schemeId, list);
        } else {
            SQLBuilder builder = new SQLBuilder();
            String locl = ctx.getLocale().toString();
            builder.append("SELECT DISTINCT it.FId, it.FName_").append(locl).append(" fname, s.FSeq \n");
            builder.append("  FROM T_CSL_IndexAnalysisScheme schm  \n");
            builder.append("  JOIN T_CSL_IndexAnalysisSchemeEntry e ON schm.FId = e.FSchemeId \n");
            builder.append("  LEFT JOIN T_CSL_IndexType_Sort s ON s.FSchemeId= schm.FId AND s.FIndexTypeId = e.FIndexTypeId");
            builder.append("   AND s.FUserId=?", (Object)userId);
            builder.append("  JOIN T_CSL_IndexType it ON it.FId = e.FIndexTypeId \n");
            builder.append(" WHERE schm.FId=? \n", (Object)schemeId);
            builder.append(" ORDER BY s.FSeq ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)builder.getSQL(), (Object[])builder.getParams());
            try {
                ArrayList indexTypeList = new ArrayList();
                while (rs.next()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("IndexTypeName", rs.getString("FName"));
                    map.put("IndexTypeId", rs.getString("FId"));
                    indexTypeList.add(map);
                }
                result.put(KEYS_INDEXTYPE, indexTypeList);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.put(KEYS_ERRORMESSAGE, e.getMessage());
            }
        }
        return result;
    }

    private String getResourceByName(Context ctx, String name) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.mobile.MobileCommonResource", (String)name, (Locale)ctx.getLocale());
    }

    private String getHardCodingSettingResourceByName(Context ctx, String name) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.HardCodingSettingResource", (String)name, (Locale)ctx.getLocale());
    }

    private void debug(SQLBuilder buffer, String title) {
        try {
            String kql = PsSql.getSqlWithParams((Object)buffer.getSQL(), (Object[])buffer.getParams(), (int)7, (boolean)false);
            MobileUtil.debugLog(logger, "[" + title + "]******************************************:\n" + kql);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private int[] getPeriod(int dimension, int offset) {
        int year = 0;
        int period = 0;
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        if (dimension == 3) {
            c.add(2, offset * 3);
            int month = c.get(2) + 1;
            period = (int)Math.ceil((double)month / 3.0);
        } else if (dimension == 2) {
            c.add(1, offset);
            period = 12;
        } else if (dimension == 1) {
            c.add(2, offset);
            period = c.get(2) + 1;
        }
        year = c.get(1);
        return new int[]{year, period};
    }

    private int[] getPeriod(Timestamp ts, int dimension, int offset) {
        int year = 0;
        int period = 0;
        Calendar c = Calendar.getInstance();
        if (ts == null) {
            c.setTimeInMillis(System.currentTimeMillis());
        } else {
            c.setTimeInMillis(ts.getTime());
        }
        if (dimension == 3) {
            c.add(2, offset * 3);
            int month = c.get(2) + 1;
            period = (int)Math.ceil((double)month / 3.0);
        } else if (dimension == 2) {
            c.add(1, offset);
            period = 12;
        } else if (dimension == 1) {
            c.add(2, offset);
            period = c.get(2) + 1;
        }
        year = c.get(1);
        return new int[]{year, period};
    }

    private String getTreeIdByNumberAndDate(Context ctx, Date date, String treeId) throws BOSException {
        SQLBuilder buffer = new SQLBuilder();
        Timestamp ts = new Timestamp(date.getTime());
        buffer.append("SELECT FId FROM T_ORG_Tree ");
        buffer.append(" WHERE FNumber = (SELECT FNumber FROM T_ORG_Tree WHERE FId=?)", (Object)treeId);
        buffer.append("   AND ((FStatus = 2 AND FStartDate <= ? ", (Object)ts);
        buffer.append("        AND FEndDate >= ?) ", (Object)ts);
        buffer.append("    OR (FStatus = 1 AND FStartDate <= ?))", (Object)ts);
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)buffer.toString(), (Object[])buffer.getParams());
            if (rowSet.next()) {
                return rowSet.getString("FId");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private String getTreeIdBy(Context ctx, int year, int period, int periodType, String treeId) throws BOSException {
        Date date = RPTDateUtil.getPeriodLastDate(year, period, RptPeriodTypeEnum.getEnum((int)periodType));
        return this.getTreeIdByNumberAndDate(ctx, date, treeId);
    }

    private Map getIndexCalcGuideInfo(Context ctx, int year, int period, String indexTypeId) throws EASBizException, BOSException {
        boolean is13Period = false;
        Map map = null;
        if (period == 12) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("indexTypeId", indexTypeId);
            param.put("year", year);
            param.put("period", period);
            map = IndexTypeFactory.getLocalInstance(ctx).getIndexCalcGuideInfo(param);
        }
        return map;
    }

    @Override
    protected Map _getIdxTypeDefine(Context ctx) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        String userId = ((UserInfo)ctx.get((Object)"UserInfo")).getId().toString();
        SQLBuilder buffer = new SQLBuilder();
        buffer.append("SELECT DISTINCT idxType.FId, idxType.FName_" + ctx.getLocale() + " FName, idxType.FNumber,");
        buffer.append("       CASE WHEN idxTypeUD.findextypeid IS NULL THEN 0 ELSE 1 END FIsAdded,");
        buffer.append("       idxTypeUD.FSeq FSeq");
        buffer.append("  FROM T_CSL_IndexType idxType");
        buffer.append("  JOIN T_CSL_IndexDispensed idxD ON idxType.fid = idxD.findextype and idxD.fuser=?", (Object)userId);
        buffer.append("  LEFT JOIN T_CSL_IndexType_UserDefine idxTypeUD ON idxType.fid = idxTypeUD.findextypeid");
        buffer.append("                                                AND idxTypeUD.fuserid =?", (Object)userId);
        buffer.append(" WHERE idxType.FLastCalcTime IS NOT NULL");
        buffer.append(" ORDER BY FIsAdded DESC, FSeq, FNumber");
        this.debug(buffer, "_getIdxTypeDefine: Get IndexType Define Info");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buffer.getSQL(), (Object[])buffer.getParams());
        ArrayList resultList = new ArrayList();
        try {
            HashMap<String, String> rec = null;
            while (rs.next()) {
                rec = new HashMap<String, String>();
                rec.put("id", rs.getString("FId"));
                rec.put("name", rs.getString("FName"));
                rec.put("isAdded", rs.getString("FIsAdded"));
                resultList.add(rec);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        resultMap.put("key_list", resultList);
        return resultMap;
    }
}

