/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.pa.PaReportException;
import com.kingdee.eas.fi.gr.pa.PaReportInfo;
import com.kingdee.eas.fi.gr.pa.PaRptServerUtil;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.app.AbstractPaReportControllerBean;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportTypeEnum;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class PaReportControllerBean
extends AbstractPaReportControllerBean {
    private static final long serialVersionUID = 7082733279977599968L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.pa.app.PaReportControllerBean");

    protected void recycleNumberByOrg(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
    }

    public void checktempCodeDump(Context ctx, ReportBaseInfo reportBaseInfo) throws BOSException, RptAndTempException, EASBizException {
        PaReportInfo report = (PaReportInfo)reportBaseInfo;
        if (report.getId() != null) {
            return;
        }
        if (report.getPaTemplate() == null || report.getPaTemplate().getId() == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_csl_pareport r where r.forgtreeid=? ");
        sql.append(" and r.forgunitid =? and r.fperiodtype = ? and r.fyear =? ");
        sql.append(" and r.fperiod = ? and r.fcurrencyid = ? and r.fpatemplateid = ? ");
        ArrayList<Object> params = new ArrayList<Object>(7);
        params.add(report.getOrgTree().getId().toString());
        params.add(report.getOrgUnit().getId().toString());
        params.add(new Integer(report.getPeriodType().getValue()));
        params.add(new Integer(report.getYear()));
        params.add(new Integer(report.getPeriod()));
        params.add(report.getCurrency().getId().toString());
        params.add(report.getPaTemplate().getId().toString());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params.toArray());
        try {
            if (rs.next()) {
                throw new PaReportException(PaReportException.REPORTEXIST01, new Object[]{report.getName(), report.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void checkNumber(Context ctx, ReportBaseInfo reportBaseInfo) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select fnumber from t_csl_pareport r where r.fnumber=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{reportBaseInfo.getNumber()});
        try {
            if (rs.next()) {
                throw new PaReportException(PaReportException.REPORTNUMBEREXIST01, new Object[]{reportBaseInfo.getName(), reportBaseInfo.getNumber(), reportBaseInfo.getNumber()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected int setRuleNumber(Context ctx, ReportBaseInfo baseInfo) throws EASBizException, BOSException {
        return -2;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumber(ctx, (ReportBaseInfo)model);
        this.loadTemplateInfo(ctx, (PaReportInfo)model);
        return super._addnew(ctx, model);
    }

    private void loadTemplateInfo(Context ctx, PaReportInfo report) throws BOSException {
        if (report.getPaTemplate() != null && report.getPaTemplate().getId() != null && report.getZipData() == null && report.getPaTemplate().getZipData() == null) {
            PaTemplateInfo templateInfo = PaRptServerUtil.getPaTemplateInfo(ctx, report.getPaTemplate().getId().toString());
            report.setPaTemplate(templateInfo);
            report.setZipData(templateInfo.getZipData());
            RptSheetParamCollection sheetParams = templateInfo.getSheetParam();
            if (sheetParams != null && sheetParams.size() > 0) {
                for (int j = 0; j < sheetParams.size(); ++j) {
                    sheetParams.get(j).setRelaType(ReportTypeEnum.PAREPORT);
                    sheetParams.get(j).setStatus(1);
                }
            }
            report.getSheetParam().addCollection(sheetParams);
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteForReport(ctx, pk);
        super._delete(ctx, pk, true);
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        PaReportInfo paReportInfo = (PaReportInfo)model;
        this.updateForPaReport(ctx, paReportInfo);
        super.update(ctx, pk, model);
    }

    @Override
    protected void _deleteForReport(Context ctx, IObjectPK id) throws BOSException {
    }

    @Override
    protected void _updateForPaReport(Context ctx, IObjectValue model) throws BOSException {
    }
}

