/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.pa.IPaReport;
import com.kingdee.eas.fi.gr.pa.PaReportFactory;
import com.kingdee.eas.fi.gr.pa.PaTemplateInfo;
import com.kingdee.eas.fi.gr.pa.PaTmpException;
import com.kingdee.eas.fi.gr.pa.app.AbstractPaTemplateControllerBean;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.RptAndTempException;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.util.app.DbUtil;

public class PaTemplateControllerBean
extends AbstractPaTemplateControllerBean {
    private static final long serialVersionUID = -426880720036795777L;

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        PaTemplateInfo info = this.getPaTemplateInfo(ctx, pk);
        return info.getLogInfo();
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.addForPaTmp(ctx);
        PaTemplateInfo templateInfo = (PaTemplateInfo)model;
        this.modifyTmpName(templateInfo);
        super._addnew(ctx, pk, (IObjectValue)templateInfo);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.addForPaTmp(ctx);
        PaTemplateInfo templateInfo = (PaTemplateInfo)model;
        this.modifyTmpName(templateInfo);
        IObjectPK pk = super._addnew(ctx, (IObjectValue)templateInfo);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PaTemplateInfo templateInfo = (PaTemplateInfo)model;
        this.updateForPaTmp(ctx, templateInfo);
        this.allowUpdate(ctx, pk);
        this.modifyTmpName(templateInfo);
        super._update(ctx, pk, (IObjectValue)templateInfo);
    }

    private boolean allowUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        PaTemplateInfo objectBaseInfo = this.getPaTemplateInfo(ctx, pk, sic);
        if (objectBaseInfo == null) {
            throw new PaTmpException(PaTmpException.TEMPLATEREMOVEDCANNOTUPDATE);
        }
        return true;
    }

    private void modifyTmpName(PaTemplateInfo templateInfo) {
        String name = templateInfo.getName();
        if (name != null && name.length() > 80) {
            templateInfo.setName(name.substring(0, 80));
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.deleteForPaTmp(ctx, pk);
        this.deleteCommCheck(ctx, pk);
        this.delPaTemplateDispenseRecord(ctx, pk);
        this.delAttach(ctx, pk);
        this.delTemplateAttach(ctx, pk);
        super._delete(ctx, pk);
    }

    private void delPaTemplateDispenseRecord(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("delete from t_csl_paTemplateDispense where");
        _sql.append(" FdispenseSrcid = ?");
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    protected void delAttach(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IRptSheetParam iRptSheetParam = RptSheetParamFactory.getLocalInstance((Context)ctx);
        iRptSheetParam.delForReport(pk);
    }

    protected void delTemplateAttach(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer _sql = new StringBuffer("delete from t_rpt_rptOrgRela where");
        _sql.append(" Freportid= ?");
        Object[] params = new Object[]{pk.toString()};
        DbUtil.execute((Context)ctx, (String)_sql.toString(), (Object[])params);
    }

    private void deleteCommCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("paTemplate.id", (Object)pk.toString());
        filter.getFilterItems().add(filterItem);
        IPaReport iReport = PaReportFactory.getLocalInstance(ctx);
        boolean isExist = iReport.exists(filter);
        if (isExist) {
            throw new RptAndTempException(RptAndTempException.HASREPORTNODELETE);
        }
    }

    @Override
    protected void _addForPaTmp(Context ctx) throws BOSException {
    }

    @Override
    protected void _deleteForPaTmp(Context ctx, IObjectPK id) throws BOSException {
    }

    @Override
    protected void _updateForPaTmp(Context ctx, IObjectValue model) throws BOSException {
    }
}

