/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.pa.rptguide;

import com.kingdee.eas.fi.gr.cslrpt.DataElementInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.util.StringUtils;
import java.io.Serializable;

public class ItemTabInfo
implements Serializable {
    private static final long serialVersionUID = 3927841281243191992L;
    private static final String SPILT = "##";
    DataElementInfo dataElementInfo;
    RPTItemInfo itemInfo;
    ValueTypeEnum valueType = ValueTypeEnum.MONEY;

    public ItemTabInfo() {
    }

    public ItemTabInfo(RPTItemInfo itemInfo, DataElementInfo dataElementInfo) {
        this.itemInfo = itemInfo;
        this.dataElementInfo = dataElementInfo;
    }

    public DataElementInfo getDataElementInfo() {
        return this.dataElementInfo;
    }

    public void setDataElementInfo(DataElementInfo dataElementInfo) {
        this.dataElementInfo = dataElementInfo;
    }

    public RPTItemInfo getRPTItemInfo() {
        return this.itemInfo;
    }

    public void setRPTItemInfo(RPTItemInfo itemInfo) {
        this.itemInfo = itemInfo;
    }

    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public String getId() {
        return this.itemInfo.getId().toString() + this.dataElementInfo.getNumber() + this.valueType.getValue();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.itemInfo.getId().toString()).append(SPILT);
        str.append(this.itemInfo.getName()).append(SPILT);
        str.append(this.itemInfo.getNumber()).append(SPILT);
        str.append(this.dataElementInfo.getNumber()).append(SPILT);
        str.append(this.valueType.getValue());
        return str.toString();
    }

    public static ItemTabInfo parse(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        ItemTabInfo info = new ItemTabInfo();
        String[] s = str.split(SPILT);
        RPTItemInfo itemInfo = new RPTItemInfo();
        itemInfo.put("id", s[0]);
        itemInfo.setName(s[1]);
        itemInfo.setNumber(s[2]);
        info.setRPTItemInfo(itemInfo);
        info.setDataElementInfo(DataElementProvider.getDataElementInfo(s[3]));
        info.setValueType(ValueTypeEnum.getEnum(Integer.valueOf(s[4])));
        return info;
    }
}

