/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.dynamic.fill.FormulaFilterInfo;
import com.kingdee.eas.fi.rpt.CashTypeEnum;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.PeriodHandler;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.util.SysUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.utils.StringUtils;
import org.apache.log4j.Logger;

public class DynaItemFormulaParse {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.rptintegration.util.DynaItemFormulaParse");
    private Context _ctx;
    private Map<String, String> formulas;
    private int _year;
    private int _period;
    private OrgUnitInfo _company;
    private String _currencyNumber;
    private int _periodType;
    private Map<String, List<FormulaFilterInfo>> acctFormulasGroupMap;
    private Map<String, Map<String, List<FormulaFilterInfo>>> acctCashformulaFilterGroupMap;
    private boolean isMergeByFiscalPeriod = false;
    private PeriodCollection periodColl;

    public DynaItemFormulaParse(Context ctx, Map<String, String> formulas, int year, int period, OrgUnitInfo company, String currencyNumber, int periodType) {
        this._ctx = ctx;
        this.formulas = formulas;
        this._year = year;
        this._period = period;
        this._currencyNumber = currencyNumber;
        this._company = company;
        this._periodType = periodType;
        this.acctFormulasGroupMap = new HashMap<String, List<FormulaFilterInfo>>();
        this.acctCashformulaFilterGroupMap = new HashMap<String, Map<String, List<FormulaFilterInfo>>>();
    }

    public void formulaParse() {
        if (this.formulas == null || this.formulas.isEmpty()) {
            return;
        }
        for (String formulaId : this.formulas.keySet()) {
            FormulaFilterInfo filterInfo = null;
            String formula = this.formulas.get(formulaId);
            ArrayList<FormulaHint> celleformulaExprList = new ArrayList<FormulaHint>();
            this.expandExpress(formula, celleformulaExprList);
            this.removeDuble(celleformulaExprList);
            for (FormulaHint hint : celleformulaExprList) {
                String cashFlowNumber;
                String accountNumber;
                if (hint.name.equalsIgnoreCase("ACCT")) {
                    accountNumber = hint.params[1];
                    if (StringUtils.isEmpty((String)accountNumber)) continue;
                    filterInfo = new FormulaFilterInfo();
                    filterInfo.setFormulaId(formulaId);
                    this.setFormulaFilterInfo(filterInfo, accountNumber, hint.params[0], hint.params[7], hint.params[3], hint.params[4], hint.params[5], hint.params[6], hint.params[2], hint.name);
                    this.putFilter(null, filterInfo, this.acctFormulasGroupMap);
                    continue;
                }
                if (hint.name.equalsIgnoreCase("ACCTAC")) {
                    accountNumber = hint.params[2];
                    if (StringUtils.isEmpty((String)accountNumber)) continue;
                    accountNumber = accountNumber.split("\\|")[0];
                    filterInfo = new FormulaFilterInfo();
                    filterInfo.setFormulaId(formulaId);
                    this.setFormulaFilterInfo(filterInfo, accountNumber, hint.params[0], hint.params[8], hint.params[4], hint.params[5], hint.params[6], hint.params[7], hint.params[3], hint.name);
                    this.putFilter(null, filterInfo, this.acctFormulasGroupMap);
                    continue;
                }
                if (!hint.name.equalsIgnoreCase("ACCTCASH") || StringUtils.isEmpty((String)(cashFlowNumber = hint.params[6]))) continue;
                filterInfo = new FormulaFilterInfo();
                filterInfo.setFormulaId(formulaId);
                CashTypeEnum cashType = hint.params[1] == null ? null : CashTypeEnum.getEnum((String)hint.params[1].toUpperCase());
                String key = cashType == null || !CashTypeEnum.AS.equals((Object)cashType) && !CashTypeEnum.AZ.equals((Object)cashType) ? "1" : "0";
                this.setFormulaFilterInfo(filterInfo, cashFlowNumber, hint.params[0], hint.params[2], hint.params[3], hint.params[4], hint.params[3], hint.params[5], hint.params[1], hint.name);
                this.putFilter(key, filterInfo, this.acctCashformulaFilterGroupMap);
            }
        }
    }

    protected void putFilter(String key, FormulaFilterInfo filterInfo, Map map) {
        if (!StringUtils.isEmpty((String)key)) {
            ArrayList<FormulaFilterInfo> filters;
            HashMap<String, ArrayList<FormulaFilterInfo>> filterMap = (HashMap<String, ArrayList<FormulaFilterInfo>>)map.get(filterInfo.getAsstactTypeNumber());
            if (filterMap == null) {
                filterMap = new HashMap<String, ArrayList<FormulaFilterInfo>>();
                map.put(filterInfo.getAsstactTypeNumber(), filterMap);
            }
            if ((filters = (ArrayList<FormulaFilterInfo>)filterMap.get(key)) == null) {
                filters = new ArrayList<FormulaFilterInfo>();
                filterMap.put(key, filters);
            }
            filters.add(filterInfo);
        } else {
            ArrayList<FormulaFilterInfo> filters = (ArrayList<FormulaFilterInfo>)map.get(filterInfo.getAsstactTypeNumber());
            if (filters == null) {
                filters = new ArrayList<FormulaFilterInfo>();
                map.put(filterInfo.getAsstactTypeNumber(), filters);
            }
            filters.add(filterInfo);
        }
    }

    private boolean setFormulaFilterInfo(FormulaFilterInfo filterInfo, String accountNumber, String orgUnitNumber, String currencyNumber, String startYear, String startPeriod, String endYear, String endPeriod, String balanceType, String hintName) {
        if (!this.setFormulaAccount(filterInfo, accountNumber)) {
            return false;
        }
        if ("ACCTCASH".equalsIgnoreCase(hintName)) {
            accountNumber = accountNumber.split("\\|")[0];
            filterInfo.setCashFlowNumber(accountNumber);
        } else {
            String[] accounts = (accountNumber = accountNumber.split("\\|")[0]).split(":");
            if (accounts.length > 1) {
                filterInfo.setStartAccount(accounts[0]);
                filterInfo.setEndAccount(accounts[1]);
            } else {
                filterInfo.setStartAccount(accountNumber);
                filterInfo.setEndAccount(accountNumber);
            }
        }
        if (!StringUtils.isEmpty((String)orgUnitNumber)) {
            filterInfo.setCompanyNumber(orgUnitNumber);
        } else {
            filterInfo.setCompanyNumber(this._company.getNumber());
        }
        if (!StringUtils.isEmpty((String)currencyNumber)) {
            filterInfo.setCurrency(currencyNumber);
        } else {
            filterInfo.setCurrency(this._currencyNumber);
        }
        filterInfo.setPeriodType(balanceType);
        int[] startYearPeriod = this.getYearAndPeriod(Integer.parseInt(startYear), Integer.parseInt(startPeriod), true);
        int[] endYearPeriod = this.getYearAndPeriod(Integer.parseInt(endYear), Integer.parseInt(endPeriod), false);
        filterInfo.setStartYear(String.valueOf(startYearPeriod[0]));
        filterInfo.setStartPeriod(String.valueOf(startYearPeriod[1]));
        filterInfo.setEndYear(String.valueOf(endYearPeriod[0]));
        filterInfo.setEndPeriod(String.valueOf(endYearPeriod[1]));
        return true;
    }

    protected boolean setFormulaAccount(FormulaFilterInfo filterInfo, String accountAsstNumber) {
        String[] accountAsstNumbers;
        return StringUtils.isEmpty((String)accountAsstNumber) || this.initAccountAssts(filterInfo, accountAsstNumbers = accountAsstNumber.split("\\|"));
    }

    protected boolean initAccountAssts(FormulaFilterInfo filterInfo, String[] accountAssts) {
        for (int i = 1; i <= (accountAssts.length - 1) / 2; ++i) {
            String asstType = accountAssts[i * 2 - 1];
            String asstValue = accountAssts[i * 2];
            if (StringUtils.isEmpty((String)asstValue) || asstValue.trim().indexOf("@") < 0 || StringUtils.isEmpty((String)asstType)) continue;
            filterInfo.setAsstactTypeNumber(asstType);
            return true;
        }
        return false;
    }

    private int[] getYearAndPeriod(int year, int period, boolean isStart) {
        int[] yearAndPeriod = null;
        PeriodHandler periodHandler = new PeriodHandler();
        int baseYear = this._year;
        int basePeriod = this._period;
        yearAndPeriod = periodHandler.action(year, period, baseYear, basePeriod, RptPeriodTypeEnum.getEnum((int)this._periodType), this.periodColl, this.isMergeByFiscalPeriod);
        if (this._periodType != 3) {
            yearAndPeriod = FiscalPeriodHelper.getYearAndFirstOrLastPeriodNumber(this.periodColl, yearAndPeriod[0], yearAndPeriod[1], RptPeriodTypeEnum.getEnum((int)this._periodType), this.isMergeByFiscalPeriod, isStart);
        }
        return yearAndPeriod;
    }

    private void removeDuble(List<FormulaHint> celleformulaExprList) {
        HashMap tmpMap = new HashMap();
        for (int i = celleformulaExprList.size() - 1; i >= 0; --i) {
            if (tmpMap.containsKey(celleformulaExprList.get(i).toString())) {
                celleformulaExprList.remove(i);
                continue;
            }
            tmpMap.put(celleformulaExprList.get(i).toString(), null);
        }
        tmpMap.clear();
    }

    private void expandExpress(String expression, List<FormulaHint> reslutList) {
        List formulaList = null;
        try {
            formulaList = TableToolkit.parseExcelFormula((String)expression, (boolean)true);
        }
        catch (ParserException e) {
            logger.error((Object)"expandExpress_parseExcelFormula error!");
            SysUtil.abort();
        }
        if (formulaList == null || formulaList.size() == 0) {
            logger.error((Object)"expandExpress_formulaList.size is zero!");
            SysUtil.abort();
        }
        this.expandDiscreteFormula(formulaList, reslutList);
    }

    private void expandDiscreteFormula(List expressions, List<FormulaHint> reslutList) {
        if (expressions == null) {
            return;
        }
        int size = expressions.size();
        for (int i = 0; i < size; ++i) {
            int[] paramType;
            FormulaHint hint = (FormulaHint)expressions.get(i);
            for (int x = 0; hint.params != null && x < hint.params.length && (paramType = hint.getParamType()) != null; ++x) {
                if (paramType.length < x || paramType[x] != 0) continue;
                this.handBinaryOp(hint.params[x], reslutList);
            }
            if ("acct".equalsIgnoreCase(hint.name) || "acctac".equalsIgnoreCase(hint.name)) {
                String acct = hint.params[1].toString();
                try {
                    AcctountAsstItemParser.AccountAsstItem item = AcctountAsstItemParser.parse((String)acct);
                    AcctountAsstItemParser.Range[] accounts = item.accounts;
                    if (accounts.length < 2) {
                        reslutList.add(hint);
                        continue;
                    }
                    for (int y = 0; y < accounts.length; ++y) {
                        item.startNumber = accounts[y].startNumber;
                        item.endNumber = accounts[y].endNumber;
                        FormulaHint newHint = hint.copy();
                        newHint.params[1] = item.toOldString();
                        reslutList.add(newHint);
                    }
                    continue;
                }
                catch (ParseException e) {
                    logger.error((Object)"AcctountAsstItemParser.parse error", (Throwable)e);
                    continue;
                }
            }
            if (!"acctcash".equalsIgnoreCase(hint.name)) continue;
            reslutList.add(hint);
        }
    }

    private void handBinaryOp(String expression, List<FormulaHint> reslutList) {
        try {
            if (!StringUtils.isEmpty((String)expression) && expression.toUpperCase().indexOf("ACCT") >= 0) {
                Expression exp = ExcelFormulaPaserHelper.parse((String)expression);
                if (exp instanceof BinaryOperationExpr) {
                    if (this.isIncludeAcct(((BinaryOperationExpr)exp).right)) {
                        this.expandExpress("=" + ((BinaryOperationExpr)exp).right.toString(), reslutList);
                    }
                    if (this.isIncludeAcct(((BinaryOperationExpr)exp).left)) {
                        this.expandExpress("=" + ((BinaryOperationExpr)exp).left.toString(), reslutList);
                    }
                } else if (this.isIncludeAcct(exp)) {
                    this.expandExpress("=" + exp.toString(), reslutList);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("expandDiscreteFormula error:" + expression), (Throwable)e);
        }
    }

    private boolean isIncludeAcct(Expression exp) {
        return exp != null && exp.toString().toUpperCase().indexOf("ACCT") >= 0;
    }

    public Map<String, Map<String, List<FormulaFilterInfo>>> getAcctCashformulaFilterGroupMap() {
        return this.acctCashformulaFilterGroupMap;
    }

    public Map<String, List<FormulaFilterInfo>> getAcctFormulasGroupMap() {
        return this.acctFormulasGroupMap;
    }
}

