/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.rptintegration.util;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SQLType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.rptintegration.ISubmitLog;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogCollection;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogFactory;
import com.kingdee.eas.fi.gr.rptintegration.SubmitLogInfo;
import com.kingdee.eas.fi.gr.rptintegration.SubmitStateEnum;
import com.kingdee.eas.fi.gr.rptintegration.util.SynchronizeType;
import com.kingdee.eas.fi.gr.rptintegration.util.synchronize.download.GetDatasFromDataCenterSynOperate;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptIntegrationUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.rptintegration.util.RptIntegrationUtils");

    public static void addnewBatchData(Context ctx, CoreBaseCollection colls) throws Exception {
        if (colls != null && colls.size() > 0) {
            CoreBaseInfo info = colls.get(0);
            EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(info.getBOSType());
            String tableName = entityObjectInfo.getTable().getName();
            PropertyCollection properties = entityObjectInfo.getEntityProperties();
            Map property_Column = RptIntegrationUtils.getPropertyMaps(properties)[0];
            Map property_Type = RptIntegrationUtils.getPropertyMaps(properties)[1];
            Map<String, String> linkProperty_Column = RptIntegrationUtils.getLinkPropertyColumnMap(properties);
            String pkField = entityObjectInfo.getLogicalKey().getName().toUpperCase();
            Enumeration keys = info.keys();
            String key = null;
            ArrayList<String> propertyList = new ArrayList<String>();
            while (keys.hasMoreElements()) {
                key = ((String)keys.nextElement()).toUpperCase();
                if (!property_Column.containsKey(key)) continue;
                propertyList.add(key);
            }
            if (!propertyList.isEmpty()) {
                StringBuffer columnSql = new StringBuffer();
                StringBuffer valuesSql = new StringBuffer();
                for (String curProperty : propertyList) {
                    columnSql.append((String)property_Column.get(curProperty)).append(",");
                    valuesSql.append("?,");
                }
                if (propertyList.contains(pkField)) {
                    columnSql.deleteCharAt(columnSql.lastIndexOf(","));
                    valuesSql.deleteCharAt(valuesSql.lastIndexOf(","));
                } else {
                    columnSql.append((String)property_Column.get(pkField));
                    valuesSql.append("newBosId('").append(info.getBOSType().toString()).append("')");
                }
                String sql = "insert into " + tableName + "(" + columnSql + ") values(" + valuesSql + ")";
                String linkProperty = null;
                ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
                for (int i = 0; i < colls.size(); ++i) {
                    Object[] params = new Object[propertyList.size()];
                    for (int j = 0; j < propertyList.size(); ++j) {
                        params[j] = colls.get(i).get((String)propertyList.get(j));
                        linkProperty = linkProperty_Column.get(propertyList.get(j));
                        if (linkProperty != null && params[j] != null && params[j] instanceof CoreBaseInfo) {
                            params[j] = ((CoreBaseInfo)params[j]).get(linkProperty);
                            if (params[j] == null || !(params[j] instanceof BOSUuid)) continue;
                            params[j] = params[j].toString();
                            continue;
                        }
                        params[j] = RptIntegrationUtils.typeConversion(params[j], (String)propertyList.get(j), property_Type);
                    }
                    paramsList.add(params);
                }
                if (!paramsList.isEmpty()) {
                    DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
                    if (colls.get(0) instanceof ObjectBaseInfo) {
                        RptIntegrationUtils.updateControlUnitId(ctx, tableName);
                    }
                    if (colls.get(0).containsKey("trackrecordcreator")) {
                        RptIntegrationUtils.updateOrgUnitId(ctx, tableName, "ftrackrecordcreatorId", null);
                    }
                }
            }
        }
    }

    private static Object typeConversion(Object value, String propertyName, Map<String, SQLType> property_Type) throws Exception {
        SQLType sqlType = property_Type.get(propertyName);
        Object obj = value;
        if (sqlType != null && sqlType.equals((Object)SQLType.DATETIME)) {
            obj = TypeConversionUtils.objToTimestamp((Object)value);
        }
        return obj;
    }

    private static Map[] getPropertyMaps(PropertyCollection properties) throws Exception {
        HashMap<String, String> propertyColumnMap = new HashMap<String, String>();
        HashMap<String, SQLType> propertyTypeMap = new HashMap<String, SQLType>();
        ColumnInfo columnInfo = null;
        String columnName = null;
        for (int i = 0; i < properties.size(); ++i) {
            columnInfo = properties.get(i).getMappingField();
            if (columnInfo == null) continue;
            columnName = columnInfo.getName();
            if (columnInfo.isMultilingual()) {
                for (Locale curLoacle : BOSLocaleUtil.getSupportedLocales()) {
                    propertyColumnMap.put((properties.get(i).getName() + "_" + BOSLocaleUtil.getShortCode((Locale)curLoacle)).toUpperCase(), columnName + "_" + BOSLocaleUtil.getShortCode((Locale)curLoacle));
                }
                continue;
            }
            propertyColumnMap.put(properties.get(i).getName().toUpperCase(), columnName);
            propertyTypeMap.put(properties.get(i).getName().toUpperCase(), columnInfo.getTypeName());
        }
        return new Map[]{propertyColumnMap, propertyTypeMap};
    }

    private static Map<String, String> getLinkPropertyColumnMap(PropertyCollection properties) throws Exception {
        HashMap<String, String> linkPropertyColumnMap = new HashMap<String, String>();
        PropertyInfo info = null;
        RelationshipInfo curRelation = null;
        for (int i = 0; i < properties.size(); ++i) {
            info = properties.get(i);
            if (info.getMappingField() == null || !(info instanceof LinkPropertyInfo)) continue;
            curRelation = ((LinkPropertyInfo)info).getRelationship();
            if (curRelation.getSupplierProperty().getName().toUpperCase().equals(info.getName().toUpperCase())) {
                linkPropertyColumnMap.put(info.getName().toUpperCase(), curRelation.getClientProperty().getName());
                continue;
            }
            linkPropertyColumnMap.put(info.getName().toUpperCase(), curRelation.getSupplierProperty().getName());
        }
        return linkPropertyColumnMap;
    }

    public static void updateUser(Context ctx, String tableName, String field) throws Exception {
        RptIntegrationUtils.updateUser(ctx, tableName, field, null);
    }

    public static void updateUser(Context ctx, String tableName, String field, String where) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tableName).append(" set ").append(field).append("=? ");
        sql.append(" where fid in (");
        sql.append(" select a.fid from ").append(tableName).append(" a ");
        sql.append(" left join t_pm_user b on a.").append(field).append("=b.fid ");
        sql.append(" where b.fid is null) ");
        if (!StringUtils.isEmpty((String)where)) {
            sql.append(" and ").append(where);
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{ctx.getCaller().toString()});
    }

    public static void saveSubmitLog(Context ctx, String cslRptId, SubmitStateEnum submitState, boolean isUpdateTime) throws Exception {
        SubmitLogInfo info = null;
        ISubmitLog iSubmitLog = ctx == null ? SubmitLogFactory.getRemoteInstance() : SubmitLogFactory.getLocalInstance(ctx);
        SubmitLogCollection coll = iSubmitLog.getSubmitLogCollection("select * where reportid='" + cslRptId + "'");
        if (coll != null && coll.size() > 0) {
            info = coll.get(0);
            if (isUpdateTime) {
                info.setLastUpdateTime(null);
                info.setLastUpdateUser(null);
            }
            info.setSubmitState(submitState);
            iSubmitLog.submit((CoreBaseInfo)info);
        } else {
            info = new SubmitLogInfo();
            info.setReportId(cslRptId);
            info.setSubmitState(submitState);
            iSubmitLog.addnew(info);
        }
    }

    public static void updateControlUnitId(Context ctx, String tableName) throws Exception {
        RptIntegrationUtils.updateOrgUnitId(ctx, tableName, "FCONTROLUNITID", null);
    }

    public static void updateOrgUnitId(Context ctx, String tableName, String field, String whereStr) throws Exception {
        StringBuffer curSql = new StringBuffer();
        if (tableName.toLowerCase(Locale.ENGLISH).equals("t_org_structure")) {
            curSql.append(" update ").append(tableName).append(" t set ").append(field).append("=");
            curSql.append(" (select m.fid from ").append(tableName).append(" m ");
            curSql.append("       inner join t_org_tree tree on tree.fid=m.ftreeid ");
            curSql.append("       inner join t_org_tree tree2 on tree.ftype=tree2.ftype and tree2.fid=t.ftreeid ");
            curSql.append("        where m.funitid='00000000-0000-0000-0000-000000000000CCE7AED4')");
            curSql.append("  where fid in( select a.fid from ").append(tableName).append(" a ");
            curSql.append(" left join ").append(tableName).append(" struc on struc.fid=a.").append(field);
            curSql.append(" where struc.fid is null) and ").append(field).append(" is not null ");
            if (!StringUtils.isEmpty((String)whereStr)) {
                curSql.append(" and ").append(whereStr);
            }
        } else {
            curSql.append(" update ").append(tableName).append(" set ").append(field).append("='00000000-0000-0000-0000-000000000000CCE7AED4' where fid in(");
            curSql.append(" select a.fid from ").append(tableName).append(" a ");
            curSql.append(" left join t_org_baseunit unit on unit.fid=a.").append(field);
            if (StringUtils.isEmpty((String)whereStr) || tableName.toLowerCase(Locale.ENGLISH).equals("t_org_baseunit")) {
                // empty if block
            }
            curSql.append(" where unit.fid is null) and ").append(field).append(" is not null ");
            if (!StringUtils.isEmpty((String)whereStr)) {
                curSql.append(" and ").append(whereStr);
            }
        }
        DbUtil.execute((Context)ctx, (String)curSql.toString());
    }

    public static void updateOrgUnitLongNumber(Context ctx, String tableName, String whereStr, String relateField) throws Exception {
        IRowSet rowSet;
        StringBuffer sql = new StringBuffer();
        String number = null;
        number = StringUtils.isEmpty((String)relateField) ? "sub.fnumber" : "d.fnumber";
        sql.append("select distinct sub.fid fid,parent.flongnumber fparentlongNumber,concat(concat(parent.flongnumber,'!'),").append(number).append(")  flongnumber,");
        sql.append(number).append(" fnumber,sub.fparentid,sub.flongNumber fsublongNumber ");
        sql.append(" from ").append(tableName).append(" sub ");
        sql.append(" left join ").append(tableName).append(" parent on parent.fid=sub.fparentid ");
        if (!StringUtils.isEmpty((String)relateField)) {
            sql.append(" inner join t_org_baseunit d on d.fid=sub.").append(relateField);
        }
        sql.append(" where sub.fparentid is not null ");
        if (!StringUtils.isEmpty((String)whereStr)) {
            sql.append(" and sub.").append(whereStr);
        }
        if ((rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString())) != null) {
            HashMap<String, List<String[]>> parent_units = new HashMap<String, List<String[]>>();
            ArrayList<String[]> parentErrorUnits = new ArrayList<String[]>();
            while (rowSet.next()) {
                String fparentId = rowSet.getString("fparentid");
                String flongNumber = rowSet.getString("flongnumber");
                String fsubLongNumber = rowSet.getString("fsublongNumber");
                String fparentLongNumber = rowSet.getString("fparentlongNumber");
                String fsubNumber = rowSet.getString("fnumber");
                ArrayList<String[]> units = (ArrayList<String[]>)parent_units.get(fparentId);
                if (units == null) {
                    units = new ArrayList<String[]>();
                    parent_units.put(fparentId, units);
                }
                units.add(new String[]{rowSet.getString("fid"), rowSet.getString("fnumber")});
                if (fsubLongNumber != null && fsubLongNumber.equals(fparentLongNumber + "!" + fsubNumber)) continue;
                parentErrorUnits.add(new String[]{flongNumber, rowSet.getString("fid")});
            }
            ArrayList<String[]> errorUnits = new ArrayList<String[]>();
            for (String[] parentErrorUnit : parentErrorUnits) {
                RptIntegrationUtils.handChildUnit(parentErrorUnit, errorUnits, parent_units);
            }
            errorUnits.addAll(parentErrorUnits);
            if (!errorUnits.isEmpty()) {
                DbUtil.executeBatch((Context)ctx, (String)("update " + tableName + " set flongnumber=? where fid=? "), errorUnits);
            }
        }
    }

    public static void handChildUnit(String[] parentErrorUnit, List<String[]> errorUnits, Map<String, List<String[]>> parent_units) throws Exception {
        String parentId = parentErrorUnit[1];
        String parentLongNumber = parentErrorUnit[0];
        List<String[]> childUnits = parent_units.get(parentId);
        if (childUnits != null) {
            for (String[] childUnit : childUnits) {
                String childNumber = childUnit[1];
                String childId = childUnit[0];
                String childLongNumber = parentLongNumber + "!" + childNumber;
                errorUnits.add(new String[]{childLongNumber, childId});
                RptIntegrationUtils.handChildUnit(new String[]{childLongNumber, childId}, errorUnits, parent_units);
            }
        }
    }

    public static void updateUser(Context ctx, String[] fields, CoreBaseInfo info, String dataCenterId) {
        try {
            HashMap<String, String> id_numberMap = new HashMap<String, String>();
            HashSet<String> emptyIds = new HashSet<String>();
            for (String field : fields) {
                UserInfo userInfo = (UserInfo)info.get(field);
                if (userInfo == null) continue;
                id_numberMap.put(userInfo.getId().toString(), userInfo.getNumber());
                if (!StringUtils.isEmpty((String)userInfo.getNumber())) continue;
                emptyIds.add(userInfo.getId().toString());
            }
            if (!id_numberMap.isEmpty()) {
                UserCollection coll = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id where id in(" + CslRptUtil.collection2String(id_numberMap.keySet(), ",", true) + ")");
                if (coll != null) {
                    for (int i = 0; i < coll.size(); ++i) {
                        id_numberMap.remove(coll.get(i).getId().toString());
                        emptyIds.remove(coll.get(i).getId().toString());
                    }
                }
                if (!id_numberMap.isEmpty()) {
                    GetDatasFromDataCenterSynOperate sysOperate;
                    List dataList;
                    if (dataCenterId != null && !emptyIds.isEmpty() && (dataList = (sysOperate = (GetDatasFromDataCenterSynOperate)SynchronizeType.getSynType2HandleObject().get(SynchronizeType.getDatasFromDataCenter)).getDatasFromDataCenter(ctx, "select fnumber,fid from t_pm_user where fid in(" + CslRptUtil.collection2String(emptyIds, ",", true) + ")", dataCenterId, UserInfo.class.getName())) != null) {
                        for (Object obj : dataList) {
                            id_numberMap.put(((UserInfo)obj).getId().toString(), ((UserInfo)obj).getNumber());
                        }
                    }
                    coll = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id,number where number in(" + CslRptUtil.collection2String(id_numberMap.values(), ",", true) + ")");
                    HashMap<String, String> number_idMap = new HashMap<String, String>();
                    if (coll != null) {
                        for (int i = 0; i < coll.size(); ++i) {
                            number_idMap.put(coll.get(i).getNumber(), coll.get(i).getId().toString());
                        }
                    }
                    HashMap<String, String> oldId_newIdMap = new HashMap<String, String>();
                    for (String key : id_numberMap.keySet()) {
                        String newId = null;
                        if (!StringUtils.isEmpty((String)((String)id_numberMap.get(key)))) {
                            newId = (String)number_idMap.get(id_numberMap.get(key));
                        }
                        if (StringUtils.isEmpty(newId)) {
                            newId = ctx.getCaller().toString();
                        }
                        oldId_newIdMap.put(key, newId);
                    }
                    for (Iterator<Object> iterator : fields) {
                        String newId;
                        UserInfo userInfo = (UserInfo)info.get(iterator);
                        if (userInfo == null || StringUtils.isEmpty((String)(newId = (String)oldId_newIdMap.get(userInfo.getId().toString())))) continue;
                        userInfo.setId(BOSUuid.read((String)newId));
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"updateUser error.", (Throwable)e);
        }
    }
}

