/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.job.app.JobServiceUIFacade;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class JobServerRunningConfig {
    private static final Logger logger = Logger.getLogger(JobServerRunningConfig.class);
    private final String loadbalanceFile = "/server/cluster/ormrpc_loadbalance.properties";
    private Map serverMap = null;

    public JobServerRunningConfig() {
        this.loadClusterConfig();
    }

    public String getServer(Context ctx) throws BOSException {
        String server = JobServerRunningConfig.getRptWeaveSetServer(ctx);
        if (!StringUtils.isEmpty((String)server)) {
            return server;
        }
        ArrayList allSevList = new JobServiceUIFacade(ctx).getJobServiceInstanceKeys();
        server = this.getUserDefineServer(ctx, allSevList);
        if (!StringUtils.isEmpty((String)server)) {
            return server;
        }
        if ((this.serverMap == null || this.serverMap.isEmpty()) && allSevList.size() > 0) {
            SecureRandom rd = new SecureRandom();
            int index = rd.nextInt(allSevList.size());
            if (index >= allSevList.size()) {
                index %= allSevList.size();
            }
            return allSevList.get(index).toString();
        }
        SecureRandom r = new SecureRandom();
        ArrayList serverList = new ArrayList(this.serverMap.entrySet());
        int idx = r.nextInt(serverList.size());
        if (idx >= serverList.size()) {
            idx %= serverList.size();
        }
        if (allSevList.contains(server = (String)((Map.Entry)serverList.get(idx)).getKey())) {
            return server;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadClusterConfig() {
        String clusterPath;
        File file;
        if (this.serverMap == null) {
            this.serverMap = new HashMap();
        }
        if (!(file = new File(FilenameUtils.normalize((String)(clusterPath = System.getProperty("EAS_HOME") + "/server/cluster/ormrpc_loadbalance.properties")))).exists()) {
            logger.info((Object)"ormrpc_loadbalance.properties not exists");
            return;
        }
        Properties propertie = new Properties();
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(file);
            propertie.load(inputFile);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"ormrpc_loadbalance.properties not found", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"ormrpc_loadbalance.properties load failded", (Throwable)e);
        }
        finally {
            if (null != inputFile) {
                try {
                    inputFile.close();
                }
                catch (IOException e) {
                    logger.error((Object)"close file  failded! ", (Throwable)e);
                }
            }
        }
        try {
            this.initServerMap(propertie);
        }
        catch (Exception e) {
            logger.error((Object)"ormrpc_loadbalance.properties  is error", (Throwable)e);
        }
    }

    private void initServerMap(Properties propertie) {
        Iterator<Map.Entry<Object, Object>> iterator = propertie.entrySet().iterator();
        ArrayList<String> nameList = new ArrayList<String>();
        String expression = "loadbalance.\\d+.name";
        Pattern p = Pattern.compile(expression);
        Matcher m = null;
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> e = iterator.next();
            m = p.matcher(e.getKey().toString());
            if (!m.find()) continue;
            nameList.add(e.getKey().toString());
        }
        for (int i = 0; i < nameList.size(); ++i) {
            String serverName = (String)nameList.get(i);
            String serverTcpStr = (String)propertie.get(serverName.replace(".name", ""));
            if (serverTcpStr == null) continue;
            String ipStr = "";
            if (serverTcpStr.indexOf(":") > -1 && serverTcpStr.indexOf(":") < serverTcpStr.length()) {
                ipStr = serverTcpStr.split(":")[1];
                ipStr = ipStr.replace("/", "");
            }
            String serverAddr = propertie.get(serverName) + "@" + ipStr;
            String capability = (String)propertie.get(serverName.replace(".name", "") + ".capability");
            if (capability == null || Integer.parseInt(capability) == 0) continue;
            this.serverMap.put(serverAddr, capability);
            logger.debug((Object)(serverAddr + "=" + capability + "**********"));
        }
    }

    private String getUserDefineServer(Context ctx, List allSevList) throws BOSException {
        String userDefineServer = "";
        try {
            Map paramsMap = RptAutoWeaveUtil.getCslParams(ctx, new String[]{"KEY_CSLPARAM_RPTWEAVE_VALIDSERVER"});
            userDefineServer = (String)paramsMap.get("KEY_CSLPARAM_RPTWEAVE_VALIDSERVER");
        }
        catch (Exception e) {
            return null;
        }
        if (StringUtils.isEmpty((String)userDefineServer)) {
            return null;
        }
        String[] defineServer = userDefineServer.split(",|;");
        if (defineServer.length > 0) {
            SecureRandom r = new SecureRandom();
            int idx = r.nextInt(defineServer.length);
            if (idx >= defineServer.length) {
                idx %= defineServer.length;
            }
            if (allSevList.contains(defineServer[idx])) {
                return defineServer[idx];
            }
        }
        return null;
    }

    public static String getRptWeaveSetServer(Context ctx) {
        Map paramsMap;
        try {
            paramsMap = RptAutoWeaveUtil.getCslParams(ctx, new String[]{"KEY_CSLPARAM_RPTAUTOWEAVE_SERVER"});
        }
        catch (Exception e) {
            return null;
        }
        return (String)paramsMap.get("KEY_CSLPARAM_RPTAUTOWEAVE_SERVER");
    }
}

