/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class LogTrace {
    private static final Logger log = Logger.getLogger(LogTrace.class);
    protected static ThreadLocal tl = new ThreadLocal();
    protected Map modelMsgFormats = new HashMap();
    protected String flag;

    public LogTrace(String flag, Map modelMsgFormats) {
        this.flag = flag;
        this.modelMsgFormats = modelMsgFormats;
    }

    public void trace(String name, Object[] msgParam) {
        Object msgFormat = this.modelMsgFormats.get(name);
        if (!(msgFormat instanceof String)) {
            return;
        }
        String wholeMsg = (String)msgFormat;
        if (msgParam.length > 0) {
            wholeMsg = MessageFormat.format((String)msgFormat, msgParam);
        }
        LogTrace.info(name + " <" + this.flag + ">", wholeMsg, "--------");
    }

    public static void trace(String name, Object msg) {
        LogTrace.info(name, msg, "--------");
    }

    public static void error(String name, Object msg) {
        LogTrace.info(name, msg, "+++++++++");
    }

    protected static void info(String name, Object msg, String separator) {
        try {
            log.debug((Object)(separator + name + separator));
            if (msg == null) {
                log.error((Object)"null");
            } else if (msg instanceof Object[]) {
                log.error(LogTrace.toString((Object[])msg));
            } else {
                log.error((Object)msg.toString());
            }
            log.debug((Object)(separator + separator));
        }
        catch (Exception e) {
            log.error((Object)"================LogTrace Error============", (Throwable)e);
        }
    }

    private static Object toString(Object[] msg) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < msg.length; ++i) {
            sb.append(',');
            sb.append(msg[i]);
        }
        return sb.substring(1);
    }

    public static void recordTime() {
        try {
            long startTime = System.currentTimeMillis();
            tl.set(new Long(startTime));
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static void printRecordTime(String flag) {
        try {
            long currTime = System.currentTimeMillis();
            long startTime = (Long)tl.get();
            LogTrace.trace(flag, new Long(currTime - startTime));
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public static void assertTrue(boolean isTrue, String errorFlag, Object errorMsg) {
        if (!isTrue) {
            LogTrace.error(errorFlag, errorMsg);
        }
    }
}

