/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveLog;
import com.kingdee.eas.fi.gr.weaverpt.IRptAutoWeaveSchmRpt;
import com.kingdee.eas.fi.gr.weaverpt.IRptWeaveSchmCompEntry;
import com.kingdee.eas.fi.gr.weaverpt.IRptWeaveSchmTempEntry;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmCompEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmCompEntryFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTaskCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryFactory;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptAutoWeaveSchmRptControllerBean;
import com.kingdee.eas.fi.gr.weaverpt.app.RptCalcSchemeHandle;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptAutoWeaveSchmRptControllerBean
extends AbstractRptAutoWeaveSchmRptControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.gr.weaverpt.app.RptAutoWeaveSchmRptControllerBean");

    @Override
    protected void _rptWeaveSolution(Context ctx, String pk, String userId) throws BOSException, EASBizException {
        if (this.isRunningScheme(ctx, pk)) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"844_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()) + pk));
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE", (Locale)ctx.getOriginLocale()));
        }
        RptAutoWeaveSchmRptInfo schmRptInfo = this.getRptAutoWeaveSchmRpt(ctx, pk);
        if (schmRptInfo.isIsFreezed()) {
            return;
        }
        RptWeaveSchmTempEntryCollection tempEnties = schmRptInfo.getTemplateEtries();
        if (schmRptInfo.getCompanyEntries().size() == 0 || tempEnties.size() == 0) {
            return;
        }
        RptWeaveSchmCompEntryCollection companyEnties = (RptWeaveSchmCompEntryCollection)((Object)schmRptInfo.getCompanyEntries().clone());
        schmRptInfo.getCompanyEntries().clear();
        RptPeriodTypeEnum periodType = tempEnties.get(0).getTemplate().getPeriodType();
        OrgType orgType = tempEnties.get(0).getTemplate().getOrgType();
        int cycle = schmRptInfo.getDispatchPeriod();
        Calendar calendar = Calendar.getInstance();
        List times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
        Integer year = (Integer)times.get(0);
        Integer period = (Integer)times.get(1);
        times = cycle == 0 ? RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, -1) : RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, 0);
        Integer weaveYear = (Integer)times.get(0);
        Integer weavePeriod = (Integer)times.get(1);
        Date rptDate = (Date)times.get(2);
        ArrayList<String> taskList = new ArrayList<String>();
        ArrayList<String> companyList = new ArrayList<String>();
        boolean isQueueWeave = RptAutoWeaveUtil.isQueueRptAutoWeave(ctx);
        String mutex = "RptAutoWeave";
        int mutexFlag = 0;
        Object dbtype = ctx.get((Object)"dbType");
        this.deleteSchmLog(ctx, schmRptInfo.getId().toString(), periodType.getValue(), weaveYear, weavePeriod);
        for (int i = 0; i < companyEnties.size(); ++i) {
            RptWeaveParams param = new RptWeaveParams();
            param.setInt("Year", weaveYear);
            param.setInt("Period", weavePeriod);
            param.setObject("Day", rptDate);
            param.setObject("orgType", orgType);
            param.setObject("rpt_weave_rptSchmObj", schmRptInfo);
            RptWeaveExecParams execParam = new RptWeaveExecParams();
            if (schmRptInfo.getLastUpdateUser() != null) {
                userId = schmRptInfo.getLastUpdateUser().getId().toString();
            }
            execParam.setUserId(userId);
            param.setObject("rpt_weave_execparams", execParam);
            param.setObject("KEY_COMPANY", companyEnties.get(i).getCompany());
            param.setObject("dbType", dbtype);
            param.setObject("ControlUnit", ContextUtil.getCurrentCtrlUnit((Context)ctx));
            mutex = "RptAutoWeave";
            mutexFlag = i % 2;
            mutex = mutex + mutexFlag;
            if (isQueueWeave) {
                String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)(schmRptInfo.isIsReceive() || schmRptInfo.isIsSendBack() ? "147_RptAutoReceiveSolu" : "120_RptAutoWeaveSchmRptControllerBean"), (Locale)ctx.getOriginLocale());
                String title = MessageFormat.format(msg, i, schmRptInfo.getNumber(), companyEnties.get(i).getCompany().getName(), companyEnties.get(i).getCompany().getNumber());
                Job job = RptAutoWeaveUtil.createWeaveRptJob(ctx, param, title, mutex, new RptCalcSchemeHandle());
                taskList.add(job.getId());
                companyList.add(companyEnties.get(i).getCompany().getId().toString());
                continue;
            }
            RptCalcSchemeHandle jobHandler = new RptCalcSchemeHandle();
            Job job = new Job(ctx, (IJobHandler)jobHandler, (Object)param);
            try {
                jobHandler.execute(job);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"RptWeaveSolution", (Throwable)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        RptAutoWeaveUtil.saveRptWeaveTask(ctx, taskList, companyList, weaveYear, weavePeriod, periodType, pk);
        this.setLastCalculateTime(ctx, pk, null);
    }

    private boolean getBooleanParamValue(Map executeParams, String paralName) {
        Object obj = executeParams.get(paralName);
        if (obj == null) {
            return false;
        }
        return Boolean.valueOf(obj.toString());
    }

    private void deleteSchmLog(Context ctx, String schmId, int periodType, int year, int period) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("RptWeaveSchmId", (Object)schmId));
        filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)new Integer(periodType)));
        filter.getFilterItems().add(new FilterItemInfo("Year", (Object)new Integer(year)));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(period)));
        IRptAutoWeaveLog iLog = RptAutoWeaveLogFactory.getLocalInstance(ctx);
        iLog.delete(filter);
    }

    private SelectorItemCollection getRptSchmSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isFreezed"));
        sic.add(new SelectorItemInfo("jobProcessDef"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("isAddNew"));
        sic.add(new SelectorItemInfo("isCopyPre"));
        sic.add(new SelectorItemInfo("isCalc"));
        sic.add(new SelectorItemInfo("isAduit"));
        sic.add(new SelectorItemInfo("isCommit"));
        sic.add(new SelectorItemInfo("isReceive"));
        sic.add(new SelectorItemInfo("isSendBack"));
        sic.add(new SelectorItemInfo("calcType"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("Currency.id"));
        sic.add(new SelectorItemInfo("Currency.number"));
        sic.add(new SelectorItemInfo("orgType"));
        sic.add(new SelectorItemInfo("periodType"));
        sic.add(new SelectorItemInfo("dispatchPeriod"));
        sic.add(new SelectorItemInfo("companyEntries.id"));
        sic.add(new SelectorItemInfo("companyEntries.company.id"));
        sic.add(new SelectorItemInfo("companyEntries.company.name"));
        sic.add(new SelectorItemInfo("companyEntries.company.number"));
        sic.add(new SelectorItemInfo("companyEntries.company.LongNumber"));
        sic.add(new SelectorItemInfo("companyEntries.company.CU.*"));
        sic.add(new SelectorItemInfo("companyEntries.company.IsCU"));
        sic.add(new SelectorItemInfo("companyEntries.company.isUnion"));
        sic.add(new SelectorItemInfo("templateEtries.id"));
        sic.add(new SelectorItemInfo("templateEtries.template.id"));
        sic.add(new SelectorItemInfo("templateEtries.template.number"));
        sic.add(new SelectorItemInfo("templateEtries.template.periodtype"));
        sic.add(new SelectorItemInfo("templateEtries.template.templateType"));
        sic.add(new SelectorItemInfo("convertSolution.id"));
        sic.add(new SelectorItemInfo("convertSolution.name"));
        sic.add(new SelectorItemInfo("convertSolution.number"));
        return sic;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RptWeaveSchmTempEntryCollection tplEntries;
        RptWeaveSchmCompEntryCollection companyEntries;
        RptAutoWeaveSchmRptInfo checkModel = (RptAutoWeaveSchmRptInfo)model;
        RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).checkNumberDup(checkModel);
        RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).checkNameDup(checkModel);
        IObjectPK modelPK = super._submit(ctx, model);
        if (!StringUtils.isEmpty((String)model.getString("jobProcessDef"))) {
            EnactmentServiceFactory.createEnactService((Context)ctx).setProcessDefEnable(model.getString("jobProcessDef"), !model.getBoolean("isFreezed"));
        }
        if (!(model instanceof RptAutoWeaveSchmRptInfo)) {
            return modelPK;
        }
        RptAutoWeaveSchmRptInfo rptInfo = (RptAutoWeaveSchmRptInfo)model;
        if (rptInfo.getId() == null) {
            rptInfo.setId(BOSUuid.read((String)modelPK.toString()));
        }
        if (!(companyEntries = rptInfo.getCompanyEntries()).isEmpty()) {
            IRptWeaveSchmCompEntry compDao = RptWeaveSchmCompEntryFactory.getLocalInstance(ctx);
            compDao.delete("where scheme='" + rptInfo.getId() + "'");
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < companyEntries.size(); ++i) {
                companyEntries.get(i).setId(null);
                companyEntries.get(i).setScheme(rptInfo);
            }
            coll.addObjectCollection((IObjectCollection)companyEntries);
            compDao.addnew(coll);
        }
        if (!(tplEntries = rptInfo.getTemplateEtries()).isEmpty()) {
            IRptWeaveSchmTempEntry tempDao = RptWeaveSchmTempEntryFactory.getLocalInstance(ctx);
            tempDao.delete("where scheme='" + rptInfo.getId() + "'");
            CoreBaseCollection coll = new CoreBaseCollection();
            for (int i = 0; i < tplEntries.size(); ++i) {
                tplEntries.get(i).setId(null);
                tplEntries.get(i).setScheme(rptInfo);
            }
            coll.addObjectCollection((IObjectCollection)tplEntries);
            tempDao.addnew(coll);
        }
        return modelPK;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK != null && arrayPK.length > 0) {
            StringBuffer ids = new StringBuffer();
            for (IObjectPK pk : arrayPK) {
                ids.append("'").append(pk).append("'").append(",");
            }
            int index = ids.lastIndexOf(",");
            if (index > 0) {
                ids.deleteCharAt(index);
            }
            RptAutoWeaveSchmRptCollection models = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).getRptAutoWeaveSchmRptCollection("select * where id in(" + ids + ")");
            this.assistDeleteCompAndTempByScheme(ctx, arrayPK);
            super._delete(ctx, arrayPK);
            for (int i = 0; i < models.size(); ++i) {
                RptAutoWeaveSchmRptInfo model = models.get(i);
                if (model != null && (model.isIsSendBack() || model.isIsReceive())) {
                    this.delete_RecForLog(ctx, (CoreBaseInfo)model);
                    continue;
                }
                this.deleteForLog(ctx, (CoreBaseInfo)model);
            }
        }
    }

    private void assistDeleteCompAndTempByScheme(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        if (arrayPK.length == 0) {
            return;
        }
        IRptWeaveSchmCompEntry compDao = RptWeaveSchmCompEntryFactory.getLocalInstance(ctx);
        IRptWeaveSchmTempEntry tplDao = RptWeaveSchmTempEntryFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("scheme", new HashSet<IObjectPK>(Arrays.asList(arrayPK)), CompareType.INCLUDE));
        compDao.delete(filter);
        tplDao.delete(filter);
    }

    @Override
    public Map _abortSchemeTask(Context ctx, String schemeId) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        RptWeaveSchmTaskCollection taskColl = RptAutoWeaveUtil.getSchmTaskColl(ctx, schemeId);
        if (taskColl == null || taskColl.size() == 0) {
            returnMap.put("IsSuccess", "IsNoExceute");
            return returnMap;
        }
        StringBuffer sb = new StringBuffer("(");
        for (int i = 0; i < taskColl.size(); ++i) {
            sb.append("'").append(taskColl.get(i).getJobinstid()).append("',");
        }
        if (taskColl.size() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        sb.append(")");
        String sql = "select fjobinstid,fstate from T_JOB_INST WITH(READPAST) where fjobinstid in" + sb.toString();
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> cannotAbortJobList = new ArrayList<String>();
        ArrayList<String> canAbortJobList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String fjobinstid = rowSet.getString("fjobinstid");
                String fstate = rowSet.getString("fstate");
                if (JobState.valueOf((String)fstate).equals((Object)JobState.Running) || JobState.valueOf((String)fstate).equals((Object)JobState.Complete) || JobState.valueOf((String)fstate).equals((Object)JobState.Failed)) {
                    cannotAbortJobList.add(fjobinstid);
                    continue;
                }
                canAbortJobList.add(fjobinstid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        int result = 0;
        if (canAbortJobList.size() > 0) {
            try {
                String[] strings = new String[canAbortJobList.size()];
                result += JobServiceFactory.getLocalInstance((Context)ctx).abort(canAbortJobList.toArray(strings));
            }
            catch (Exception e) {
                logger.warn((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"845_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()), (Throwable)e);
                throw new RptWeaveException(EASResource.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"TAST_ABORT_ISERROR"));
            }
        }
        returnMap.put("cannotAbortJobList", cannotAbortJobList);
        returnMap.put("canAbortJobList", canAbortJobList);
        if (cannotAbortJobList.size() > 0) {
            returnMap.put("IsSuccess", "false");
        } else {
            returnMap.put("IsSuccess", "true");
        }
        return returnMap;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        RptAutoWeaveSchmRptInfo model = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).getRptAutoWeaveSchmRptInfo(pk);
        this.assistDeleteCompAndTempByScheme(ctx, new IObjectPK[]{pk});
        super._delete(ctx, pk);
        if (model != null && (model.isIsSendBack() || model.isIsReceive())) {
            this.delete_RecForLog(ctx, (CoreBaseInfo)model);
        } else {
            this.deleteForLog(ctx, (CoreBaseInfo)model);
        }
    }

    @Override
    protected void _schemeImmediatelyRun(Context ctx, String pk, String userId, Map executeParams) throws BOSException, EASBizException {
        super._schemeImmediatelyRun(ctx, pk, userId, executeParams);
        if (executeParams.containsKey("isFromCustom")) {
            this.rptWeaveSolutionByCustom(ctx, pk, userId, executeParams);
            this.setLastCalculateTime(ctx, pk, executeParams);
        } else {
            this.rptWeaveSolution(ctx, pk, userId);
        }
    }

    private void setLastCalculateTime(Context ctx, String pk, Map executeParams) throws BOSException, EASBizException {
        ObjectUuidPK id = new ObjectUuidPK(pk);
        RptAutoWeaveSchmRptInfo schmRptInfo = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).getRptAutoWeaveSchmRptInfo("select distinct *,dispatchPeriod,templateEtries.template.periodtype,currency.id where id='" + pk + "'");
        List times = null;
        RptWeaveSchmTempEntryCollection tempEnties = schmRptInfo.getTemplateEtries();
        RptPeriodTypeEnum periodType = tempEnties.get(0).getTemplate().getPeriodType();
        if (executeParams == null) {
            int cycle = schmRptInfo.getDispatchPeriod();
            Calendar calendar = Calendar.getInstance();
            times = RPTDateUtil.getRptPeriod(calendar.getTime(), periodType);
            Integer year = (Integer)times.get(0);
            Integer period = (Integer)times.get(1);
            times = cycle == 0 ? RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, -1) : RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, 0);
            Integer weaveYear = (Integer)times.get(0);
            Integer weavePeriod = (Integer)times.get(1);
            schmRptInfo.setLastCalculateYear(weaveYear);
            schmRptInfo.setLastCalculatePeriod(weavePeriod);
            Date rptDate = (Date)times.get(2);
            Timestamp time = new Timestamp(rptDate.getTime());
            schmRptInfo.setLastCalculateTime(time);
            String currencyid = schmRptInfo.getCurrency().getId().toString();
            schmRptInfo.setLastCalculateCurrency(currencyid);
        } else {
            Integer year = (int)Integer.valueOf(executeParams.get("year").toString());
            Integer period = (int)Integer.valueOf(executeParams.get("period").toString());
            CurrencyInfo currency = (CurrencyInfo)executeParams.get("currency");
            schmRptInfo.setLastCalculateYear(year);
            schmRptInfo.setLastCalculatePeriod(period);
            schmRptInfo.setLastCalculateCurrency(currency.getId().toString());
            if (periodType.getValue() == 3 && period == 13) {
                period = 12;
            }
            times = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, 0);
        }
        Date rptDate = (Date)times.get(2);
        Timestamp time = new Timestamp(rptDate.getTime());
        schmRptInfo.setLastCalculateTime(time);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("lastCalculateYear"));
        selector.add(new SelectorItemInfo("lastCalculatePeriod"));
        selector.add(new SelectorItemInfo("lastCalculateCurrency"));
        selector.add(new SelectorItemInfo("lastCalculateTime"));
        RptAutoWeaveSchmRptFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)schmRptInfo, selector);
    }

    private void rptWeaveSolutionByCustom(Context ctx, String schmid, String userId, Map executeParams) throws BOSException, EASBizException {
        if (this.isRunningScheme(ctx, schmid)) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"844_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()) + schmid));
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE", (Locale)ctx.getOriginLocale()));
        }
        RptAutoWeaveSchmRptInfo schmRptInfo = this.getRptAutoWeaveSchmRpt(ctx, schmid);
        if (schmRptInfo.isIsFreezed()) {
            return;
        }
        RptWeaveSchmCompEntryCollection companyEnties = schmRptInfo.getCompanyEntries();
        RptWeaveSchmTempEntryCollection tempEnties = schmRptInfo.getTemplateEtries();
        if (companyEnties.size() == 0 || tempEnties.size() == 0) {
            return;
        }
        RptPeriodTypeEnum periodType = tempEnties.get(0).getTemplate().getPeriodType();
        Integer year = (int)Integer.valueOf(executeParams.get("year").toString());
        Integer period = (int)Integer.valueOf(executeParams.get("period").toString());
        List times = RPTDateUtil.getRptYearAndPeriodAndDate(year, period, periodType.getValue(), 0, 0);
        if (periodType.getValue() != 3 || period != 13) {
            year = (Integer)times.get(0);
            period = (Integer)times.get(1);
        }
        Date rptDate = (Date)times.get(2);
        ArrayList<String> taskList = new ArrayList<String>();
        ArrayList<String> companyList = new ArrayList<String>();
        boolean isQueueWeave = RptAutoWeaveUtil.isQueueRptAutoWeave(ctx);
        String mutex = "RptAutoWeave";
        int mutexFlag = 0;
        Object dbtype = ctx.get((Object)"dbType");
        this.deleteSchmLog(ctx, schmRptInfo.getId().toString(), periodType.getValue(), year, period);
        for (int i = 0; i < companyEnties.size(); ++i) {
            RptWeaveParams param = new RptWeaveParams();
            param.setInt("Year", year);
            param.setInt("Period", period);
            param.setObject("Day", rptDate);
            CurrencyInfo currency = (CurrencyInfo)executeParams.get("currency");
            param.setObject("currency", currency);
            boolean isAddNew = this.getBooleanParamValue(executeParams, "isAddNew");
            param.setBoolean("isAddNew", isAddNew);
            schmRptInfo.setIsAddNew(isAddNew);
            boolean isAudit = this.getBooleanParamValue(executeParams, "isAudit");
            param.setBoolean("isAudit", isAudit);
            schmRptInfo.setIsAduit(isAudit);
            boolean isCalc = this.getBooleanParamValue(executeParams, "isCalc");
            param.setBoolean("isCalc", isCalc);
            schmRptInfo.setIsCalc(isCalc);
            boolean isCommit = this.getBooleanParamValue(executeParams, "isCommit");
            param.setBoolean("isCommit", isCommit);
            schmRptInfo.setIsCommit(isCommit);
            boolean isCopyPre = this.getBooleanParamValue(executeParams, "isCopyPre");
            param.setBoolean("isCopyPre", isCopyPre);
            schmRptInfo.setIsCopyPre(isCopyPre);
            boolean isConvert = this.getBooleanParamValue(executeParams, "isConvert");
            param.setBoolean("isConvert", isConvert);
            boolean isReceive = this.getBooleanParamValue(executeParams, "isReceive");
            param.setBoolean("isReceive", isReceive);
            schmRptInfo.setIsReceive(isReceive);
            boolean isSendBack = this.getBooleanParamValue(executeParams, "isSendBack");
            param.setBoolean("isSendBack", isSendBack);
            schmRptInfo.setIsSendBack(isSendBack);
            param.setObject("rpt_weave_rptSchmObj", schmRptInfo);
            RptWeaveExecParams execParam = new RptWeaveExecParams();
            if (schmRptInfo.getLastUpdateUser() != null) {
                userId = schmRptInfo.getLastUpdateUser().getId().toString();
            }
            execParam.setUserId(userId);
            param.setObject("rpt_weave_execparams", execParam);
            param.setObject("KEY_COMPANY", companyEnties.get(i).getCompany());
            param.setObject("dbType", dbtype);
            param.setObject("ControlUnit", ContextUtil.getCurrentCtrlUnit((Context)ctx));
            mutex = "RptAutoWeave";
            mutexFlag = i % 2;
            mutex = mutex + mutexFlag;
            if (isQueueWeave) {
                String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)(schmRptInfo.isIsReceive() || schmRptInfo.isIsSendBack() ? "147_RptAutoReceiveSolu" : "120_RptAutoWeaveSchmRptControllerBean"), (Locale)ctx.getOriginLocale());
                String title = MessageFormat.format(msg, i, schmRptInfo.getNumber(), companyEnties.get(i).getCompany().getName(), companyEnties.get(i).getCompany().getNumber());
                Job job = RptAutoWeaveUtil.createWeaveRptJob(ctx, param, title, mutex, new RptCalcSchemeHandle());
                taskList.add(job.getId());
                companyList.add(companyEnties.get(i).getCompany().getId().toString());
                continue;
            }
            RptCalcSchemeHandle jobHandler = new RptCalcSchemeHandle();
            Job job = new Job(ctx, (IJobHandler)jobHandler, (Object)param);
            try {
                jobHandler.execute(job);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"RptWeaveSolution", (Throwable)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        RptAutoWeaveUtil.saveRptWeaveTask(ctx, taskList, companyList, year, period, periodType, schmid);
    }

    private RptAutoWeaveSchmRptInfo getRptAutoWeaveSchmRpt(Context ctx, String schmid) throws BOSException, EASBizException {
        IRptAutoWeaveSchmRpt schmRpt = RptAutoWeaveSchmRptFactory.getLocalInstance(ctx);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo templateSeqSorter = new SorterItemInfo("templateEtries.seq");
        templateSeqSorter.setSortType(SortType.ASCEND);
        sorter.add(templateSeqSorter);
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)schmRpt.getValue((IObjectPK)new ObjectUuidPK(schmid), this.getRptSchmSelector(), sorter);
        return schmRptInfo;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null && (((RptAutoWeaveSchmRptInfo)model).isIsSendBack() || ((RptAutoWeaveSchmRptInfo)model).isIsReceive())) {
            this.update_RecForLog(ctx, (CoreBaseInfo)((RptAutoWeaveSchmRptInfo)model));
        } else {
            this.updateForLog(ctx, (CoreBaseInfo)((RptAutoWeaveSchmRptInfo)model));
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        if (model != null && (((RptAutoWeaveSchmRptInfo)model).isIsSendBack() || ((RptAutoWeaveSchmRptInfo)model).isIsReceive())) {
            this.addnew_RecForLog(ctx, (CoreBaseInfo)((RptAutoWeaveSchmRptInfo)model));
        } else {
            this.addnewForLog(ctx, (CoreBaseInfo)((RptAutoWeaveSchmRptInfo)model));
        }
        return pk;
    }
}

