/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveSchmTempEntryCollection;
import com.kingdee.eas.fi.gr.weaverpt.app.RptWeaveExecStrategy;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.log4j.Logger;

public class RptCalcSchemeHandle
implements IJobHandler {
    protected static final Logger logger = Logger.getLogger(RptCalcSchemeHandle.class);

    public Object execute(Job job) throws Exception {
        RptWeaveParams schmParam = (RptWeaveParams)job.getParameters();
        Context ctx = job.getContext();
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)schmParam.getObject("rpt_weave_rptSchmObj");
        RptWeaveSchmTempEntryCollection tempateEnties = schmRptInfo.getTemplateEtries();
        RptWeaveExecParams execParam = (RptWeaveExecParams)schmParam.getObject("rpt_weave_execparams");
        String userId = execParam.getUserId();
        RptAutoWeaveLogInfo log = null;
        FullOrgUnitInfo companyInfo = (FullOrgUnitInfo)schmParam.getObject("KEY_COMPANY");
        int year = schmParam.getInt("Year");
        int period = schmParam.getInt("Period");
        RptPeriodTypeEnum periodType = tempateEnties.get(0).getTemplate().getPeriodType();
        this.addCtxObject(ctx, userId, companyInfo, schmParam);
        this.setCompanyBaseCurrency(schmRptInfo, ctx, companyInfo);
        boolean currencyExist = CurrencyFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(schmRptInfo.getCurrency().getId()));
        for (int j = 0; j < tempateEnties.size() && !execParam.isCalcException(); ++j) {
            try {
                if (this.isNormalTemplate(tempateEnties.get(j).getTemplate()) && companyInfo.isIsUnion() || !this.isNormalTemplate(tempateEnties.get(j).getTemplate()) && !companyInfo.isIsUnion()) continue;
                String companyId = companyInfo.getId().toString();
                String schemTempId = tempateEnties.get(j).getTemplate().getId().toString();
                log = this.initLogInfo(ctx, companyId, schemTempId, schmRptInfo.getId().toString(), periodType, year, period, userId);
                if (!currencyExist) {
                    throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"CURRENCY_IS_ERROR", (Locale)ctx.getOriginLocale()));
                }
                TemplateInfo tempInfo = this.getLastestByTemapIdAndComp(ctx, companyId, tempateEnties.get(j).getTemplate().getId().toString());
                schmParam.setObject("KEY_TEMPLATE", tempInfo);
                String cslrptTemaplateId = this.getCurrentPeriodRptTempalteId(tempInfo, companyInfo, schmRptInfo.getCurrency(), periodType.getValue(), period, year, ctx);
                if (!StringUtils.isEmpty((String)cslrptTemaplateId)) {
                    log.setTemplateId(cslrptTemaplateId);
                } else {
                    log.setTemplateId(tempInfo.getId().toString());
                }
                this.addInitLog(ctx, log);
                this.resetParam(execParam);
                RptWeaveExecStrategy execStrategy = new RptWeaveExecStrategy(schmRptInfo, log);
                execStrategy.rptWeaveExceute(schmParam, ctx);
                this.writeLog(ctx, log, "", RptWeaveLogSuccEnum.SUCCESS);
                continue;
            }
            catch (Throwable e) {
                if (log != null) {
                    this.writeLog(ctx, log, e.getLocalizedMessage(), RptWeaveLogSuccEnum.FAILED);
                }
                if (!(e instanceof RptWeaveException)) {
                    logger.error((Object)"RptCalcSchemeHandle", e);
                }
                execParam.setException(e);
            }
        }
        if (execParam.isException()) {
            logger.error((Object)"", execParam.getException());
            throw (Exception)execParam.getException();
        }
        return null;
    }

    private boolean isNormalTemplate(TemplateInfo template) {
        return template.getTemplateType().equals((Object)RptTmpTypeEnum.COMMONREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.GROUPCOMMREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.DYNAMICNORMALREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.RPTDYNAMICREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIDYNAMICCSLREPORT) || template.getTemplateType().equals((Object)RptTmpTypeEnum.MULTIRPTDYNAMICREPORT);
    }

    public void resetParam(RptWeaveExecParams execParam) {
        execParam.setCslrptId("");
        execParam.setException(false);
        execParam.setCommitReport(false);
    }

    private void setCompanyBaseCurrency(RptAutoWeaveSchmRptInfo schmRptInfo, Context ctx, FullOrgUnitInfo companyInfo) throws BOSException, EASBizException {
        if (schmRptInfo.getCurrency() != null) {
            return;
        }
        CurrencyInfo currencyInfo = null;
        FullOrgUnitInfo fullOrgUnitInfo = null;
        ObjectStringPK pk = new ObjectStringPK(companyInfo.getId().toString());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("partFI.id"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.id"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.number"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.name"));
        selector.add(new SelectorItemInfo("partFI.baseCurrency.precision"));
        try {
            fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)pk, selector);
        }
        catch (Exception e) {
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            schmRptInfo.setCurrency(currencyInfo);
            return;
        }
        if (fullOrgUnitInfo.getPartFI() == null || fullOrgUnitInfo.getPartFI().getBaseCurrency() == null) {
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectStringPK("dfd38d11-00fd-1000-e000-1ebdc0a8100dDEB58FDC"));
            schmRptInfo.setCurrency(currencyInfo);
            return;
        }
        schmRptInfo.setCurrency(fullOrgUnitInfo.getPartFI().getBaseCurrency());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCtxObject(Context ctx, String userId, FullOrgUnitInfo companyInfo, RptWeaveParams schmParam) throws BOSException, EASBizException {
        ctx.put((Object)"UserInfo", (Object)RptAutoWeaveUtil.getCurrentUser(ctx, userId));
        ctx.put((Object)OrgType.ControlUnit, schmParam.getObject("ControlUnit"));
        try {
            ctx.put((Object)"CompanyInfo", (Object)FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyInfo.getId())));
        }
        catch (Exception e) {
            ctx.put((Object)"CompanyInfo", (Object)companyInfo);
            logger.error((Object)"addCtxObject", (Throwable)e);
        }
        if (companyInfo.isIsUnion()) {
            ctx.put((Object)OrgType.Company, (Object)companyInfo);
        } else {
            ctx.put((Object)OrgType.Company, (Object)MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)companyInfo, ctx));
        }
        ctx.setCaller((IObjectPK)new ObjectUuidPK(userId));
        if (schmParam.getObject("dbType") == null) {
            String dbType = "";
            Connection conn = null;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                dbType = KSqlUtil.getDbTypeName((Connection)conn);
            }
            catch (SQLException e1) {
                dbType = "oracle";
            }
            finally {
                SQLUtils.cleanup(null, null, (Connection)conn);
            }
            ctx.put((Object)"dbType", (Object)dbType);
        } else {
            ctx.put((Object)"dbType", schmParam.getObject("dbType"));
        }
    }

    public String getCurrentPeriodRptTempalteId(TemplateInfo templateInfo, FullOrgUnitInfo orgUnitInfo, CurrencyInfo currency, int periodType, int period, int year, Context ctx) throws BOSException, EASBizException {
        String cslrptId = RptWeaveCalcHelper.getRptidInSameVersion(templateInfo, (OrgUnitInfo)orgUnitInfo, currency, periodType, period, year, ctx);
        if (StringUtils.isEmpty((String)cslrptId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("template.id"));
        CslReportInfo cslRptInfo = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(cslrptId), sic);
        if (cslRptInfo.getTemplate() != null) {
            return cslRptInfo.getTemplate().getId().toString();
        }
        return null;
    }

    public void addInitLog(Context ctx, RptAutoWeaveLogInfo logInfo) throws BOSException, EASBizException {
        IObjectPK pk = RptAutoWeaveLogFactory.getLocalInstance(ctx).addnew(logInfo);
        logInfo.setId(BOSUuid.read((String)pk.toString()));
    }

    public void writeLog(Context ctx, RptAutoWeaveLogInfo logInfo, String detailMsg, RptWeaveLogSuccEnum logSuccType) throws BOSException, EASBizException {
        if (detailMsg == null) {
            detailMsg = "java.lang.NullPointerException";
        }
        if (detailMsg.length() > 2000) {
            detailMsg = detailMsg.substring(0, 2000);
        }
        logInfo.setDetails(detailMsg);
        logInfo.setResultType(logSuccType);
        if (logInfo.getId() == null) {
            RptAutoWeaveLogFactory.getLocalInstance(ctx).addnew(logInfo);
        } else {
            SelectorItemCollection itemColl = new SelectorItemCollection();
            itemColl.add(new SelectorItemInfo("details"));
            itemColl.add(new SelectorItemInfo("resultType"));
            itemColl.add(new SelectorItemInfo("linkType"));
            if (logInfo.getError() != null) {
                itemColl.add(new SelectorItemInfo("error"));
            }
            if (logInfo.getEndTime() != null) {
                itemColl.add(new SelectorItemInfo("endTime"));
            }
            RptAutoWeaveLogFactory.getLocalInstance(ctx).updatePartial(logInfo, itemColl);
        }
    }

    public RptAutoWeaveLogInfo initLogInfo(Context ctx, String companyId, String tempId, String schmRptId, RptPeriodTypeEnum item, int year, int peroid, String userId) throws BOSException, EASBizException {
        RptAutoWeaveLogInfo log = new RptAutoWeaveLogInfo();
        log.setCompanyID(companyId);
        log.setTemplateId(tempId);
        log.setRptWeaveSchmId(schmRptId);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        log.setCreator(userInfo);
        log.setPeriodType(item);
        log.setYear(year);
        log.setPeriod(peroid);
        log.setResultType(RptWeaveLogSuccEnum.EXCEUTING);
        return log;
    }

    private boolean isTemplateDispense(Context ctx, String companyId, String templateId) throws BOSException {
        StringBuffer sqlBuff = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sqlBuff.append(" select 1 from  T_RPT_Template  TEMPLATE \t\n");
        sqlBuff.append(" inner  join T_CSL_TempletDispense d on TEMPLATE.fid = d.FDispenseSrcID  ");
        sqlBuff.append("       where d.FCompanyID = ? \n");
        sqlBuff.append("       and TEMPLATE.Fid=? \n");
        sqlBuff.append("      and TEMPLATE.fversionstatus < 2  \n");
        sqlBuff.append("     and TEMPLATE.FIsFreezed = 0  \n");
        sqlBuff.append("   AND TEMPLATE.FPublishedStatus = 1 \n");
        sqlBuff.append("    AND TEMPLATE.FVERSIONSTATUS = 1 ");
        params.add(companyId);
        params.add(templateId);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    public TemplateInfo getLastestByTemapIdAndComp(Context ctx, String companyId, String templateId) throws BOSException, EASBizException {
        TemplateInfo info = new TemplateInfo();
        ArrayList<String> params = new ArrayList<String>();
        String outerSelectStr = "select top 1 tab.* from ( ";
        String selectStr = " SELECT  TEMPLATE.fid fid ,TEMPLATE.fnumber fnumber,TEMPLATE.fname fname,";
        selectStr = selectStr + "TEMPLATE.fperiodType fperiodType,TEMPLATE.ftemplateType ftemplateType,TEMPLATE.fversionnumber fversionnumber,TEMPLATE.FORGTYPE forgtype  \n";
        StringBuffer sqlBuff = new StringBuffer(outerSelectStr).append(selectStr);
        sqlBuff.append(" from T_RPT_Template as TEMPLATE \n");
        sqlBuff.append("  inner join T_CSL_TempletDispense d on TEMPLATE.fid = d.FDispenseSrcID  \n");
        sqlBuff.append("   INNER JOIN T_ORG_BaseUnit AS COMPANY ON TEMPLATE.FCompanyID = COMPANY.FID  \n");
        sqlBuff.append("   left JOIN (select * from T_RPT_Template where FCompanyID=?    \n");
        sqlBuff.append(" and FVersionStatus = 1  and FTemplateType in(2,12 ,16)) AS t \n");
        sqlBuff.append("  on TEMPLATE.fid=t.FGroupTemplateID  \n");
        params.add(companyId);
        sqlBuff.append("  where d.FCompanyID =?   and   \n");
        params.add(companyId);
        sqlBuff.append("  TEMPLATE.fgroup in(select fgroup from T_RPT_Template where fid=?) \n");
        params.add(templateId);
        sqlBuff.append("  and TEMPLATE.fversionstatus = 1   and TEMPLATE.FIsFreezed = 0  \n");
        sqlBuff.append("  and t.fid is null  \n");
        sqlBuff.append("   union all   \n");
        sqlBuff.append(selectStr);
        sqlBuff.append("   from T_RPT_Template TEMPLATE  \n");
        sqlBuff.append("  inner  join T_RPT_Template t2 on TEMPLATE.FGroup = t2.FGroup  \n");
        sqlBuff.append("  inner  join T_CSL_TempletDispense d on t2.fid = d.FDispenseSrcID   \n");
        sqlBuff.append("  INNER JOIN T_ORG_BaseUnit AS COMPANY ON TEMPLATE.FCompanyID = COMPANY.FID  \n");
        sqlBuff.append("  where TEMPLATE.fcompanyid = ?  and  \n");
        params.add(companyId);
        sqlBuff.append("  TEMPLATE.fgroup in(select fgroup from T_RPT_Template where fid=? ) \n");
        params.add(templateId);
        sqlBuff.append("  and d.FIsAllowChgTemplet =1   and TEMPLATE.FIsFreezed = 0  \n");
        sqlBuff.append("  AND TEMPLATE.FPublishedStatus = 1 AND TEMPLATE.FVERSIONSTATUS = 1  \n");
        sqlBuff.append("  AND TEMPLATE.FTemplateType in(2,12,16)  \n");
        sqlBuff.append(" )tab order by  fversionnumber desc ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuff.toString(), (Object[])params.toArray());
        try {
            if (rowSet.next()) {
                info.setId(BOSUuid.read((String)rowSet.getString("fid")));
                info.setNumber(rowSet.getString("fnumber"));
                info.setName(rowSet.getString("fname"));
                info.setPeriodType(RptPeriodTypeEnum.getEnum((int)rowSet.getInt("fperiodType")));
                info.setTemplateType(RptTmpTypeEnum.getEnum((int)rowSet.getInt("ftemplateType")));
                info.setOrgType(OrgType.getEnum((int)rowSet.getInt("forgtype")));
                return info;
            }
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"TEMPLATE_ISNOT_DISPEN", (Locale)ctx.getOriginLocale()));
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

