/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.ICslReport;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveCalcHelper;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.newrpt.PermissionHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportTypeCollection;
import com.kingdee.eas.fi.rpt.RptTypeRelaCollection;
import com.kingdee.eas.fi.rpt.RptTypeRelaFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RptWeaveExceCopyPre
extends AbstractRptWeaveExecute {
    public RptWeaveExceCopyPre(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void beforeExecute() throws Exception {
        super.beforeExecute();
        FullOrgUnitInfo orgUnitInfo = null;
        try {
            orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
            this.checkAddNewPermission(this.ctx, (IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), PermissionHelper.getAddNewPermNameByOrgType((OrgType)this.getTemplateOrgType()));
        }
        catch (Exception exc) {
            logger.info((Object)("Permission-user:" + this.userId + " comp:" + orgUnitInfo.getId()));
            throw exc;
        }
    }

    public void checkAddNewPermission(Context ctx, IObjectPK userPK, IObjectPK orgPK, String permItemName) throws BOSException, EASBizException {
        IPermission ip = PermissionFactory.getLocalInstance((Context)ctx);
        ip.checkFunctionPermission(userPK, orgPK, permItemName);
    }

    @Override
    protected void executeRptWeave() throws Exception {
        TemplateInfo templateInfo = (TemplateInfo)this.schmParam.getObject("KEY_TEMPLATE");
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
        int periodType = templateInfo.getPeriodType().getValue();
        int period = this.schmParam.getInt("Period");
        int year = this.schmParam.getInt("Year");
        RptAutoWeaveSchmRptInfo schmRptInfo = (RptAutoWeaveSchmRptInfo)this.schmParam.getObject("rpt_weave_rptSchmObj");
        CurrencyInfo currency = schmRptInfo.getCurrency();
        String cslrptId = RptWeaveCalcHelper.getRptidInSameVersion(templateInfo, (OrgUnitInfo)orgUnitInfo, currency, periodType, period, year, this.ctx);
        logger.info((Object)("CopyPre:cslrptId-----------------" + cslrptId == null ? "null" : cslrptId));
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        if (cslrptId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("isCommitReport"));
            ICslReport iReport = CslReportFactory.getLocalInstance(this.ctx);
            CslReportInfo cslrptInfo = iReport.getCslReportInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)cslrptId)), sic);
            if (cslrptInfo.isIsCommitReport()) {
                execParam.setCommitReport(cslrptInfo.isIsCommitReport());
                cslrptId = RptAutoWeaveUtil.getReportInfoByCslrpt(this.ctx, cslrptInfo.getId().toString()).getId().toString();
            }
            logger.info((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"840_RptWeaveExceCopyPre", (Locale)this.ctx.getOriginLocale()));
        } else {
            String rptId = this.copyPreReport(orgUnitInfo.getId().toString(), periodType, currency.getId().toString(), year, period, templateInfo.getId().toString(), schmRptInfo.getId().toString());
            if (rptId == null) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"COPY_PreRPT_ISERROR", (Locale)this.ctx.getOriginLocale()));
            }
            cslrptId = rptId;
            execParam.setCommitReport(true);
            logger.info((Object)("copyPreReport is success:" + cslrptId));
        }
        execParam.setCslrptId(cslrptId);
    }

    private String copyPreReport(String companyId, int periodType, String currencyId, int year, int period, String templateId, String schmRptId) throws Exception {
        List idList;
        ArrayList<String> idCopyList = new ArrayList<String>();
        String[] rptIDAndTempId = this.getPreReportIdAndTempId(companyId, periodType, currencyId, year, period, templateId);
        idCopyList.add(rptIDAndTempId[0]);
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("year", new Integer(year));
        paramMap.put("period", new Integer(period));
        RptTypeRelaCollection typeRela = RptTypeRelaFactory.getLocalInstance((Context)this.ctx).getRptTypeRelaCollection("where report='" + rptIDAndTempId[0] + "'");
        ReportTypeCollection reportTypeColl = new ReportTypeCollection();
        for (int i = 0; i < typeRela.size(); ++i) {
            reportTypeColl.add(typeRela.get(i).getRptType());
        }
        paramMap.put("pathColl", (Integer)reportTypeColl);
        Map resultMap = ReportFactory.getLocalInstance((Context)this.ctx).copyHisRpt(idCopyList, paramMap);
        List fl = (List)resultMap.get("faultRptList");
        boolean hasDupMsg = fl != null && fl.size() > 0;
        StringBuffer sb = new StringBuffer();
        if (hasDupMsg) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"copyResultCslDup", (Locale)this.ctx.getOriginLocale()));
            sb.append("<br><br>");
            for (String s : fl) {
                sb.append(s);
                sb.append("<br>");
            }
            throw new RptWeaveException(sb.toString());
        }
        if (!templateId.equals(rptIDAndTempId[1])) {
            this.modifyLogTemplateId(rptIDAndTempId[1], year, period, periodType, schmRptId, companyId, templateId);
        }
        if ((idList = (List)resultMap.get("idList")) != null && idList.size() > 0) {
            return (String)idList.get(0);
        }
        return null;
    }

    private void modifyLogTemplateId(String templateId, int year, int period, int periodType, String schmRptId, String companyId, String oldTempId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update  T_csl_rptautoweavelog set ").append(" FTemplateId = '").append(templateId).append("'").append(" where FRptWeaveSchmId = '" + schmRptId).append("'").append(" and  FCompanyID = '" + companyId).append("'").append(" and  FYear = " + year).append(" and fperiod=" + period).append(" and FPeriodType=" + periodType).append(" and FTemplateId= '").append(oldTempId).append("'");
        try {
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
        }
        catch (Exception exc) {
            throw new BOSException("Sql execute exception : " + sql.toString(), (Throwable)exc);
        }
    }

    private String[] getPreReportIdAndTempId(String companyId, int fperiodType, String currencyId, int year, int period, String templateId) throws BOSException, EASBizException {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 rpt.fid as id,rpt.ftemplateID as templateId from T_rpt_report rpt  \n");
        sql.append(" inner join T_ORG_BaseUnit company on rpt.fcompanyid=company.fid   \n");
        sql.append(" inner join  T_BD_Currency currency on rpt.fcurrencyid=currency.fid \n");
        sql.append(" inner join T_rpt_template template on rpt.ftemplateid= template.fid \n");
        sql.append(" where  company.fid =?  \n");
        params.add(companyId);
        sql.append("  AND rpt.fperiodType = ?  AND currency.fid = ?   \n");
        params.add(new Integer(fperiodType));
        params.add(currencyId);
        sql.append(" AND fisSupportGroup=1 AND ((rpt.fyear = ? AND rpt.fperiod < ?) or (rpt.fyear = ?))    \n");
        params.add(new Integer(year));
        params.add(new Integer(period));
        params.add(new Integer(year - 1));
        sql.append(" AND template.fgroup in  (select fgroup from T_rpt_template where fid=? ) \n");
        params.add(templateId);
        sql.append("  order by rpt.fyear desc,rpt.fperiod desc  ");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])params.toArray());
        String[] rptIDAndTempId = new String[2];
        try {
            if (rowSet.next()) {
                rptIDAndTempId[0] = rowSet.getString("id");
                rptIDAndTempId[1] = rowSet.getString("templateId");
                return rptIDAndTempId;
            }
            String NoLastYearRecord = null;
            NoLastYearRecord = period != 1 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"COPY_PreRPT_NOLastYearRECORD", (Locale)this.ctx.getOriginLocale()).replaceAll("\\{0\\}", Integer.toString(year - 1)).replaceAll("\\{1\\}", Integer.toString(year)).replaceAll("\\{2\\}", Integer.toString(period - 1)) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"COPY_PreRPT_NOLastYear", (Locale)this.ctx.getOriginLocale()).replaceAll("\\{0\\}", Integer.toString(year - 1));
            throw new RptWeaveException(NoLastYearRecord);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

