/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormulaCheckResultFactory;
import com.kingdee.eas.fi.gr.cslrpt.ReportNoticeAndCheckTool;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.newrpt.MultOrgUnitHelper;
import com.kingdee.eas.fi.newrpt.PermissionHelper;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RptWeaveExecCommit
extends AbstractRptWeaveExecute {
    private String rptId = "";

    public RptWeaveExecCommit(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void beforeExecute() throws Exception {
        super.beforeExecute();
        this.rptId = this.getExistRptId();
    }

    @Override
    protected void executeRptWeave() throws Exception {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        if (execParam.isCommitReport()) {
            this.rptCommit(this.ctx, this.rptId);
        } else {
            this.cslrptCommit(this.ctx, this.rptId);
        }
    }

    private void cslrptCommit(Context ctx, String rptId) throws Exception {
        CslReportInfo editData = CslReportFactory.getLocalInstance(ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(rptId));
        if (editData.getCommittedStatus().equals((Object)CommittedStatusEnum.UNCOMMITTED) && editData.getAuditedStatus() == AuditedStatusEnum.AUDITED) {
            ArrayList<String> passedIdList = new ArrayList<String>();
            if (!CslRptUtil.isNewVersionStatus(ctx, editData, null)) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"8_BaseReportDesignerUI", (Locale)ctx.getOriginLocale()));
            }
            if (!RptAutoWeaveUtil.checkReport(ctx, this, editData.getId().toString(), 3, editData.getBook())) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"CslRptUCheckFail", (Locale)ctx.getOriginLocale()));
            }
            ArrayList<String> ReportIdList = new ArrayList<String>();
            ReportIdList.add(editData.getId().toString());
            if (ReportIdList.size() > 0) {
                ItemFormulaCheckResultFactory.getLocalInstance(ctx).batchDelete(ReportIdList);
                RptAutoWeaveUtil.clearCurBookUserObject(editData.getBook());
            }
            passedIdList.add(editData.getId().toString());
            HashSet<String> companyidset = new HashSet<String>();
            if (editData.getReportSourceType() != null && !CslRptUtil.isCslRpt(editData.getReportSourceType().getValue())) {
                companyidset.add(editData.getCompany().getId().toString());
                HashMap isCheckOpenmap = new HashMap();
                if (companyidset.size() > 0) {
                    isCheckOpenmap = CslRptUtil.getrptSysStatusCtrol(ctx, companyidset);
                }
                if (!CslRptUtil.checkGeneralLedgerIsCheckout(ctx, isCheckOpenmap, editData)) {
                    String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"General_Ledger_Not_Checkout", (Locale)ctx.getOriginLocale());
                    throw new RptWeaveException(MessageFormat.format(msg, String.valueOf(editData.getYear()), String.valueOf(CslRptUtil.getPeriod(editData.getPeriodType().getValue(), editData.getPeriod()))));
                }
            }
            this.resetContext(editData);
            String result = CslReportFactory.getLocalInstance(ctx).commitReportLocal(editData.getId().toString());
            if (passedIdList != null && passedIdList.size() > 0) {
                ReportNoticeAndCheckTool.reportCommitNotice(ctx, passedIdList, "reportCommit", null);
            }
        } else {
            if (editData.getCommittedStatus().getValue() == 3) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"224_RptReportProcessUI", (Locale)ctx.getOriginLocale()));
            }
            if (editData.getCommittedStatus().getValue() != 2) {
                throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"REPORT_COMMITED_ERROR", (Locale)ctx.getOriginLocale()));
            }
        }
    }

    private void rptCommit(Context ctx, String rptId) throws Exception {
        ReportInfo reportInfo = ReportFactory.getLocalInstance((Context)ctx).getReportInfo((IObjectPK)new ObjectUuidPK(rptId), this.getSelectors());
        if (reportInfo.getIsSupportGroup() != IsSupportGroupReportEnum.SUPPORT) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"221_RptReportProcessUI", (Locale)ctx.getOriginLocale()));
        }
        if (!CslRptUtil.isNewVersionStatus(ctx, (ReportBaseInfo)reportInfo, null)) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"222_RptReportProcessUI", (Locale)ctx.getOriginLocale()));
        }
        if (reportInfo.getAuditedStatus() == AuditedStatusEnum.UNAUDITED) {
            String FARES = "com.kingdee.eas.fi.rpt.ReportResourceSince51";
            throw new RptWeaveException(ResourceBase.getString((String)FARES, (String)"Report", (Locale)ctx.getOriginLocale()) + reportInfo.getName() + ResourceBase.getString((String)FARES, (String)"NoauditedCannotCommit", (Locale)ctx.getOriginLocale()));
        }
        if (reportInfo.getCommittedStatus() == CommittedStatusEnum.GROUPCOMMITTED) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"224_RptReportProcessUI", (Locale)ctx.getOriginLocale()));
        }
        if (reportInfo.getCommittedStatus() == CommittedStatusEnum.COMMITTED) {
            return;
        }
        FullOrgUnitInfo orgUnitInfo = (FullOrgUnitInfo)this.schmParam.getObject("KEY_COMPANY");
        if (!this.schmParam.getBoolean("rpt_web_isRptExec")) {
            this.checkOperatePermission(ctx, (IObjectPK)new ObjectUuidPK(this.userId), (IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), PermissionHelper.getCommitPermNameByOrgType((OrgType)this.getTemplateOrgType()));
        }
        HashSet<String> companyidset = new HashSet<String>();
        companyidset.add(reportInfo.getCompany().getId().toString());
        HashMap isCheckOpenmap = new HashMap();
        if (companyidset.size() > 0) {
            isCheckOpenmap = CslRptUtil.getrptSysStatusCtrol(ctx, companyidset);
        }
        if (!CslRptUtil.checkGeneralLedgerIsCheckout(ctx, isCheckOpenmap, (ReportBaseInfo)reportInfo)) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.RptUIMsg", (String)"General_Ledger_Not_Checkout", (Locale)ctx.getOriginLocale());
            throw new RptWeaveException(MessageFormat.format(msg, String.valueOf(reportInfo.getYear()), String.valueOf(CslRptUtil.getPeriod(reportInfo.getPeriodType().getValue(), reportInfo.getPeriod()))));
        }
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(reportInfo.getId().toString());
        this.resetContext((ReportBaseInfo)reportInfo);
        List list = ReportFactory.getLocalInstance((Context)ctx).commitReportNew(idList);
        String result = null;
        boolean passed = true;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String checkInterExch;
                Map map = (Map)list.get(i);
                if (map == null) continue;
                if (map.containsKey("reportCheck") && map.get("reportCheck") != null && map.get("reportCheck") instanceof List) {
                    list = (List)map.get("reportCheck");
                    i = -1;
                    continue;
                }
                if (map.get("KEY_CHECK_MESSAGE") != null) {
                    result = (String)map.get("KEY_CHECK_MESSAGE");
                }
                if (map.get("KEY_CHECK_FLAG") != null) {
                    passed = (Boolean)map.get("KEY_CHECK_FLAG");
                }
                if (!map.containsKey("checkInterExch") || StringUtils.isEmpty((String)(checkInterExch = (String)map.get("checkInterExch")))) continue;
                checkInterExch = checkInterExch.replaceAll("<br>", "\n");
                passed = false;
                throw new Exception(checkInterExch);
            }
        }
        if (passed) {
            ArrayList<String> ReportIdList = new ArrayList<String>();
            ReportIdList.add(reportInfo.getId().toString());
            if (ReportIdList.size() > 0) {
                ItemFormulaCheckResultFactory.getLocalInstance(ctx).batchDelete(ReportIdList);
                Book book = reportInfo.getBook();
                RptAutoWeaveUtil.clearCurBookUserObject(book);
            }
        } else {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"DATACHECK_FAIL", (Locale)ctx.getOriginLocale()));
        }
        ReportNoticeAndCheckTool.reportCommitNotice(ctx, idList, "reportCommit", null);
    }

    private void resetContext(ReportBaseInfo reportInfo) throws BOSException, EASBizException {
        String companyid = null;
        if (reportInfo instanceof CslReportInfo) {
            CslReportInfo cslreport = (CslReportInfo)reportInfo;
            companyid = cslreport.getOrgUnit().getId().toString();
        } else if (reportInfo instanceof ReportInfo) {
            ReportInfo report = (ReportInfo)reportInfo;
            companyid = report.getCompany().getId().toString();
        }
        FullOrgUnitInfo fullOrgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)this.ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        this.ctx.put((Object)"CompanyInfo", (Object)fullOrgUnitInfo);
        this.ctx.put((Object)OrgType.Company, (Object)MultOrgUnitHelper.getInstance().getDelegateCompanyNoOrgType((OrgUnitInfo)fullOrgUnitInfo, this.ctx));
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("dataCollect.*"));
        sic.add(new SelectorItemInfo("dataCollectNumber"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.name"));
        sic.add(new SelectorItemInfo("sourceCurrency.number"));
        sic.add(new SelectorItemInfo("sourceCurrency.precision"));
        sic.add(new SelectorItemInfo("orgRela.id"));
        sic.add(new SelectorItemInfo("orgRela.orgType"));
        sic.add(new SelectorItemInfo("orgRela.relaType"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.number"));
        sic.add(new SelectorItemInfo("savePoint.relaType"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.id"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.name"));
        sic.add(new SelectorItemInfo("savePoint.rptType.parent.number"));
        sic.add(new SelectorItemInfo("savePoint.rptType.rptTypeStd"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("template.id"));
        sic.add(new SelectorItemInfo("template.name"));
        sic.add(new SelectorItemInfo("template.number"));
        sic.add(new SelectorItemInfo("template.templateType"));
        sic.add(new SelectorItemInfo("template.group"));
        sic.add(new SelectorItemInfo("template.checkOpenPeriod"));
        return sic;
    }
}

