/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.weaverpt.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.fi.gr.cslrpt.ConvertStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveSchmRptInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveException;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.gr.weaverpt.app.AbstractRptWeaveExecute;
import com.kingdee.eas.fi.rpt.IsSupportGroupReportEnum;
import com.kingdee.eas.fi.rpt.ReportFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;

public class RptWeaveExecConvert
extends AbstractRptWeaveExecute {
    private String rptId = "";

    public RptWeaveExecConvert(RptWeaveParams schmParam, Context ctx) {
        super(schmParam, ctx);
    }

    @Override
    protected void beforeExecute() throws Exception {
        super.beforeExecute();
        this.rptId = this.getExistRptId();
    }

    @Override
    protected void executeRptWeave() throws Exception {
        RptWeaveExecParams execParam = (RptWeaveExecParams)this.schmParam.getObject("rpt_weave_execparams");
        if (execParam.isCommitReport()) {
            ReportInfo rptInfo = ReportFactory.getLocalInstance((Context)this.ctx).getReportInfo((IObjectPK)new ObjectUuidPK(this.rptId), this.getRptSelectors());
            this.convert(this.ctx, rptInfo);
        } else {
            CslReportInfo cslrptInfo = this.getCslReportInfo(this.ctx, this.rptId);
            this.cslrptAduit(this.ctx, cslrptInfo);
        }
    }

    private void verify(Context ctx, Map convertParam, ReportInfo reportInfo) throws Exception {
        StringBuffer msgBuffer = new StringBuffer();
        if (!IsSupportGroupReportEnum.SUPPORT.equals((Object)reportInfo.getIsSupportGroup()) || RptSrcTypeEnum.NORMAL.equals((Object)reportInfo.getSourceType()) || ConvertStatusEnum.Converted.equals((Object)reportInfo.getConvertStatus())) {
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"127_ReportMaintainUI", (Locale)ctx.getOriginLocale());
            msgBuffer.append(MessageFormat.format(msg, reportInfo.getNumber())).append("\r\n").append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.onlySup", (Locale)ctx.getOriginLocale())).append("\r\n");
            throw new RptWeaveException(msgBuffer.toString());
        }
        Map mapBas = (Map)convertParam.get("KEY_BASE");
        String currencyId = mapBas.get("KEY_BASE_TARGETCY").toString();
        if (reportInfo.getSourceCurrency() != null && currencyId.equals(reportInfo.getSourceCurrency().getId().toString())) {
            String number = reportInfo.getNumber() == null ? "" : reportInfo.getNumber();
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"128_ReportMaintainUI", (Locale)ctx.getOriginLocale());
            msgBuffer.setLength(0);
            msgBuffer.append(MessageFormat.format(msg, number)).append("\r\n");
            throw new RptWeaveException(msgBuffer.toString());
        }
    }

    private void convert(Context ctx, ReportInfo reportInfo) throws Exception {
        QuerySolutionInfo obj = ((RptAutoWeaveSchmRptInfo)this.schmParam.getObject("rpt_weave_rptSchmObj")).getConvertSolution();
        if (obj == null) {
            throw new RptWeaveException(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveResource", (String)"Report_Convert_NoSolution", (Locale)ctx.getOriginLocale()));
        }
        String convertSolutionId = obj.getId().toString();
        Map convertParam = this.getConvertQueryParams(ctx, convertSolutionId);
        this.verify(ctx, convertParam, reportInfo);
        Map result = ReportFactory.getLocalInstance((Context)ctx).cyCover(Arrays.asList((Object[])new String[]{reportInfo.getId().toString()}), convertParam);
        if ("error".equals(result.get("status"))) {
            throw new RptWeaveException(result.get("msg").toString());
        }
        logger.info((Object)("rptConvert:" + reportInfo.getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getConvertQueryParams(Context ctx, String querySouId) throws Exception {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("QueryPanelInfo.customerParams"));
        QuerySolutionInfo querySoluInfo = QuerySolutionFactory.getLocalInstance((Context)ctx).getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(querySouId), selector);
        String objStr = querySoluInfo.getQueryPanelInfo().get(0).getCustomerParams();
        CustomerParams cp = new CustomerParams();
        cp = XMLBean.transStrToCommonCustParams((String)objStr);
        byte[] objByte = Base64.decode((String)cp.getCustomerParam("FilterParam"));
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            Object map = bais.readObject();
            Map map2 = (Map)map;
            return map2;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

