/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.fill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.BookFormulaHelper;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.InsertType;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportServiceFacadeFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.fill.DyaItemFormulaParse;
import com.kingdee.eas.fi.gr.dynamic.util.AsstAccountUtils;
import com.kingdee.eas.fi.gr.dynamic.util.AsstActTypeUtils;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.styleinherit.IRptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInherit;
import com.kingdee.eas.fi.rpt.styleinherit.RptSheetSytleInheritParam;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorFormula;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorHeightOrWidth;
import com.kingdee.eas.fi.rpt.styleinherit.StyleDecoratorValidation;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Point;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.log4j.Logger;

public class MultiDynaItemFillHandle {
    private static final Logger logger = CoreUIObject.getLogger(MultiDynaItemFillHandle.class);
    private Sheet curSheet = null;
    private Point curPoint = null;
    private DynaParameters parameters;
    private Map attribute2AsstActTypeMap = new HashMap();
    private Map asstActTypeAttribeMap2NumberMap = new HashMap();
    private Map asstActTypeNumber2AttribeMap = new HashMap();
    private Map asstActTypeAttribeMap2GroupMap = new HashMap();
    List<String> attributeList = new ArrayList<String>();
    private Component parentUI = null;
    private Map preValueMap;
    private Map preFormulaMap;
    private IReportPropertyAdapter reportPropertyAdapter = null;
    private OrgUnitInfo company = null;
    private boolean isPass = true;
    private boolean isAutoFill = false;
    private Context ctx = null;
    private Map<String, String> specialFormulaCatch = new HashMap<String, String>();

    public MultiDynaItemFillHandle(Sheet sheet, Point basePoint, Component parentUI) {
        this.curSheet = sheet;
        this.curPoint = basePoint;
        this.parentUI = parentUI;
        this.parameters = this.getParameters();
    }

    public MultiDynaItemFillHandle(Sheet sheet, Point basePoint, boolean isAuto, Component parentUI) {
        this.curSheet = sheet;
        this.curPoint = basePoint;
        this.parentUI = parentUI;
        this.isAutoFill = isAuto;
    }

    public MultiDynaItemFillHandle(Sheet sheet, Point basePoint, boolean isAuto, Component parentUI, Context ctx) {
        this.curSheet = sheet;
        this.curPoint = basePoint;
        this.parentUI = parentUI;
        this.isAutoFill = isAuto;
        this.ctx = ctx;
    }

    public void initVar(Map attribute2AsstActTypeMap, Map asstActTypeAttribeMap2NumberMap, Map asstActTypeNumber2AttribeMap, Map preValueMap, Map preFormulaMap) {
        this.attribute2AsstActTypeMap = attribute2AsstActTypeMap;
        this.asstActTypeAttribeMap2NumberMap = asstActTypeAttribeMap2NumberMap;
        this.asstActTypeNumber2AttribeMap = asstActTypeNumber2AttribeMap;
        this.preValueMap = preValueMap;
        this.preFormulaMap = preFormulaMap;
    }

    public void initVar(IReportPropertyAdapter reportPropertyAdapter, OrgUnitInfo company) {
        this.reportPropertyAdapter = reportPropertyAdapter;
        this.company = company;
    }

    private List<String> getFirstRowFormulas() throws Exception {
        ArrayList<String> formulas = new ArrayList<String>();
        int sumLine = this.parameters.isIncludeSum() && this.parameters.getPosition() == 1 ? 1 : 0;
        int maxCol = this.getMaxColIndex(this.curSheet, this.curPoint.y, this.curPoint.x);
        this.copyFirstLineFormulaToHeadLine(maxCol, this.curPoint.y + sumLine + 1, this.curPoint);
        int startCol = this.curPoint.x + this.asstActTypeNumber2AttribeMap.size();
        Cell cell = null;
        String formula = null;
        for (int i = startCol; i <= maxCol; ++i) {
            cell = this.curSheet.getCell(this.curPoint.y, i, true);
            formula = (String)cell.getUserObjectValue("tmpFormula");
            if (StringUtils.isEmpty((String)formula) || formula.indexOf("@") <= 0 || formula.toLowerCase().indexOf("acct") <= 0) continue;
            formulas.add(formula);
        }
        return formulas;
    }

    private String getOffSetFormula(String formula, Cell cell) {
        Object havSpecialExprPosition;
        if (!StringUtils.isEmpty((String)formula) && (havSpecialExprPosition = cell.getUserObjectValue("isHavSpecialExpr")) != null) {
            String curFormula = this.specialFormulaCatch.get(havSpecialExprPosition);
            if (curFormula != null) {
                return curFormula;
            }
            String[] indexs = havSpecialExprPosition.toString().split(",");
            curFormula = DynamicTemplateUtility.offerFormula(formula, this.curSheet, Integer.valueOf(indexs[0].trim()), Integer.valueOf(indexs[1].trim()), cell.getRow(), cell.getCol());
            this.specialFormulaCatch.put(havSpecialExprPosition.toString(), curFormula);
            return curFormula;
        }
        return formula;
    }

    public void autoFillSheet() throws Exception {
        List<String> formulas = null;
        DyaItemFormulaParse formulaPars = null;
        ArrayList basePoints = DynamicTemplateUtility.getBasePointList(this.curSheet);
        ReportVariables vars = ReportVariables.loadFromBook((Book)this.curSheet.getBook());
        for (int i = basePoints.size() - 1; i >= 0; --i) {
            this.isPass = true;
            this.curPoint = (Point)basePoints.get(i);
            this.parameters = this.getParameters();
            this.clearCacheAsstActAttribute();
            this.cacheAsstActAttribute();
            formulas = this.getFirstRowFormulas();
            DynamicTemplateUtility.resumSheetFormulas(this.curSheet, formulas);
            if (!this.isPass || formulas == null || formulas.isEmpty()) {
                logger.error((Object)("basePoint " + this.curPoint.toString() + " formulas is null"));
                continue;
            }
            DynamicTemplateUtility.getRelatedExcelFormula(this.curSheet, formulas);
            formulaPars = this.ctx == null ? new DyaItemFormulaParse(null, formulas, vars, this.reportPropertyAdapter, this.curSheet.getSheetName(), this.company, this.asstActTypeNumber2AttribeMap) : new DyaItemFormulaParse(this.ctx, formulas, vars, this.reportPropertyAdapter, this.curSheet.getSheetName(), this.company, this.asstActTypeNumber2AttribeMap);
            formulaPars.formulaParse(this.curSheet);
            if (!this.check(formulaPars)) continue;
            logger.info((Object)("isAccordFillItem:" + formulaPars.isAccordFillItem()));
            if (formulaPars.isAccordFillItem() && !formulaPars.getTable_formulaFilters().isEmpty()) {
                Map dataMap = null;
                dataMap = this.ctx == null ? CslReportServiceFacadeFactory.getRemoteInstance().getDynItemData(this.getParamsMap(formulaPars, vars)) : CslReportServiceFacadeFactory.getLocalInstance((Context)this.ctx).getDynItemData(this.getParamsMap(formulaPars, vars));
                logger.debug((Object)("return DynItemData is:" + dataMap.toString()));
                this.fillSheet(dataMap);
                dataMap.clear();
                continue;
            }
            if (this.parentUI == null) continue;
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"143_multiAutoFillSuportAcct");
            MsgBox.showInfo((Component)this.parentUI, (String)msg);
        }
    }

    private boolean check(DyaItemFormulaParse formulaPars) {
        if (formulaPars.getAsstTypeMap().isEmpty()) {
            if (this.parentUI != null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"144_multiIsSame");
                MsgBox.showInfo((Component)this.parentUI, (String)msg);
            }
            return false;
        }
        for (List<String> asstValues : formulaPars.getAsstTypeMap().values()) {
            for (String asstValue : asstValues) {
                if (asstValue.indexOf(":") <= 0) continue;
                if (this.parentUI != null) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"142_checkMultiAutoFillAsstValue");
                    MsgBox.showInfo((Component)this.parentUI, (String)MessageFormat.format(msg, asstValue));
                }
                return false;
            }
        }
        return true;
    }

    private Map getParamsMap(DyaItemFormulaParse formulaPars, ReportVariables vars) throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("isMulti", true);
        params.put("formulaFilter", formulaPars.getTable_formulaFilters());
        HashMap asstActTypeAttribeAndGroupMap = new HashMap();
        ArrayList<Object> asstActTypeList = new ArrayList<Object>();
        ArrayList AsstActTypeList = this.parameters.getAsstAccount().getAsstActTypeList();
        Object AsstAct = null;
        for (Object obj : AsstActTypeList) {
            AsstAct = this.attribute2AsstActTypeMap.get(((AsstActTypeUtils)obj).asstHGAttribute);
            if (AsstAct == null) continue;
            asstActTypeList.add(AsstAct);
            asstActTypeAttribeAndGroupMap.put(((AsstActTypeUtils)obj).asstHGAttribute, this.asstActTypeAttribeMap2GroupMap.get(((AsstActTypeUtils)obj).asstHGAttribute));
        }
        HashMap useredTypes = new HashMap();
        for (String asstTypeNumber : formulaPars.getAsstTypeMap().keySet()) {
            useredTypes.put(this.attribute2AsstActTypeMap.get(this.asstActTypeNumber2AttribeMap.get(asstTypeNumber)), formulaPars.getAsstTypeMap().get(asstTypeNumber));
        }
        if (this.company == null) {
            this.company = SysContext.getSysContext().getCurrentFIUnit();
        }
        params.put("asstActTypeList", asstActTypeList);
        params.put("asstActTypeAttribeAndGroupMap", asstActTypeAttribeAndGroupMap);
        params.put("useredTypes", useredTypes);
        params.put("currentUnit", this.company);
        RptSheetParamInfo rptSheetParamInfo = VariablesHelper.variables2SheetParams((ReportVariables)vars, (String)this.curSheet.getSheetName(), (boolean)true, null);
        params.put("isIncludingUnposted", rptSheetParamInfo.isIsIncludingUnposted());
        params.put("orgType", this.reportPropertyAdapter.getReportProperty("orgType"));
        return params;
    }

    public void fillSheet(Map<Object, List<Object>> tableValues) throws Exception {
        if (tableValues != null && tableValues.size() > 0) {
            if (!this.isAutoFill) {
                this.cacheAsstActAttribute();
                this.parameters = this.getParameters();
            }
            boolean tmpListener = DynaItemListener.getisListener();
            try {
                DynaItemListener.setListener(false);
                this.adjustRowCount(tableValues);
                this.doFillSheet(tableValues);
                this.saveBasePointCell(this.curSheet, this.curPoint);
            }
            finally {
                DynaItemListener.setListener(tmpListener);
            }
            int fillRowCount = this.parameters.getDefaultCounter();
            StyleDecoratorFormula sytleInherit = new StyleDecoratorFormula(null);
            RptSheetSytleInheritParam styleParam = new RptSheetSytleInheritParam();
            if (this.parameters.isIncludeSum() && this.parameters.getPosition() == 1) {
                styleParam.setStartRow(this.curPoint.y + 2 + 1);
                styleParam.setStandardPoint(new Point(this.curPoint.x, this.curPoint.y + 1));
            } else {
                styleParam.setStartRow(this.curPoint.y + 1 + 1);
                styleParam.setStandardPoint(this.curPoint);
            }
            int endRow = styleParam.getStartRow() + fillRowCount - 2;
            styleParam.setEndRow(endRow);
            styleParam.setStartColumn(this.curPoint.x);
            styleParam.setEndColumn(this.getMaxColIndex(this.curSheet, this.curPoint.y, this.curPoint.x));
            styleParam.setVerticalInherit(true);
            styleParam.setGradeFill(false);
            styleParam.setInsertInherit(false);
            sytleInherit.regionInheritStyleByDefaultPoint(this.curSheet, styleParam);
            sytleInherit = new StyleDecoratorHeightOrWidth((IRptSheetSytleInherit)new RptSheetSytleInherit());
            sytleInherit = new StyleDecoratorValidation((IRptSheetSytleInherit)sytleInherit);
            sytleInherit.regionInheritStyleByDefaultPoint(this.curSheet, styleParam);
        } else {
            this.removeSheetRows(0, this.parameters.getDefaultCounter());
            this.parameters.setDefaultCounter(1);
            this.saveBasePointCell(this.curSheet, this.curPoint);
        }
    }

    private void doFillSheet(Map tableValues) throws BOSException {
        int sumLine = this.parameters.isIncludeSum() && this.parameters.getPosition() == 1 ? 1 : 0;
        List headItemList = this.getHeadItemList();
        int maxCol = this.getMaxColIndex(this.curSheet, this.curPoint.y, this.curPoint.x);
        this.copyFirstLineFormulaToHeadLine(maxCol, this.curPoint.y + sumLine + 1, this.curPoint);
        int colCount = this.getItemStartColIndex();
        for (int i = 0; i < this.parameters.getDefaultCounter(); ++i) {
            int asstIndex = 0;
            int itemIndex = 0;
            String dItemNumber = this.constructDItemNumber(tableValues, i);
            int x = this.curPoint.x;
            while (x <= this.getMaxColIndex(this.curSheet, this.curPoint.y, this.curPoint.x)) {
                if (x < colCount) {
                    int asstAccount = this.fillAsstItem(tableValues, x, this.curPoint.y + sumLine + i + 1, asstIndex, i);
                    x += asstAccount;
                    ++asstIndex;
                    continue;
                }
                this.fillItem(dItemNumber, headItemList, x, this.curPoint.y + sumLine + i + 1, itemIndex);
                this.autoFillFormula(tableValues, x, this.curPoint.y + sumLine + i + 1, i);
                ++x;
                ++itemIndex;
            }
        }
        this.specialFormulaCatch.clear();
        List<Integer> deleteIndex = this.getDeleteRowIndex(colCount);
        for (Integer rowIndex : deleteIndex) {
            Range range = this.curSheet.getRowRange(rowIndex.intValue(), rowIndex.intValue());
            range.setIgnoreProtected(true);
            range.delete();
        }
        this.parameters.setDefaultCounter(this.parameters.getDefaultCounter() - deleteIndex.size());
    }

    private List<Integer> getDeleteRowIndex(int colCount) {
        Cell cell;
        int i;
        ArrayList<Integer> deleteIndex = new ArrayList<Integer>();
        int itemColIndex = colCount;
        for (i = colCount; i <= this.curSheet.getMaxColIndex(); ++i) {
            cell = this.curSheet.getCell(this.curPoint.y, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            itemColIndex = i;
            break;
        }
        for (i = this.parameters.getDefaultCounter(); i > 0; --i) {
            String dItemNumber;
            ItemFormula itemFormula;
            cell = this.curSheet.getCell(this.curPoint.y + i, itemColIndex, false);
            if (cell == null || (itemFormula = this.getItemFormula(cell)) == null || (dItemNumber = itemFormula.getDItemNumber()) == null || dItemNumber.indexOf("null") <= 0 || !this.hasRowNotNull(deleteIndex, this.curPoint.y + i, itemColIndex, dItemNumber)) continue;
            deleteIndex.add(this.curPoint.y + i);
        }
        return deleteIndex;
    }

    private boolean hasRowNotNull(List<Integer> deleteIndex, int curRowIndex, int itemColIndex, String dItemNumber) {
        for (int i = this.parameters.getDefaultCounter(); i > 0; --i) {
            String[] itemNumber;
            String[] curItemNumber;
            String curDItemNumber;
            ItemFormula itemFormula;
            Cell cell;
            if (curRowIndex == this.curPoint.y + i || deleteIndex.contains(this.curPoint.y + i) || (cell = this.curSheet.getCell(this.curPoint.y + i, itemColIndex, false)) == null || (itemFormula = this.getItemFormula(cell)) == null || (curDItemNumber = itemFormula.getDItemNumber()) == null || (curItemNumber = curDItemNumber.split(";")).length != (itemNumber = dItemNumber.split(";")).length) continue;
            boolean flag = false;
            for (int j = 0; j < itemNumber.length; ++j) {
                String[] number = itemNumber[j].split("\\|");
                String[] curNumber = curItemNumber[j].split("\\|");
                if (number.length != 2 || curNumber.length != 2) break;
                boolean bl = curNumber[0] != null ? curNumber[0].equals(number[0]) : (flag = number[0] == null);
                if (!flag) break;
                if ("null".equals(number[1])) continue;
                boolean bl2 = curNumber[1] != null ? curNumber[1].equals(number[1]) : (flag = number[1] == null);
                if (!flag) break;
            }
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private void autoFillFormula(Map tableValues, int curCol, int curRow, int rowIndex) throws BOSException {
        Cell headCell = this.curSheet.getCell(this.curPoint.y, curCol, true);
        Cell curCell = this.curSheet.getCell(curRow, curCol, true);
        if (headCell.getUserObject("tmpFormula") != null) {
            String formula = headCell.getUserObject("tmpFormula").getValue().toString();
            if ((formula = this.getOffSetFormula(formula, headCell)).toUpperCase().indexOf("DYITEM") >= 0) {
                this.autoFillDyitemFormula(curCell, formula, tableValues, rowIndex);
            } else {
                String[] asstNumbers;
                String[] asstTypes = this.getAsstType(formula, headCell);
                boolean isAcct = false;
                if (formula.toUpperCase().indexOf("ACCT(") >= 0 || formula.toUpperCase().indexOf("AGE(") >= 0) {
                    isAcct = true;
                }
                if (asstTypes != null && (asstNumbers = this.getCurRowAsstNumberByAsstType(tableValues, asstTypes, rowIndex, isAcct)) != null) {
                    StringBuffer tmpFormula = new StringBuffer();
                    int lastIndex = 0;
                    for (int i = 0; i < asstNumbers.length; ++i) {
                        if (formula.indexOf("@") >= 0) {
                            int index = formula.indexOf("@", lastIndex);
                            if (index < 0) continue;
                            String curAsstNumber = Matcher.quoteReplacement(asstNumbers[i]);
                            tmpFormula.append(formula.substring(lastIndex, index)).append(curAsstNumber);
                            lastIndex = index + 1;
                            continue;
                        }
                        if (this.parentUI != null) {
                            MsgBox.showInfo((Component)this.parentUI, (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"61_MultiDynaItemWizardUI") + curCell.getName(false, true) + EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"62_MultiDynaItemWizardUI")));
                        }
                        SysUtil.abort();
                    }
                    tmpFormula.append(formula.substring(lastIndex, formula.length()));
                    curCell.setFormula(tmpFormula.toString());
                }
            }
        } else {
            String firstFormula;
            int sumLine = this.parameters.isIncludeSum() && this.parameters.getPosition() == 1 ? 1 : 0;
            Cell firstCell = this.curSheet.getCell(this.curPoint.y + sumLine + 1, curCol, false);
            if (firstCell != null && !StringUtils.isEmpty((String)(firstFormula = firstCell.getFormula())) && firstFormula.indexOf("@") < 0) {
                curCell.setFormula(firstFormula);
            }
        }
    }

    private void autoFillDyitemFormula(Cell cell, String formula, Map tableValues, int rowIndex) {
        String dyItem = this.getDyitem(formula);
        if (!StringUtils.isEmpty((String)dyItem)) {
            if (dyItem.trim().equals("@")) {
                String ditemNumber = this.constructDItemNumber(tableValues, rowIndex);
                cell.setFormula(formula.replaceFirst("@", Matcher.quoteReplacement(ditemNumber)));
            } else {
                String[] asstType2itemArray = dyItem.split(";");
                String asstType = null;
                String[] itemNumbers = null;
                for (String curAsstType2item : asstType2itemArray) {
                    if (curAsstType2item.indexOf("@") < 0 || curAsstType2item.indexOf("|") < 0 || (itemNumbers = this.getCurRowAsstNumberByAsstType(tableValues, new String[]{asstType = curAsstType2item.split("\\|")[0].trim()}, rowIndex)) == null || itemNumbers.length <= 0) continue;
                    formula = formula.replaceFirst("@", Matcher.quoteReplacement(itemNumbers[0]));
                }
                cell.setFormula(formula);
            }
        }
    }

    private int fillAsstItem(Map tableValues, int x, int y, int asstIndex, int rowIndex) {
        Range range;
        int count = 0;
        AsstActTypeUtils asstActType = (AsstActTypeUtils)this.parameters.getAsstAccount().getAsstActTypeList().get(asstIndex);
        List objValues = (List)tableValues.get(asstActType.asstHGAttribute);
        IObjectValue info = (IObjectValue)objValues.get(rowIndex);
        if (!StringUtils.isEmpty((String)asstActType.properityName)) {
            range = this.curSheet.getRange(y, x++);
            range.setIgnoreProtected(true);
            range.setValue(new Variant());
            if (info != null) {
                range.setValue(new Variant(info.get("number")));
            }
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.properityAlias)) {
            range = this.curSheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setValue(new Variant());
            if (info != null) {
                range.setValue(new Variant(info.get("name", SysContext.getSysContext().getLocale())));
            }
            ++count;
        }
        if (!StringUtils.isEmpty((String)asstActType.dynaProperty)) {
            range = this.curSheet.getRange(y, x);
            range.setIgnoreProtected(true);
            range.setValue(new Variant());
            range.setUserObject("guideFill", (Object)"Y");
            if (info != null) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.attribute2AsstActTypeMap.get(asstActType.getAsstHGAttribute());
                MetaDataPK pk = new MetaDataPK(asstActTypeInfo.getDefaultQueryName());
                IQueryExecutor exec = null;
                exec = this.ctx == null ? QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk) : QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)pk);
                EntityViewInfo ev = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                if ("numberandname".equalsIgnoreCase(asstActType.dynaProperty)) {
                    sic.add("name");
                    sic.add("number");
                } else {
                    sic.add(asstActType.dynaProperty);
                }
                ev.setSelector(sic);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", info.get("id")));
                ev.setFilter(filter);
                exec.setObjectView(ev);
                try {
                    IRowSet rs = exec.executeQuery();
                    if (rs.next()) {
                        if ("numberandname".equalsIgnoreCase(asstActType.dynaProperty)) {
                            range.setValue(new Variant((Object)(rs.getString("number") + "-" + rs.getString("name"))));
                        } else {
                            String s = null;
                            s = rs.getString(asstActType.getDynaProperty()).equals("false") ? (this.ctx == null ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"87_DynaRangeUI") : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource.87_DynaRangeUI", (Locale)this.ctx.getOriginLocale())) : (rs.getString(asstActType.getDynaProperty()).equals("true") ? (this.ctx == null ? EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"86_DynaRangeUI") : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource,86_DynaRangeUI", (Locale)this.ctx.getOriginLocale())) : rs.getString(asstActType.getDynaProperty()));
                            range.setValue(new Variant((Object)s));
                        }
                    }
                }
                catch (BOSException e) {
                    logger.error((Object)e.getStackTrace(), (Throwable)e);
                }
                catch (SQLException e) {
                    logger.error((Object)e.getStackTrace(), (Throwable)e);
                }
            }
            ++count;
        }
        return count;
    }

    private void fillItem(String dItemNumber, List headItemList, int x, int y, int colIndex) {
        Range range = this.curSheet.getRange(y, x);
        range.setIgnoreProtected(true);
        ItemFormula itemFormula = (ItemFormula)headItemList.get(colIndex);
        if (itemFormula != null) {
            this.fillDItemFormula(range, itemFormula, dItemNumber);
            this.fillValue(range, this.getItemFormulaKey(itemFormula), dItemNumber);
            this.fillFormula(range, this.getItemFormulaKey(itemFormula), dItemNumber);
        } else {
            range.setUserObject("ITEM", null);
            range.setValue(Variant.nullVariant);
            range.setFormula(null);
        }
    }

    private String getItemFormulaKey(ItemFormula itemFormula) {
        if (itemFormula == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(itemFormula.getItemNumber()).append(";");
        sb.append(itemFormula.getDataElementNumber()).append(";");
        sb.append(itemFormula.getValueType());
        return sb.toString();
    }

    private AsstActTypeInfo getCachedAsstActTypeInfo(String attribute) {
        return (AsstActTypeInfo)this.attribute2AsstActTypeMap.get(attribute);
    }

    private void fillDItemFormula(Range range, ItemFormula itemFormula, String dItemNumber) {
        String dItemFormula = this.constructDItemFormula(itemFormula, dItemNumber);
        range.setUserObject("ITEM", (Object)new ItemFormula(dItemFormula));
    }

    private void fillValue(Range range, String itemFormulaKey, String dItemNumber) {
        Map dItem2ValueMap;
        if (this.preValueMap != null && (dItem2ValueMap = (Map)this.preValueMap.get(itemFormulaKey)) != null) {
            Variant value = (Variant)dItem2ValueMap.get(dItemNumber);
            if (value != null) {
                range.setValue(value);
            } else {
                range.setValue(Variant.nullVariant);
            }
        }
    }

    private String constructDItemFormula(ItemFormula itemFormula, String dnumber) {
        if (itemFormula == null) {
            return null;
        }
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("=DItem(\"");
        strBuffer.append(itemFormula.getItemNumber() + "\",\"");
        strBuffer.append(dnumber + "\",");
        strBuffer.append(itemFormula.getYearOffSet() + ",");
        strBuffer.append(itemFormula.getPeriodOffSet() + ",\"");
        strBuffer.append(itemFormula.getDataElementNumber() + "\",\"");
        ValueTypeEnum type = ValueTypeEnum.getEnum((int)itemFormula.getValueType());
        if (type == null) {
            return null;
        }
        strBuffer.append(ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getName());
        strBuffer.append("\")");
        return strBuffer.toString();
    }

    private void fillFormula(Range range, String itemFormulaKey, String dItemNumber) {
        Map dItem2FormulaMap;
        if (this.preFormulaMap != null && (dItem2FormulaMap = (Map)this.preFormulaMap.get(itemFormulaKey)) != null) {
            String formula = (String)dItem2FormulaMap.get(dItemNumber);
            if (formula != null) {
                range.setFormula(formula);
            } else {
                range.setFormula(null);
            }
        }
    }

    private String constructDItemNumber(Map tableValues, int rowIndex) {
        StringBuffer sb = new StringBuffer();
        boolean isFirst = true;
        ArrayList attributeList = this.parameters.getAsstAccount().getAsstActTypeList();
        HashSet<String> attributeSet = new HashSet<String>();
        ArrayList<AsstActTypeUtils> attributeListCopy = new ArrayList<AsstActTypeUtils>();
        for (int j = 0; j < attributeList.size(); ++j) {
            AsstActTypeUtils asstType = (AsstActTypeUtils)attributeList.get(j);
            if (attributeSet.contains(asstType.getAsstHGAttribute())) continue;
            attributeSet.add(asstType.getAsstHGAttribute());
            attributeListCopy.add(asstType);
        }
        for (AsstActTypeUtils asstActTypeUtils : attributeListCopy) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(";");
            }
            sb.append(this.asstActTypeAttribeMap2NumberMap.get(asstActTypeUtils.asstHGAttribute));
            List objectList = (List)tableValues.get(asstActTypeUtils.asstHGAttribute);
            IObjectValue info = (IObjectValue)objectList.get(rowIndex);
            String fieldName = RptUtil.isUseLongNumber((AsstActTypeInfo)this.getCachedAsstActTypeInfo(asstActTypeUtils.asstHGAttribute)) ? "longnumber" : "number";
            sb.append("|").append(info == null ? "null" : info.get(fieldName));
        }
        return sb.toString();
    }

    private void copyFirstLineFormulaToHeadLine(int maxCol, int firstLine, Point basePoint) throws BOSException {
        Cell headCell = null;
        Cell firstCell = null;
        String formula = null;
        for (int i = basePoint.x; i <= maxCol; ++i) {
            boolean isExcelFunction;
            headCell = this.curSheet.getCell(basePoint.y, i, true);
            firstCell = this.curSheet.getCell(firstLine, i, true);
            formula = firstCell.getFormula();
            if (this.isAutoFormula(formula, firstCell)) {
                headCell.setUserObject("tmpFormula", (Object)formula);
                if (formula == null) continue;
                boolean isHavSpecialExpr = DynamicTemplateUtility.isExcelFormula(formula);
                if (isHavSpecialExpr) {
                    headCell.setUserObject("isHavSpecialExpr", (Object)(headCell.getRow() + "," + headCell.getCol()));
                    continue;
                }
                headCell.setUserObject("isHavSpecialExpr", null);
                continue;
            }
            if (formula == null || !(isExcelFunction = BookFormulaHelper.isExcelFunctionNodigit(null, (Sheet)this.curSheet, (String)formula))) continue;
            headCell.setUserObject("tmpFormula", (Object)formula);
            headCell.setUserObject("isHavSpecialExpr", (Object)(headCell.getRow() + "," + headCell.getCol()));
        }
    }

    private void removeSheetRows(int rowCount, int oldMaxRowCount) {
        int y = this.curPoint.y;
        int sumLine = this.parameters.isIncludeSum() && this.parameters.getPosition() == 1 ? 1 : 0;
        int y1 = y + (rowCount == 0 ? rowCount + 1 : rowCount) + 1 + sumLine;
        int y2 = y + oldMaxRowCount + sumLine;
        Range range = this.curSheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        if (y2 - y1 >= 0) {
            range.delete();
        }
    }

    private int getMaxColIndex(Sheet curSheet, int top, int left) {
        int width;
        for (int i = width = curSheet.getMaxColIndex(); i > left; --i) {
            Cell cell = curSheet.getCell(top, i, false);
            if (cell == null || !this.hasItemFormula(cell)) continue;
            return i;
        }
        return 1;
    }

    private List getHeadItemList() {
        ArrayList<ItemFormula> result = new ArrayList<ItemFormula>();
        for (int i = this.getItemStartColIndex(); i <= this.getMaxColIndex(this.curSheet, this.curPoint.y, this.curPoint.x); ++i) {
            Cell cell = this.curSheet.getCell(this.curPoint.y, i, false);
            result.add(cell == null ? null : this.getItemFormula(cell));
        }
        return result;
    }

    private int getItemStartColIndex() {
        int startIndex = this.curPoint.x;
        AsstAccountUtils asstAccount = this.parameters.getAsstAccount();
        if (asstAccount == null) {
            return startIndex;
        }
        for (AsstActTypeUtils asstType : asstAccount.getAsstActTypeList()) {
            if (!StringUtils.isEmpty((String)asstType.properityAlias)) {
                ++startIndex;
            }
            if (!StringUtils.isEmpty((String)asstType.properityName)) {
                ++startIndex;
            }
            if (StringUtils.isEmpty((String)asstType.dynaProperty)) continue;
            ++startIndex;
        }
        return startIndex;
    }

    private void adjustRowCount(Map tableValues) {
        int realRowCount = ((List)tableValues.get(((AsstActTypeUtils)this.parameters.getAsstAccount().getAsstActTypeList().get((int)0)).asstHGAttribute)).size();
        if (realRowCount > this.parameters.getDefaultCounter()) {
            this.addSheetRows(realRowCount, this.parameters.getDefaultCounter());
        } else if (realRowCount < this.parameters.getDefaultCounter()) {
            this.removeSheetRows(realRowCount, this.parameters.getDefaultCounter());
        }
        this.parameters.setDefaultCounter(realRowCount);
    }

    private void addSheetRows(int rowCount, int oldMaxRowCount) {
        int y = this.curPoint.y;
        int sumLine = this.parameters.isIncludeSum() && this.parameters.getPosition() == 1 ? 1 : 0;
        int y1 = y + oldMaxRowCount + 1 + sumLine;
        int y2 = y + rowCount + sumLine;
        Range range = this.curSheet.getRowRange(y1, y2);
        range.setIgnoreProtected(true);
        range.insert(true, InsertType.NOSTYLE);
    }

    private void saveBasePointCell(Sheet table, Point basePoint) {
        DynamicTemplateUtility.autoAdjustSum(this.curSheet, this.curPoint, this.parameters.getDefaultCounter(), false);
        Range range = table.getRange(basePoint.y, basePoint.x);
        DynamicTemplateUtility.saveParametersToCell(range, this.parameters);
    }

    private boolean isAutoFormula(String formula, Cell cell) throws BOSException {
        if (formula != null && !StringUtils.isEmpty((String)formula)) {
            String upperCaseFormula = formula.toUpperCase();
            if (DynamicTemplateUtility.isInclude(formula) && (upperCaseFormula.indexOf("ACCT") >= 0 || upperCaseFormula.indexOf("ACCTEXT") >= 0 || upperCaseFormula.indexOf("AGE") >= 0)) {
                ItemFormula itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM");
                if (itemFormula != null && itemFormula.getDItemNumber() != null && itemFormula.getDItemNumber().indexOf("@") > 0) {
                    return false;
                }
                if (this.getAsstType(formula, cell) != null) {
                    return true;
                }
            }
            if (formula.indexOf("@") > 0 && upperCaseFormula.indexOf("DYITEM") >= 0) {
                return this.isDyitemAutoFill(formula, cell);
            }
        }
        return false;
    }

    private boolean isDyitemAutoFill(String formula, Cell cell) {
        String dyitem = this.getDyitem(formula);
        if (!StringUtils.isEmpty((String)dyitem) && dyitem.indexOf("@") >= 0) {
            String[] itemGroupArray = dyitem.split(";");
            if (itemGroupArray.length > 0) {
                String asstType = null;
                for (String curItemGroup : itemGroupArray) {
                    if (curItemGroup.indexOf("@") < 0 || curItemGroup.indexOf("|") < 0 || this.asstActTypeNumber2AttribeMap.containsKey(asstType = curItemGroup.split("\\|")[0])) continue;
                    if (this.parentUI != null) {
                        MsgBox.showInfo((Component)this.parentUI, (String)(EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"61_MultiDynaItemWizardUI") + cell.getName(false, true) + EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"63_MultiDynaItemWizardUI") + asstType + EASResource.getString((String)"com.kingdee.eas.fi.gr.dynamic.DYNAMICAutoGenerateResource", (String)"64_MultiDynaItemWizardUI")));
                    }
                    SysUtil.abort();
                }
            }
            return true;
        }
        return false;
    }

    private String getDyitem(String formula) {
        String paramStr = formula.substring(formula.indexOf("(") + 1, formula.lastIndexOf(")"));
        String[] paramArray = paramStr.split(",");
        if (paramArray.length > 6) {
            String dyitem = paramArray[5];
            return dyitem.substring(dyitem.indexOf("\"") + 1, dyitem.lastIndexOf("\""));
        }
        return null;
    }

    private String[] getAsstType(String formula, Cell cell) throws BOSException {
        String[] tmpValue = formula.split("@");
        if (tmpValue.length < 1) {
            return null;
        }
        String[] asstTypes = new String[tmpValue.length - 1];
        String asstType = null;
        for (int i = 0; i < tmpValue.length - 1; ++i) {
            if (tmpValue[i] != null && !StringUtils.isEmpty((String)tmpValue[i])) {
                String msg;
                int lastIndex = tmpValue[i].lastIndexOf("|");
                if (lastIndex > 0 && tmpValue[i].lastIndexOf("|", lastIndex - 1) >= 0) {
                    asstType = tmpValue[i].substring(tmpValue[i].lastIndexOf("|", lastIndex - 1) + 1, lastIndex);
                    if (!this.asstActTypeNumber2AttribeMap.containsKey(asstType)) {
                        if (this.ctx == null) {
                            msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"64_MultiDynaItemWizardUI");
                            MsgBox.showInfo((Component)this.parentUI, (String)MessageFormat.format(msg, cell.getName(false, true), asstType));
                            if (this.isAutoFill) {
                                this.isPass = false;
                                continue;
                            }
                            SysUtil.abort();
                            continue;
                        }
                        if (this.isAutoFill) {
                            this.isPass = false;
                        }
                        msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"64_MultiDynaItemWizardUI", (Locale)this.ctx.getOriginLocale(), (Object[])new Object[]{cell.getName(false, true), asstType});
                        throw new BOSException(msg);
                    }
                    asstTypes[i] = asstType;
                    continue;
                }
                if (this.ctx == null) {
                    if (this.parentUI != null) {
                        msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"65_MultiDynaItemWizardUI");
                        MsgBox.showInfo((Component)this.parentUI, (String)MessageFormat.format(msg, cell.getName(false, true)));
                    }
                    if (this.isAutoFill) {
                        this.isPass = false;
                        continue;
                    }
                    SysUtil.abort();
                    continue;
                }
                if (this.isAutoFill) {
                    this.isPass = false;
                }
                msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"65_MultiDynaItemWizardUI", (Locale)this.ctx.getOriginLocale(), (Object[])new Object[]{cell.getName(false, true)});
                throw new BOSException(msg);
            }
            if (this.ctx == null) {
                if (this.parentUI != null) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"65_MultiDynaItemWizardUI");
                    MsgBox.showInfo((Component)this.parentUI, (String)MessageFormat.format(msg, cell.getName(false, true)));
                }
                if (this.isAutoFill) {
                    this.isPass = false;
                    continue;
                }
                SysUtil.abort();
                continue;
            }
            if (this.isAutoFill) {
                this.isPass = false;
            }
            String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"65_MultiDynaItemWizardUI", (Locale)this.ctx.getOriginLocale(), (Object[])new Object[]{cell.getName(false, true)});
            throw new BOSException(msg);
        }
        return asstTypes;
    }

    private String[] getCurRowAsstNumberByAsstType(Map tableValues, String[] asstType, int rowIndex) {
        return this.getCurRowAsstNumberByAsstType(tableValues, asstType, rowIndex, false);
    }

    private String[] getCurRowAsstNumberByAsstType(Map tableValues, String[] asstType, int rowIndex, boolean isAcct) {
        String[] asst = new String[asstType.length];
        String attribe = null;
        for (int i = 0; i < asstType.length; ++i) {
            if (this.asstActTypeNumber2AttribeMap.containsKey(asstType[i])) {
                attribe = (String)this.asstActTypeNumber2AttribeMap.get(asstType[i]);
                List objectList = (List)tableValues.get(attribe);
                IObjectValue info = (IObjectValue)objectList.get(rowIndex);
                if (info != null) {
                    AsstActTypeInfo asstActTypeInfo = this.getCachedAsstActTypeInfo(attribe);
                    boolean isUseLongNumber = RptUtil.isUseLongNumber((AsstActTypeInfo)asstActTypeInfo);
                    if (isAcct && !"T_BD_GeneralAsstActType".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
                        isUseLongNumber = false;
                    }
                    if (isUseLongNumber || "CurProject".equals(attribe)) {
                        asst[i] = ((String)info.get("longnumber")).replaceAll("\\!", "\\.");
                        continue;
                    }
                    asst[i] = (String)info.get("number");
                    continue;
                }
                asst[i] = "null";
                continue;
            }
            return null;
        }
        return asst;
    }

    private boolean hasItemFormula(Cell cell) {
        if (cell == null) {
            return false;
        }
        ItemFormula itemCellObj = this.getItemFormula(cell);
        return itemCellObj != null;
    }

    private ItemFormula getItemFormula(Cell cell) {
        ItemFormula itemCellObj = (ItemFormula)cell.getUserObjectValue("ITEM");
        return itemCellObj;
    }

    private DynaParameters getParameters() {
        this.parameters = DynamicTemplateUtility.getDynaParametersFromCell(this.curSheet, this.curPoint.y, this.curPoint.x);
        return this.parameters;
    }

    private void clearCacheAsstActAttribute() {
        this.attributeList.clear();
        this.attribute2AsstActTypeMap.clear();
        this.asstActTypeAttribeMap2NumberMap.clear();
        this.asstActTypeNumber2AttribeMap.clear();
        this.asstActTypeAttribeMap2GroupMap.clear();
    }

    private void cacheAsstActAttribute() throws Exception {
        if (this.asstActTypeNumber2AttribeMap.isEmpty() || this.asstActTypeAttribeMap2NumberMap.isEmpty() || this.attribute2AsstActTypeMap.isEmpty() || this.attributeList.isEmpty()) {
            this.clearCacheAsstActAttribute();
            ArrayList AsstActTypeList = this.parameters.getAsstAccount().getAsstActTypeList();
            for (Object obj : AsstActTypeList) {
                this.attributeList.add(((AsstActTypeUtils)obj).asstHGAttribute);
                this.asstActTypeAttribeMap2GroupMap.put(((AsstActTypeUtils)obj).asstHGAttribute, ((AsstActTypeUtils)obj).assistantSubType);
            }
            Map asstActTypeMap = null;
            asstActTypeMap = this.ctx == null ? DynamicTemplateUtility.getAsstActTypeMap(null, this.attributeList) : DynamicTemplateUtility.getAsstActTypeMap(this.ctx, this.attributeList);
            for (Object number : asstActTypeMap.keySet()) {
                this.asstActTypeNumber2AttribeMap.put(number, ((AsstActTypeInfo)asstActTypeMap.get(number)).getAsstHGAttribute());
                this.asstActTypeAttribeMap2NumberMap.put(((AsstActTypeInfo)asstActTypeMap.get(number)).getAsstHGAttribute(), number);
                this.attribute2AsstActTypeMap.put(((AsstActTypeInfo)asstActTypeMap.get(number)).getAsstHGAttribute(), (AsstActTypeInfo)asstActTypeMap.get(number));
            }
            this.attributeList.clear();
            asstActTypeMap.clear();
        }
    }
}

