/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.gr.cslrpt.DynaSumMethodEnum;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeEntryInfo;
import com.kingdee.eas.fi.gr.dynamic.DItemGradeInfo;
import com.kingdee.eas.fi.gr.dynamic.util.DynaGradeSettingAdviser;
import com.kingdee.eas.fi.gr.dynamic.util.DynaItemListener;
import com.kingdee.eas.fi.gr.dynamic.util.DynaParameters;
import com.kingdee.eas.fi.gr.dynamic.util.DynamicTemplateUtility;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.UserObjectHelper;
import com.kingdee.util.StringUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DynaGradeSettingAdviserImpl
implements DynaGradeSettingAdviser {
    private Sheet sheet;
    private boolean isVertical = true;
    private int maxItemPos = -1;
    private Point basePoint;
    private Point topBasePoint;
    private int[] headerPos = null;
    private boolean isFillSumData = false;
    private Map nameMap;
    private DynaParameters param;
    private int showCount;
    private boolean genItemFormula = true;
    private String type = "report";
    private DItemGradeInfo templateGradeInfo;
    private Map<String, String> formulaCatch = new HashMap<String, String>();
    private int summethod = 0;

    public DItemGradeInfo getTemplateGradeInfo() {
        return this.templateGradeInfo;
    }

    public void setTemplateGradeInfo(DItemGradeInfo templateGradeInfo) {
        this.templateGradeInfo = templateGradeInfo;
    }

    public DynaGradeSettingAdviserImpl(Sheet sheet) {
        this.sheet = sheet;
    }

    @Override
    public DItemGradeInfo fetch() {
        return (DItemGradeInfo)this.sheet.getBook().getActiveCellRange().getUserObject("DItemGradeInfo");
    }

    public void setBasePoint(Point b) {
        this.basePoint = b;
        this.topBasePoint = new Point(b.x, b.y);
    }

    public void setIsFillSumData(boolean b) {
        this.isFillSumData = b;
    }

    @Override
    public void fill(DItemGradeInfo info) {
        DItemGradeInfo fill = info;
        if (this.basePoint == null) {
            int col = this.sheet.getActiveCol();
            int row = this.sheet.getActiveRow();
            this.basePoint = new Point(col, row);
        }
        this.param = DynamicTemplateUtility.getDynaParameters(this.sheet, this.basePoint);
        this.isVertical = this.param.getSpreadStyle() == 0;
        FillDataBuild b = new FillDataBuild(fill, this.param.getPosition() == 1, DynaSumMethodEnum.getEnum((int)this.getSumMethod()));
        this.initHeaderPos();
        int endRowIndex = 0;
        endRowIndex = this.isVertical ? this.basePoint.y + this.param.getDefaultCounter() : this.basePoint.x + this.param.getDefaultCounter();
        int count = b.newEntries.size();
        boolean isTemplate = this.type.equals("template");
        if (isTemplate) {
            this.formulaCatch.clear();
            this.clear(this.basePoint, count, endRowIndex, true);
            this.param.setDefaultCounter(b.newEntries.size());
            DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x)), this.param);
        }
        if (this.isVertical) {
            this.fillVertical(b.newEntries);
        } else {
            this.fillHoriozonal(b.newEntries);
        }
        if (isTemplate) {
            this.formulaCatch.clear();
        }
    }

    public void fill(Map infos) {
        int n;
        this.param = DynamicTemplateUtility.getDynaParameters(this.sheet, this.basePoint);
        this.isVertical = this.param.getSpreadStyle() == 0;
        this.initHeaderPos();
        int i = 0;
        int entrySize = 0;
        for (Map.Entry entry : infos.entrySet()) {
            DItemGradeInfo info = (DItemGradeInfo)entry.getValue();
            info.reform2(true);
            FillDataBuild b = new FillDataBuild(info, this.param.getPosition() == 1, DynaSumMethodEnum.getEnum((int)this.getSumMethod()));
            entry.setValue(b);
            entrySize += b.newEntries.size();
            ++i;
        }
        int endRowIndex = 0;
        endRowIndex = this.isVertical ? this.basePoint.y + this.param.getDefaultCounter() : this.basePoint.x + this.param.getDefaultCounter();
        this.clear(this.basePoint, entrySize > this.param.getDefaultCounter() ? entrySize : this.param.getDefaultCounter(), endRowIndex, false);
        int n2 = -1;
        int col = -1;
        int pos = -1;
        if (this.isVertical) {
            pos = this.basePoint.y;
            col = this.basePoint.x;
        } else {
            n = this.basePoint.y;
            pos = this.basePoint.x;
        }
        Range basepoint = UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x));
        for (Map.Entry en : infos.entrySet()) {
            FillDataBuild b = (FillDataBuild)en.getValue();
            if (this.isVertical) {
                this.basePoint.y = pos = this.fillVertical(b.newEntries, pos, col);
                this.basePoint.x = col;
                continue;
            }
            this.basePoint.x = pos = this.fillHoriozonal(b.newEntries, n, pos);
            this.basePoint.y = n;
        }
        this.param.setDefaultCounter(entrySize);
        DynamicTemplateUtility.saveParametersToCell(basepoint, this.param);
    }

    void initHeaderPos() {
        ItemFormula item;
        int i;
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (this.isVertical) {
            for (i = this.basePoint.x; i <= this.sheet.getCols().getMaxIntMark(); ++i) {
                item = UserObjectHelper.getItemFormula((Cell)this.sheet.getCell(this.basePoint.y, i, false));
                if (item == null || item.toString() == null) continue;
                temp.add(new Integer(i));
            }
        } else {
            for (i = this.basePoint.y; i <= this.sheet.getRows().getMaxIntMark(); ++i) {
                item = UserObjectHelper.getItemFormula((Cell)this.sheet.getCell(i, this.basePoint.x, false));
                if (item == null || item.toString() == null) continue;
                temp.add(new Integer(i));
            }
        }
        this.headerPos = new int[temp.size()];
        for (i = 0; i < temp.size(); ++i) {
            this.headerPos[i] = (Integer)temp.get(i);
        }
        if (this.topBasePoint == null) {
            this.topBasePoint = new Point(this.basePoint.x, this.basePoint.y);
        }
    }

    private void clear(Point base, int count, int endLine, boolean isCatchFormul) {
        boolean isShoeNumber = false;
        if (this.param.getDynaItemShowType() == 1) {
            isShoeNumber = true;
        }
        Sheet.ICellsIterator it = null;
        if (this.isVertical) {
            int defaultCount = endLine - base.y;
            int nextBasePointIndex = this.getNextBasePointRowCol(base, count, true);
            if (nextBasePointIndex > 0) {
                endLine = endLine >= nextBasePointIndex ? nextBasePointIndex - 1 : endLine;
            }
            this.maxItemPos = this.sheet.getCols().getMaxIntMark();
            int end = base.y + count;
            int deff = endLine - end;
            it = this.sheet.getCellsIterator(base.y + 1, isShoeNumber ? base.x - 1 : base.x, endLine, this.maxItemPos, true, true);
            while (it.hasNext()) {
                Cell cell = it.next();
                if (isCatchFormul) {
                    this.catchFormul(cell);
                }
                UserObjectHelper.setItemFormula((Cell)cell, null);
                cell.setFormula(null);
            }
            if (deff < 0) {
                UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(base.y + 1, base.y + -deff)).insert();
            } else if (deff > 0) {
                UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(base.y + 1, base.y + deff)).delete();
            }
        } else {
            int nextBasePointIndex = this.getNextBasePointRowCol(base, count, false);
            if (nextBasePointIndex > 0) {
                endLine = endLine >= nextBasePointIndex ? nextBasePointIndex - 1 : endLine;
            }
            this.maxItemPos = this.sheet.getRows().getMaxIntMark();
            int end = base.x + count;
            int deff = endLine - end;
            it = this.sheet.getCellsIterator(isShoeNumber ? base.y - 1 : base.y, base.x + 1, this.maxItemPos, endLine, true, true);
            while (it.hasNext()) {
                Cell cell = it.next();
                if (isCatchFormul) {
                    this.catchFormul(cell);
                }
                UserObjectHelper.setItemFormula((Cell)cell, null);
                cell.setFormula(null);
            }
            if (deff < 0) {
                UserObjectHelper.getUnprotectedRange((Range)this.sheet.getColRange(base.x + 1, base.x + -deff)).insert();
            } else if (deff > 0) {
                UserObjectHelper.getUnprotectedRange((Range)this.sheet.getColRange(base.x + 1, base.x + deff)).delete();
            }
        }
    }

    private void catchFormul(Cell cell) {
        String itemFormulaStr;
        if (this.type.equals("template") && !StringUtils.isEmpty((String)(itemFormulaStr = this.getCellItemFormula(cell))) && !StringUtils.isEmpty((String)cell.getFormula())) {
            this.formulaCatch.put(itemFormulaStr, cell.getFormula());
        }
    }

    private void setFormula(Cell cell) {
        String formula;
        String itemFormulaStr;
        if (this.type.equals("template") && !this.formulaCatch.isEmpty() && !StringUtils.isEmpty((String)(itemFormulaStr = this.getCellItemFormula(cell))) && !StringUtils.isEmpty((String)(formula = this.formulaCatch.get(itemFormulaStr)))) {
            cell.setFormula(formula);
        }
    }

    private String getCellItemFormula(Cell cell) {
        Object itemObject = cell.getUserObjectValue("ITEM");
        if (itemObject != null && itemObject instanceof ItemFormula) {
            return ((ItemFormula)itemObject).toString();
        }
        return null;
    }

    private int getNextBasePointRowCol(Point base, int count, boolean isRow) {
        if (isRow) {
            int maxRow = this.sheet.getMaxRowIndex();
            for (int i = base.y + 1; i <= maxRow; ++i) {
                if (!DynamicTemplateUtility.isBasePointCell(this.sheet, i, base.x)) continue;
                return i;
            }
            int baseEndRow = base.y + count;
            return baseEndRow > maxRow ? baseEndRow : maxRow + 1;
        }
        int colRow = this.sheet.getMaxColIndex();
        for (int i = base.x + 1; i <= colRow; ++i) {
            if (!DynamicTemplateUtility.isBasePointCell(this.sheet, base.y, i)) continue;
            return i;
        }
        int baseEndCol = base.x + count;
        return baseEndCol > colRow ? baseEndCol : colRow + 1;
    }

    private int fillVertical(List list, int row, int col) {
        for (int i = 0; i < list.size(); ++i) {
            int newRow = ++row;
            this.fillLine((MyDItemGradeEntryInfo)list.get(i), newRow, this.basePoint.x, newRow, this.basePoint.x - 1, false);
        }
        return row;
    }

    private int fillHoriozonal(List list, int row, int col) {
        for (int i = 0; i < list.size(); ++i) {
            int newCol = ++col;
            this.fillLine((MyDItemGradeEntryInfo)list.get(i), this.basePoint.y, newCol, this.basePoint.y - 1, newCol, false);
        }
        return col;
    }

    private void fillVertical(List list) {
        boolean isFillByGrade = this.fillByGrade(list);
        if (!isFillByGrade) {
            for (int i = 0; i < list.size(); ++i) {
                this.fillLine((MyDItemGradeEntryInfo)list.get(i), this.basePoint.y + 1 + i, this.basePoint.x, this.basePoint.y + 1 + i, this.basePoint.x - 1, false);
            }
        }
    }

    private void fillHoriozonal(List list) {
        boolean isFillByGrade = this.fillByGrade(list);
        if (!isFillByGrade) {
            for (int i = 0; i < list.size(); ++i) {
                this.fillLine((MyDItemGradeEntryInfo)list.get(i), this.basePoint.y, this.basePoint.x + 1 + i, this.basePoint.y - 1, this.basePoint.x + 1 + i, false);
            }
        }
    }

    private boolean fillByGrade(List list) {
        if ("template".equals(this.type)) {
            return false;
        }
        HashMap<String, MyDItemGradeEntryInfo> parentGradeMap = new HashMap<String, MyDItemGradeEntryInfo>();
        for (Object obj : list) {
            MyDItemGradeEntryInfo gradeInfo = (MyDItemGradeEntryInfo)obj;
            if (gradeInfo == null || gradeInfo.entry == null || gradeInfo.entry.isLeaf()) continue;
            parentGradeMap.put(gradeInfo.entry.getGrade(), gradeInfo);
        }
        if (!list.isEmpty() && parentGradeMap.isEmpty()) {
            return false;
        }
        this.fillByGrade(list, parentGradeMap);
        return true;
    }

    private void fillByGrade(List list, Map<String, MyDItemGradeEntryInfo> parentGradeMap) {
        DItemGradeInfo pointGradeInfo = DynamicTemplateUtility.getGradeInfo(this.sheet.getRange(this.basePoint.y, this.basePoint.x));
        int preGradePoint = -1;
        if (this.isVertical) {
            Sheet.RowsIterator it = this.sheet.getRowsIterator(this.basePoint.y + 1, this.basePoint.y + this.param.getDefaultCounter(), true);
            int basePointLastRow = -1;
            while (it.hasNext()) {
                DItemGradeEntryInfo pointEntry;
                Row r = it.next();
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)r.getCell(this.basePoint.x, false));
                if (item == null || (pointEntry = pointGradeInfo.find(item.getExt("GRADE_NUMBER"))) == null || pointEntry.isLeaf()) continue;
                if (preGradePoint < 0) {
                    basePointLastRow = preGradePoint = this.basePoint.y + this.param.getDefaultCounter() + 1;
                }
                int rowCount = preGradePoint - r.getRow() - 1;
                MyDItemGradeEntryInfo gradeInfo = parentGradeMap.get(pointEntry.getGrade());
                if (gradeInfo != null && gradeInfo.children.size() > 0) {
                    int offRow;
                    int deff = rowCount - gradeInfo.children.size();
                    int n = offRow = pointEntry.getDetailCount() > 1 ? 1 : 0;
                    if (deff < 0) {
                        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(r.getRow() + 1 + offRow, r.getRow() + -deff + offRow)).insert();
                    } else if (deff > 0) {
                        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(r.getRow() + 1 + offRow, r.getRow() + deff + offRow)).delete();
                    }
                    this.param.setDefaultCounter(this.param.getDefaultCounter() + -deff);
                    DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x)), this.param);
                    basePointLastRow -= deff;
                    UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(r.getRow() + 1, this.basePoint.x, r.getRow() + gradeInfo.children.size(), this.basePoint.x)).clear(true, true, true, true, new String[]{"ITEM"});
                    MyDItemGradeEntryInfo curEntryInfo = null;
                    for (int i = 0; i < gradeInfo.children.size(); ++i) {
                        curEntryInfo = (MyDItemGradeEntryInfo)gradeInfo.children.get(i);
                        if (curEntryInfo == null || !curEntryInfo.entry.isLeaf()) continue;
                        this.fillLine(curEntryInfo, r.getRow() + i + 1, this.basePoint.x, r.getRow() + i + 1, this.basePoint.x - 1, true);
                    }
                    if (pointEntry.getDetailCount() <= 1 && deff != 0) {
                        this.fillSumFormula(gradeInfo, r.getRow(), this.basePoint.x, true);
                    }
                } else if (rowCount > 0) {
                    UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRowRange(r.getRow() + 1, r.getRow() + rowCount)).delete();
                    basePointLastRow -= rowCount;
                }
                preGradePoint = r.getRow();
            }
            if (basePointLastRow > 0) {
                this.param.setDefaultCounter(basePointLastRow - this.basePoint.y);
                DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x)), this.param);
            }
        } else {
            Sheet.ColsIterator it = this.sheet.getColsIterator(this.basePoint.x + 1, this.basePoint.x + this.param.getDefaultCounter(), true);
            int basePointLastCol = -1;
            while (it.hasNext()) {
                DItemGradeEntryInfo pointEntry;
                Column col = it.next();
                ItemFormula item = UserObjectHelper.getItemFormula((Cell)this.sheet.getCell(this.basePoint.y, col.getCol(), false));
                if (item == null || (pointEntry = pointGradeInfo.find(item.getExt("GRADE_NUMBER"))) == null || pointEntry.isLeaf()) continue;
                if (preGradePoint < 0) {
                    basePointLastCol = preGradePoint = this.basePoint.x + this.param.getDefaultCounter() + 1;
                }
                int colCount = preGradePoint - col.getCol() - 1;
                MyDItemGradeEntryInfo gradeInfo = parentGradeMap.get(pointEntry.getGrade());
                if (gradeInfo != null && gradeInfo.children.size() > 0) {
                    int offCol;
                    int deff = colCount - gradeInfo.children.size();
                    int n = offCol = pointEntry.getDetailCount() > 1 ? 1 : 0;
                    if (deff < 0) {
                        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getColRange(col.getCol() + 1 + offCol, col.getCol() + -deff + offCol)).insert();
                    } else if (deff > 0) {
                        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getColRange(col.getCol() + 1 + offCol, col.getCol() + deff + offCol)).delete();
                    }
                    this.param.setDefaultCounter(this.param.getDefaultCounter() + -deff);
                    DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x)), this.param);
                    basePointLastCol -= deff;
                    UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, col.getCol() + 1, this.basePoint.y, col.getCol() + gradeInfo.children.size())).clear(true, true, true, true, new String[]{"ITEM"});
                    MyDItemGradeEntryInfo curEntryInfo = null;
                    for (int i = 0; i < gradeInfo.children.size(); ++i) {
                        curEntryInfo = (MyDItemGradeEntryInfo)gradeInfo.children.get(i);
                        if (curEntryInfo == null || !curEntryInfo.entry.isLeaf()) continue;
                        this.fillLine(curEntryInfo, this.basePoint.y, col.getCol() + i + 1, this.basePoint.y - 1, col.getCol() + i + 1, true);
                    }
                    if (pointEntry.getDetailCount() <= 1 && deff != 0) {
                        this.fillSumFormula(gradeInfo, this.basePoint.y, col.getCol(), true);
                    }
                } else if (colCount > 0) {
                    UserObjectHelper.getUnprotectedRange((Range)this.sheet.getColRange(col.getCol() + 1, col.getCol() + colCount)).delete();
                    basePointLastCol -= colCount;
                }
                preGradePoint = col.getCol();
            }
            if (basePointLastCol > 0) {
                this.param.setDefaultCounter(basePointLastCol - this.basePoint.x);
                DynamicTemplateUtility.saveParametersToCell(UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(this.basePoint.y, this.basePoint.x)), this.param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillLine(MyDItemGradeEntryInfo eninfo, int nameRow, int nameCol, int numberRow, int numberCol, boolean isFillByGrade) {
        try {
            DItemGradeEntryInfo en = eninfo.entry;
            if (en != null) {
                Point p;
                String ditem;
                DynaItemListener.setAutoFillTextGradeSum(false);
                DynaItemListener.setExeFlag(true);
                Range range = UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(nameRow, nameCol));
                range.setHidden(eninfo.ishidden, this.isVertical);
                UserObjectHelper.getItemFormula((Range)range, (boolean)true).putExt("GRADE_NUMBER", en.getGrade());
                String string = ditem = this.isFillSumData ? en.getNumber() : en.getNumber() + "_" + en.getName();
                if (this.isGenItemFormula()) {
                    DynaItemListener.autoFillFormula(this.sheet, nameRow, nameCol, ditem, null, 0, null, false);
                }
                if (en.isLeaf() || en.getChildren().size() <= 0) {
                    for (int i = 0; i < this.headerPos.length; ++i) {
                        this.setFormula(this.sheet.getCell(this.isVertical ? nameRow : this.headerPos[i], this.isVertical ? this.headerPos[i] : nameCol, true));
                    }
                }
                DynaItemListener.setExeFlag(false);
                DItemGradeEntryInfo templateParentGradeInfo = this.getTemplateParentGradeInfo(en.getGrade());
                String ditemname = (templateParentGradeInfo != null ? templateParentGradeInfo.getIdentBlank() + templateParentGradeInfo.getParentIndentBlank() : "") + en.getName();
                range.setValue(new Variant((Object)ditemname));
                String numberShow = en.getNumber();
                if (this.param.getDynaItemShowType() == 1 && !StringUtils.isEmpty((String)numberShow)) {
                    numberShow = en.getNumber();
                    String[] numberShowSplits = numberShow.split("]");
                    String[] numberArray = (numberShow = numberShowSplits[numberShowSplits.length - 1]).split("!");
                    if (numberArray.length > 1) {
                        numberShow = numberArray[numberArray.length - 1];
                        for (int i = 1; i < numberArray.length; ++i) {
                            numberShow = " " + numberShow;
                        }
                    }
                    Range numberRange = UserObjectHelper.getUnprotectedRange((Range)this.sheet.getRange(numberRow, numberCol));
                    numberRange.setValue(new Variant((Object)numberShow));
                }
                DynaItemListener.setExeFlag(true);
                if (!en.isLeaf() && !isFillByGrade) {
                    this.fillSumFormula(eninfo, nameRow, nameCol, false);
                }
                if ((eninfo.children.size() < 1 || eninfo.hasBranchChild) && eninfo.valueMap != null) {
                    for (Map.Entry points : ((Map)eninfo.valueMap.get("KEY_POINT_VALUE")).entrySet()) {
                        p = (Point)points.getKey();
                        Object value = points.getValue();
                        if (this.isVertical) {
                            this.sheet.getCell(nameRow, p.x, true).setValue(new Variant(value));
                            continue;
                        }
                        this.sheet.getCell(p.y, nameCol, true).setValue(new Variant(value));
                    }
                } else if (this.isFillSumData) {
                    for (Map.Entry points : ((Map)eninfo.valueMap.get("KEY_POINT_VALUE")).entrySet()) {
                        p = (Point)points.getKey();
                        Object value = points.getValue();
                        Cell cell = this.isVertical ? this.sheet.getCell(nameRow, p.x, true) : this.sheet.getCell(p.y, nameCol, true);
                        if (cell.hasFormula()) continue;
                        cell.setValue(new Variant(value));
                    }
                }
            }
        }
        finally {
            DynaItemListener.setExeFlag(true);
            DynaItemListener.setAutoFillTextGradeSum(true);
        }
    }

    private void fillSumFormula(MyDItemGradeEntryInfo eninfo, int nameRow, int nameCol, boolean isFillByGrade) {
        for (int i = 0; i < this.headerPos.length; ++i) {
            MyDItemGradeEntryInfo end;
            ValueTypeEnum valueType;
            ItemFormula header = UserObjectHelper.getItemFormula((Cell)this.sheet.getCell(this.isVertical ? this.topBasePoint.y : this.headerPos[i], this.isVertical ? this.headerPos[i] : this.topBasePoint.x, false));
            if (header == null || (valueType = ValueTypeEnum.getEnum((int)header.getValueType())) == ValueTypeEnum.TXT) continue;
            if (eninfo.hasBranchChild && !isFillByGrade) {
                StringBuffer sb = new StringBuffer();
                int eninfoSize = eninfo.children.size();
                for (int j = 0; j < eninfoSize; ++j) {
                    MyDItemGradeEntryInfo child = (MyDItemGradeEntryInfo)eninfo.children.get(j);
                    if (child.entry == null) {
                        int startpos = child.position;
                        int endpos = -1;
                        while (child.entry == null) {
                            endpos = child.position;
                            if (++j >= eninfoSize) break;
                            child = (MyDItemGradeEntryInfo)eninfo.children.get(j);
                        }
                        if (sb.length() < 1) {
                            sb.append('=');
                        } else {
                            sb.append('+');
                        }
                        if (!this.isVertical) {
                            sb.append("SUM(").append(TableToolkit.xy2range((int)(this.basePoint.x + 1 + startpos), (int)this.headerPos[i])).append(":").append(TableToolkit.xy2range((int)(this.basePoint.x + 1 + endpos), (int)this.headerPos[i])).append(")");
                        } else {
                            sb.append("SUM(").append(TableToolkit.xy2range((int)this.headerPos[i], (int)(this.basePoint.y + 1 + startpos))).append(":").append(TableToolkit.xy2range((int)this.headerPos[i], (int)(this.basePoint.y + 1 + endpos))).append(")");
                        }
                        if (child.entry == null) continue;
                    }
                    int r = 0;
                    int c = 0;
                    if (this.isVertical) {
                        r = this.basePoint.y + 1 + child.position;
                        c = this.headerPos[i];
                    } else {
                        c = this.basePoint.x + 1 + child.position;
                        r = this.headerPos[i];
                    }
                    if (sb.length() < 1) {
                        sb.append('=');
                    } else {
                        sb.append('+');
                    }
                    sb.append(TableToolkit.xy2range((int)c, (int)r));
                }
                if (sb.length() <= 0 || !"template".equals(this.type)) continue;
                if (this.isVertical) {
                    this.sheet.getCell(nameRow, this.headerPos[i], true).setFormula(sb.toString());
                    continue;
                }
                this.sheet.getCell(this.headerPos[i], nameCol, true).setFormula(sb.toString());
                continue;
            }
            if (eninfo.children.size() <= 0) continue;
            Cell cell = null;
            cell = this.isVertical ? this.sheet.getCell(nameRow, this.headerPos[i], true) : this.sheet.getCell(this.headerPos[i], nameCol, true);
            if (isFillByGrade && !StringUtils.isEmpty((String)cell.getFormula()) && !cell.getFormula().trim().toLowerCase().startsWith("=sum")) continue;
            StringBuffer sb = new StringBuffer("=SUM(");
            MyDItemGradeEntryInfo start = (MyDItemGradeEntryInfo)eninfo.children.get(0);
            MyDItemGradeEntryInfo myDItemGradeEntryInfo = end = eninfo.children.size() >= 2 ? (MyDItemGradeEntryInfo)eninfo.children.get(eninfo.children.size() - 1) : start;
            if (this.isVertical) {
                if (isFillByGrade) {
                    sb.append(TableToolkit.xy2range((int)this.headerPos[i], (int)(nameRow + 1))).append(":").append(TableToolkit.xy2range((int)this.headerPos[i], (int)(nameRow + eninfo.children.size())));
                } else {
                    sb.append(TableToolkit.xy2range((int)this.headerPos[i], (int)(start.position + 1 + this.basePoint.y))).append(":").append(TableToolkit.xy2range((int)this.headerPos[i], (int)(end.position + 1 + this.basePoint.y)));
                }
            } else if (isFillByGrade) {
                sb.append(TableToolkit.xy2range((int)(nameCol + 1), (int)this.headerPos[i])).append(":").append(TableToolkit.xy2range((int)(nameCol + eninfo.children.size()), (int)this.headerPos[i]));
            } else {
                sb.append(TableToolkit.xy2range((int)(start.position + 1 + this.basePoint.x), (int)this.headerPos[i])).append(":").append(TableToolkit.xy2range((int)(end.position + 1 + this.basePoint.x), (int)this.headerPos[i]));
            }
            eninfo.children.size();
            if (sb.length() <= 0) continue;
            sb.append(")");
            cell.setFormula(sb.toString());
        }
    }

    private int getBranchChild(DItemGradeEntryInfo parent) {
        List children = parent.getChildren();
        int childCount = 0;
        for (int i = 0; i < children.size(); ++i) {
            boolean isleaf = ((DItemGradeEntryInfo)children.get(i)).isLeaf();
            if (isleaf) continue;
            ++childCount;
        }
        return childCount;
    }

    @Override
    public void save(DItemGradeInfo info) {
        UserObjectHelper.getUnprotectedRange((Range)this.sheet.getBook().getActiveCellRange()).setUserObject("DItemGradeInfo", (Object)info);
    }

    @Override
    public DynaParameters fetchParameter() {
        int col = this.sheet.getActiveCol();
        int row = this.sheet.getActiveRow();
        DynaParameters param = DynamicTemplateUtility.getDynaParametersFromCell(this.sheet, row, col);
        return param;
    }

    public void setNameMap(Map nameMap) {
        this.nameMap = nameMap;
    }

    public void setShowCount(int showCount) {
        this.showCount = showCount;
    }

    public void setGenItemFormula(boolean genItemFormula) {
        this.genItemFormula = genItemFormula;
    }

    public boolean isGenItemFormula() {
        return this.genItemFormula;
    }

    public int getSumMethod() {
        return this.summethod;
    }

    public void setSumMethod(int summethod) {
        this.summethod = summethod;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public static List getOrderEntries(Sheet sheet, DItemGradeInfo info, Point basePoint, DynaParameters param) {
        boolean is_left_up;
        if (info == null) {
            return null;
        }
        boolean bl = is_left_up = param.getPosition() == 1;
        if (!is_left_up) {
            DynaGradeSettingAdviserImpl adviserImpl = new DynaGradeSettingAdviserImpl(sheet);
            adviserImpl.basePoint = basePoint;
            adviserImpl.param = param;
            adviserImpl.isFillSumData = true;
            DynaGradeSettingAdviserImpl dynaGradeSettingAdviserImpl = adviserImpl;
            dynaGradeSettingAdviserImpl.getClass();
            FillDataBuild b = dynaGradeSettingAdviserImpl.new FillDataBuild(info, param.getPosition() == 1, null);
            ArrayList<DItemGradeEntryInfo> l = new ArrayList<DItemGradeEntryInfo>(b.newEntries.size());
            for (int i = 0; i < b.newEntries.size(); ++i) {
                l.add(((MyDItemGradeEntryInfo)b.newEntries.get((int)i)).entry);
            }
            info.setEntries(l);
            return l;
        }
        return info.getEntries();
    }

    private DItemGradeEntryInfo getTemplateParentGradeInfo(String grade) {
        DItemGradeEntryInfo gradeInfo = null;
        if (this.templateGradeInfo != null) {
            gradeInfo = this.templateGradeInfo.findParent(grade);
        }
        return gradeInfo;
    }

    class _TextGradeSumSorter
    implements Comparator {
        private final Map nameMap;
        private final DynaParameters param;

        public _TextGradeSumSorter(Map nameMap, DynaParameters param) {
            this.nameMap = nameMap;
            this.param = param;
        }

        public int compare(Object key0, Object key1) {
            Map map1 = ((MyDItemGradeEntryInfo)key0).valueMap;
            String grade1 = (String)map1.get("GRADE_NUMBER");
            Map map2 = ((MyDItemGradeEntryInfo)key1).valueMap;
            String grade2 = (String)map2.get("GRADE_NUMBER");
            if ((this.param.getOrderBy().getValue() == 2 || this.param.getOrderBy().getValue() == 3) && this.isSameParentAndDetail(grade1, grade2)) {
                int orderRow = this.param.getOrderRow();
                boolean isHorizontal = this.param.getSpreadStyle() == 1;
                Map values0 = (Map)map1.get("KEY_POINT_VALUE");
                Map values1 = (Map)map2.get("KEY_POINT_VALUE");
                if (values0 != null && values1 != null) {
                    Point p0 = new Point((Point)values0.keySet().toArray()[0]);
                    Point p1 = new Point((Point)values1.keySet().toArray()[0]);
                    if (isHorizontal) {
                        p0.y = orderRow;
                        p1.y = orderRow;
                    } else {
                        p0.x = orderRow;
                        p1.x = orderRow;
                    }
                    Object obj0 = values0.get(p0);
                    Object obj1 = values1.get(p1);
                    if (obj0 == null && obj1 == null) {
                        return 0;
                    }
                    if (obj0 == null && obj1 != null) {
                        if (this.param.getOrderBy().getValue() == 2) {
                            return -1;
                        }
                        return 1;
                    }
                    if (obj0 != null && obj1 == null) {
                        if (this.param.getOrderBy().getValue() == 2) {
                            return 1;
                        }
                        return -1;
                    }
                    if (obj0 instanceof Comparable && obj1 instanceof Comparable) {
                        if (this.param.getOrderBy().getValue() == 2) {
                            return ((Comparable)obj0).compareTo(obj1);
                        }
                        if (this.param.getOrderBy().getValue() == 3) {
                            return ((Comparable)obj1).compareTo(obj0);
                        }
                        return ((Comparable)obj0).compareTo(obj1);
                    }
                }
            }
            if (grade1 != null && grade2 != null && grade1.equals(grade2)) {
                String n1 = (String)map1.get("KEY_DITEM_NAME");
                String n2 = (String)map2.get("KEY_DITEM_NAME");
                if (n1 != null && n2 != null) {
                    String c1 = (String)map1.get("COMPANY_NAME");
                    String c2 = (String)map2.get("COMPANY_NAME");
                    if (c1 != null && c2 != null) {
                        if (!c1.equals(c2)) {
                            if (this.param.getOrderBy().getValue() == 2) {
                                return c1.compareTo(c2);
                            }
                            if (this.param.getOrderBy().getValue() == 3) {
                                return c2.compareTo(c1);
                            }
                            return c1.compareTo(c2);
                        }
                        if (this.param.getOrderBy().getValue() == 2) {
                            return n1.compareTo(n2);
                        }
                        if (this.param.getOrderBy().getValue() == 3) {
                            return n2.compareTo(n1);
                        }
                        return n1.compareTo(n2);
                    }
                    if (this.param.getOrderBy().getValue() == 2) {
                        return n1.compareTo(n2);
                    }
                    if (this.param.getOrderBy().getValue() == 3) {
                        return n2.compareTo(n1);
                    }
                    return n1.compareTo(n2);
                }
            }
            if (this.param.getOrderBy().getValue() == 2) {
                return new DItemGradeEntryInfo(grade1).compareTo(new DItemGradeEntryInfo(grade2));
            }
            if (this.param.getOrderBy().getValue() == 3) {
                return new DItemGradeEntryInfo(grade2).compareTo(new DItemGradeEntryInfo(grade1));
            }
            return 0;
        }

        private boolean isSameParentAndDetail(String g1, String g2) {
            String p2;
            int pos1 = g1.lastIndexOf(46);
            int lvl1 = -1;
            if (pos1 < 0) {
                lvl1 = 1;
            }
            int pos2 = g2.lastIndexOf(46);
            int lvl2 = -1;
            if (pos2 < 0) {
                lvl2 = 1;
            }
            if (pos1 < 0 || pos2 < 0) {
                return lvl1 == 1 && lvl2 == 1;
            }
            String p1 = g1.substring(0, pos1);
            boolean sameParent = p1.equalsIgnoreCase(p2 = g2.substring(0, pos2));
            if (!sameParent) {
                return false;
            }
            return g1.substring(pos1).equals(".D") || g2.substring(pos2).equals(".D");
        }
    }

    class MyDItemGradeEntryInfo {
        DItemGradeEntryInfo entry = null;
        int position;
        boolean hasBranchChild = false;
        boolean hasChild = false;
        List children = new ArrayList();
        Map valueMap = null;
        boolean ishidden = false;

        MyDItemGradeEntryInfo(DItemGradeEntryInfo entry, boolean bhasBranchChild) {
            if (DynaGradeSettingAdviserImpl.this.nameMap != null) {
                this.valueMap = (Map)DynaGradeSettingAdviserImpl.this.nameMap.get(entry.getNumber());
            }
            if (entry != null) {
                this.hasChild = entry.getChildren().size() > 0;
            }
            this.hasBranchChild = bhasBranchChild;
            this.entry = entry;
        }

        void addChild(MyDItemGradeEntryInfo child) {
            this.children.add(child);
        }

        public String toString() {
            return this.entry.getName() + "," + this.entry.getGrade();
        }

        public boolean equals(Object obj) {
            if (this != null && obj != null) {
                if (obj instanceof MyDItemGradeEntryInfo) {
                    MyDItemGradeEntryInfo info = (MyDItemGradeEntryInfo)obj;
                    return this.entry.getName().equals(info.entry.getName());
                }
                return false;
            }
            return super.equals(obj);
        }
    }

    class FillDataBuild {
        List newEntries = null;
        boolean is_left_up = true;

        FillDataBuild(DItemGradeInfo info, boolean is_left_up, DynaSumMethodEnum sumMethod) {
            List oldList = info.getEntries();
            this.is_left_up = is_left_up;
            this.newEntries = new ArrayList(info.getEntries().size());
            for (int i = 0; i < oldList.size(); ++i) {
                DItemGradeEntryInfo entry = (DItemGradeEntryInfo)oldList.get(i);
                if (entry.getParentGrade() != null) continue;
                this.fill(new MyDItemGradeEntryInfo(entry, DynaGradeSettingAdviserImpl.this.getBranchChild(entry) > 0));
            }
        }

        MyDItemGradeEntryInfo fill(MyDItemGradeEntryInfo info) {
            int count;
            int i;
            if (info.entry.isLeaf()) {
                return this.addEntry(info);
            }
            boolean branchChild = info.hasBranchChild;
            MyDItemGradeEntryInfo parent = info;
            if (this.is_left_up) {
                this.addEntry(parent);
            }
            List child = info.entry.getChildren();
            ArrayList<MyDItemGradeEntryInfo> hasChildList = new ArrayList<MyDItemGradeEntryInfo>();
            ArrayList<MyDItemGradeEntryInfo> noChildList = new ArrayList<MyDItemGradeEntryInfo>();
            for (int i2 = 0; i2 < child.size(); ++i2) {
                DItemGradeEntryInfo ch;
                MyDItemGradeEntryInfo o = new MyDItemGradeEntryInfo(ch, DynaGradeSettingAdviserImpl.this.getBranchChild(ch = (DItemGradeEntryInfo)child.get(i2)) > 0);
                if (o.hasChild || !ch.isLeaf()) {
                    hasChildList.add(o);
                    continue;
                }
                noChildList.add(o);
            }
            Object[] objects = noChildList.toArray();
            if (child.size() > 0 && noChildList.size() > 0 && DynaGradeSettingAdviserImpl.this.nameMap != null) {
                Arrays.sort(objects, new _TextGradeSumSorter(DynaGradeSettingAdviserImpl.this.nameMap, DynaGradeSettingAdviserImpl.this.param));
            }
            MyDItemGradeEntryInfo[] mydgs = new MyDItemGradeEntryInfo[child.size()];
            for (int i3 = 0; objects != null && i3 < objects.length; ++i3) {
                mydgs[i3] = (MyDItemGradeEntryInfo)objects[i3];
            }
            int m = objects != null ? objects.length : 0;
            for (int j = 0; j < hasChildList.size(); ++j) {
                mydgs[m + j] = (MyDItemGradeEntryInfo)hasChildList.get(j);
            }
            for (i = 0; i < mydgs.length; ++i) {
                if (info.hasBranchChild || i + 1 <= DynaGradeSettingAdviserImpl.this.showCount) continue;
                mydgs[i].ishidden = true;
            }
            if (this.is_left_up) {
                int i4;
                if (!DynaGradeSettingAdviserImpl.this.isFillSumData && info.entry.isIncludeUnknowDetail() && branchChild) {
                    count = info.entry.getDetailCount();
                    for (i4 = 0; i4 < count; ++i4) {
                        parent.addChild(this.addEntry(new MyDItemGradeEntryInfo(null, false)));
                    }
                }
                for (i = 0; i < mydgs.length; ++i) {
                    parent.addChild(this.fill(mydgs[i]));
                }
                if (!DynaGradeSettingAdviserImpl.this.isFillSumData && info.entry.isIncludeUnknowDetail() && !branchChild) {
                    count = info.entry.getDetailCount() - info.entry.getChildren().size();
                    for (i4 = 0; i4 < count; ++i4) {
                        parent.addChild(this.addEntry(new MyDItemGradeEntryInfo(null, false)));
                    }
                }
            } else {
                for (i = mydgs.length - 1; i >= 0; --i) {
                    parent.addChild(this.fill(mydgs[i]));
                }
                if (!DynaGradeSettingAdviserImpl.this.isFillSumData && info.entry.isIncludeUnknowDetail()) {
                    count = 0;
                    count = !branchChild ? info.entry.getDetailCount() - info.entry.getChildren().size() : info.entry.getDetailCount();
                    for (int i5 = 0; i5 < count; ++i5) {
                        parent.addChild(this.addEntry(new MyDItemGradeEntryInfo(null, false)));
                    }
                }
            }
            if (!this.is_left_up) {
                this.addEntry(parent);
            }
            return parent;
        }

        private MyDItemGradeEntryInfo addEntry(DItemGradeEntryInfo info) {
            return this.addEntry(info, false);
        }

        private MyDItemGradeEntryInfo addEntry(DItemGradeEntryInfo info, boolean bbranch) {
            return this.addEntry(new MyDItemGradeEntryInfo(info, bbranch));
        }

        private MyDItemGradeEntryInfo addEntry(MyDItemGradeEntryInfo info) {
            info.position = this.newEntries.size();
            this.newEntries.add(info);
            return info;
        }
    }
}

