/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.gr.dynamic.util;

import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class MultiDynaItem {
    private static final Pattern pattern1 = Pattern.compile(";");
    private static final Pattern pattern2 = Pattern.compile("\\|");
    private static final Pattern pattern3 = Pattern.compile(":");
    private static final int ASSTACTTYPE = 0;
    private static final int ASSTITEM = 1;
    private List asstList;
    private String dItemNumber;

    public MultiDynaItem(String dITemNumber) {
        if (!StringUtils.isEmpty((String)dITemNumber)) {
            String[] split = pattern1.split(dITemNumber);
            ArrayList<String> temp = new ArrayList<String>();
            HashMap<String, String> tempMap = new HashMap<String, String>();
            this.asstList = new ArrayList(split.length);
            for (int i = 0; i < split.length; ++i) {
                String[] typeItem = pattern2.split(split[i]);
                if (typeItem.length <= 0) continue;
                this.asstList.add(typeItem);
                temp.add(typeItem[0]);
                if (typeItem.length >= 2) {
                    tempMap.put(typeItem[0], typeItem[1]);
                    continue;
                }
                tempMap.put(typeItem[0], "");
            }
            if (this.asstList.size() > 0) {
                Collections.sort(temp);
                StringBuffer sb = new StringBuffer();
                boolean isFirst = true;
                for (String typeNumber : temp) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(";");
                    }
                    String itemNumber = (String)tempMap.get(typeNumber);
                    if (itemNumber != null) {
                        sb.append(typeNumber).append("|").append(itemNumber);
                        continue;
                    }
                    sb.append(typeNumber);
                }
                this.dItemNumber = sb.toString();
            }
        }
    }

    private MultiDynaItem() {
    }

    public List getAsstActTypeList() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.asstList == null) {
            return result;
        }
        for (String[] asst : this.asstList) {
            result.add(asst[0]);
        }
        Collections.sort(result);
        return result;
    }

    public String getAsstItemNumber(String asstActTypeNumber) {
        if (this.asstList == null) {
            return null;
        }
        for (String[] asst : this.asstList) {
            if (asst.length != 2 || !asst[0].equals(asstActTypeNumber)) continue;
            return asst[1];
        }
        return null;
    }

    public void setAsstItemNumber(String asstActTypeNumber, String longNumber) {
        if (this.asstList != null && this.asstList.size() > 0) {
            for (String[] asst : this.asstList) {
                if (asst.length != 2 || !asst[0].equals(asstActTypeNumber)) continue;
                asst[1] = longNumber;
            }
        }
    }

    public String[] getAsstItemNumbers(String asstActTypeNumber) {
        if (this.asstList == null) {
            return null;
        }
        for (String[] asst : this.asstList) {
            if (asst.length != 2 || !asst[0].equals(asstActTypeNumber)) continue;
            String[] items = pattern3.split(asst[1]);
            if (items.length == 1) {
                return new String[]{items[0], items[0]};
            }
            if (items.length == 2) {
                return items;
            }
            return null;
        }
        return null;
    }

    public int hashCode() {
        return this.dItemNumber == null ? -1 : this.dItemNumber.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof MultiDynaItem)) {
            return false;
        }
        if (this.dItemNumber == null) {
            return ((MultiDynaItem)obj).dItemNumber == null;
        }
        return this.dItemNumber.equals(((MultiDynaItem)obj).dItemNumber);
    }

    public static MultiDynaItem getInstance() {
        return new MultiDynaItem();
    }

    public Map parseDItemNumber(String dItemNumber) {
        String[] split = pattern1.split(dItemNumber);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (int i = 0; i < split.length; ++i) {
            String[] typeItem = pattern2.split(split[i]);
            if (typeItem.length >= 2) {
                tempMap.put(typeItem[0], typeItem[1]);
                continue;
            }
            if (typeItem.length != 1) continue;
            tempMap.put(typeItem[0], "");
        }
        return tempMap;
    }

    public String reverseDItemNumber(Map typeMap) {
        ArrayList list = new ArrayList(typeMap.keySet());
        Collections.sort(list);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i != 0) {
                sb.append(";");
            }
            String typeNumber = (String)list.get(i);
            sb.append(typeNumber).append("|").append(typeMap.get(typeNumber));
        }
        return sb.toString();
    }

    public String sortDynaKey(String dynaKey) {
        return this.reverseDItemNumber(this.parseDItemNumber(dynaKey));
    }
}

