/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.frame;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectMultiPK;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.IUserCustomConfig;
import com.kingdee.eas.framework.config.UserCustomConfigFactory;
import com.kingdee.eas.framework.config.UserCustomConfigInfo;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.eas.framework.config.UserXMLHelper;
import com.kingdee.eas.framework.config.client.TablePreferences;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslCoreUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jdom.JDOMException;

public class CslTablePreferencesHelper {
    private static Logger logger = Logger.getLogger((Class)CslTablePreferencesHelper.class);
    public static final String CURRENT_TABLE = "CurrentTable";
    public static final String HELPER = "helper";
    public static final String ROW_HEIGHT = "RowHeight";
    public static final String FORECOLOR = "ForeGroundColor";
    public static final String BGCOLOR = "BackGroundColor";
    public static final String PRINTSETTING = "PrintSetting";
    public static final String OLD_SPLIT_CHAR = ",";
    public static final String SPLIT_CHAR = "\u03b1";
    private ResourceBundleHelper resHelper;
    private CslCoreUI ui;
    private Map uiTables = new LinkedHashMap();
    private Map tables = new LinkedHashMap();
    private UserPreferenceData defaultUserData = null;
    private boolean canSetHideColumn = true;
    private boolean canSetFrozeColumn = true;
    private boolean canSetForeColor = true;
    private boolean canSetBGColor = true;
    private boolean canSetRowHeight = true;
    private Set disabledTables = new HashSet();
    private Set forceDisplayKeys = new HashSet();

    public CslTablePreferencesHelper(CslCoreUI ui) {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.ui = ui;
    }

    public void init() {
        if (((Object)((Object)this.ui)).getClass().equals(TablePreferences.class)) {
            return;
        }
        Component[] components = this.ui.getComponents();
        this.tables.clear();
        this.uiTables.clear();
        this.findAllTables(components);
        this.defaultUserData = this.getUserDataFromUI();
        Object userDBData = null;
        Iterator itr = this.tables.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            KDTable table = (KDTable)this.tables.get(key);
            this.addMenuToTable(table);
            if (userDBData == null || userDBData.getTableCurrentSetting(key) == null) continue;
            this.applyConfigFromData(table, userDBData.getTableCurrentSetting(key), false);
        }
    }

    private void addMenuToTable(KDTable table) {
        KDTMenuManager tm = this.ui.getMenuManager(table);
        if (tm == null) {
            tm = new KDTMenuManager(table);
            String path = System.getProperty("user.dir");
            path = path + "\\eastmp.xls";
            tm.setTempFile(path);
        }
        if (tm.getMenu().getComponentCount() > 0) {
            tm.getMenu().addSeparator();
        }
    }

    private void findAllTables(Component[] components) {
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof KDTable) {
                String tableName = ((Object)((Object)this.ui)).getClass().getName() + "." + components[i].getName();
                if (this.disabledTables.contains(components[i])) continue;
                if (components[i] != null) {
                    ((KDTable)components[i]).checkParsed();
                }
                this.tables.put(tableName, components[i]);
                this.uiTables.put(components[i], tableName);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            Container container = (Container)components[i];
            this.findAllTables(container.getComponents());
        }
    }

    public void restoreDefault(KDTable t) {
        this.applyConfigFromData(t, this.defaultUserData.getTableCurrentSetting((String)this.uiTables.get(t)));
    }

    public UserCustomConfigItemData getDefaultUserData(KDTable t) {
        return this.defaultUserData.getTableCurrentSetting((String)this.uiTables.get(t));
    }

    public String getTableName(KDTable t) {
        return (String)this.uiTables.get(t);
    }

    public void saveConfig(KDTable tb) {
        try {
            UserPreferenceData userData = this.getUserDataFromDB();
            if (userData == null) {
                userData = this.getUserDataFromUI();
            }
            UserCustomConfigItemData itemData = null;
            itemData = this.getColumnDataFromTable(tb, itemData);
            itemData = this.getGenricDataFromTable(tb, itemData);
            if (this.uiTables.get(tb) != null) {
                // empty if block
            }
            userData.getTables().put(this.uiTables.get(tb), itemData);
            this.saveDataToDB(userData);
        }
        catch (Exception e) {
            logger.error((Object)("save userconfig error:" + e));
        }
    }

    private void saveDataToDB(UserPreferenceData data) throws Exception {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            UserXMLHelper.saveData((UserPreferenceData)data, (Writer)writer, (String)"UTF-8");
            ObjectMultiPK pk = new ObjectMultiPK();
            pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
            pk.setKeyValue("uiClassName", (Object)((Object)((Object)this.ui)).getClass().getName());
            UserCustomConfigInfo userConfigInfo = new UserCustomConfigInfo();
            userConfigInfo.setUser(SysContext.getSysContext().getCurrentUserInfo());
            userConfigInfo.setUiClassName(((Object)((Object)this.ui)).getClass().getName());
            userConfigInfo.setConfigXML(writer.toString());
            if (this.getBizInterface().exists((IObjectPK)pk)) {
                this.getBizInterface().update((IObjectPK)pk, userConfigInfo);
            } else {
                this.getBizInterface().addnew(userConfigInfo);
            }
        }
        catch (IOException err) {
            throw err;
        }
        finally {
            writer.close();
        }
    }

    public IUserCustomConfig getBizInterface() throws Exception {
        return UserCustomConfigFactory.getRemoteInstance();
    }

    public void applyConfigFromData(KDTable table, UserCustomConfigItemData userData) {
        this.applyConfigFromData(table, userData, true);
    }

    public void applyConfigFromData(KDTable table, UserCustomConfigItemData userData, boolean hasData) {
        if (this.canSetRowHeight) {
            table.setDefaultRowHeight(Integer.parseInt((String)userData.getGenericData().get(ROW_HEIGHT)));
        }
        this.applyToTable(table, userData, hasData);
    }

    private void applyToTable(KDTable table, UserCustomConfigItemData itemData, boolean hasData) {
        if (itemData == null) {
            return;
        }
        if (table.isColumnMoveable()) {
            Iterator itr = itemData.getColumnData().keySet().iterator();
            while (itr.hasNext()) {
                int originalIndex;
                int expectIndex;
                String key = (String)itr.next();
                ColumnItemData columnData = (ColumnItemData)itemData.getColumnData().get(key);
                if (columnData == null || (expectIndex = columnData.getIndex()) == (originalIndex = table.getColumnIndex(key)) || expectIndex < 0 || originalIndex < 0) continue;
                table.exchangeColumn(originalIndex, expectIndex);
            }
        }
        int frozeColumnIndex = 0;
        Iterator itr = itemData.getColumnData().keySet().iterator();
        while (itr.hasNext()) {
            IColumn col;
            String key = (String)itr.next();
            ColumnItemData columnData = (ColumnItemData)itemData.getColumnData().get(key);
            if (columnData == null || (col = table.getColumn(key)) == null) continue;
            col.setUserObject((Object)columnData);
            col.getStyleAttributes().setHided(columnData.isHidden());
            col.setWidth(columnData.getWidth());
            col.getStyleAttributes().setHorizontalAlign(columnData.getAlign());
            if (!columnData.isLocked() || columnData.getIndex() <= frozeColumnIndex) continue;
            frozeColumnIndex = columnData.getIndex();
        }
        if (!hasData && table.getViewManager().getFreezeCol() > 0) {
            table.getViewManager().setFreezeView(0, 0);
        } else if (hasData && table.getViewManager().getFreezeCol() > 0) {
            table.getViewManager().freeze(0, 0);
        }
        if (frozeColumnIndex > 0) {
            if (!hasData) {
                table.getViewManager().setFreezeView(0, frozeColumnIndex + 1);
            } else {
                table.getViewManager().freeze(0, frozeColumnIndex + 1);
            }
        }
    }

    public UserPreferenceData getUserDataFromDB() {
        UserPreferenceData userData;
        UserCustomConfigInfo userConfigInfo;
        ObjectMultiPK pk = new ObjectMultiPK();
        pk.setKeyValue("user", (Object)SysContext.getSysContext().getCurrentUserInfo().getId());
        pk.setKeyValue("uiClassName", (Object)((Object)((Object)this.ui)).getClass().getName());
        try {
            userConfigInfo = this.getBizInterface().getValue((IObjectPK)pk);
        }
        catch (Exception e) {
            return null;
        }
        if (userConfigInfo.getConfigXML() == null) {
            return null;
        }
        try {
            userData = UserXMLHelper.loadPreferenceData((String)userConfigInfo.getConfigXML());
            Iterator iter = userData.getTables().keySet().iterator();
            while (iter.hasNext()) {
                UserCustomConfigItemData info = (UserCustomConfigItemData)userData.getTables().get(iter.next());
                if (info == null) continue;
                Iterator _itr = info.getColumnData().keySet().iterator();
                while (_itr.hasNext()) {
                    String key = (String)_itr.next();
                    info.getColumnData().put(key, this.string2ColumnData((String)info.getColumnData().get(key)));
                }
            }
        }
        catch (JDOMException e1) {
            logger.error((Object)("load preference data failed:" + (Object)((Object)e1)));
            return null;
        }
        catch (IOException e1) {
            logger.error((Object)("load preference data failed:" + e1));
            return null;
        }
        if (userData.getVersion().compare(UserPreferenceData.VER_2_0_0) < 0) {
            userData = this.upgradeToVer2_0_0(userData);
            StringWriter writer = null;
            try {
                writer = new StringWriter();
                UserXMLHelper.saveData((UserPreferenceData)userData, (Writer)writer, (String)"UTF-8");
                userConfigInfo.setConfigXML(writer.toString());
                this.getBizInterface().update((IObjectPK)pk, userConfigInfo);
            }
            catch (Exception e) {
                logger.error((Object)"update preference data error.", (Throwable)e);
            }
        }
        return userData;
    }

    private UserPreferenceData upgradeToVer2_0_0(UserPreferenceData data) {
        data.setVersion(UserPreferenceData.VER_2_0_0);
        Iterator iter = this.tables.keySet().iterator();
        while (iter.hasNext()) {
            String tableName = (String)iter.next();
            KDTable tempTab = (KDTable)this.tables.get(tableName);
            UserCustomConfigItemData item = (UserCustomConfigItemData)data.getTables().get(tableName);
            if (tempTab == null || item == null) continue;
            item = this.upgradeToVer2_0_0(item, tempTab);
            data.getTables().put(tableName, item);
        }
        return data;
    }

    private UserCustomConfigItemData upgradeToVer2_0_0(UserCustomConfigItemData item, KDTable table) {
        UserCustomConfigItemData newItem = new UserCustomConfigItemData();
        newItem.getGenericData().putAll(item.getGenericData());
        Iterator iter = item.getColumnData().keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            try {
                int index = Integer.valueOf(key);
                IColumn col = table.getColumn(index);
                if (col == null) continue;
                String colKey = col.getKey();
                if (StringUtils.isEmpty((String)colKey)) {
                    colKey = key;
                }
                newItem.getColumnData().put(colKey, item.getColumnData().get(key));
            }
            catch (Exception e) {
                logger.error((Object)"update UserCustomeConfigItemData error.", (Throwable)e);
            }
        }
        return newItem;
    }

    public UserPreferenceData getUserDataFromUI() {
        UserPreferenceData userData = new UserPreferenceData();
        userData.setVersion(UserPreferenceData.VER_2_0_0);
        Iterator itr = this.tables.keySet().iterator();
        while (itr.hasNext()) {
            String tableName = (String)itr.next();
            KDTable tb = (KDTable)this.tables.get(tableName);
            UserCustomConfigItemData itemData = null;
            itemData = this.getColumnDataFromTable(tb, itemData);
            itemData = this.getGenricDataFromTable(tb, itemData);
            userData.getTables().put(tableName, itemData);
        }
        return userData;
    }

    public UserCustomConfigItemData getGenricDataFromTable(KDTable tb, UserCustomConfigItemData itemData) {
        if (itemData == null) {
            itemData = new UserCustomConfigItemData();
        }
        itemData.getGenericData().put(ROW_HEIGHT, String.valueOf(tb.getDefaultRowHeight()));
        itemData.getGenericData().put(FORECOLOR, this.getColorString(tb.getStyleAttributes().getFontColor()));
        itemData.getGenericData().put(BGCOLOR, this.getColorString(tb.getStyleAttributes().getBackground()));
        return itemData;
    }

    public UserCustomConfigItemData getColumnDataFromTable(KDTable tb, UserCustomConfigItemData itemData) {
        if (itemData == null) {
            itemData = new UserCustomConfigItemData();
        }
        int frozenColIndex = tb.getViewManager().getFreezeCol();
        int j = tb.getColumnCount();
        for (int i = 0; i < j; ++i) {
            IColumn col = tb.getColumn(i);
            ColumnItemData columnData = new ColumnItemData();
            columnData.setIndex(i);
            String key = col.getKey();
            if (StringUtils.isEmpty((String)key)) continue;
            columnData.setKey(key);
            if (tb.getHeadRowCount() == 1) {
                columnData.setTitle((String)tb.getHeadRow(0).getCell(i).getValue());
                if (columnData.getTitle() == null) {
                    columnData.setTitle("");
                }
            } else {
                columnData.setTitle(this.getColTitle(tb, i));
            }
            columnData.setWidth(col.getWidth());
            columnData.setAlign(col.getStyleAttributes().getHorizontalAlign());
            columnData.setHidden(col.getStyleAttributes().isHided());
            columnData.setLocked(false);
            if (frozenColIndex == 0) {
                columnData.setLocked(false);
            } else if (i < frozenColIndex) {
                columnData.setLocked(true);
            } else {
                columnData.setLocked(false);
            }
            itemData.getColumnData().put(key, columnData);
        }
        return itemData;
    }

    private String getColTitle(KDTable tb, int colIndex) {
        int rowCnt = tb.getHeadRowCount();
        String result = "";
        for (int k = 0; k < rowCnt; ++k) {
            IRow row = tb.getHeadRow(k);
            ICell cell = row.getCell(colIndex);
            Object cellValue = cell.getValue();
            if (cell.getStyleAttributes().isHided()) continue;
            if (cellValue == null) {
                if (cell.getMergeBlock() == null || cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() <= 0) continue;
                if (result != null && result.length() > 0) {
                    result = result + "-";
                }
                result = result + (String)row.getCell(cell.getMergeBlock().getLeft()).getValue();
                continue;
            }
            String tmpValue = "";
            tmpValue = (String)cell.getValue();
            if (cell.getMergeBlock() != null) {
                if (cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() > 0) {
                    tmpValue = (String)row.getCell(cell.getMergeBlock().getLeft()).getValue();
                }
                if (cell.getMergeBlock().getBottom() - cell.getMergeBlock().getTop() > 0 && result != null && result.length() > 0) {
                    tmpValue = "";
                }
            }
            if (result != null && result.length() > 0 && tmpValue.length() > 0) {
                result = result + "-";
            }
            result = result + tmpValue;
        }
        return result;
    }

    public ColumnItemData string2ColumnData(String values) {
        if (values == null) {
            return null;
        }
        String[] value = values.split(SPLIT_CHAR);
        if (value.length == 1) {
            value = values.split(OLD_SPLIT_CHAR);
        }
        if (value.length != 7) {
            return null;
        }
        ColumnItemData data = new ColumnItemData();
        data.setTitle(value[0]);
        data.setWidth(Integer.parseInt(value[1]));
        data.setAlign(this.getAlign(value[2]));
        data.setSorted(Boolean.valueOf(value[3]).booleanValue());
        data.setHidden(Boolean.valueOf(value[4]).booleanValue());
        data.setLocked(Boolean.valueOf(value[5]).booleanValue());
        data.setIndex(Integer.parseInt(value[6]));
        return data;
    }

    public Styles.HorizontalAlignment getAlign(String str) {
        if (str.equalsIgnoreCase("left")) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase("center")) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase("right")) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return this.getAlignFromSource(str);
    }

    private Styles.HorizontalAlignment getAlignFromSource(String str) {
        if (str.equalsIgnoreCase(this.resHelper.getString("left"))) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase(this.resHelper.getString("center"))) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase(this.resHelper.getString("right"))) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return Styles.HorizontalAlignment.LEFT;
    }

    public Color getColor(String s) {
        if (s != null) {
            String[] rgb = s.split(SPLIT_CHAR);
            if (rgb.length == 1) {
                rgb = s.split(OLD_SPLIT_CHAR);
            }
            return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        return null;
    }

    public String getColorString(Color c) {
        String result = "";
        if (c != null) {
            result = result + String.valueOf(c.getRed()) + String.valueOf(SPLIT_CHAR);
            result = result + String.valueOf(c.getGreen()) + String.valueOf(SPLIT_CHAR);
            result = result + String.valueOf(c.getBlue());
        }
        return result;
    }

    public boolean isCanSetFrozeColumn() {
        return this.canSetFrozeColumn;
    }

    public void setCanSetFrozeColumn(boolean canSetFrozeColumn) {
        this.canSetFrozeColumn = canSetFrozeColumn;
    }

    public boolean isCanSetHideColumn() {
        return this.canSetHideColumn;
    }

    public void setCanSetHideColumn(boolean canSetHideColumn) {
        this.canSetHideColumn = canSetHideColumn;
    }

    public Set getDisabledTables() {
        return this.disabledTables;
    }

    public Map getUiTables() {
        return this.uiTables;
    }

    public void setCanSetForeColor(boolean canSetForeColor) {
        this.canSetForeColor = canSetForeColor;
    }

    public void setCanSetBGColor(boolean canSetBGColor) {
        this.canSetBGColor = canSetBGColor;
    }

    public void setCanSetRowHeight(boolean canSetRowHeight) {
        this.canSetRowHeight = canSetRowHeight;
    }

    public boolean isCanSetBGColor() {
        return this.canSetBGColor;
    }

    public boolean isCanSetForeColor() {
        return this.canSetForeColor;
    }

    public boolean isCanSetRowHeight() {
        return this.canSetRowHeight;
    }

    public String getPrintSetting(KDTable tbl) {
        UserPreferenceData userData = this.getUserDataFromDB();
        UserCustomConfigItemData itemData = null;
        if (userData != null) {
            itemData = (UserCustomConfigItemData)userData.getTables().get((String)this.uiTables.get(tbl));
        }
        if (itemData != null) {
            return (String)itemData.getGenericData().get(PRINTSETTING);
        }
        return null;
    }

    public void setPrintSetting(KDTable tbl, String printSetting) {
        UserPreferenceData userData = this.getUserDataFromDB();
        UserCustomConfigItemData itemData = null;
        if (userData == null) {
            userData = this.getUserDataFromUI();
        }
        if (userData != null) {
            itemData = (UserCustomConfigItemData)userData.getTables().get((String)this.uiTables.get(tbl));
        }
        if (itemData != null) {
            itemData.getGenericData().put(PRINTSETTING, printSetting);
            try {
                this.saveDataToDB(userData);
            }
            catch (Exception e) {
                logger.error((Object)("save userconfig error:" + e));
            }
        }
    }

    public boolean tableHasChanged(KDTable currentTable, UserCustomConfigItemData defaultData) {
        if (currentTable != null && defaultData != null) {
            if (currentTable.getColumnCount() != defaultData.getColumnData().size()) {
                return true;
            }
            Iterator itr = defaultData.getColumnData().keySet().iterator();
            while (itr.hasNext()) {
                int dataIndex;
                IColumn col;
                String key = (String)itr.next();
                ColumnItemData columnData = (ColumnItemData)defaultData.getColumnData().get(key);
                if (columnData == null || key.equals((col = currentTable.getColumn(dataIndex = columnData.getIndex())).getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public Set getForceDisplayKeys() {
        return this.forceDisplayKeys;
    }
}

