/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import com.kingdee.util.SerializableByteArrayInputStream;
import com.kingdee.util.db.SQLUtils;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DbUtil {
    private static Connection connection = null;

    public static IRowSet executeQuery(String sql) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            statement = conn.createStatement();
            rs = statement.executeQuery(sql);
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
        return jdbcRowSet;
    }

    public static IRowSet executeQuery(String sql, Object[] params) throws BOSException {
        JdbcRowSet jdbcRowSet;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            rs = ps.executeQuery();
            JdbcRowSet rowset = new JdbcRowSet();
            rowset.populate(rs);
            jdbcRowSet = rowset;
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)conn);
        return jdbcRowSet;
    }

    public static void execute(String sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        try {
            conn = DbUtil.getConnection();
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException exc) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)conn);
        }
    }

    public static void execute(String sql, Object[] params) throws BOSException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = DbUtil.getConnection();
            ps = conn.prepareStatement(sql);
            for (int i = 0; i < params.length; ++i) {
                ps.setObject(i + 1, params[i]);
            }
            ps.execute();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sql, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public static Connection getConnection() throws SQLException {
        String url = UIConfig.getConnectUrl();
        String name = UIConfig.getDBUserName();
        String password = UIConfig.getDBPassword();
        if (connection == null) {
            com.kingdee.bos.ctrl.common.util.DBUtil.loadKSQLDriver();
            connection = com.kingdee.bos.ctrl.common.util.DBUtil.openDB((String)url, (String)name, (String)password);
        }
        if (connection.isClosed()) {
            connection = com.kingdee.bos.ctrl.common.util.DBUtil.openDB((String)url, (String)name, (String)password);
        }
        return connection;
    }

    public static RptRowSet executeQuery(String sql, int from, int length) throws SQLException {
        RptRowSet rst = DBUtil.executeQuery((String)sql.toString(), null, (int)from, (int)length, (Connection)DbUtil.getConnection());
        return rst;
    }

    public static RptRowSet executeQuery(String sql, SqlParams params, int from, int length) throws SQLException {
        RptRowSet rst = DBUtil.executeQuery((String)sql.toString(), (SqlParams)params, (int)from, (int)length, (Connection)DbUtil.getConnection());
        return rst;
    }

    public static void prepareVarcharParam(PreparedStatement stmt, int index, String param) throws SQLException {
        byte[] value = param.getBytes();
        stmt.setAsciiStream(index, (InputStream)new SerializableByteArrayInputStream(value), value.length);
    }
}

