/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.ClientVersionUtil;
import com.kingdee.eas.fi.gr.cslrpt.util.DNFFile;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.rptclient.gr.rptclient.util.BaseBizDataUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ReceiveTemplate {
    public static boolean receive(String kdtPath, String password) throws BOSException, IOException, KDFException {
        DNFFile file = new DNFFile(kdtPath, password);
        boolean result = true;
        String easVersion = null;
        try {
            easVersion = ClientVersionUtil.getCommonLibVersion();
            if (easVersion.compareTo(file.getEASVersion()) < 0) {
                result = false;
                throw new Exception("\u60a8\u4f7f\u7528\u7684\u5ba2\u6237\u7a0b\u5e8f\u7248\u672c\u592a\u4f4e\uff0c\u53ef\u80fd\u65e0\u6cd5\u4f7f\u7528\u65b0\u6a21\u677f\uff0c\u5efa\u8bae\u5347\u7ea7\u5ba2\u6237\u7aef\u7a0b\u5e8f\uff01");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ReceiveTemplate.receiveTemplates(file.getTemplateCollection());
        }
        catch (SQLException e) {
            result = false;
        }
        ReceiveTemplate.receiveCurrency(file.getCurrencyCollection());
        ReceiveTemplate.receiveCompany(file.getOrgUnitCollection());
        ReceiveTemplate.writeUpdateTime(file.getUpdateTime());
        return result;
    }

    private static boolean receiveTemplate(ArrayList templateCollection) throws BOSException, IOException, KDFException {
        if (templateCollection == null) {
            return true;
        }
        ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        boolean iscover = false;
        boolean askCover = false;
        StringBuffer msg = new StringBuffer();
        Iterator iter = templateCollection.iterator();
        while (iter.hasNext()) {
            TemplateInfo template = (TemplateInfo)iter.next();
            StringBuffer sql = new StringBuffer();
            sql.append("select Fid from t_eas_template");
            sql.append(" where fnumber = ? and FVersionNumber = ?");
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{template.getNumber(), template.getVersionNumber()});
            if (rowSet.size() > 0) {
                if (!askCover) {
                    askCover = true;
                    if (MsgBox.showConfirm2((String)resHelper.getString("templateHasExists")) != 0) continue;
                    iscover = true;
                }
                if (!iscover) continue;
                sql = new StringBuffer();
                sql.append("update t_eas_template");
                sql.append(" set FId = ?, FName = ?, FDescription = ?,");
                sql.append(" FPeriodType = ?, FDynaRptType = ?, ");
                sql.append(" FTemplateType = ?,");
                sql.append(" FIsEditable = ?");
                sql.append(" where FNumber = ? and FVersionNumber = ?");
                DbUtil.execute(sql.toString(), new Object[]{template.getId().toString(), template.getName(), template.getDescription(), new Integer(template.getPeriodType().getValue()), new Integer(template.getDynaRptType().getValue()), new Integer(template.getTemplateType().getValue()), new Integer((Boolean)template.get("CSL_PROPERTY_ISALLOWCHANGE") != false ? 1 : 0), template.getNumber(), template.getVersionNumber()});
            } else {
                sql = new StringBuffer();
                sql.append("select FId, FVersionNumber from t_eas_template");
                sql.append(" where FNumber = ?");
                IRowSet rst = DbUtil.executeQuery(sql.toString(), new Object[]{template.getNumber()});
                try {
                    if (rst.next()) {
                        String version = rst.getString("FVersionNumber");
                        if (!ReceiveTemplate.isBiggerVersion(template.getVersionNumber(), version)) continue;
                        DbUtil.execute("delete t_eas_template where FId = ?", new Object[]{rst.getString("FId")});
                    }
                }
                catch (SQLException e) {
                    throw new SQLDataException(e);
                }
                sql = new StringBuffer();
                sql.append("insert into t_eas_template ");
                sql.append("(FId, FNumber, FName, FVersionNumber,");
                sql.append(" FDescription, FPeriodType, FDynaRpttype, FTemplateType, ");
                sql.append(" FIsEditable)");
                sql.append(" values (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                DbUtil.execute(sql.toString(), new Object[]{template.getId().toString(), template.getNumber(), template.getName(), template.getVersionNumber(), template.getDescription(), new Integer(template.getPeriodType().getValue()), new Integer(template.getDynaRptType().getValue()), new Integer(template.getTemplateType().getValue()), new Integer((Boolean)template.get("CSL_PROPERTY_ISALLOWCHANGE") != false ? 1 : 0)});
            }
            sql = new StringBuffer();
            sql.append("update t_eas_template set fdata = ? where fid = ?");
            DbUtil.execute(sql.toString(), new Object[]{template.getData(), template.getId().toString()});
        }
        if (msg.length() > 0) {
            AdvMsgBox box = AdvMsgBox.createAdvMsgBox(null, (String)"", (String)resHelper.getString("templateHasUsed"), (String)msg.toString(), (int)1, (int)8188);
            box.show();
            return false;
        }
        return true;
    }

    public static void receiveTemplates(List templates) throws BOSException, SQLException {
        String updateSql;
        String key;
        if (templates == null || templates.isEmpty()) {
            return;
        }
        Integer intTrue = new Integer(1);
        Integer intFalse = new Integer(0);
        StringBuffer overTemplateIds = new StringBuffer();
        StringBuffer insertSql = new StringBuffer("insert into t_eas_template ");
        insertSql.append("(FId,FNumber,FName,FDescription,FVersionNumber");
        insertSql.append(",FPeriodType,FDynaRpttype,FTemplateType,FIsEditable,FVersionStatus)");
        insertSql.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, String[]> localTemplates = new HashMap<String, String[]>();
        StringBuffer querySql = new StringBuffer();
        querySql.append("select FID,FNumber,FTemplateType,FVersionNumber");
        querySql.append(" from T_EAS_Template where FVersionStatus=1");
        IRowSet rs = DbUtil.executeQuery(querySql.toString());
        while (rs.next()) {
            key = rs.getString(2) + ";" + rs.getString(3);
            localTemplates.put(key, new String[]{rs.getString(1), rs.getString(4)});
        }
        Iterator iter = templates.iterator();
        while (iter.hasNext()) {
            TemplateInfo template = (TemplateInfo)iter.next();
            key = template.getNumber() + ";" + template.getTemplateType().getValue();
            boolean isNew = !localTemplates.containsKey(key);
            boolean isNewVersion = false;
            if (!isNew) {
                String[] value = (String[])localTemplates.get(key);
                String versionNumber = value[1];
                isNewVersion = ReceiveTemplate.isNewVersion(template.getVersionNumber(), versionNumber);
                if (isNewVersion) {
                    overTemplateIds.append("'").append(value[0]).append("'.");
                }
            }
            if (!isNew && !isNewVersion) continue;
            values.clear();
            values.add(template.getId().toString());
            values.add(template.getNumber());
            values.add(template.getName());
            values.add(template.getDescription());
            values.add(template.getVersionNumber());
            values.add(new Integer(template.getPeriodType().getValue()));
            values.add(new Integer(template.getDynaRptType().getValue()));
            values.add(new Integer(template.getTemplateType().getValue()));
            Boolean isAllowChange = (Boolean)template.get("CSL_PROPERTY_ISALLOWCHANGE");
            values.add(isAllowChange != false ? intTrue : intFalse);
            values.add(intTrue);
            DbUtil.execute(insertSql.toString(), values.toArray());
            updateSql = "update t_eas_template set fdata = ? where fid = ?";
            values.clear();
            values.add(template.getData());
            values.add(template.getId().toString());
            DbUtil.execute(updateSql.toString(), values.toArray());
        }
        if (overTemplateIds.length() > 0) {
            overTemplateIds.setLength(overTemplateIds.length() - 1);
            updateSql = "update T_EAS_Template set FVersionStatus=0 where FID in(" + overTemplateIds.toString() + ")";
            DbUtil.execute(updateSql);
        }
    }

    public static void writeUpdateTime(String updateTime) {
        String sql = "update t_eas_param set FValue=? where FName=?";
        try {
            DbUtil.execute(sql, new Object[]{updateTime, "DNF_UpdateTime"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isBiggerVersion(String version1, String version2) {
        int j;
        String[] vers1 = version1.split("\\.");
        String[] vers2 = version2.split("\\.");
        int i = Integer.parseInt(vers1[0]);
        if (i > (j = Integer.parseInt(vers2[0]))) {
            return true;
        }
        i = Integer.parseInt(vers1[1]);
        if (i > (j = Integer.parseInt(vers2[1]))) {
            return true;
        }
        return vers1.length == 3 && vers2.length == 3 && (i = Integer.parseInt(vers1[2])) > (j = Integer.parseInt(vers2[2]));
    }

    public static boolean isNewVersion(String newVersion, String oldVersion) {
        String[] version2;
        String[] version1 = newVersion.split("\\.");
        if (version1.length > (version2 = oldVersion.split("\\.")).length) {
            for (int i = 0; i < version2.length; ++i) {
                int number2;
                int number1 = Integer.parseInt(version1[i]);
                if (number1 == (number2 = Integer.parseInt(version2[i]))) continue;
                return number1 > number2;
            }
            return true;
        }
        for (int i = 0; i < version2.length; ++i) {
            int number2;
            int number1 = Integer.parseInt(version1[i]);
            if (number1 == (number2 = Integer.parseInt(version2[i]))) continue;
            return number1 > number2;
        }
        return false;
    }

    public static void receiveCurrency(ArrayList currencyCollection) throws BOSException {
        if (currencyCollection == null) {
            return;
        }
        Map idAndNumbers = BaseBizDataUtil.getCurrencyIdAndNumber();
        Iterator iter = currencyCollection.iterator();
        while (iter.hasNext()) {
            CurrencyInfo currency = (CurrencyInfo)iter.next();
            if (currency.getNumber().equals("GLC") || currency.getNumber().equals("GRC") || idAndNumbers.containsKey(currency.getId().toString()) || idAndNumbers.containsValue(currency.getNumber())) continue;
            String sql = "insert into T_Eas_Currency (FId, FNumber, FName) values (?, ?, ?)";
            DbUtil.execute(sql, new Object[]{currency.getId().toString(), currency.getNumber(), currency.getName()});
        }
    }

    public static void receiveCompany(ArrayList orgUnitCollection) throws BOSException {
        if (orgUnitCollection == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        Map idAndNumbers = BaseBizDataUtil.getCompanyIdAndNumber();
        try {
            String sql = "select Fid from t_eas_company where fid = ? or fnumber = ?";
            for (int i = orgUnitCollection.size() - 1; i >= 0; --i) {
                OrgUnitInfo company = (OrgUnitInfo)orgUnitCollection.get(i);
                if (!idAndNumbers.containsKey(company.getId().toString()) && !idAndNumbers.containsValue(company.getNumber())) continue;
                orgUnitCollection.remove(i);
            }
            conn = DbUtil.getConnection();
            sql = "insert into T_Eas_Company (FId, FNumber, FName) values (?, ?, ?)";
            ps = conn.prepareStatement(sql);
            boolean bool = false;
            HashSet set = new HashSet(orgUnitCollection);
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                OrgUnitInfo company = (OrgUnitInfo)iter.next();
                bool = true;
                ps.setString(1, company.getId().toString());
                ps.setString(2, company.getNumber());
                ps.setString(3, company.getName());
                ps.addBatch();
            }
            if (bool) {
                ps.executeBatch();
            }
            ps.clearBatch();
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }
}

