/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.check;

import com.kingdee.eas.rptclient.newrpt.designer.check.AbstractRptCheckExpLineEditUI;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaPickListener;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaPickerUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;

public class RptCheckExpLineEditUI
extends AbstractRptCheckExpLineEditUI {
    private HashMap insertMap;
    private PickerListener pickerListener = null;

    public RptCheckExpLineEditUI() throws Exception {
        this.initializeUI();
    }

    private void initializeUI() {
        this.insertMap = new HashMap(15, 0.75f);
        this.insertMap.put(this.btnOR, "OR()");
        this.insertMap.put(this.btnNOT, "NOT()");
        this.insertMap.put(this.btnPlus, "+");
        this.insertMap.put(this.btnMinus, "-");
        this.insertMap.put(this.btnMultiply, "*");
        this.insertMap.put(this.btnDivision, "/");
        this.insertMap.put(this.btnAND, "AND()");
        this.insertMap.put(this.btnBracket, "()");
        this.insertMap.put(this.btnEqual, "=");
        this.insertMap.put(this.btnGT, ">");
        this.insertMap.put(this.btnLT, "<");
        this.insertMap.put(this.btnDiff, "<>");
        this.insertMap.put(this.btnDot, ",");
        this.insertMap.put(this.btnIf, "[A]+[B]=[C]{|}");
        this.setName(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.checkCondition"));
        this.initUIContentLayout();
        this.btnOR.setText("OR()");
        this.btnNOT.setText("NOT()");
        this.btnPlus.setText("+");
        this.btnMinus.setText("-");
        this.btnMultiply.setText("*");
        this.btnDivision.setText("/");
        this.btnAND.setText("AND()");
        this.btnBracket.setText("()");
        this.btnEqual.setText("=");
        this.btnGT.setText(">");
        this.btnLT.setText("<");
        this.btnDiff.setText("<>");
        this.btnDot.setText(",");
        this.btnFormula.setText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.formula"));
        this.txtExpression.setSelectAllOnFocus(false);
    }

    public String getExpression() {
        String res = this.txtExpression.getText();
        if (res != null) {
            res = res.trim();
        }
        return res;
    }

    public void setExpression(String exp) {
        this.txtExpression.setText(exp);
    }

    public void actionInsertOperate_actionPerformed(ActionEvent e) throws Exception {
        Object src = e.getSource();
        if (src == this.btnFormula) {
            this.insertFormula();
        } else {
            this.insertOperator((String)this.insertMap.get(src), src == this.btnBracket);
        }
    }

    public void setFocus() {
        this.txtExpression.requestFocus();
    }

    private void insertOperator(String word, boolean isBracket) {
        int pos = this.txtExpression.getCaretPosition();
        this.txtExpression.insert(word, pos);
        if (isBracket) {
            this.txtExpression.setCaretPosition(pos + 1);
        }
        this.txtExpression.requestFocus();
    }

    private void insertFormula() {
        if (this.pickerListener == null) {
            this.pickerListener = new PickerListener();
        }
        try {
            FormulaPickerUI picker = FormulaPickerUI.creatFormulaPicker((Component)((Object)this));
            picker.addFormulaPickerListener(this.pickerListener);
            picker.setExtendable(false);
            picker.open("exclude:{formulas{item,ditem,GETCURRENCY};exclude:categorys{CslRptFormula,manage_accountant,fixasset,fm_fs,fm_fpl,fm_fp,rptIndex}}", false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private class PickerListener
    implements FormulaPickListener {
        private PickerListener() {
        }

        public String pickFormulaLine() {
            return null;
        }

        public void setFormulaLine(String line) {
            RptCheckExpLineEditUI.this.insertOperator(line, false);
        }
    }
}

