/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormula;
import java.util.StringTokenizer;

public final class FormulaFilter {
    public static final String FORMULA_FILTER = "exclude:{formulas{item,ditem,GETCURRENCY};exclude:categorys{CslRptFormula,manage_accountant,fixasset,fm_fs,fm_fpl,fm_fp,rptIndex}}";
    private String inCategory;
    private String exCategory;
    private String inGroup;
    private String exGroup;
    private String inFormula;
    private String exFormula;
    private boolean parsed = false;
    public static final String CMD_INCLUDE = "include:";
    public static final String CMD_EXCLUDE = "exclude:";
    public static final String FLT_CATE = "categorys";
    public static final String FLT_GRUP = "groups";
    public static final String FLT_NAME = "formulas";
    public static final String FLT_WILDCARD = "*";

    public FormulaFilter() {
        this.initialize();
    }

    private void initialize() {
        this.inCategory = null;
        this.exCategory = null;
        this.inGroup = null;
        this.exGroup = null;
        this.inFormula = null;
        this.exFormula = null;
    }

    public void setFilter(String strFilter) {
        if (!this.parseFilter(strFilter)) {
            this.initialize();
        }
    }

    private boolean parseFilter(String strFilter) {
        if (this.parsed) {
            return true;
        }
        this.parsed = true;
        if (strFilter == null) {
            return false;
        }
        StringTokenizer tk = new StringTokenizer(strFilter.toLowerCase(), ";\n\r\f");
        boolean isOk = true;
        while (tk.hasMoreTokens()) {
            String cmd = tk.nextToken();
            if (cmd.startsWith(CMD_INCLUDE)) {
                isOk = this.parseSubFilter(cmd.substring(CMD_INCLUDE.length()), true) && isOk;
            } else if (cmd.startsWith(CMD_EXCLUDE)) {
                boolean bl = isOk = this.parseSubFilter(cmd.substring(CMD_EXCLUDE.length()), false) && isOk;
            }
            if (isOk) continue;
            break;
        }
        return isOk;
    }

    private boolean parseSubFilter(String strFilter, boolean isInclude) {
        StringTokenizer tk = new StringTokenizer(strFilter, "{},");
        boolean isOk = true;
        String cmd = null;
        int status = 0;
        block16: while (tk.hasMoreTokens()) {
            cmd = tk.nextToken();
            if (FLT_CATE.equals(cmd)) {
                status = isInclude ? 1 : 2;
                continue;
            }
            if (FLT_GRUP.equals(cmd)) {
                status = isInclude ? 3 : 4;
                continue;
            }
            if (FLT_NAME.equals(cmd)) {
                status = isInclude ? 5 : 6;
                continue;
            }
            if (status == 7) continue;
            if (FLT_WILDCARD.equals(cmd)) {
                switch (status) {
                    case 1: {
                        this.inCategory = null;
                        break;
                    }
                    case 2: {
                        this.exCategory = null;
                        break;
                    }
                    case 3: {
                        this.inGroup = null;
                        break;
                    }
                    case 4: {
                        this.exGroup = null;
                        break;
                    }
                    case 5: {
                        this.inFormula = null;
                        break;
                    }
                    case 6: {
                        this.exFormula = null;
                        break;
                    }
                    default: {
                        isOk = false;
                        break block16;
                    }
                }
                status = 7;
                continue;
            }
            cmd = cmd + '|';
            switch (status) {
                case 1: {
                    if (this.inCategory == null) {
                        this.inCategory = cmd;
                        continue block16;
                    }
                    this.inCategory = this.inCategory + cmd;
                    continue block16;
                }
                case 2: {
                    if (this.exCategory == null) {
                        this.exCategory = cmd;
                        continue block16;
                    }
                    this.exCategory = this.exCategory + cmd;
                    continue block16;
                }
                case 3: {
                    if (this.inGroup == null) {
                        this.inGroup = cmd;
                        continue block16;
                    }
                    this.inGroup = this.inGroup + cmd;
                    continue block16;
                }
                case 4: {
                    if (this.exGroup == null) {
                        this.exGroup = cmd;
                        continue block16;
                    }
                    this.exGroup = this.exGroup + cmd;
                    continue block16;
                }
                case 5: {
                    if (this.inFormula == null) {
                        this.inFormula = cmd;
                        continue block16;
                    }
                    this.inFormula = this.inFormula + cmd;
                    continue block16;
                }
                case 6: {
                    if (this.exFormula == null) {
                        this.exFormula = cmd;
                        continue block16;
                    }
                    this.exFormula = this.exFormula + cmd;
                    continue block16;
                }
            }
            isOk = false;
            break;
        }
        return isOk;
    }

    public boolean filtrateFormula(RptFormula fm) {
        return fm == null || this.filtrateCate(fm.getCategory()) || this.filtrateGroup(fm.getGroup()) || this.filtrateName(fm.getName());
    }

    public boolean filtrateCate(String cateName) {
        if (cateName == null) {
            return true;
        }
        cateName = cateName.toLowerCase();
        if (this.exCategory != null && this.regexMatches(this.exCategory, cateName)) {
            return true;
        }
        return this.inCategory != null && !this.regexMatches(this.inCategory, cateName);
    }

    public boolean filtrateGroup(String groupName) {
        if (groupName == null) {
            return true;
        }
        groupName = groupName.toLowerCase();
        if (this.exGroup != null && this.regexMatches(this.exGroup, groupName)) {
            return true;
        }
        return this.inGroup != null && !this.regexMatches(this.inGroup, groupName);
    }

    public boolean filtrateName(String fmName) {
        if (fmName == null) {
            return true;
        }
        fmName = fmName.toLowerCase();
        if (this.exFormula != null && this.regexMatches(this.exFormula, fmName)) {
            return true;
        }
        return this.inFormula != null && !this.regexMatches(this.inFormula, fmName);
    }

    private boolean regexMatches(String matchee, String matcher) {
        return matchee.matches("(" + matcher + "\\|.*)|(.*\\|" + matcher + "\\|.*)");
    }
}

