/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.designer.formulawizard;

import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaValidation;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.IRptDataPublisher;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptFormulaParameter;
import com.kingdee.eas.rptclient.newrpt.designer.formulawizard.RptOperObject;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class RptFormula
extends RptOperObject
implements IRptDataPublisher {
    protected static final int STA_PARAMS = 1;
    protected static final int STA_CMTS = 2;
    protected static final int STA_PARAM = 3;
    protected static final int STA_CMT = 4;
    protected static final int STA_ALIAS = 5;
    protected static final int STA_LNAME = 6;
    protected Vector parameters;
    protected String type;
    protected String returnType;
    protected String group;
    protected String category;
    private String wizard;
    protected boolean strictRequired = false;
    private String temp;
    private List validations = null;

    public RptFormula(String name) {
        super(name);
    }

    public RptFormula(String name, IRptDataPublisher pb) {
        super(name, pb);
        this.parameters = new Vector(4);
    }

    public String toString() {
        String res = super.toString();
        if (!this.name.equalsIgnoreCase(res)) {
            res = this.name + " (" + res + ")";
        }
        return res;
    }

    public void clear() {
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            ((RptFormulaParameter)this.parameters.elementAt(i)).clear();
        }
        this.parameters.removeAllElements();
        super.clear();
    }

    public void goContent(String value) {
        if (this.status == 4) {
            this.description.put(this.temp, value);
        } else if (this.status == 6) {
            this.alias.put(this.temp, value);
        }
    }

    public void goInto(String target, Attributes atts) throws SAXException {
        if (target.equalsIgnoreCase("param")) {
            if (this.status != 1) {
                this.status = -1;
            } else {
                this.status = 3;
                RptFormulaParameter p = new RptFormulaParameter(target, this);
                this.publisher.keep(p);
                p.goInto(target, atts);
            }
        } else if (target.equalsIgnoreCase("params")) {
            this.status = this.status != 0 ? -1 : 1;
        } else if (target.equalsIgnoreCase("formula")) {
            this.status = 0;
            String av = atts.getValue("name");
            if (av == null) {
                throw new SAXException("rptformula-exp-noname");
            }
            this.name = av.trim();
            av = atts.getValue("type");
            this.type = av != null ? av.trim() : "default";
            av = atts.getValue("return");
            this.type = av != null ? av.trim() : "amount";
            av = atts.getValue("category");
            this.category = av != null ? av.trim() : null;
            av = atts.getValue("group");
            this.group = av != null ? av.trim() : "$";
            av = atts.getValue("wizard");
            this.wizard = av != null ? av.trim() : "com.kingdee.eas.rptclient.newrpt.designer.formulawizard.FormulaWizardUI";
            av = atts.getValue("strictRequired");
            if (!StringUtils.isEmpty((String)av)) {
                this.strictRequired = CommonUtil.isTrue(av);
            }
        } else if (target.equalsIgnoreCase("comments")) {
            this.status = this.status != 0 ? -1 : 2;
        } else if (target.equalsIgnoreCase("comment")) {
            if (this.status != 2) {
                this.status = -1;
            } else {
                this.status = 4;
                String av = atts.getValue("language");
                this.temp = av != null ? av.trim() : "default";
            }
        } else if (target.equalsIgnoreCase("alias")) {
            this.status = this.status != 0 ? -1 : 5;
        } else if (target.equalsIgnoreCase("local_name")) {
            if (this.status != 5) {
                this.status = -1;
            } else {
                this.status = 6;
                String av = atts.getValue("language");
                this.temp = av != null ? av.trim() : "default";
            }
        } else if (target.equalsIgnoreCase("validation")) {
            FormulaValidation valid = new FormulaValidation(target, this);
            this.publisher.keep(valid);
            valid.goInto(target, atts);
        } else if (!target.equalsIgnoreCase("var")) {
            this.status = 0;
        }
    }

    public void goOut(String target) {
        if (target.equalsIgnoreCase("param")) {
            this.status = 1;
        } else if (target.equalsIgnoreCase("params")) {
            this.status = this.status != 1 ? -1 : 0;
        } else if (target.equalsIgnoreCase("formula")) {
            this.status = 0;
            this.publisher.publish(this);
        } else if (target.equalsIgnoreCase("comments")) {
            this.status = this.status != 2 ? -1 : 0;
        } else if (target.equalsIgnoreCase("comment")) {
            this.status = 2;
        } else if (target.equalsIgnoreCase("alias")) {
            this.status = this.status != 5 ? -1 : 0;
        } else if (target.equalsIgnoreCase("local_name")) {
            this.status = 5;
        } else if (!target.equalsIgnoreCase("validation")) {
            this.status = 0;
        }
    }

    public void keep(RptOperObject ob) {
        this.publisher.keep(ob);
    }

    public void publish(RptOperObject ob) {
        if (ob instanceof RptFormulaParameter) {
            this.parameters.add(ob);
            this.status = 1;
            this.publisher.keep(this);
        } else if (ob instanceof FormulaValidation) {
            if (this.validations == null) {
                this.validations = new ArrayList(2);
            }
            this.validations.add(ob);
            this.publisher.keep(this);
        } else {
            this.publisher.publish(ob);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public String getCategory() {
        return this.category;
    }

    public Collection getParameters() {
        return this.parameters;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getType() {
        return this.type;
    }

    public List getValidations() {
        return this.validations;
    }

    public void setValidations(List validations) {
        this.validations = validations;
    }

    public boolean isStrictRequired() {
        return this.strictRequired;
    }

    public void setStrictRequired(boolean strictRequired) {
        this.strictRequired = strictRequired;
    }

    public String getWizard() {
        return this.wizard;
    }

    public void setWizard(String wizard) {
        this.wizard = wizard;
    }
}

