/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.functionimpl;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.rptclient.gr.k3webservice.K3WebServiceContext;
import com.kingdee.eas.rptclient.gr.k3webservice.impl.K3AccFunctionsSoapStub;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.functionimpl.CalculateContext;
import com.kingdee.eas.rptclient.newrpt.functionimpl.IFormulaBatchExecute;
import com.kingdee.util.StringUtils;
import javax.xml.rpc.Service;
import org.apache.axis.AxisFault;

public class AcctcashBatchExecute
extends IFormulaBatchExecute {
    protected void execOne(Parameter p) throws Exception {
        IDataProvider dataProvider;
        Book book = this.getBook();
        Sheet sheet = book.getSheet(p.getSheetName());
        ReportVariables variables = BookProperties.loadVariables(book);
        Object[] args = p.getArgs();
        String sdsnName = (String)((Variant)args[6]).getValue();
        int year = ((Number)((Variant)args[3]).getValue()).intValue();
        int startp = ((Number)((Variant)args[4]).getValue()).intValue();
        int endp = ((Number)((Variant)args[5]).getValue()).intValue();
        if (year <= 0) {
            year += variables.getIntValue("StartYear", sheet.getSheetName(), 0);
        }
        if (startp <= 0) {
            startp += variables.getIntValue("StartPeriod", sheet.getSheetName(), 0);
        }
        if (endp <= 0) {
            endp += variables.getIntValue("EndPeriod", sheet.getSheetName(), 0);
        }
        boolean include = variables.getBoolValue("IncludePosted", sheet.getSheetName(), false);
        String currency = (String)((Variant)args[2]).getValue();
        if (StringUtils.isEmpty((String)currency)) {
            currency = variables.getStringValue("Currency", sheet.getSheetName());
        }
        if ((dataProvider = (IDataProvider)book.getUserObjectValue("CTX")) instanceof CslReportDataProvider) {
            CslReportDataProvider pp = (CslReportDataProvider)dataProvider;
            if (year <= 0) {
                year += pp.getReportVO().getYear();
            }
            if (startp <= 0) {
                startp += pp.getReportVO().getPeriod();
            }
            if (endp <= 0) {
                endp += pp.getReportVO().getPeriod();
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = pp.getReportVO().getCurrencyNumber();
            }
        }
        Object result = this.acctCash((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), (String)((Variant)args[2]).getValue(), year, startp, endp, include, sdsnName);
        p.setValue(result);
    }

    public Object acctCash(String item, String fetchType, String currency, int year, int startPeriod, int endPeriod, boolean include, String sdName) throws Exception {
        try {
            currency = CalculateContext.getInstance().getK3CurrencyNumber(currency);
            K3AccFunctionsSoapStub proxy = new K3AccFunctionsSoapStub(K3WebServiceContext.getInstance().getK3FunctionEndPoint(), (Service)new org.apache.axis.client.Service());
            StringBuffer sb = new StringBuffer();
            sb.append(item).append(',').append(fetchType).append(',').append(currency == null ? "" : currency).append(',').append(year).append(',').append(startPeriod).append(',').append(endPeriod).append(',').append(include ? "Y" : "N");
            String sdsn = K3WebServiceContext.getInstance().getSDSNByName(sdName);
            String acct = proxy.acctCash(sdsn, sb.toString());
            if ("#".equals(acct)) {
                return "0";
            }
            return acct;
        }
        catch (AxisFault e) {
            e.printStackTrace();
            throw new Exception(e);
        }
    }
}

