/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.functionimpl;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.functionimpl.IFormulaBatchExecute;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;

public class CsRefBatchExecute
extends IFormulaBatchExecute {
    protected void execOne(Parameter parameter) throws Exception {
        Book book = this.getBook();
        IDataProvider dataProvider = (IDataProvider)book.getUserObjectValue("CTX");
        Object[] args = parameter.getArgs();
        if (dataProvider instanceof CslReportDataProvider) {
            int periodType;
            int period;
            CslReportDataProvider pp = (CslReportDataProvider)dataProvider;
            ReportVO reportVO = pp.getReportVO();
            String tempCode = (String)((Variant)args[1]).getValue();
            if (StringUtils.isEmpty((String)tempCode)) {
                tempCode = reportVO.getTemplateNumber();
            }
            String groupTempType = (String)((Variant)args[2]).getValue();
            int rptTmpType = RptTmpTypeEnum.getEnum((String)groupTempType).getValue();
            int yearOff = ((Variant)args[3]).intValue();
            int periodOff = ((Variant)args[4]).intValue();
            int year = reportVO.getYear();
            int[] arrYearAndPeriod = RPTDateUtil.getRptYearAndPeriod((int)year, (int)(period = reportVO.getPeriod()), (int)(periodType = reportVO.getPeriodType().getValue()), (int)yearOff, (int)periodOff);
            if (arrYearAndPeriod != null) {
                year = arrYearAndPeriod[0];
                period = arrYearAndPeriod[1];
            }
            String sheetName = (String)((Variant)args[5]).getValue();
            String cellName = (String)((Variant)args[6]).getValue();
            String currency = (String)((Variant)args[7]).getValue();
            if (StringUtils.isEmpty((String)currency)) {
                currency = reportVO.getCurrencyNumber();
            }
            Object result = this.csRef(tempCode, rptTmpType, year, period, sheetName, cellName, currency);
            parameter.setValue(result);
        }
    }

    private Object csRef(String tempCode, int rptTmpType, int year, int period, String sheetName, String cellName, String currency) {
        StringBuffer sql = new StringBuffer();
        sql.append("select r.FId, r.FData from T_EAS_Report r join T_EAS_Template t");
        sql.append(" on r.FTemplateID = t.FId ");
        sql.append(" join T_Eas_Currency c on r.FCurrencyID = c.FId");
        sql.append(" where c.FNumber = ? and t.FNumber = ? and t.FTemplateType = ?");
        sql.append(" and r.FYear = ? and r.FPeriod = ?");
        Object[] params = new Object[]{currency, tempCode, new Integer(rptTmpType), new Integer(year), new Integer(period)};
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql.toString(), params);
            if (rowSet.next()) {
                return this.getCellValue(IOHelper.unpackBook((byte[])rowSet.getBytes("FData")), sheetName, cellName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
        return null;
    }

    private Object getCellValue(Book book, String sheetName, String cellName) throws ReportException {
        ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.fi.rpt.ReportResource");
        Sheet sheet = book.getSheet(sheetName);
        if (sheet == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{resHelper.getString("Sheet_Not_Exists") + " \"" + sheetName + "\""});
        }
        Rect pos = TableToolkit.range2xy((String)cellName);
        if (pos == null || !pos.isValid()) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{resHelper.getString("Cell_Not_Exists") + " \"" + cellName + "\""});
        }
        pos.normalize();
        Cell c = sheet.getCell(pos.getYBase(), pos.getXBase(), false);
        if (c == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{resHelper.getString("Cell_Not_Exists") + " \"" + cellName + "\""});
        }
        return c.getValue();
    }
}

