/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.util;

import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.eas.fi.rpt.CalculateErrorHandler;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;

public class CommonUtil {
    public static final String RPT_ERRORHANDLER = "RPT_ERRORHANDLER";
    public static final String ZERORDIVIDE = "ZERORDIVIDE";
    public static final String resPath = "com.kingdee.eas.rptclient.gr.rptclient.resource.RptClientUIResource";

    public static boolean isTrue(Object target) {
        return CommonUtil.isTrue(target, false);
    }

    public static boolean isTrue(Object target, boolean defaultValue) {
        String[] TRUTH = new String[]{"true", "yes", "1", "sure", "Y", "confirm"};
        String[] FALSE = new String[]{"false", "no", "0", "cancel", "N"};
        if (target == null) {
            return defaultValue;
        }
        if (target instanceof Boolean) {
            return (Boolean)target;
        }
        String s = target.toString().trim();
        int f = 0;
        int t = 0;
        while (t + f < TRUTH.length + FALSE.length) {
            if (t < TRUTH.length) {
                if (s.equalsIgnoreCase(TRUTH[t])) {
                    return true;
                }
                ++t;
            }
            if (f >= FALSE.length) continue;
            if (s.equalsIgnoreCase(FALSE[f])) {
                return false;
            }
            ++f;
        }
        try {
            return Boolean.getBoolean(s);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static ReportCalculateErrorProvider getErrorhandlerFromKDF(KDF kdf) {
        String strDivide0;
        Object handler = kdf.getUserObject(RPT_ERRORHANDLER);
        if (handler instanceof ReportCalculateErrorProvider) {
            return (ReportCalculateErrorProvider)handler;
        }
        if (handler instanceof CalculateErrorHandler) {
            return new ReportCalculateErrorProvider((CalculateErrorHandler)handler);
        }
        if (handler == null && (strDivide0 = (String)kdf.getUserObject(ZERORDIVIDE)) != null) {
            ReportCalculateErrorProvider h = new ReportCalculateErrorProvider();
            h.setDealException(true);
            h.setExceptionReplacer(strDivide0);
            return h;
        }
        return null;
    }

    public static String getResource(String resPath, String key) {
        return ResourceBase.getString((String)resPath, (String)key, (Locale)LocaleUtils.getDefaultLocale());
    }

    public static String getResource(String key) {
        return ResourceBase.getString((String)resPath, (String)key, (Locale)LocaleUtils.getDefaultLocale());
    }

    public static String fixVersionNumber(String version) {
        StringBuffer fixedVersion = new StringBuffer();
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if ((c < '0' || c > '9') && c != '.') continue;
            fixedVersion.append(c);
        }
        return fixedVersion.toString();
    }

    public static boolean isNewVersion(String version1, String version2) {
        String[] array2;
        if (version1 == null || version2 == null) {
            return false;
        }
        version1 = CommonUtil.fixVersionNumber(version1);
        version2 = CommonUtil.fixVersionNumber(version2);
        String[] array1 = version1.split("\\.");
        if (array1.length >= (array2 = version2.split("\\.")).length) {
            for (int i = 0; i < array2.length; ++i) {
                int v2;
                int v1 = Integer.parseInt(array1[i]);
                if (v1 <= (v2 = Integer.parseInt(array2[i]))) continue;
                return true;
            }
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            int v1 = Integer.parseInt(array1[i]);
            int v2 = Integer.parseInt(array2[i]);
            if (v2 <= v1) continue;
            return false;
        }
        return true;
    }
}

