/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.newrpt.util;

import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.lang.reflect.UndeclaredThrowableException;
import javax.swing.JOptionPane;

public class ExceptionHandler {
    public static void handle(Throwable exc) {
        exc.printStackTrace();
        ExceptionHandler.handle(null, ExceptionHandler.getFriendlyMsg(exc), exc);
    }

    public static void handle(String errMsg, Throwable exc) {
        ExceptionHandler.handle(null, errMsg, exc);
    }

    public static void handle(Component owner, Throwable exc) {
        ExceptionHandler.handle(owner, ExceptionHandler.getFriendlyMsg(exc), exc);
    }

    public static void handle(Component owner, String errMsg, Throwable exc) {
        if (owner == null) {
            owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (!ExceptionHandler.handleArrayIndexOutOfBounds(owner, exc) && !ExceptionHandler.handleNullPointerException(owner, exc)) {
            if (exc instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException uex = (UndeclaredThrowableException)exc;
                if (uex != null) {
                    ExceptionHandler.handle(owner, uex.getUndeclaredThrowable());
                } else {
                    ExceptionHandler.handle(owner, exc);
                }
                return;
            }
            if (exc instanceof IllegalComponentStateException) {
                if ("component must be showing on the screen to determine its location".equals(exc.getMessage())) {
                    return;
                }
            } else if (!ExceptionHandler.isTheIllegalAgumentException(exc) && !ExceptionHandler.handleClassNotFoundException(owner, exc)) {
                JOptionPane.showMessageDialog(owner, errMsg, "\u9519\u8bef", 0);
                return;
            }
        }
    }

    private static boolean isTheIllegalAgumentException(Throwable exc) {
        boolean isIt = false;
        if (exc instanceof IllegalArgumentException) {
            String msg = "TextHitInfo is out of range";
            if (exc.getMessage() != null && exc.getMessage().equals(msg)) {
                isIt = true;
            }
        }
        return isIt;
    }

    private static boolean handleClassNotFoundException(Component owner, Throwable exc) {
        boolean handled = false;
        Throwable cause = exc;
        do {
            if (!(cause instanceof ClassNotFoundException)) continue;
            JOptionPane.showMessageDialog(owner, exc.getMessage(), "\u9519\u8bef", 0);
            handled = true;
            break;
        } while ((cause = cause.getCause()) != null);
        return handled;
    }

    private static String getFriendlyMsg(Throwable exc) {
        return exc.getMessage();
    }

    private static boolean handleArrayIndexOutOfBounds(Component owner, Throwable e) {
        String aim = "javax.swing.RepaintManager";
        if (e instanceof ArrayIndexOutOfBoundsException) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraces = cause.getStackTrace();
                for (int i = 0; i < stackTraces.length; ++i) {
                    if (stackTraces[i].toString().indexOf("javax.swing.RepaintManager") == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean handleNullPointerException(Component owner, Throwable e) {
        String aim = "sun.awt.windows.WInputMethod.dispatchEvent(WInputMethod.java:253)";
        String aim2 = "com.kingdee.bos.ctrl.swing.plaf.KingdeeTabbedPaneUI$StyleData.getInteger(KingdeeTabbedPaneUI.java:722)";
        if (e instanceof NullPointerException) {
            for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                StackTraceElement[] stackTraces = cause.getStackTrace();
                for (int i = 0; i < stackTraces.length; ++i) {
                    if (stackTraces[i].toString().indexOf("sun.awt.windows.WInputMethod.dispatchEvent(WInputMethod.java:253)") == -1 && stackTraces[i].toString().indexOf("com.kingdee.bos.ctrl.swing.plaf.KingdeeTabbedPaneUI$StyleData.getInteger(KingdeeTabbedPaneUI.java:722)") == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

