/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.base;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ModelDialogFactory
implements IUIFactory {
    private static final Logger log = Logger.getLogger(UIFactory.class);

    @Override
    public AbstractPanel create(Component owner, String panelName, Map uiContext) throws Exception {
        log.debug((Object)("Open ui " + panelName));
        Class<?> clazz = Class.forName(panelName);
        if (!AbstractPanel.class.isAssignableFrom(clazz)) {
            return null;
        }
        AbstractPanel p = (AbstractPanel)((Object)clazz.newInstance());
        if (owner == null && uiContext != null) {
            owner = (Component)uiContext.get("Owner");
        }
        Component ancestor = null;
        if (owner != null) {
            ancestor = SwingUtilities.getWindowAncestor(owner);
        }
        if (ancestor == null) {
            ancestor = owner;
        }
        KDDialog dialog = null;
        if (ancestor == null) {
            dialog = new KDDialog();
        } else if (ancestor instanceof Dialog) {
            dialog = new KDDialog((Dialog)ancestor, true);
        } else if (ancestor instanceof Frame) {
            dialog = new KDDialog((Frame)ancestor, true);
        }
        if (dialog == null) {
            dialog = new KDDialog();
        }
        p.setOwnerWindow((Window)dialog);
        p.setUIContext(uiContext);
        p.initUIContentLayout();
        dialog.getContentPane().add((Component)((Object)p));
        dialog.setTitle(p.getTitle());
        Dimension size = new Dimension(p.getSize());
        ((JPanel)dialog.getContentPane()).setPreferredSize(size);
        dialog.setResizable(false);
        dialog.setSize(size);
        ModelDialogFactory.setToScreenCenter((Window)dialog);
        return p;
    }

    public static void setToScreenCenter(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension windowSize = window.getSize();
        if (windowSize.height > screenSize.height) {
            windowSize.height = screenSize.height;
        }
        if (windowSize.width > screenSize.width) {
            windowSize.width = screenSize.width;
        }
        window.setLocation((screenSize.width - windowSize.width) / 2, (screenSize.height - windowSize.height) / 2);
    }
}

