/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.dataupdate;

import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateConstant;
import com.kingdee.eas.rptclient.dataupdate.DataUpdateUtil;
import com.kingdee.eas.rptclient.dataupdate.base.AbstractDataOper;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateDAO;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class TemplateData53OperImpl
extends AbstractDataOper {
    private static final Logger logger = Logger.getLogger(TemplateData53OperImpl.class);
    private List fileList = new ArrayList();
    private int fileCopyCount = 0;

    @Override
    public void writeNewData() {
        if (this.voList.isEmpty() || this.fileList.isEmpty()) {
            return;
        }
        super.writeNewData();
        if (this.getOperDataCount() > 0) {
            this.fileCopyCount = DataUpdateUtil.fileBatchCopy(this.fileList);
        }
    }

    protected File getTemplateFile(TemplateVO vo) {
        String fileName = FilenameUtils.normalize((String)(DataUpdateConstant.OLD_SHAREFILE_FOR_53 + TemplateDAO.getTemplateFileName(vo)));
        return new File(fileName);
    }

    public int getFileCopyCount() {
        return this.fileCopyCount;
    }

    @Override
    protected boolean getValueOfVoList() {
        boolean flag = false;
        int voSize = this.voList.size();
        for (int i = 0; i < voSize; ++i) {
            TemplateVO vo = (TemplateVO)this.voList.get(i);
            try {
                this.ps.setString(1, vo.getId());
                this.ps.setString(2, vo.getNumber());
                this.ps.setString(3, vo.getName());
                this.ps.setString(4, vo.getDescription());
                this.ps.setString(5, vo.getVersionNumber());
                this.ps.setInt(6, vo.getPeriodType().getValue());
                this.ps.setInt(7, vo.getDynaType());
                this.ps.setInt(8, vo.getTemplateType());
                this.ps.setInt(9, vo.getEditable());
                this.ps.setString(10, vo.getUpdateUserId());
                this.ps.setTimestamp(11, vo.getUpdateTime());
                this.ps.setInt(12, vo.getVersionStatus());
                this.ps.setString(13, vo.getCompanyNum());
                this.ps.setInt(14, vo.getIsIncludeOtherDC());
                this.ps.addBatch();
            }
            catch (SQLException e) {
                logger.error((Object)e);
                continue;
            }
            flag = true;
        }
        return flag;
    }

    @Override
    protected String getInsertNewSql() {
        return "insert into t_eas_template (FId, FNumber, FName, FDescription, FVersionNumber, FPeriodType, FDynaRpttype, FTemplateType, FIsEditable, FLastUpdateUserId, FLastUpdateTime, FVersionStatus, FCompanyNum, FIsIncludeOtherDC) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    protected String getQueryOldSql() {
        return "select FId, FNumber, FName, FDescription, FVersionNumber, FPeriodType, FDataCollect ,FDynaRpttype, FTemplateType, FIsEditable, FLastUpdateUserId, FLastUpdateTime, FVersionStatus, FCompanyNum from t_eas_template";
    }

    @Override
    protected void putValueInVoList() throws SQLException {
        TemplateVO vo = new TemplateVO();
        vo.setCompanyNum(this.rs.getString("FCompanyNum"));
        vo.setNumber(this.rs.getString("FNumber"));
        vo.setTemplateType(this.rs.getInt("FTemplateType"));
        vo.setPeriodType(RptPeriodTypeEnum.getEnum((int)this.rs.getInt("FPeriodType")));
        vo.setVersionNumber(this.rs.getString("FVersionNumber"));
        File templateFile = this.getTemplateFile(vo);
        if (!templateFile.exists()) {
            return;
        }
        vo.setId(this.rs.getString("FId"));
        vo.setName(this.rs.getString("FName"));
        vo.setDescription(this.rs.getString("FDescription"));
        vo.setIsIncludeOtherDC(this.rs.getInt("FDataCollect"));
        vo.setDynaType(this.rs.getInt("FDynaRpttype"));
        vo.setEditable(this.rs.getInt("FIsEditable"));
        vo.setUpdateUserId(this.rs.getString("FLastUpdateUserId"));
        vo.setUpdateTime(this.rs.getTimestamp("FLastUpdateTime"));
        vo.setVersionStatus(this.rs.getInt("FVersionStatus"));
        this.voList.add(vo);
        this.fileList.add(templateFile);
    }
}

