/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.k3webservice;

import com.kingdee.bos.ctrl.common.variant.SyntaxErrorException;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.util.StringUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class K3WebServiceContext {
    private Map sdsnMapping = new HashMap(3);
    private String endPoint = null;
    private String userName = null;
    private String password = null;
    private static K3WebServiceContext webServiceContext;
    private long AISID;

    private K3WebServiceContext() {
    }

    public static K3WebServiceContext getInstance() {
        if (webServiceContext == null) {
            webServiceContext = new K3WebServiceContext();
        }
        return webServiceContext;
    }

    public URL getEndPoint(String function) throws Exception {
        this.endPoint = UIConfig.getK3Ip();
        if (this.endPoint == null || this.endPoint.trim().length() < 1) {
            throw new SyntaxErrorException(0x400000L, (Object)CslRptClientResourceHelper.getString("3_K3WebServiceContext"));
        }
        return new URL("http://" + this.endPoint + function);
    }

    public URL getK3FunctionEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/K3AccFunctions.asmx");
    }

    public URL getLoginEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/K3LoginService.asmx");
    }

    public URL getAISQueryEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/Public.asmx");
    }

    public URL getCurrencyQueryEndPoint() throws Exception {
        return this.getEndPoint("/kdwebservice/Currency.asmx");
    }

    public void setEndPointURL(String endPoint) {
        this.endPoint = endPoint;
    }

    public Map getSdsnMapping() {
        return this.sdsnMapping;
    }

    public void setSdsnMapping(Map sdsnMapping) {
        this.sdsnMapping = sdsnMapping;
    }

    public String getSDSNByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return UIConfig.getK3Url();
        }
        String sdsn = (String)this.sdsnMapping.get(name);
        if (StringUtils.isEmpty((String)sdsn)) {
            return UIConfig.getK3Url();
        }
        return sdsn;
    }

    public void putSDSNByName(String name, String sdsn) {
        this.sdsnMapping.put(name, sdsn);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setAISID(long acctid) {
        this.AISID = acctid;
    }

    public long getAISID() {
        return this.AISID;
    }
}

