/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.rptclient.gr.rptclient.AbstractAddCompanyUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Arrays;

public class AddCompanyUI
extends AbstractAddCompanyUI {
    private String companyID = null;
    private String ftpID = null;

    public AddCompanyUI() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnEnter_mouseClicked(MouseEvent e) throws Exception {
        if (this.checkInput()) {
            int result = -1;
            String sql = null;
            Object[] param = null;
            boolean success = false;
            if (this.isExistCompany()) {
                result = MsgBox.showConfirm2((Component)((Object)this), this.resHelper.getString("EXISTCOMPANY"));
                if (result == 0) {
                    sql = "update T_EAS_Company set FNumber = ?, FName = ?, FIsMtnOrg = 1 where FID = ?";
                    param = new Object[]{this.txtCompanyNum.getText(), this.txtCompanyName.getText(), this.companyID};
                    DbUtil.execute(sql, param);
                    if (this.isExistFTP()) {
                        char[] pwd = this.txtPassword.getPassword();
                        sql = "update T_EAS_FTP set FServerPath=?, FUsername=?, FPassword=?, FUploadPath=?, FDownloadPath=?, FCompanyNumber=? where FID = ?";
                        param = new Object[]{this.txtServerPath.getText(), this.txtUserID.getText(), pwd.toString(), this.txtUploadPath.getText(), this.txtDownPath.getText(), this.txtCompanyNum.getText(), this.ftpID};
                        DbUtil.execute(sql, param);
                        Arrays.fill(pwd, ' ');
                        success = true;
                    } else {
                        this.insertFTP();
                        success = true;
                    }
                }
            } else {
                sql = "insert into T_EAS_Company(FId, FNumber, FName, FIsMtnOrg) values(?, ?, ?, 1)";
                param = new Object[]{Uuid.create().toString(), this.txtCompanyNum.getText(), this.txtCompanyName.getText()};
                DbUtil.execute(sql, param);
                this.insertFTP();
                success = true;
            }
            if (success) {
                MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("OPERATESUCCESS"));
                this.reset();
            }
        }
    }

    private boolean isExistCompany() throws Exception {
        String sql = "select FID from T_EAS_Company where FNumber = ?";
        IRowSet rs = DbUtil.executeQuery(sql, new Object[]{this.txtCompanyNum.getText()});
        if (rs.next()) {
            this.companyID = rs.getString("FID");
            return true;
        }
        return false;
    }

    private boolean isExistFTP() throws Exception {
        String sql = "select FID from T_EAS_FTP where FCompanyNumber = ?";
        IRowSet rs = DbUtil.executeQuery(sql, new Object[]{this.txtCompanyNum.getText()});
        if (rs.next()) {
            this.ftpID = rs.getString("FID");
            return true;
        }
        return false;
    }

    private void insertFTP() throws Exception {
        char[] pwd = this.txtPassword.getPassword();
        String sql = "insert into T_EAS_FTP values(?, ?, ?, ?, ?, ?,?,?)";
        Object[] param = new Object[]{Uuid.create().toString(), this.txtServerPath.getText(), this.txtUserID.getText(), pwd.toString(), this.txtUploadPath.getText(), this.txtDownPath.getText(), "", this.txtCompanyNum.getText()};
        DbUtil.execute(sql, param);
        Arrays.fill(pwd, ' ');
    }

    @Override
    protected void btnReset_mouseClicked(MouseEvent e) throws Exception {
        super.btnReset_mouseClicked(e);
        this.reset();
    }

    private void reset() {
        this.txtCompanyName.setText("");
        this.txtCompanyNum.setText("");
        this.txtPassword.setText("");
        this.txtRePassword.setText("");
        this.txtServerPath.setText("");
        this.txtUploadPath.setText("");
        this.txtUserID.setText("");
        this.txtDownPath.setText("");
        this.txtUploadPath.setText("");
    }

    private boolean checkInput() {
        char[] password = this.txtPassword.getPassword();
        char[] rePasswrod = this.txtRePassword.getPassword();
        if (StringUtils.isEmpty((String)this.txtCompanyName.getText())) {
            MsgBox.showInfo(this.resHelper.getString("inputCompanyName.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtCompanyNum.getText())) {
            MsgBox.showInfo(this.resHelper.getString("inputCompanyNum.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)password.toString())) {
            MsgBox.showInfo(this.resHelper.getString("inputPassword.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)rePasswrod.toString())) {
            MsgBox.showInfo(this.resHelper.getString("inputPassword.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtServerPath.getText())) {
            MsgBox.showInfo(this.resHelper.getString("inputServerPath.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtUploadPath.getText())) {
            MsgBox.showInfo(this.resHelper.getString("inputUploadPath.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtUserID.getText())) {
            MsgBox.showInfo(this.resHelper.getString("inputUserID.text"));
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtDownPath.getText())) {
            MsgBox.showInfo(this.resHelper.getString("inputDownloadPath.text"));
            return false;
        }
        if (!password.toString().equals(rePasswrod.toString())) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("PASSWORDNOTSAME"));
            this.txtPassword.setText("");
            this.txtRePassword.setText("");
            return false;
        }
        Arrays.fill(password, ' ');
        Arrays.fill(rePasswrod, ' ');
        return true;
    }

    public void destroyWindow() {
        Object owner = this.getUIContext().get("Owner");
        if (owner instanceof ListUI) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException(e);
            }
        }
    }
}

