/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.action.NotifyListener;
import com.kingdee.bos.ctrl.excel.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.rpt.RptCheckExpTank;
import com.kingdee.eas.fi.rpt.RptCheckExpression;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.rptclient.gr.rptclient.ReportVO;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslReportDataProvider;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.CslrptParamUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DataCollectUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynaItemListener;
import com.kingdee.eas.rptclient.gr.rptclient.util.DynamicTemplateUtility;
import com.kingdee.eas.rptclient.gr.rptclient.util.ReportDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.TableAfterAction;
import com.kingdee.eas.rptclient.gr.rptclient.util.TableBeforeAction;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.client.designer.IDataProvider;
import com.kingdee.eas.rptclient.newrpt.client.designer.IMenuStrategy;
import com.kingdee.eas.rptclient.newrpt.client.designer.MenuManager;
import com.kingdee.eas.rptclient.newrpt.client.designer.ReportDesigner;
import com.kingdee.eas.rptclient.newrpt.designer.BookProperties;
import com.kingdee.eas.rptclient.newrpt.designer.check.ReportCheckHelper;
import com.kingdee.eas.rptclient.newrpt.util.AdvMsgBox;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.rptclient.newrpt.util.ResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.SpreadHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.Date;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

public class CslReportDesigner
extends ReportDesigner {
    private static final long serialVersionUID = 6070158230689507189L;
    public static final String MenuName_Save = "File/saveFile";
    public static final String MenuName_Audit = "Tool/audit";
    public static final String MenuName_UnAudit = "Tool/unaudit";
    private ResourceBundleHelper resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.RPTDesignerResource");
    private String id;
    private boolean isAudited = false;

    public CslReportDesigner(String id, CoreUIObject uiObj) throws BOSException, EASBizException {
        this.id = id;
        this.initAuditStatus(id);
    }

    private void initAuditStatus(String id) throws EASBizException, BOSException {
        String sql = "select FAuditedStatus from t_eas_report where fid = ?";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{id});
        try {
            if (rowSet.next()) {
                this.isAudited = 2 == rowSet.getInt("FAuditedStatus");
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void initApplication() throws Exception {
        super.initApplication();
        this.initUITitle();
        this.disableRptCheckSchema();
        this.initListener();
        this.initMenuItem();
        this.setMenuStrategy(new ReportMenuStrategy(this.getDataProvider()));
        this.getSpreadManager().setItemFormulasetEnabled(false);
        this.getMenuStrategy().applyMenuState(this.getOperState());
        this.initSpreadStatus();
        this.initParam();
    }

    private void initParam() {
        try {
            this.getMenuManager().findMenuUsingPath("File/ImportFile").setEnabled(UIConfig.isShowImportData());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initSpreadStatus() {
        KDSpread spread = this.getSpread();
        Book book = spread.getBook();
        book.getActiveSheet().getSheetOption().setCellDisplayMode(0);
        spread.repaint();
    }

    private void initMenuItem() {
        ActionFileSave actionFileSave = new ActionFileSave();
        actionFileSave.putValue("Name", this.resHelper.getString("actionFileSave"));
        this.setAction(MenuName_Save, actionFileSave, "control S");
        JToolBar toolBar = this.getToolBar("common");
        KDWorkButton saveButton = new KDWorkButton();
        actionFileSave.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_save"));
        saveButton.setAction((Action)actionFileSave);
        saveButton.setText("");
        saveButton.setToolTipText(this.resHelper.getString("actionFileSave"));
        toolBar.add((Component)saveButton, 1);
        KDMenu menuTool = (KDMenu)this.getMenuManager().findMenuUsingPath("tool");
        ActionAudit actionAudit = new ActionAudit();
        actionAudit.putValue("Name", this.resHelper.getString("actionAudit") + "(A)");
        KDMenuItem menuItemAudit = new KDMenuItem((Action)actionAudit);
        menuItemAudit.setName("audit");
        menuItemAudit.setMnemonic('A');
        menuTool.add((JMenuItem)menuItemAudit);
        ActionUnAudit actionUnaudit = new ActionUnAudit();
        actionUnaudit.putValue("Name", this.resHelper.getString("actionUnaudit") + "(U)");
        KDMenuItem menuItemUnAudit = new KDMenuItem((Action)actionUnaudit);
        menuItemUnAudit.setName("unaudit");
        menuItemUnAudit.setMnemonic('U');
        menuTool.add((JMenuItem)menuItemUnAudit);
        KDMenu menuStyle = (KDMenu)this.getMenuManager().findMenuUsingPath("Style");
        ActionUseNewTemplate actionUseNewTemplate = new ActionUseNewTemplate();
        actionUseNewTemplate.putValue("Name", this.resHelper.getString("actionUseNewTemplate") + "(N)");
        KDMenuItem menuItemUseNewTemplate = new KDMenuItem((Action)actionUseNewTemplate);
        menuItemUseNewTemplate.setName("useNewTemplate");
        menuItemUseNewTemplate.setMnemonic('N');
        menuStyle.add((JMenuItem)menuItemUseNewTemplate);
        KDMenu menuFile = (KDMenu)this.getMenuManager().findMenuUsingPath("file");
        ActionImportData actionimptData = new ActionImportData();
        actionimptData.putValue("Name", this.resHelper.getString("importData") + "(D)");
        KDMenuItem menuImportData = new KDMenuItem((Action)actionimptData);
        menuImportData.setName("ImportData");
        menuImportData.setMnemonic('D');
        menuFile.insert((JMenuItem)menuImportData, 2);
    }

    private void disableRptCheckSchema() {
        RptCheckExpTank expTank;
        KDSpread spread;
        BookProperties properties;
        if (this.getOperState().equals("ADDNEW") && (properties = BookProperties.loadFromSpread((spread = this.getSpread()).getBook())) != null && properties.getOperationSchema() != null && (expTank = properties.getOperationSchema().getExpTank()) != null && expTank.getExpressions() != null) {
            for (RptCheckExpression exp : expTank.getExpressions()) {
                exp.setStatus(3);
                exp.setEditable(false);
                exp.setDeleteable(false);
            }
        }
    }

    private void initUITitle() {
        String title = "";
        CslReportDataProvider provider = (CslReportDataProvider)this.getDataProvider();
        title = "ADDNEW".equals(this.getOperState()) ? this.resHelper.getString("addnew") : ("EDIT".equals(this.getOperState()) ? this.resHelper.getString("edit") : this.resHelper.getString("view"));
        title.concat(this.resHelper.getString("report")).concat("--").concat(provider.getReportVO().getName());
        this.setTitle(title);
    }

    private void initListener() throws BOSException, SQLException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select r.FSourceType, t.FDynaRpttype from t_eas_report r ");
        sql.append(" inner join t_eas_template t on r.FTemplateNumber = t.FNumber");
        sql.append(" where r.FId = ?");
        IRowSet rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{this.id});
        if (rowSet.next()) {
            int sourceType = rowSet.getInt("FSourceType");
            int dynaType = rowSet.getInt("FDynaRpttype");
            if (sourceType == 10 && dynaType == 2) {
                this.getSpread().getBook().addSheetChangeListener((SheetChangeListener)new DynaItemListener());
                SpreadAction action = (SpreadAction)this.getActionManager().getAction("Insert_Row");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Insert_Row"));
                action = (SpreadAction)this.getActionManager().getAction("Insert_Col");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Insert_Col"));
                action = (SpreadAction)this.getActionManager().getAction("Insert_Cell");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Insert_Cell"));
                action = (SpreadAction)this.getActionManager().getAction("Delete_Row");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Delete_Row"));
                action = (SpreadAction)this.getActionManager().getAction("Delete_Col");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Delete_Col"));
                action = (SpreadAction)this.getActionManager().getAction("Delete_Cell");
                action.setBeforeAction((NotifyListener)new TableBeforeAction("Delete_Cell"));
                ((SpreadAction)this.getActionManager().getAction("Insert_Row")).setAfterAction((NotifyListener)new TableAfterAction("Insert_Row"));
                ((SpreadAction)this.getActionManager().getAction("Insert_Col")).setAfterAction((NotifyListener)new TableAfterAction("Insert_Col"));
            }
        }
    }

    protected void actionImportData_perform(ActionEvent e) {
        File f;
        KDFileChooser fc = new KDFileChooser();
        fc.addChoosableFileFilter((FileFilter)new SimpleFileFilter("xls", ResourceHelper.getMenuResource("MenuManager.136")));
        fc.setMultiSelectionEnabled(false);
        int openResult = fc.showOpenDialog((Component)((Object)this));
        if (openResult == 0 && (f = fc.getSelectedFile()).exists() && f.canRead()) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("EXPORT_FORMULA", "false");
            KDSBook book = POIXlsReader.parse((String)f.getAbsolutePath(), hm);
            if (book == null) {
                MsgBox.showWarning(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"badFileError"));
                SysUtil.abort();
            }
            KDSSheet ks = null;
            Book spread = this.getSpread().getBook();
            StringBuffer failingSheet = new StringBuffer();
            int size = book.getSheetCount();
            for (int i = 0; i < size; ++i) {
                ks = book.getSheet((Object)new Integer(i));
                Sheet sheet = spread.getSheet(ks.getName());
                if (sheet == null) {
                    if (failingSheet.length() > 1) {
                        failingSheet.append(',');
                    }
                    failingSheet.append(ks.getName());
                    continue;
                }
                CslRptUIUtil.copyData((KDSSheet)ks, (Sheet)sheet, (int)1, (boolean)false);
            }
            this.repaint();
            if (failingSheet.length() > 1) {
                MsgBox.showWarning(CslRptClientResourceHelper.getString("5_CslReportDesigner") + failingSheet.toString());
            }
        }
    }

    private void setAction(String actionName, AbstractAction action, String keystrok) {
        KDMenuItem menuItem = (KDMenuItem)this.getMenuManager().findMenuUsingPath(actionName);
        menuItem.setAction((Action)action);
        if (!StringUtils.isEmpty((String)keystrok)) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(keystrok));
        }
    }

    public void actionFileSave_actionPerform(ActionEvent e) {
        Variant.nullVariant.setObject(null);
        this.verify();
        this.save();
        super.actionFileSave_actionPerform(e);
        MsgBox.showInfo((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
    }

    private void save() {
        CslReportDataProvider provider = (CslReportDataProvider)this.getDataProvider();
        try {
            DataCollectUtil.clearCellFormulaByDataCollect(this.getSpread().getBook());
            provider.saveBook(this.getSpread().getBook());
            byte[] data = provider.getKDF();
            if (data != null) {
                StringBuffer sql = new StringBuffer();
                sql.append("update t_eas_report set FLastUpdateUserID = ?, ");
                sql.append(" FLastUpdateTime = ? ");
                sql.append(" where FId = ?");
                Date d = new Date(new java.util.Date().getTime());
                DbUtil.execute(sql.toString(), new Object[]{UIConfig.getLoginUser(), d, this.id});
                ReportDAO.saveData(provider.getReportVO());
            }
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
            return;
        }
    }

    public void actionAudit_actionPerform(ActionEvent e) {
        if (!OprtState.VIEW.equals(this.getOperState())) {
            this.save();
        }
        if (!DynamicTemplateUtility.checkItem(this.getSpread().getBook())) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("ItemFormulaDup"));
            return;
        }
        KDSpread spread = this.getSpread();
        RptCheckExpTank expTank = BookProperties.loadFromSpread(spread.getBook()).getOperationSchema().getExpTank();
        StringBuffer msg = new StringBuffer();
        try {
            Book book = SpreadHelper.copySpread(spread).getBook();
            Map result = ReportCheckHelper.checkReportResult(book, this.getDataProvider(), expTank, LocaleUtils.getDefaultLocale());
            Boolean isCheckedPass = (Boolean)result.get("isCheckPass");
            if (result.get("checkResult") != null) {
                msg.append(result.get("checkResult"));
            }
            if (!isCheckedPass.booleanValue()) {
                this.createAdvMsgBox(EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource", (String)"ReportAudit_fail"), EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource", (String)"ReportAudit_fail"), msg.toString(), 1, 8188).show();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)spread, (Throwable)ex);
            return;
        }
        try {
            String loginUserId;
            CslReportDataProvider provider;
            String creatorId;
            String value = CslrptParamUtil.getParamValueByNumber("Is_Cslrpt_Creator_Auditor_Same");
            if (CslrptParamUtil.isTrue(value) && (creatorId = (provider = (CslReportDataProvider)this.getDataProvider()).getReportVO().getCreatorID()).equals(loginUserId = UIConfig.getLoginUser())) {
                this.createAdvMsgBox(EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource", (String)"ReportAudit_fail"), EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource", (String)"ReportAudit_fail"), CslRptClientResourceHelper.getString("188_clientRptParam"), 1, 8188).show();
                return;
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)spread, (Throwable)ex);
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("update t_eas_report set FAuditedStatus = 2, ");
        sql.append("FAuditorID = ?, FAuditedTime = ?");
        sql.append(" where fid = ?");
        try {
            Date d = new Date(new java.util.Date().getTime());
            DbUtil.execute(sql.toString(), new Object[]{UIConfig.getLoginUser(), d, this.id});
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            return;
        }
        this.isAudited = true;
        this.setOperState("VIEW");
        this.createAdvMsgBox(this.resHelper.getString("HasAudited"), this.resHelper.getString("HasAudited"), msg.toString(), 1, 8188).show();
        this.getMenuStrategy().applyMenuState(this.getOperState());
    }

    private boolean canAuditOrUnaudit() {
        try {
            String value = CslrptParamUtil.getParamValueByNumber("Is_Cslrpt_Creator_Auditor_Same");
            boolean isValueTrue = CslrptParamUtil.isTrue(value);
            ReportVO reportVO = ReportDAO.getReportVO(this.id);
            String loginUserId = UIConfig.getLoginUser();
            String createRptId = reportVO.getCreatorID();
            if (isValueTrue && createRptId.equals(loginUserId)) {
                this.createAdvMsgBox(EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource", (String)"ReportAudit_fail"), EASResource.getString((String)"com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource", (String)"ReportAudit_fail"), CslRptClientResourceHelper.getString("188_clientRptParam"), 1, 8188).show();
                return false;
            }
        }
        catch (Exception ex) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex);
            return false;
        }
        return true;
    }

    public void actionUnAudit_actionPerform(ActionEvent e) {
        if (!this.canAuditOrUnaudit()) {
            return;
        }
        try {
            StringBuffer oql = new StringBuffer();
            oql.append("update t_eas_report set FAuditedStatus = 1, ");
            oql.append("FAuditorID = null, ");
            oql.append(" FAuditedTime = null");
            oql.append(" where fid = ?");
            DbUtil.execute(oql.toString(), new Object[]{this.id});
        }
        catch (Exception exc) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)exc);
            return;
        }
        this.isAudited = false;
        this.setOperState("EDIT");
        MsgBox.showInfo(this.resHelper.getString("HasUnAudited"));
        this.getMenuStrategy().applyMenuState(this.getOperState());
    }

    public void actionUseNewTemplate_actionPerform(ActionEvent e) {
        CslReportDataProvider dataProvider = (CslReportDataProvider)this.getDataProvider();
        String templateNumber = dataProvider.getReportVO().getTemplateNumber();
        String sql = "select FId from t_eas_template where FNumber = ?".concat("and FId <> ? order by FVersionNumber desc");
        try {
            IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{templateNumber, dataProvider.getReportVO().getTemplateId()});
            if (rowSet.next()) {
                String newId = rowSet.getString("FId");
                TemplateVO tvo = TemplateDAO.getTemplateVO(newId);
                byte[] data = tvo.getData();
                Book book = IOHelper.unpackBook((byte[])data);
                KDSpread nowSpread = this.getSpread();
                for (int i = 0; i < book.getSheetCount(); ++i) {
                    Sheet sheet = book.getSheet(i);
                    Sheet nowSheet = nowSpread.getBook().getSheet(sheet.getSheetName());
                    if (nowSheet == null) continue;
                    nowSheet.copyStyleFrom(sheet);
                }
                nowSpread.repaint();
            }
        }
        catch (Exception e1) {
            MsgBox.showInfo((Component)((Object)this), e1.getMessage());
        }
    }

    private void verify() {
        String mgs = CslRptClientResourceHelper.getString("6_CslReportDesigner");
        String checkItemResult = DynamicTemplateUtility.checkNumber(this.getSpread().getBook());
        if (checkItemResult != null) {
            MsgBox.showDetailAndOK((Window)((Object)this), mgs, checkItemResult, -1);
            SysUtil.abort();
        }
    }

    private AdvMsgBox createAdvMsgBox(String title, String msg, String detail, int msgType, int option) {
        AdvMsgBox box = AdvMsgBox.createAdvMsgBox((Component)this.getSpread(), title, msg, detail, msgType, option);
        return box;
    }

    private void changeCompanyFillStatus() {
        if (((CslReportDataProvider)this.getDataProvider()).getReportVO().getSourceType() != 1) {
            return;
        }
        this.getMenuManager().findMenuUsingPath("Tool/CompanyFill").setVisible(false);
        try {
            Book book = this.getSpread().getBook();
            BookProperties bookPro = BookProperties.loadFromSpread(book);
            for (int i = 0; i < book.getSheetCount(); ++i) {
                Sheet sheet = book.getSheet(i);
                VariableEntry entry = bookPro.getVariables().get("SheetClass", sheet.getSheetName());
                CSLReportGroupEnum groupEnum = CSLReportGroupEnum.getEnum((int)Integer.parseInt(entry.getValue()));
                if (groupEnum.equals((Object)CSLReportGroupEnum.COMMON)) continue;
                this.getMenuManager().findMenuUsingPath("Tool/CompanyFill").setVisible(true);
                break;
            }
        }
        catch (Exception e) {
            this.getMenuManager().findMenuUsingPath("Tool/CompanyFill").setVisible(true);
        }
    }

    class ActionFileSave
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ActionFileSave() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionFileSave_actionPerform(e);
        }
    }

    class ActionAudit
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ActionAudit() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionAudit_actionPerform(e);
        }
    }

    class ActionUseNewTemplate
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ActionUseNewTemplate() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionUseNewTemplate_actionPerform(e);
        }
    }

    class ActionUnAudit
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ActionUnAudit() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionUnAudit_actionPerform(e);
        }
    }

    class ActionImportData
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        ActionImportData() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CslReportDesigner.this.actionImportData_perform(e);
        }
    }

    protected class ReportMenuStrategy
    implements IMenuStrategy {
        private IDataProvider data = null;

        public ReportMenuStrategy(IDataProvider data) {
            this.data = data;
        }

        public void applyMenuState(String state) {
            if (state.equals("ADDNEW")) {
                this.setAddNew();
            } else if (state.equals("EDIT")) {
                this.setEdit();
            } else if (state.equals("VIEW")) {
                this.setView();
            }
        }

        private void setAddNew() {
            this.setEdit();
        }

        private void setView() {
            MenuManager m = CslReportDesigner.this.getMenuManager();
            m.findMenuUsingPath("File/addnew").setVisible(false);
            KDMenuItem save = (KDMenuItem)m.findMenuUsingPath(CslReportDesigner.MenuName_Save);
            save.setVisible(false);
            save.getAction().setEnabled(false);
            m.findMenuUsingPath("File/saveAs").setVisible(false);
            m.findMenuUsingPath("Style/useNewTemplate").setVisible(false);
            m.findMenuUsingPath("View/menuFormulaState").setVisible(false);
            m.findMenuUsingPath("View/menuFormulaState").setEnabled(false);
            if (CslReportDesigner.this.isAudited) {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(false);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(true);
            } else {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(true);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(false);
            }
            this.initDynaMenuState(m);
        }

        private void setEdit() {
            MenuManager m = CslReportDesigner.this.getMenuManager();
            m.findMenuUsingPath("File/addnew").setVisible(false);
            m.findMenuUsingPath("File/saveAs").setVisible(false);
            KDMenuItem save = (KDMenuItem)m.findMenuUsingPath(CslReportDesigner.MenuName_Save);
            m.findMenuUsingPath("Style/useNewTemplate").setVisible(true);
            m.findMenuUsingPath("View/menuFormulaState").setVisible(false);
            m.findMenuUsingPath("View/menuFormulaState").setEnabled(false);
            if (CslReportDesigner.this.isAudited) {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(false);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(true);
                save.setVisible(false);
                save.getAction().setEnabled(false);
            } else {
                m.findMenuUsingPath(CslReportDesigner.MenuName_Audit).setVisible(true);
                m.findMenuUsingPath(CslReportDesigner.MenuName_UnAudit).setVisible(false);
                save.setVisible(true);
                save.getAction().setEnabled(true);
            }
            this.initDynaMenuState(m);
            CslReportDesigner.this.changeCompanyFillStatus();
        }

        private void initDynaMenuState(MenuManager m) {
            int sourceType = ((CslReportDataProvider)this.data).getReportVO().getSourceType();
            if (sourceType == 10 || sourceType == 11 || sourceType == 12) {
                m.findMenuUsingPath("View/Dyna_Range").setVisible(true);
                m.findMenuUsingPath("View/Dyna_Range").setEnabled(true);
            } else {
                m.findMenuUsingPath("View/Dyna_Range").setVisible(false);
            }
        }
    }
}

