/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.rptclient.base.AbstractPanel;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.FTPUpDown;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.SysUtil;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;

public class DownFilePathSetUI
extends AbstractPanel {
    protected KDLabel lblPathDesc1;
    protected KDTextField txtFilePath;
    protected KDButton btnOk;
    protected KDButton btnCancel;
    protected KDWorkButton btnChooseFile;
    private boolean isCancel = true;
    private FTPUpDown ftpUpDown;
    private String ftpPath;

    public DownFilePathSetUI() throws Exception {
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setUITitle(CommonUtil.getResource("title_confirmDownFile"));
        this.lblPathDesc1 = new KDLabel();
        this.txtFilePath = new KDTextField();
        this.lblPathDesc1.setName("lblPathDesc1");
        this.lblPathDesc1.setText(CommonUtil.getResource("plsChooseFilePath"));
        this.txtFilePath.setName("txtFilePath");
        this.txtFilePath.setEditable(false);
        this.btnOk = new KDButton();
        this.btnCancel = new KDButton();
        this.btnChooseFile = new KDWorkButton();
        this.btnOk.setName("btnOk");
        this.btnCancel.setName("btnCancel");
        this.btnChooseFile.setName("btnChooseFile");
        this.btnOk.setText(CommonUtil.getResource("common_ok"));
        this.btnCancel.setText(CommonUtil.getResource("common_cancel"));
        this.btnChooseFile.setText("...");
        this.initListeners();
    }

    protected void initListeners() {
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownFilePathSetUI.this.down();
                DownFilePathSetUI.this.isCancel = false;
                DownFilePathSetUI.this.disposeUIWindow();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownFilePathSetUI.this.disposeUIWindow();
            }
        });
        this.btnChooseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DownFilePathSetUI.this.chooseFoler();
            }
        });
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 400, 120));
        this.setLayout(null);
        int x = 10;
        int y = 10;
        int width = this.getWidth() - 20;
        int height = 19;
        this.lblPathDesc1.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.lblPathDesc1, null);
        y = y + 19 + 5;
        width = this.getWidth() - 20 - 19;
        this.txtFilePath.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.txtFilePath, null);
        x = 10 + this.txtFilePath.getWidth();
        width = 19;
        height = 19;
        this.btnChooseFile.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.btnChooseFile, null);
        y = y + 19 + 35;
        x = this.getWidth() - 161;
        width = 73;
        height = 21;
        this.btnOk.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.btnOk, null);
        x = this.getWidth() - 83;
        this.btnCancel.setBounds(new Rectangle(x, y, width, height));
        this.add((Component)this.btnCancel, null);
    }

    public void setFTPUpDown(FTPUpDown ftpUpDown, String ftpPath) {
        this.ftpUpDown = ftpUpDown;
        this.ftpPath = ftpPath;
    }

    public String getFilePath() {
        return this.txtFilePath.getText();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private void down() {
        File file = new File(this.txtFilePath.getText());
        if (!file.isAbsolute()) {
            MsgBox.showInfo((Component)((Object)this), CommonUtil.getResource("invalidFilePath"));
            this.txtFilePath.requestFocus();
            SysUtil.abort();
        }
        try {
            this.lblPathDesc1.setText(CslRptClientResourceHelper.getString("8_DownFilePathSetUI"));
            this.repaint();
            this.ftpUpDown.resetPath();
            this.ftpUpDown.downFolder(this.ftpPath, this.txtFilePath.getText());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), e.getMessage());
        }
    }

    protected void chooseFoler() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(CslRptClientResourceHelper.getString("9_DownFilePathSetUI"));
        chooser.setApproveButtonText(CslRptClientResourceHelper.getString("10_DownFilePathSetUI"));
        int returnVal = chooser.showSaveDialog((Component)((Object)this));
        if (returnVal == 0) {
            File selectFile = chooser.getSelectedFile();
            if (!selectFile.exists()) {
                MsgBox.showError((Component)((Object)this), CslRptClientResourceHelper.getString("11_DownFilePathSetUI"));
            }
            String path = selectFile.getAbsolutePath();
            this.txtFilePath.setText(path);
        }
    }
}

