/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.fi.gr.cslrpt.OrderByEnum;
import com.kingdee.eas.fi.gr.dynamic.DynaItemTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.AbstractDynaRangeUI;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynaRangeUI
extends AbstractDynaRangeUI {
    private static final Logger logger = CoreUIObject.getLogger(DynaRangeUI.class);

    public static DynaRangeUI getInstance(Component parent, Map ctx) {
        try {
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            DynaRangeUI ui = (DynaRangeUI)fy.create(parent, DynaRangeUI.class.getName(), ctx);
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return null;
        }
    }

    public void onLoad(Map map) throws Exception {
        this.setResult((HashMap)map);
        this.initWorkButton();
    }

    private void setResult(HashMap map) throws Exception {
        String s;
        Point basePoint = null;
        Point dynaRangeRow = null;
        Point dynaRangeCol = null;
        boolean isGrade = true;
        Point sumItemRow = null;
        Point sumItemCol = null;
        String dynaSource = null;
        String orderBy = null;
        String orderRow = null;
        int orderCol = -1;
        if (map.get("basePoint") != null) {
            basePoint = (Point)map.get("basePoint");
        }
        if (map.get("dynaRangeRow") != null) {
            dynaRangeRow = (Point)map.get("dynaRangeRow");
        }
        if (map.get("dynaRangeCol") != null) {
            dynaRangeCol = (Point)map.get("dynaRangeCol");
        }
        if (map.get("isGrade") != null) {
            isGrade = (Boolean)map.get("isGrade");
        }
        if (map.get("sumItemRow") != null) {
            sumItemRow = (Point)map.get("sumItemRow");
        }
        if (map.get("sumItemCol") != null) {
            sumItemCol = (Point)map.get("sumItemCol");
        }
        if (map.get("dynaSource") != null) {
            dynaSource = ((DynaItemTypeEnum)map.get("dynaSource")).getAlias();
        }
        if (basePoint != null) {
            if (dynaRangeRow != null) {
                s = TableToolkit.xy2range((int)basePoint.x, (int)basePoint.y) + ":" + TableToolkit.xy2range((int)dynaRangeRow.y, (int)dynaRangeRow.x);
                this.txtDynaRange.setText(s);
            } else if (dynaRangeCol != null) {
                s = TableToolkit.xy2range((int)basePoint.x, (int)basePoint.y) + ":" + TableToolkit.xy2range((int)dynaRangeCol.y, (int)dynaRangeCol.x);
                this.txtDynaRange.setText(s);
            }
        }
        if (dynaSource != null && !"".equals(dynaSource)) {
            this.txtDynaSource.setText(dynaSource);
        }
        if (isGrade) {
            this.txtGradeSum.setText("\u662f");
        } else {
            this.txtGradeSum.setText("\u5426");
        }
        if (map.get("isHaveSumItem") != null) {
            if (sumItemRow != null) {
                s = sumItemRow.x + 1 + "\u884c";
                this.txtSumRow.setText(s);
            } else if (sumItemCol != null) {
                s = this.getCellName(0, sumItemCol.y) + "\u5217";
                this.txtSumRow.setText(s);
            }
        } else {
            this.txtSumRow.setText(CslRptClientResourceHelper.getString("13_DynaRangeUI"));
        }
        if ((OrderByEnum)map.get("orderBy") == OrderByEnum.NONE) {
            orderBy = OrderByEnum.NONE.getAlias();
            this.txtSort.setText(orderBy);
        } else {
            orderBy = ((OrderByEnum)map.get("orderBy")).getAlias();
            if (map.get("orderRow") != null) {
                orderRow = (String)map.get("orderRow");
                s = "\u6309" + orderRow.charAt(0) + "\u5217" + orderBy;
                this.txtSort.setText(s);
            }
            if (map.get("orderCol") != null) {
                orderCol = (Integer)map.get("orderCol");
                s = "\u6309" + orderCol + "\u884c" + orderBy;
                this.txtSort.setText(s);
            }
        }
    }

    public String getCellName(int rowIndex, int colIndex) {
        if (rowIndex < 0 || colIndex < 0) {
            return null;
        }
        int[] series = DynaRangeUI.getBaseSeries(colIndex, 26);
        StringBuffer colName = new StringBuffer();
        int n = series.length;
        for (int i = 0; i < n; ++i) {
            if (i == 0 && n > 1) {
                colName.append((char)(64 + series[i]));
                continue;
            }
            colName.append((char)(65 + series[i]));
        }
        return colName.toString();
    }

    public static int[] getBaseSeries(int number, int base) {
        if (number < 0 || base < 1) {
            return new int[0];
        }
        int n = number;
        ArrayList<Integer> result = new ArrayList<Integer>();
        do {
            result.add(0, new Integer(n - n / base * base));
        } while ((n /= base) > 0);
        int[] ret = new int[result.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (Integer)result.get(i);
        }
        return ret;
    }

    @Override
    public void actionClose_actionPerformed(ActionEvent e) throws Exception {
        super.actionClose_actionPerformed(e);
        this.disposeUIWindow();
    }

    protected void initWorkButton() {
        this.txtDynaRange.setEnabled(false);
        this.txtDynaSource.setEnabled(false);
        this.txtGradeSum.setEnabled(false);
        this.txtSumRow.setEnabled(false);
        this.txtSort.setEnabled(false);
        this.btnClose.setEnabled(true);
    }
}

