/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptResourceHelper;
import com.kingdee.eas.rptclient.base.IUIFactory;
import com.kingdee.eas.rptclient.base.UIFactory;
import com.kingdee.eas.rptclient.gr.rptclient.CompanyVO;
import com.kingdee.eas.rptclient.gr.rptclient.ImportCompanyUI;
import com.kingdee.eas.rptclient.gr.rptclient.resource.CslRptClientResourceHelper;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.newrpt.client.designer.BaseCompanyListUI;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MaintionCompanyUI
extends BaseCompanyListUI {
    private KDWorkButton btnImport;
    private KDWorkButton btnRemove;

    public MaintionCompanyUI() throws Exception {
        this.jbinit2();
        this.setUITitle(CslRptClientResourceHelper.getString("34_MaintionCompanyUI"));
    }

    private void jbinit2() {
        this.btnExit.setVisible(false);
        this.btnExit.setEnabled(false);
        this.remove((Component)this.btnExit);
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.btnImport = new KDWorkButton();
        this.btnImport.setName("btnImport");
        this.btnImport.setText(this.resHelper.getString("importCompany"));
        this.btnImport.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    MaintionCompanyUI.this.btnImport_mouserClicked(e);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex.getMessage(), (Throwable)ex);
                }
            }
        });
        this.btnRemove = new KDWorkButton();
        this.btnRemove.setName("btnRemove");
        this.btnRemove.setText(CslRptClientResourceHelper.getString("28_ImportCompanyUI"));
        this.btnRemove.setIcon(RptResourceHelper.getIcon((String)"imgTbtn_delete"));
        this.btnRemove.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    MaintionCompanyUI.this.btnRemove_mouseClick(e);
                }
                catch (Exception ex) {
                    ExceptionHandler.handle(ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.setBounds(new Rectangle(10, 10, 580, 480));
        this.setLayout((LayoutManager)new KDLayout());
        this.btnImport.setBounds(new Rectangle(470, 16, 81, 19));
        this.btnRemove.setBounds(new Rectangle(243, 16, 63, 19));
        this.add((Component)this.btnRemove, new KDLayout.Constraints(243, 16, 63, 19, 0));
    }

    public void initChoise() {
        super.initChoise();
    }

    public void setUIContext2(Map map) {
        this.setUIContext(map);
    }

    public static BaseCompanyListUI getInstance(Component parent, Map ctx) {
        try {
            IUIFactory fy = UIFactory.createUIFactory("com.kingdee.eas.rptclient.base.ModelDialogFactory");
            MaintionCompanyUI ui = (MaintionCompanyUI)((Object)fy.create(parent, MaintionCompanyUI.class.getName(), ctx));
            return ui;
        }
        catch (Exception e) {
            ExceptionHandler.handle(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void importCompany(Set set) throws Exception {
        if (set == null || set.isEmpty()) {
            return;
        }
        Timestamp time = new Timestamp(new Date().getTime());
        Connection conn = DbUtil.getConnection();
        String sql = "INSERT INTO T_EAS_EditCompany VALUES(?, ?, ?, ?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        for (CompanyVO cvo : set) {
            ps.setString(1, cvo.getFid());
            ps.setString(2, cvo.getFnumber());
            ps.setString(3, cvo.getFname());
            ps.setTimestamp(4, time);
            ps.addBatch();
        }
        int[] count = ps.executeBatch();
        if (count.length > 0) {
            MsgBox.showInfo((Component)((Object)this), this.resHelper.getString("importCount.text") + " " + count.length);
        }
    }

    public void initCompany() throws BOSException, SQLException, EASBizException {
        String sql = "select FID, Fnumber, Fname, FIsMtnOrg from T_EAS_Company order by fnumber";
        IRowSet rs = DbUtil.executeQuery(sql);
        while (rs.next()) {
            String fId = rs.getString("FID");
            String fNumber = rs.getString("Fnumber");
            String fName = rs.getString("Fname");
            boolean isMtnOrg = rs.getBoolean("FIsMtnOrg");
            IRow row = this.table.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("id").setValue((Object)fId);
            row.getCell("number").setValue((Object)fNumber);
            row.getCell("name").setValue((Object)fName);
            row.getCell("mtnOrg").setValue((Object)new Boolean(isMtnOrg));
        }
    }

    public void actionClear_actionPerformed(ActionEvent e) throws Exception {
        super.actionClear_actionPerformed(e);
    }

    public void actionOk_actionPerformed(ActionEvent e) throws Exception {
        String sql = "update t_eas_company set FIsMtnOrg = ? where fid = ? and fnumber = ?";
        Connection conn = DbUtil.getConnection();
        PreparedStatement ps = conn.prepareStatement(sql);
        String id = null;
        String number = null;
        int mtnOrg = 0;
        int count = this.table.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.table.getRow(i);
            mtnOrg = (Boolean)row.getCell("mtnOrg").getValue() != false ? 1 : 0;
            id = row.getCell("id").getValue().toString();
            number = row.getCell("number").getValue().toString();
            ps.setInt(1, mtnOrg);
            ps.setString(2, id);
            ps.setString(3, number);
            ps.addBatch();
        }
        ps.executeBatch();
        ps.clearBatch();
        ps.close();
        conn.close();
        this.disposeUIWindow();
    }

    protected void btnImport_mouserClicked(MouseEvent e) throws Exception {
        ImportCompanyUI window = ImportCompanyUI.getDefaultInstance((Component)((Object)this), null);
        if (window == null) {
            return;
        }
        HashMap<Object, Object> existCompanies = new HashMap<Object, Object>();
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            existCompanies.put(this.table.getCell(i, "id").getValue(), this.table.getCell(i, "number").getValue());
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"existCompanies", existCompanies);
        window.setUIContext2((Map)uiContext);
        window.showWindow();
        Set importSet = window.getImportCompanySet();
        this.importCompany(importSet);
        super.initCompany();
    }

    private void btnRemove_mouseClick(MouseEvent e) throws Exception {
        if (this.table.getRowCount() == 0) {
            return;
        }
        int result = MsgBox.showConfirm2((Component)((Object)this), this.resHelper.getString("ISDELETE"));
        if (result != 0) {
            return;
        }
        List list = this.orgDispense();
        Connection conn = DbUtil.getConnection();
        Statement st = conn.createStatement();
        String strDel = "DELETE FROM T_EAS_Company WHERE FIsMtnOrg = 0 AND FId = ";
        StringBuffer sbId = new StringBuffer();
        StringBuffer sbNumber = new StringBuffer();
        boolean flag = false;
        int count = this.table.getRowCount();
        for (int i = 0; i < count; ++i) {
            Boolean isSelect = (Boolean)this.table.getCell(i, "select").getValue();
            String orgNumber = (String)this.table.getCell(i, "number").getValue();
            if (!isSelect.booleanValue() || list.contains(orgNumber)) continue;
            sbId.append("'").append(this.table.getCell(i, "id").getValue()).append("'");
            sbNumber.append(" AND FNumber = ");
            sbNumber.append("'").append(orgNumber).append("'");
            st.addBatch(strDel.concat(sbId.toString()).concat(sbNumber.toString()));
            sbId.setLength(0);
            sbNumber.setLength(0);
            flag = true;
        }
        if (flag) {
            st.executeBatch();
            st.clearBatch();
        }
        this.table.removeRows();
        this.initCompany();
        SQLUtils.cleanup((Statement)st, (Connection)conn);
    }

    public void initTable() {
        this.table.checkParsed();
        IColumn col = this.table.addColumn();
        col.setKey("mtnOrg");
        this.table.removeHeadRows();
        IRow headRow = this.table.addHeadRow();
        headRow.getCell(0).setValue((Object)EASResource.getString((String)this.location, (String)"K3_Choose"));
        headRow.getCell(1).setValue((Object)"id");
        headRow.getCell(2).setValue((Object)this.number);
        headRow.getCell(3).setValue((Object)this.name);
        headRow.getCell(4).setValue((Object)CslRptClientResourceHelper.getString("166_isMtnOrg"));
        this.table.getColumn(0).setWidth(51);
        this.table.getColumn(1).setWidth(0);
        this.table.getColumn(2).setWidth(110);
        this.table.getColumn(2).getStyleAttributes().setLocked(true);
        this.table.getColumn(3).setWidth(240);
        this.table.getColumn(3).getStyleAttributes().setLocked(true);
        this.table.getColumn(4).setWidth(90);
    }

    private List orgDispense() throws EASBizException, BOSException, SQLException {
        String sql = "select distinct fcompanynumber from t_eas_user_company";
        IRowSet rowSet = DbUtil.executeQuery(sql);
        ArrayList<String> list = new ArrayList<String>();
        while (rowSet.next()) {
            list.add(rowSet.getString("fcompanynumber"));
        }
        return list;
    }
}

