/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.rptclient.gr.rptclient;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectConstant;
import com.kingdee.eas.fi.gr.cslrpt.DataCollectInfo;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.GroupRptProcessUI;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.report.util.KDTableHeaderModel;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.rptclient.gr.rptclient.ReportListUI;
import com.kingdee.eas.rptclient.gr.rptclient.TemplateVO;
import com.kingdee.eas.rptclient.gr.rptclient.frame.CslEditUI;
import com.kingdee.eas.rptclient.gr.rptclient.util.DataCollectUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.DbUtil;
import com.kingdee.eas.rptclient.gr.rptclient.util.ReportDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.TemplateDAO;
import com.kingdee.eas.rptclient.gr.rptclient.util.UIConfig;
import com.kingdee.eas.rptclient.newrpt.util.CommonUtil;
import com.kingdee.eas.rptclient.newrpt.util.ExceptionHandler;
import com.kingdee.eas.rptclient.newrpt.util.MsgBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.EnumUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ReportEditUI
extends CslEditUI {
    IUIWindow reportUI = null;
    private boolean isLock = false;
    FilterInfo currentFilter = null;
    protected KDLabelContainer contYear;
    protected KDLabelContainer contPeriodType;
    protected KDComboBox comboPeriodType;
    protected KDLabelContainer contCurrency;
    protected KDComboBox comboYear;
    protected KDComboBox comboCurrency;
    protected KDComboBox comboPeriod;
    protected KDLabel lblYear;
    protected KDLabel lblPeriod;
    protected KDTable tblMain;
    protected KDLabelContainer contRptDate;
    protected KDDatePicker datePickerRptDate;
    protected KDLabelContainer contDataCollect;
    protected KDComboBox cboDataCollect;

    public ReportEditUI() throws Exception {
        this.jbInit();
        this.initUIP();
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper("com.kingdee.eas.rptclient.gr.rptclient.resource.CslClientUIResource");
        this.setUITitle(this.resHelper.getString("ReportEditUI.title"));
        this.contDataCollect = new KDLabelContainer();
        this.cboDataCollect = new KDComboBox();
        this.contYear = new KDLabelContainer();
        this.contPeriodType = new KDLabelContainer();
        this.comboPeriodType = new KDComboBox();
        this.contCurrency = new KDLabelContainer();
        this.comboYear = new KDComboBox();
        this.comboCurrency = new KDComboBox();
        this.comboPeriod = new KDComboBox();
        this.lblYear = new KDLabel();
        this.lblPeriod = new KDLabel();
        this.tblMain = new KDTable();
        this.contRptDate = new KDLabelContainer();
        this.datePickerRptDate = new KDDatePicker();
        this.contDataCollect.setName("contdataCollect");
        this.cboDataCollect.setName("cboDataCollect");
        this.contYear.setName("contYear");
        this.contPeriodType.setName("contPeriodType");
        this.comboPeriodType.setName("comboPeriodType");
        this.contCurrency.setName("contCurrency");
        this.comboYear.setName("comboYear");
        this.comboCurrency.setName("comboCurrency");
        this.comboPeriod.setName("comboPeriod");
        this.lblYear.setName("lblYear");
        this.lblPeriod.setName("lblPeriod");
        this.tblMain.setName("tblMain");
        this.contRptDate.setName("contRptDate");
        this.datePickerRptDate.setName("datePickerRptDate");
        this.cboDataCollect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ReportEditUI.this.cboDataCollect_actionPerformed(e);
                }
                catch (Exception ex) {
                    ReportEditUI.this.handUIException(ex);
                }
            }
        });
        this.contYear.setBoundLabelText(this.resHelper.getString("ReportEditUI.contYear"));
        this.contYear.setBoundLabelLength(80);
        this.contYear.setBoundLabelUnderline(true);
        this.contPeriodType.setBoundLabelText(this.resHelper.getString("ReportEditUI.contPeriodType"));
        this.contPeriodType.setBoundLabelLength(80);
        this.contPeriodType.setBoundLabelUnderline(true);
        this.comboPeriodType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.fi.rpt.RptPeriodTypeEnum").toArray());
        this.comboPeriodType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReportEditUI.this.beforeActionPerformed(e);
                try {
                    ReportEditUI.this.comboPeriodType_actionPerformed(e);
                }
                catch (Exception exc) {
                    ReportEditUI.this.handUIException(exc);
                }
                finally {
                    ReportEditUI.this.afterActionPerformed(e);
                }
            }
        });
        this.contCurrency.setBoundLabelText(this.resHelper.getString("ReportEditUI.contCurrency"));
        this.contCurrency.setBoundLabelLength(60);
        this.contCurrency.setBoundLabelUnderline(true);
        this.contDataCollect.setBoundLabelText(this.resHelper.getString("dataCollect"));
        this.contDataCollect.setBoundLabelLength(80);
        this.contDataCollect.setBoundLabelUnderline(true);
        this.lblYear.setText(this.resHelper.getString("ReportEditUI.lblYear"));
        this.lblPeriod.setText(this.resHelper.getString("ReportEditUI.lblPeriod"));
        KDTableHeaderModel tableHeader = this.createHeader();
        KDTableUtil.setHeader((KDTableHeaderModel)tableHeader, (KDTable)this.tblMain);
        String[] keys = new String[]{"id", "templateNumber", "templateName", "periodType", "versionNumber", "isIncludeOtherDC"};
        for (int i = 0; i < 6; ++i) {
            this.tblMain.getColumn(i).setKey(keys[i]);
        }
        this.tblMain.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    ReportEditUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    ReportEditUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTDataRequestListener(new KDTDataRequestListener(){

            public void tableDataRequest(KDTDataRequestEvent e) {
                ReportEditUI.this.tblMain_tableDataRequest(e);
            }
        });
        this.contRptDate.setBoundLabelText(this.resHelper.getString("ReportEditUI.contRptDate"));
        this.contRptDate.setBoundLabelUnderline(true);
        this.contRptDate.setBoundLabelLength(60);
        this.datePickerRptDate.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                try {
                    ReportEditUI.this.datePickerRptDate_dataChanged(e);
                }
                catch (Exception exc) {
                    ReportEditUI.this.handUIException(exc);
                }
            }
        });
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                ReportEditUI.this.tblSelectChanged_actionPerformed(e);
            }
        });
    }

    private KDTableHeaderModel createHeader() {
        int size = 6;
        String[][] hd = new String[1][size];
        int[] align = new int[size];
        int[] width = new int[size];
        String[] format = new String[size];
        hd[0][0] = "id";
        align[0] = 0;
        width[0] = 0;
        format[0] = "";
        hd[0][1] = this.resHelper.getString("TEMPLATENUMBER");
        align[1] = 0;
        width[1] = 80;
        format[1] = "";
        hd[0][2] = this.resHelper.getString("ReportEditUI.templateName");
        align[2] = 0;
        width[2] = 200;
        format[2] = "";
        hd[0][3] = this.resHelper.getString("ReportEditUI.periodType");
        align[3] = 0;
        width[3] = 100;
        format[3] = "";
        hd[0][4] = this.resHelper.getString("ReportEditUI.versionNumber");
        align[4] = 0;
        width[4] = 100;
        format[4] = "";
        hd[0][5] = this.resHelper.getString("dataCollect.text");
        align[5] = 0;
        width[5] = 100;
        format[5] = "";
        KDTableHeaderModel mm = new KDTableHeaderModel();
        mm.setHiddenColumnIndexices(new int[]{0});
        mm.setData(hd);
        mm.setAlignColumns(align);
        mm.setColumnsFormat(format);
        mm.setColumnWidths(width);
        return mm;
    }

    protected void cboDataCollect_actionPerformed(ActionEvent e) {
        this.tblMain.refresh();
    }

    @Override
    public void initUIContentLayout() {
        this.setBounds(new Rectangle(10, 10, 515, 350));
        this.setLayout(null);
        this.contPeriodType.setBounds(new Rectangle(10, 10, 220, 19));
        this.add((Component)this.contPeriodType, null);
        this.contYear.setBounds(new Rectangle(10, 34, 140, 19));
        this.add((Component)this.contYear, null);
        this.lblYear.setBounds(new Rectangle(155, 34, 20, 19));
        this.add((Component)this.lblYear, null);
        this.comboPeriod.setBounds(new Rectangle(170, 34, 40, 19));
        this.add((Component)this.comboPeriod, null);
        this.lblPeriod.setBounds(new Rectangle(220, 34, 20, 19));
        this.add((Component)this.lblPeriod, null);
        this.contRptDate.setBounds(new Rectangle(250, 10, 220, 19));
        this.add((Component)this.contRptDate, null);
        this.contCurrency.setBounds(new Rectangle(250, 34, 220, 19));
        this.add((Component)this.contCurrency, null);
        this.contDataCollect.setBounds(new Rectangle(10, 58, 220, 19));
        this.add((Component)this.contDataCollect);
        this.tblMain.setBounds(new Rectangle(10, 85, 460, 250));
        this.add((Component)this.tblMain, null);
        this.contYear.setBoundEditor((JComponent)this.comboYear);
        this.contPeriodType.setBoundEditor((JComponent)this.comboPeriodType);
        this.contCurrency.setBoundEditor((JComponent)this.comboCurrency);
        this.contRptDate.setBoundEditor((JComponent)this.datePickerRptDate);
        this.contDataCollect.setBoundEditor((JComponent)this.cboDataCollect);
    }

    @Override
    public void initUIMenuBarLayout() {
        this.menuBar.add((JMenu)this.menuFile);
        this.menuFile.add((JMenuItem)this.menuItemSubmit);
        this.menuFile.add((Component)this.kDSeparator1);
        this.menuFile.add((JMenuItem)this.menuItemExitCurrent);
    }

    @Override
    public void initUIToolBarLayout() {
        this.toolBar.add((Component)this.btnSubmit);
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        IObjectValue ov = dataObject;
        super.setDataObject(ov);
        this.editData = (CslReportInfo)ov;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tblMain_tableDataRequest(KDTDataRequestEvent e) {
        if (this.cboDataCollect.getItemCount() == 0) {
            return;
        }
        DataCollectInfo dataCollect = (DataCollectInfo)this.cboDataCollect.getSelectedItem();
        StringBuffer sql = new StringBuffer();
        sql.append("select FId, FNumber, FName, switch (");
        sql.append(" FPeriodType = 1, '").append(RptPeriodTypeEnum.DAILY.getAlias());
        sql.append("', FPeriodType = 2, '").append(RptPeriodTypeEnum.WEEKLY.getAlias());
        sql.append("', FPeriodType = 3, '").append(RptPeriodTypeEnum.MONTHLY.getAlias());
        sql.append("', FPeriodType = 4, '").append(RptPeriodTypeEnum.QUARTERLY.getAlias());
        sql.append("', FPeriodType = 5, '").append(RptPeriodTypeEnum.SEMIYEARLY.getAlias());
        sql.append("', FPeriodType = 6, '").append(RptPeriodTypeEnum.YEARLY.getAlias());
        sql.append("', true, '') as FFPeriodType, FVersionNumber, FIsIncludeOtherDC ");
        sql.append(" from t_eas_template");
        sql.append(" where FVersionStatus = 1 and FPeriodType = ?");
        sql.append(" and FCompanyNum = ? ");
        SqlParams param = new SqlParams();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        param.addInt(periodType.getValue());
        param.addString(UIConfig.getCurCompanyNumber());
        if ("BUDGETDATA".equals(dataCollect.getNumber())) {
            sql.append(" and FIsIncludeOtherDC = ? ");
            param.addInt(1);
        }
        sql.append("\n order by FNumber");
        try {
            this.setCursorOfWair();
            int from = e.getFirstRow();
            int length = e.getLastRow() - e.getFirstRow() + 1;
            RptRowSet rst = DbUtil.executeQuery(sql.toString(), param, from, length);
            KDTableUtil.insertRows((Object[][])rst.toArray(), null, (int)from, (KDTable)this.tblMain);
            for (int i = 0; i < this.tblMain.getRowCount3(); ++i) {
                String includeOtherDC = this.tblMain.getCell(i, "isIncludeOtherDC").getValue().toString();
                this.tblMain.getCell(i, "isIncludeOtherDC").setValue((Object)new Boolean(includeOtherDC.equals("1")));
            }
        }
        catch (BOSException ex) {
            ExceptionHandler.handle(ex);
        }
        catch (EASBizException ex) {
            ExceptionHandler.handle(ex);
        }
        finally {
            this.setCursorOfDefault();
        }
    }

    @Override
    protected IObjectValue createNewData() {
        return null;
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyInput(e);
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        int year = (Integer)this.comboYear.getSelectedItem();
        short period = (Short)this.comboPeriod.getSelectedItem();
        if (this.cboDataCollect.getItemCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), CommonUtil.getResource("noBaseData"));
            return;
        }
        DataCollectInfo dataCollect = (DataCollectInfo)this.cboDataCollect.getSelectedItem();
        if (this.comboCurrency.getItemCount() < 1 || this.tblMain.getRowCount() < 1) {
            MsgBox.showWarning((Component)((Object)this), CommonUtil.getResource("noBaseData"));
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        String currencyId = null;
        IRowSet rowSet = DbUtil.executeQuery("select FId from t_eas_currency where FNumber = ? and FCompanyNumber = ?", new Object[]{currency.getNumber(), UIConfig.getCurCompanyNumber()});
        if (rowSet.next()) {
            currencyId = rowSet.getString("FId");
        }
        String templateId = this.getSelectedTemplateID();
        TemplateVO tvo = TemplateDAO.getTemplateVO(templateId);
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from t_eas_template");
        sql.append(" where FNumber = ? ");
        sql.append(" and FPeriodType = ? ");
        sql.append(" and FDynaRpttype = ? ");
        sql.append(" and FTemplateType = ? ");
        sql.append(" and FCompanyNum = ? ");
        rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{tvo.getNumber(), new Integer(tvo.getPeriodType().getValue()), new Integer(tvo.getDynaType()), new Integer(tvo.getTemplateType()), tvo.getCompanyNum()});
        String templateIds = "(";
        while (rowSet.next()) {
            templateIds = templateIds + "'" + rowSet.getString("fid") + "',";
        }
        templateIds = templateIds.substring(0, templateIds.length() - 1) + ")";
        sql = new StringBuffer();
        sql.append("select r.fid from t_eas_report r ");
        sql.append(" inner join t_eas_template t  on t.fid = r.FtemplateID ");
        sql.append(" where r.FtemplateID in ").append(templateIds);
        sql.append(" and r.FCurrencyId = ?");
        sql.append(" and r.FYear = ? ");
        sql.append(" and r.FPeriod = ?");
        sql.append(" and r.FDataCollectNumber = ?");
        sql.append(" and r.FCompanyNum = ?");
        rowSet = DbUtil.executeQuery(sql.toString(), new Object[]{currencyId, new Integer(year), new Integer(period), dataCollect.getNumber(), UIConfig.getCurCompanyNumber()});
        if (rowSet.size() > 0) {
            throw new EASBizException(new NumericExceptionSubItem("1", this.resHelper.getString("Report_Has_Created")));
        }
        String reportId = Uuid.create().toString();
        if (tvo != null) {
            sql = new StringBuffer();
            sql.append("insert into t_eas_report");
            sql.append("(FId, FName, FTemplateID, FPeriodType, ");
            sql.append("FYear, FPeriod, FDataCollectNumber, FCreatorID, FCurrencyID, ");
            sql.append("FDescription, FTemplateNumber, FVersionNumber, ");
            sql.append(" FCreateTime, FCompanyNum, FDynaRpttype, ");
            sql.append("FSourceType, FAuditedStatus, FCheckedStatus) \n");
            sql.append(" values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,");
            sql.append(tvo.getDynaType()).append(", ");
            int templateType = tvo.getTemplateType();
            if (templateType <= 0) {
                sql.append("'', ");
            } else if (templateType == 10) {
                sql.append(10).append(", ");
            } else {
                sql.append(1).append(", ");
            }
            sql.append(1).append(", ");
            sql.append(1).append(")");
            Object[] param = new Object[]{reportId, tvo.getName(), templateId, new Integer(periodType.getValue()), new Integer(year), new Integer(period), dataCollect.getNumber(), UIConfig.getUserName(), currencyId, tvo.getDescription(), tvo.getNumber(), tvo.getVersionNumber(), new Date(new java.util.Date().getTime()), UIConfig.getCurCompanyNumber()};
            DbUtil.execute(sql.toString(), param);
            byte[] data = tvo.getData();
            Book book = IOHelper.unpackBook((byte[])data);
            book.setCalculate(false);
            DataCollectUtil.fillCellFormulaByDataCollect(book, dataCollect.getNumber());
            data = IOHelper.packBook((Book)book);
            try {
                ReportDAO.saveData(reportId, data);
            }
            catch (Exception ex) {
                DbUtil.execute("delete from t_eas_report where fid = '" + reportId + "'");
                throw new EASBizException(new NumericExceptionSubItem("1", ex.getMessage()));
            }
        }
        MsgBox.showInfo((Component)((Object)this), EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        Map context = this.getUIContext();
        ReportListUI ui = (ReportListUI)((Object)context.get("Owner"));
        if (ui != null) {
            ui.actionRefresh_actionPerformed(null);
            this.destroyWindow();
            ui.showEditUI(reportId, "ADDNEW");
        }
    }

    protected String getSelectedTemplateID() {
        Object keyValue;
        int rowIndex;
        IRow row;
        ICell cell;
        boolean tmpSelected = false;
        String selectedKeyValue = null;
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null && (cell = (row = this.tblMain.getRow(rowIndex = selectBlock.getTop())).getCell("id")) != null && (keyValue = cell.getValue()) != null) {
            selectedKeyValue = keyValue.toString();
            tmpSelected = true;
        }
        if (!tmpSelected) {
            MsgBox.showInfo((Component)((Object)this), CslRptUtil.getString((String)"SumRptEditUI.Msg_SelectRow"));
            SysUtil.abort();
        }
        return selectedKeyValue;
    }

    public String getReportUIName() {
        return GroupRptProcessUI.class.getName();
    }

    protected void comboPeriodType_actionPerformed(ActionEvent e) throws Exception {
        this.comboPeriod.removeAllItems();
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (periodType == null) {
            return;
        }
        int type = periodType.getValue();
        ArrayList<Short> items = new ArrayList<Short>();
        int count = 0;
        switch (type) {
            case 1: {
                count = 366;
                break;
            }
            case 3: {
                count = 12;
                break;
            }
            case 4: {
                count = 4;
                break;
            }
            case 5: {
                count = 2;
                break;
            }
            case 6: {
                count = 1;
                break;
            }
            case 2: {
                count = 53;
            }
        }
        for (int i = 1; i <= count; ++i) {
            items.add(new Short((short)i));
        }
        this.comboPeriod.addItems(items.toArray());
        this.refreshTimeInfo(this.datePickerRptDate.getSqlDate());
        this.tblMain.refresh();
    }

    protected void tblSelectChanged_actionPerformed(KDTSelectEvent e) {
        int index = this.tblMain.getSelectManager().getActiveRowIndex();
        try {
            this.tblMain.getCell(index, "isIncludeOtherDC").getValue();
        }
        catch (NullPointerException npe) {
            return;
        }
        if (this.tblMain.getCell(index, "isIncludeOtherDC").getValue().equals(Boolean.FALSE)) {
            String str = DataCollectConstant.getActualDC().getName(SysContext.getSysContext().getLocale());
            this.cboDataCollect.setSelectedItem((Object)str);
            this.cboDataCollect.setEnabled(false);
        }
        if (this.tblMain.getCell(index, "isIncludeOtherDC").getValue().equals(Boolean.TRUE)) {
            this.cboDataCollect.setEnabled(true);
        }
    }

    private void calculatePeriod() {
        RptPeriodTypeEnum periodType = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        Integer yearInt = (Integer)this.comboYear.getSelectedItem();
        if (yearInt != null && periodType != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(new java.util.Date());
            int year = yearInt;
            int month = calendar.get(2) + 1;
            int date = calendar.get(5);
            int period = RPTDateUtil.getPeriod((int)year, (int)month, (int)date, (RptPeriodTypeEnum)periodType);
            this.comboPeriod.setSelectedItem((Object)new Short((short)period));
        }
    }

    @Override
    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initUI();
        super.onLoad();
        this.setUITitle(this.getUITitle() + " " + CslRptUtil.getString((String)"AddNew"));
    }

    private void initUI() throws EASBizException, BOSException {
        this.comboPeriodType.setSelectedItem((Object)RptPeriodTypeEnum.MONTHLY);
        this.datePickerRptDate.setValue((Object)new java.util.Date());
        this.comboYear.setEnabled(false);
        this.comboPeriod.setEnabled(false);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new java.util.Date());
        int year = calendar.get(1);
        Integer yearObj = null;
        Integer currentYearObj = null;
        for (int i = year - 1; i <= year + 1; ++i) {
            yearObj = new Integer(i);
            if (i == year) {
                currentYearObj = yearObj;
            }
            this.comboYear.addItem((Object)yearObj);
        }
        this.comboYear.setSelectedItem(currentYearObj);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        CurrencyCollection collection = this.getCurrency();
        if (collection == null || collection.isEmpty()) {
            this.actionSubmit.setEnabled(false);
        } else {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                this.comboCurrency.addItem(iter.next());
            }
        }
        this.cboDataCollect.addItem((Object)DataCollectConstant.getActualDC());
        this.cboDataCollect.addItem((Object)DataCollectConstant.getBudgetDC());
    }

    private CurrencyCollection getCurrency() throws BOSException, EASBizException {
        CurrencyCollection col = new CurrencyCollection();
        String sql = "select FId, FNumber, FName from t_eas_currency where FCompanyNumber = ?  order by FNumber";
        IRowSet rowSet = DbUtil.executeQuery(sql, new Object[]{UIConfig.getCurCompanyNumber()});
        try {
            while (rowSet.next()) {
                CurrencyInfo info = new CurrencyInfo();
                info.setNumber(rowSet.getString("FNumber"));
                info.setName(rowSet.getString("FName"));
                col.add(info);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return col;
    }

    @Override
    public boolean isModify() {
        return false;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && this.tblMain.getSelectManager().get() != null) {
            this.actionSubmit_actionPerformed(null);
        }
    }

    @Override
    public boolean destroyWindow() {
        Object owner;
        if (this.getOprtState().equals("EDIT")) {
            super.releaseObjectLock(this.editData.getId().toString());
        }
        if ((owner = this.getUIContext().get("Owner")) instanceof ListUI) {
            try {
                ((ListUI)owner).actionRefresh_actionPerformed(null);
            }
            catch (Exception e) {
                super.handUIException(e);
            }
        }
        return super.destroyWindow();
    }

    private void refreshTimeInfo(java.util.Date newDate) {
        RptPeriodTypeEnum p = (RptPeriodTypeEnum)this.comboPeriodType.getSelectedItem();
        if (p == null || newDate == null) {
            return;
        }
        List times = RPTDateUtil.getRptPeriod((java.util.Date)newDate, (RptPeriodTypeEnum)p);
        this.comboYear.removeAllItems();
        this.comboYear.addItem((Object)new Integer(times.get(0).toString()));
        this.comboPeriod.removeAllItems();
        this.comboPeriod.addItem((Object)new Short(times.get(1).toString()));
        this.isLock = true;
        this.datePickerRptDate.setValue(times.get(2));
        this.isLock = false;
    }

    protected void datePickerRptDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this.isLock) {
            return;
        }
        if (e != null && e.getNewValue() instanceof java.util.Date) {
            this.refreshTimeInfo((java.util.Date)e.getNewValue());
        }
    }

    @Override
    protected String getClassAlise() {
        return this.resHelper.getString("ReportEditUI.title");
    }
}

